/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.pdd.core.autenticazione.ApiKey;
import org.openspcoop2.pdd.core.autenticazione.ApiKeyUtilities;
import org.openspcoop2.protocol.engine.ConfigurazioneFiltroServiziApplicativi;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;

public class ServiziApplicativiCore
extends ControlStationCore {
    public ServiziApplicativiCore() throws DriverControlStationException {
    }

    public ServiziApplicativiCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public ServizioApplicativo getServizioApplicativo(long idServizioApplicativo) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getServizioApplicativo";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ServizioApplicativo servizioApplicativo = driver.getDriverConfigurazioneDB().getServizioApplicativo(idServizioApplicativo);
            return servizioApplicativo;
        }
        catch (DriverConfigurazioneNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getServizioApplicativo(IDServizioApplicativo)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ServizioApplicativo servizioApplicativo = driver.getDriverConfigurazioneDB().getServizioApplicativo(idServizioApplicativo);
            return servizioApplicativo;
        }
        catch (DriverConfigurazioneNotFound e) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] ExceptionNotFound :" + e.getMessage(), e);
            throw new DriverConfigurazioneException("[ControlStationCore::" + nomeMetodo + "] NotFound :" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ProprietaOggetto getProprietaOggetto(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getProprietaOggetto(IDServizioApplicativo)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ProprietaOggetto proprietaOggetto = driver.getDriverConfigurazioneDB().getProprietaOggetto(idServizioApplicativo);
            return proprietaOggetto;
        }
        catch (DriverConfigurazioneNotFound e) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] ExceptionNotFound :" + e.getMessage(), e);
            throw new DriverConfigurazioneException("[ControlStationCore::" + nomeMetodo + "] NotFound :" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isSupportatoAutenticazioneApplicativiErogazione(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoAutenticazioneApplicativiErogazione";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isSupportatoAutenticazioneApplicativiEsterniErogazione(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoAutenticazioneApplicativiEsterniErogazione";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoAutenticazioneApplicativiEsterniErogazioni();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public long getIdServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIdServizioApplicativo";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.getDriverConfigurazioneDB().getIdServizioApplicativo(idSoggetto, nomeServizioApplicativo);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiBasicList(String utente, String password, boolean checkPassword) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoWithCredenzialiBasicList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoWithCredenzialiBasicList(utente, password, checkPassword);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String toAppId(String protocollo, IDServizioApplicativo idSA, boolean multipleApiKeys) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "toAppId";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            String string = ApiKeyUtilities.toAppId((String)protocollo, (IDServizioApplicativo)idSA, (boolean)multipleApiKeys, (DriverConfigurazioneDB)driver.getDriverConfigurazioneDB());
            return string;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ApiKey newApiKey(String protocollo, IDServizioApplicativo idSA) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "newApiKey";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ApiKey apiKey = ApiKeyUtilities.newApiKey((String)protocollo, (IDServizioApplicativo)idSA, (int)this.getApplicativiApiKeyLunghezzaPasswordGenerate(), (DriverConfigurazioneDB)driver.getDriverConfigurazioneDB());
            return apiKey;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ApiKey newMultipleApiKey() throws DriverConfigurazioneException {
        String nomeMetodo = "newMultipleApiKey";
        try {
            return ApiKeyUtilities.newMultipleApiKey((int)this.getApplicativiApiKeyLunghezzaPasswordGenerate());
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiApiKeyList(String utente, boolean appId) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoWithCredenzialiApiKeyList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoWithCredenzialiApiKeyList(utente, appId);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiSslList(String subject, String issuer, ConfigurazioneFiltroServiziApplicativi filtro) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoWithCredenzialiSslList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoWithCredenzialiSslList(subject, issuer, filtro.getTipiSoggetti(), filtro.isIncludiApplicativiNonModI(), filtro.isIncludiApplicativiModIEsterni(), filtro.isIncludiApplicativiModIInterni());
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiSslList(CertificateInfo certificate, boolean strictVerifier, ConfigurazioneFiltroServiziApplicativi filtro) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoWithCredenzialiSslList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoWithCredenzialiSslList(certificate, strictVerifier, filtro.getTipiSoggetti(), filtro.isIncludiApplicativiNonModI(), filtro.isIncludiApplicativiModIEsterni(), filtro.isIncludiApplicativiModIInterni());
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiPrincipalList(String principal) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoWithCredenzialiPrincipalList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoWithCredenzialiPrincipalList(principal);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiTokenList(String tokenPolicy, String tokenClientId) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoWithCredenzialiTokenList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean tokenWithHttpsEnabled = false;
            for (IProtocolFactory protocolFactory : ProtocolFactoryManager.getInstance().getProtocolFactories().values()) {
                if (!protocolFactory.createProtocolConfiguration().isSupportatoAutenticazioneApplicativiHttpsConToken()) continue;
                tokenWithHttpsEnabled = true;
                break;
            }
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoWithCredenzialiTokenList(tokenPolicy, tokenClientId, tokenWithHttpsEnabled);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoList(ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoList(ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> servizioApplicativoList(IDSoggetto idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoList(idSoggetto, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isServizioApplicativoInUsoComeErogatore(ServizioApplicativo sa, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isServizioApplicativoInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().isServizioApplicativoInUsoComeErogatore(sa, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsServizioApplicativo(IDServizioApplicativo idSA) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsServizioApplicativo";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsServizioApplicativo(idSA);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDServizioApplicativoDB> getIdServiziApplicativiWithIdErogatore(Long idErogatore) throws DriverConfigurazioneException {
        return this.getIdServiziApplicativiWithIdErogatore(idErogatore, null, false, false);
    }

    public List<IDServizioApplicativoDB> getIdServiziApplicativiWithIdErogatore(Long idErogatore, boolean checkIM, boolean checkConnettoreAbilitato) throws DriverConfigurazioneException {
        return this.getIdServiziApplicativiWithIdErogatore(idErogatore, null, checkIM, checkConnettoreAbilitato);
    }

    public List<IDServizioApplicativoDB> getIdServiziApplicativiWithIdErogatore(Long idErogatore, String tipo, boolean checkIM, boolean checkConnettoreAbilitato) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getServiziApplicativiWithIdErogatore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getIdServiziApplicativiWithIdErogatore(idErogatore, tipo, checkIM, checkConnettoreAbilitato);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDServizioApplicativoDB> soggettiServizioApplicativoList(IDSoggetto idSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, String tipo, boolean bothSslAndToken, String tokenPolicy) throws DriverConfigurazioneException {
        return this.soggettiServizioApplicativoList(idSoggetto, superuser, credenziale, appId, tipo, bothSslAndToken, tokenPolicy, false);
    }

    public List<IDServizioApplicativoDB> soggettiServizioApplicativoList(IDSoggetto idSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, String tipo, boolean bothSslAndToken, String tokenPolicy, boolean tokenPolicyOR) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettiServizioApplicativoList(soggetto,user,credenziale,appId,tipo,ssl,token)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().soggettiServizioApplicativoList(idSoggetto, superuser, credenziale, appId, tipo, bothSslAndToken, tokenPolicy, tokenPolicyOR);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> soggettiServizioApplicativoList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettiServizioApplicativoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().soggettiServizioApplicativoList(superuser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> soggettiServizioApplicativoList(ISearch ricerca, Long idSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettiServizioApplicativoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().soggettiServizioApplicativoList(idSoggetto, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isServizioApplicativoInUso(IDServizioApplicativo idServizioApplicativo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean isRegistroServiziLocale, boolean normalizeObjectIds, boolean verificaRuoli) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isServizioApplicativoInUso";
        try {
            con = ControlStationCore.dbM.getConnection();
            boolean bl = DBOggettiInUsoUtils.isServizioApplicativoInUso((Connection)con, (String)this.tipoDB, (IDServizioApplicativo)idServizioApplicativo, whereIsInUso, (boolean)isRegistroServiziLocale, (boolean)normalizeObjectIds, (boolean)verificaRuoli);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDServizioApplicativo> getAllIdServiziApplicativi(FiltroRicercaServiziApplicativi filtroRicerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getAllIdServiziApplicativi";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getAllIdServiziApplicativi(filtroRicerca);
            return list;
        }
        catch (DriverConfigurazioneNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            ArrayList<IDServizioApplicativo> arrayList = new ArrayList<IDServizioApplicativo>();
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> servizioApplicativoRuoliList(long idSA, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "servizioApplicativoRuoliList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().servizioApplicativoRuoliList(idSA, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getIdServizioApplicativoByConnettore(long idConnettore) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIdServizioApplicativoByConnettore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.getDriverConfigurazioneDB().getIdServizioApplicativoByConnettore(idConnettore);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliServizioApplicativoInUso(IDServizioApplicativo idServizioApplicativo, boolean verificaRuoli) throws DriverConfigurazioneException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean saInUso = this.isServizioApplicativoInUso(idServizioApplicativo, whereIsInUso, this.isRegistroServiziLocale(), normalizeObjectIds, verificaRuoli);
        StringBuilder inUsoMessage = new StringBuilder();
        if (saInUso) {
            String s = DBOggettiInUsoUtils.toString((IDServizioApplicativo)idServizioApplicativo, whereIsInUso, (boolean)false, (String)"\n", (boolean)normalizeObjectIds);
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("L'applicativo non risulta utilizzato in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }

    public List<Proprieta> serviziApplicativiProprietaList(int idSA, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "serviziApplicativiProprietaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().serviziApplicativiProprietaList(idSA, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> nomiProprietaSA(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoSoggettiProtocollo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "nomiProprietaSA";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().nomiProprietaSA(filterSoggettoTipo, filterSoggettoNome, tipoSoggettiProtocollo);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

