/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazionePortaGestioneErrore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.web.ctrlstat.core.CertificateChecker;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.ConnettoreServletType;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.plugins.servlet.ServletExtendedConnettoreUtils;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreStatusParams;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ServiziApplicativiVerificaCertificati
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            Object labelVerifica;
            ServiziApplicativiHelper saHelper = new ServiziApplicativiHelper(request, pd, session);
            ServiziApplicativiCore saCore = new ServiziApplicativiCore();
            SoggettiCore soggettiCore = new SoggettiCore(saCore);
            ConfigurazioneCore confCore = new ConfigurazioneCore(saCore);
            PddCore pddCore = new PddCore(saCore);
            String verificaCertificatiFromLista = saHelper.getParameter("certVerFromLista");
            boolean arrivoDaLista = "true".equalsIgnoreCase(verificaCertificatiFromLista);
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentSA == null) {
                parentSA = 0;
            }
            boolean useIdSogg = parentSA != null && parentSA == 1;
            String id = saHelper.getParameter("id");
            int idServizioApplicativo = Integer.parseInt(id);
            String idProvider = saHelper.getParameter("provider");
            String alias = saHelper.getParameter("aliasNodo");
            saHelper.makeMenu();
            List<String> aliases = confCore.getJmxPdDAliases();
            if (aliases == null || aliases.isEmpty()) {
                throw new CoreException("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
            }
            ServizioApplicativo sa = saCore.getServizioApplicativo(idServizioApplicativo);
            String nomeSA = sa.getNome();
            IDSoggetto idSoggettoProprietario = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
            IDServizioApplicativo idServizioApplicativoTmp = new IDServizioApplicativo();
            idServizioApplicativoTmp.setIdSoggettoProprietario(idSoggettoProprietario);
            idServizioApplicativoTmp.setNome(nomeSA);
            String tipoProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(sa.getTipoSoggettoProprietario());
            Soggetto soggettoProprietario = soggettiCore.getSoggettoRegistro(idSoggettoProprietario);
            String dominio = pddCore.isPddEsterna(soggettoProprietario.getPortaDominio()) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
            boolean tokenWithHttsSupportato = false;
            if (tipoProtocollo != null) {
                ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
                tokenWithHttsSupportato = protocolFactoryManager.getProtocolFactoryByName(tipoProtocollo).createProtocolConfiguration().isSupportatoAutenticazioneApplicativiHttpsConToken();
            }
            ArrayList<Parameter> parametersServletSAChange = new ArrayList<Parameter>();
            Parameter pIdSA = new Parameter("id", "" + sa.getId());
            parametersServletSAChange.add(pIdSA);
            Parameter pIdSoggettoSA = new Parameter("provider", "" + sa.getIdSoggetto());
            parametersServletSAChange.add(pIdSoggettoSA);
            if (dominio != null) {
                Parameter pDominio = new Parameter("dominio", dominio);
                parametersServletSAChange.add(pDominio);
            }
            boolean modalitaCompleta = saHelper.isModalitaCompleta();
            String tmpTitle = null;
            String protocolloSoggetto = null;
            if (useIdSogg) {
                Soggetto tmpSogg;
                if (saCore.isRegistroServiziLocale()) {
                    tmpSogg = soggettiCore.getSoggettoRegistro(Integer.parseInt(idProvider));
                    protocolloSoggetto = soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = saHelper.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                } else {
                    tmpSogg = soggettiCore.getSoggetto(Integer.parseInt(idProvider));
                    protocolloSoggetto = soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = saHelper.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                }
            }
            String verificaConnettivitaS = saHelper.getParameter("tokenVerConn");
            boolean verificaConnettivita = "true".equalsIgnoreCase(verificaConnettivitaS);
            String labelApplicativi = "Servizi Applicativi";
            String labelApplicativiDi = "Servizi Applicativi di ";
            if (!modalitaCompleta) {
                labelApplicativi = "Applicativi";
                labelApplicativiDi = "Applicativi di ";
            }
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            if (!useIdSogg) {
                lstParam.add(new Parameter(labelApplicativi, "serviziApplicativiList.do"));
            } else {
                String provider = saHelper.getParameter("provider");
                lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
                lstParam.add(new Parameter(labelApplicativiDi + tmpTitle, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", provider)}));
            }
            String labelApplicativo = sa.getNome();
            if (arrivoDaLista) {
                labelVerifica = (verificaConnettivita ? "Verifica Connettivit\u00e0 di " : "Verifica Certificati di ") + labelApplicativo;
                lstParam.add(new Parameter((String)labelVerifica, null));
            } else {
                lstParam.add(new Parameter(sa.getNome(), "serviziApplicativiChange.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()])));
                labelVerifica = verificaConnettivita ? "Verifica Connettivit\u00e0" : "Verifica Certificati";
                lstParam.add(new Parameter((String)labelVerifica, null));
            }
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            boolean ssl = false;
            boolean sslManuale = false;
            boolean piuCertificatiAssociatiEntita = false;
            boolean sicurezzaMessaggioModi = false;
            boolean serverHttps = false;
            boolean findConnettoreHttpConPrefissoHttps = false;
            String tokenPolicyNegoziazione = null;
            InvocazionePorta ip = null;
            Connettore connettore = null;
            if (!verificaConnettivita) {
                TipiConnettore tipo;
                int countSsl = 0;
                ip = sa.getInvocazionePorta();
                for (int i = 0; i < ip.sizeCredenzialiList(); ++i) {
                    Credenziali c = ip.getCredenziali(i);
                    if (!CredenzialeTipo.SSL.equals((Object)c.getTipo())) continue;
                    if (c.getCertificate() != null) {
                        ssl = true;
                        ++countSsl;
                        continue;
                    }
                    sslManuale = true;
                }
                piuCertificatiAssociatiEntita = countSsl > 1;
                boolean modi = saCore.isProfiloModIPA(tipoProtocollo);
                if (modi) {
                    KeystoreParams keystoreParams = ModIUtils.getApplicativoKeystoreParams((List)sa.getProtocolPropertyList());
                    boolean bl = sicurezzaMessaggioModi = keystoreParams != null;
                    if (!sicurezzaMessaggioModi) {
                        KeystoreParams dpopKeystoreParams = ModIUtils.getApplicativoDPoPKeystoreParams((List)sa.getProtocolPropertyList());
                        boolean bl2 = sicurezzaMessaggioModi = dpopKeystoreParams != null;
                    }
                }
                if ("server".equals(sa.getTipo()) && sa.getInvocazioneServizio() != null && (TipiConnettore.HTTP.equals((Object)(tipo = TipiConnettore.toEnumFromName((String)(connettore = sa.getInvocazioneServizio().getConnettore()).getTipo()))) || TipiConnettore.HTTPS.equals((Object)tipo))) {
                    if (TipiConnettore.HTTPS.equals((Object)tipo)) {
                        serverHttps = true;
                    } else {
                        String endpoint = ConnettoreUtils.getEndpointConnettore((Connettore)connettore, (boolean)false);
                        if (endpoint != null) {
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        }
                    }
                    String tokenPolicy = ConnettoreUtils.getNegoziazioneTokenPolicyConnettore((Connettore)connettore);
                    if (tokenPolicy != null && StringUtils.isNotEmpty((String)tokenPolicy)) {
                        tokenPolicyNegoziazione = tokenPolicy;
                    }
                }
            } else {
                connettore = sa.getInvocazioneServizio().getConnettore();
            }
            boolean verificaCertificatiEffettuata = false;
            if (!(verificaConnettivita || ssl || sicurezzaMessaggioModi || serverHttps || findConnettoreHttpConPrefissoHttps || tokenPolicyNegoziazione != null)) {
                if (sslManuale) {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati.<br/>\u00c8 presente una configurazione manuale del Subject e dell'Issuer", Costanti.MESSAGE_TYPE_INFO);
                } else {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati", Costanti.MESSAGE_TYPE_INFO);
                }
                pd.disableEditMode();
                verificaCertificatiEffettuata = true;
            } else {
                boolean sceltaClusterId = true;
                if (!verificaConnettivita) {
                    sceltaClusterId = soggettiCore.isVerificaCertificatiSceltaClusterId();
                }
                if (aliases.size() == 1 || alias != null || !sceltaClusterId) {
                    if (alias == null && !sceltaClusterId) {
                        alias = "Verifica su tutti i nodi";
                    }
                    if (verificaConnettivita) {
                        String aliasDescrizione = null;
                        aliasDescrizione = "Verifica su tutti i nodi".equals(alias) ? aliases.get(0) : (alias != null ? alias : aliases.get(0));
                        saHelper.addDescrizioneVerificaConnettivitaToDati(dati, connettore, null, aliasDescrizione);
                        if (!saHelper.isEditModeInProgress()) {
                            ArrayList<String> aliasesForCheck = new ArrayList<String>();
                            if (aliases.size() == 1) {
                                aliasesForCheck.add(aliases.get(0));
                            } else if ("Verifica su tutti i nodi".equals(alias)) {
                                aliasesForCheck.addAll(aliases);
                            } else {
                                aliasesForCheck.add(alias);
                            }
                            boolean rilevatoErrore = false;
                            StringBuilder sbPerOperazioneEffettuata = new StringBuilder();
                            int index = 0;
                            for (String aliasForVerificaConnettore : aliasesForCheck) {
                                String risorsa = confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(aliasForVerificaConnettore);
                                StringBuilder bfExternal = new StringBuilder();
                                String descrizione = confCore.getJmxPdDDescrizione(aliasForVerificaConnettore);
                                if (aliases.size() > 1) {
                                    if (index > 0) {
                                        bfExternal.append("<br/>");
                                    }
                                    bfExternal.append("ID Cluster").append(" ").append(descrizione).append("<br/>");
                                }
                                try {
                                    Boolean slowOperation = true;
                                    String nomeMetodo = confCore.getJmxPdDConfigurazioneSistemaNomeMetodoCheckConnettoreById(aliasForVerificaConnettore);
                                    String stato = confCore.getInvoker().invokeJMXMethod(aliasForVerificaConnettore, confCore.getJmxPdDConfigurazioneSistemaType(aliasForVerificaConnettore), risorsa, nomeMetodo, slowOperation, "" + connettore.getId());
                                    if ("Operazione effettuata con successo".equals(stato) || stato != null && stato.startsWith("Operazione effettuata con successo; ")) {
                                        bfExternal.append("Test di connettivit\u00e0 effettuato con successo");
                                    } else {
                                        rilevatoErrore = true;
                                        bfExternal.append("Test di connettivit\u00e0 fallito: ");
                                        if (stato != null && stato.startsWith("Operazione non riuscita: ")) {
                                            bfExternal.append(stato.substring("Operazione non riuscita: ".length()));
                                        } else {
                                            bfExternal.append(stato);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    ControlStationCore.logError("Errore durante la verifica del connettore (jmxResource '" + risorsa + "') (node:" + aliasForVerificaConnettore + "): " + e.getMessage(), e);
                                    rilevatoErrore = true;
                                    String stato = e.getMessage();
                                    bfExternal.append("Test di connettivit\u00e0 fallito: ");
                                    if (stato.startsWith("Operazione non riuscita: ")) {
                                        bfExternal.append(stato.substring("Operazione non riuscita: ".length()));
                                    }
                                    bfExternal.append(stato);
                                }
                                if (sbPerOperazioneEffettuata.length() > 0) {
                                    sbPerOperazioneEffettuata.append("<br/>");
                                }
                                sbPerOperazioneEffettuata.append(bfExternal.toString());
                                ++index;
                            }
                            if (sbPerOperazioneEffettuata != null) {
                                if (rilevatoErrore) {
                                    pd.setMessage(sbPerOperazioneEffettuata.toString());
                                } else {
                                    pd.setMessage(sbPerOperazioneEffettuata.toString(), Costanti.MESSAGE_TYPE_INFO);
                                }
                            }
                            pd.disableEditMode();
                        }
                    } else {
                        ArrayList<String> aliasesForCheck = new ArrayList<String>();
                        boolean all = false;
                        if (aliases.size() == 1) {
                            aliasesForCheck.add(aliases.get(0));
                        } else if ("Verifica su tutti i nodi".equals(alias)) {
                            aliasesForCheck.addAll(aliases);
                            all = true;
                        } else {
                            aliasesForCheck.add(alias);
                        }
                        CertificateChecker certificateChecker = null;
                        certificateChecker = all ? soggettiCore.getJmxPdDCertificateChecker() : soggettiCore.newJmxPdDCertificateChecker(aliasesForCheck);
                        StringBuilder sbDetailsError = new StringBuilder();
                        int sogliaWarningGiorni = soggettiCore.getVerificaCertificatiWarningExpirationDays();
                        String posizioneErrore = null;
                        String extraErrore = null;
                        StringBuilder sbDetailsWarningSsl = new StringBuilder();
                        String posizioneWarningSsl = null;
                        if (ssl) {
                            certificateChecker.checkApplicativo(sbDetailsError, sbDetailsWarningSsl, ssl, false, false, sa, sogliaWarningGiorni);
                            if (sbDetailsError.length() > 0) {
                                posizioneErrore = labelApplicativo;
                            } else if (sbDetailsWarningSsl.length() > 0) {
                                posizioneWarningSsl = labelApplicativo;
                            }
                        }
                        StringBuilder sbDetailsWarningModi = new StringBuilder();
                        String posizioneWarningModi = null;
                        if (sbDetailsError.length() <= 0 && sicurezzaMessaggioModi) {
                            certificateChecker.checkApplicativo(sbDetailsError, sbDetailsWarningSsl, false, sicurezzaMessaggioModi, false, sa, sogliaWarningGiorni);
                            if (sbDetailsError.length() > 0) {
                                posizioneErrore = labelApplicativo;
                            } else if (sbDetailsWarningModi.length() > 0) {
                                posizioneWarningModi = labelApplicativo;
                            }
                        }
                        StringBuilder sbDetailsWarningHttps = new StringBuilder();
                        String posizioneWarningHttps = null;
                        if (sbDetailsError.length() <= 0 && serverHttps) {
                            certificateChecker.checkApplicativo(sbDetailsError, sbDetailsWarningSsl, false, false, serverHttps, sa, sogliaWarningGiorni);
                            if (sbDetailsError.length() > 0) {
                                posizioneErrore = labelApplicativo;
                            } else if (sbDetailsWarningHttps.length() > 0) {
                                posizioneWarningHttps = labelApplicativo;
                            }
                        }
                        StringBuilder sbDetailsWarningPolicy = new StringBuilder();
                        String posizioneWarningPolicy = null;
                        if (sbDetailsError.length() <= 0 && tokenPolicyNegoziazione != null) {
                            GenericProperties gp = confCore.getGenericProperties(tokenPolicyNegoziazione, "retrievePolicyToken", false);
                            if (gp != null) {
                                boolean riferimentoFruizioneModi;
                                PolicyNegoziazioneToken policyNegoziazione = TokenUtilities.convertTo((GenericProperties)gp);
                                boolean https = false;
                                String endpoint = policyNegoziazione.getEndpoint();
                                if (StringUtils.isNotEmpty((String)endpoint)) {
                                    if (policyNegoziazione.isEndpointHttps()) {
                                        https = true;
                                    } else if (endpoint != null && !findConnettoreHttpConPrefissoHttps) {
                                        findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                                    }
                                }
                                boolean signedJwt = false;
                                KeystoreParams keystoreParams = null;
                                try {
                                    if (policyNegoziazione.isRfc7523x509Grant()) {
                                        keystoreParams = TokenUtilities.getSignedJwtKeystoreParams((PolicyNegoziazioneToken)policyNegoziazione);
                                    }
                                }
                                catch (Exception t) {
                                    throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                                }
                                boolean riferimentoApplicativoModi = keystoreParams != null && "applicativoModi".equalsIgnoreCase(keystoreParams.getPath());
                                boolean bl = riferimentoFruizioneModi = keystoreParams != null && "fruizioneModi".equalsIgnoreCase(keystoreParams.getPath());
                                if (keystoreParams != null && !riferimentoApplicativoModi && !riferimentoFruizioneModi) {
                                    signedJwt = true;
                                }
                                boolean dpopJwt = false;
                                KeystoreParams keystoreParamsDpop = null;
                                boolean riferimentoApplicativoModiDpop = false;
                                boolean riferimentoFruizioneModiDpop = false;
                                try {
                                    if (policyNegoziazione.isDpop()) {
                                        keystoreParamsDpop = TokenUtilities.getDpopKeystoreParams((PolicyNegoziazioneToken)policyNegoziazione);
                                    }
                                }
                                catch (Exception t) {
                                    throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                                }
                                riferimentoApplicativoModiDpop = keystoreParamsDpop != null && "applicativoModi".equalsIgnoreCase(keystoreParamsDpop.getPath());
                                boolean bl3 = riferimentoFruizioneModiDpop = keystoreParamsDpop != null && "fruizioneModi".equalsIgnoreCase(keystoreParamsDpop.getPath());
                                if (keystoreParamsDpop != null && !riferimentoApplicativoModiDpop && !riferimentoFruizioneModiDpop) {
                                    dpopJwt = true;
                                }
                                if (https || signedJwt || dpopJwt) {
                                    certificateChecker.checkTokenPolicyNegoziazione(sbDetailsError, sbDetailsWarningPolicy, https, signedJwt, dpopJwt, gp, sogliaWarningGiorni);
                                }
                            }
                            if (sbDetailsError.length() > 0) {
                                posizioneErrore = labelApplicativo;
                            } else if (sbDetailsWarningPolicy.length() > 0) {
                                posizioneWarningPolicy = labelApplicativo;
                            }
                        }
                        StringBuilder sbDetailsWarningCertificatiJvm = new StringBuilder();
                        String posizioneWarningCertificatiJvm = null;
                        String extraWarningCertificatiJvm = null;
                        if (sbDetailsError.length() <= 0 && findConnettoreHttpConPrefissoHttps) {
                            certificateChecker.checkConfigurazioneJvm(sbDetailsError, sbDetailsWarningCertificatiJvm, sogliaWarningGiorni);
                            if (sbDetailsError.length() > 0) {
                                posizioneErrore = labelApplicativo;
                                extraErrore = "Configurazione https nella JVM";
                            } else if (sbDetailsWarningCertificatiJvm.length() > 0) {
                                posizioneWarningCertificatiJvm = labelApplicativo;
                                extraWarningCertificatiJvm = "Configurazione https nella JVM";
                            }
                        }
                        String warning = null;
                        String posizioneWarning = null;
                        String extraWarning = null;
                        if (sbDetailsError.length() <= 0) {
                            if (sbDetailsWarningSsl.length() > 0) {
                                warning = sbDetailsWarningSsl.toString();
                                posizioneWarning = posizioneWarningSsl;
                            } else if (sbDetailsWarningModi.length() > 0) {
                                warning = sbDetailsWarningModi.toString();
                                posizioneWarning = posizioneWarningModi;
                            } else if (sbDetailsWarningHttps.length() > 0) {
                                warning = sbDetailsWarningHttps.toString();
                                posizioneWarning = posizioneWarningHttps;
                            } else if (sbDetailsWarningPolicy.length() > 0) {
                                warning = sbDetailsWarningPolicy.toString();
                                posizioneWarning = posizioneWarningPolicy;
                            } else if (sbDetailsWarningCertificatiJvm.length() > 0) {
                                warning = sbDetailsWarningCertificatiJvm.toString();
                                posizioneWarning = posizioneWarningCertificatiJvm;
                                extraWarning = extraWarningCertificatiJvm;
                            }
                        }
                        ArrayList<String> formatIds = new ArrayList<String>();
                        soggettiCore.formatVerificaCertificatiEsito(pd, formatIds, sbDetailsError.length() > 0 ? sbDetailsError.toString() : null, extraErrore, posizioneErrore, warning, extraWarning, posizioneWarning, piuCertificatiAssociatiEntita);
                        pd.disableEditMode();
                        verificaCertificatiEffettuata = true;
                    }
                } else {
                    DataElement deTestConnettivita = new DataElement();
                    deTestConnettivita.setType(DataElementType.TITLE);
                    deTestConnettivita.setLabel("Verifica Certificati");
                    dati.add(deTestConnettivita);
                    saHelper.addVerificaCertificatoSceltaAlias(aliases, dati);
                }
            }
            pd.setLabelBottoneInvia("Verifica");
            dati = saHelper.addServizioApplicativoHiddenToDati(dati, id, idProvider, dominio, sa.getNome());
            DataElement de = new DataElement();
            de.setValue("" + arrivoDaLista);
            de.setType(DataElementType.HIDDEN);
            de.setName("certVerFromLista");
            dati.add(de);
            de = new DataElement();
            de.setValue("" + verificaConnettivita);
            de.setType(DataElementType.HIDDEN);
            de.setName("tokenVerConn");
            dati.add(de);
            pd.setDati(dati);
            if (verificaCertificatiEffettuata) {
                String v;
                String v2;
                String v3;
                String v4;
                String v5;
                String connettoreDebug;
                boolean integrationManagerEnabled;
                InvocazioneServizio is;
                String oldNome;
                if (arrivoDaLista) {
                    parentSA = useIdSogg ? 1 : 0;
                    ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)parentSA, (String)"_tabKey_portaPar");
                    String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
                    ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                    int idLista = -1;
                    idLista = !useIdSogg ? Liste.SERVIZIO_APPLICATIVO : Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO;
                    List<ServizioApplicativo> lista = null;
                    if (!ServletUtils.isSearchDone((IConsoleHelper)saHelper)) {
                        lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, ServizioApplicativo.class);
                    }
                    ricerca = saHelper.checkSearchParameters(idLista, ricerca);
                    saHelper.clearFiltroSoggettoByPostBackProtocollo(0, (ISearch)ricerca, idLista);
                    if (!useIdSogg) {
                        List<String> protocolli;
                        boolean filtroSoggetto = false;
                        if (saHelper.isSoggettoMultitenantSelezionato() && (protocolli = saCore.getProtocolli(request, session, false)) != null && protocolli.size() == 1) {
                            String protocollo = protocolli.get(0);
                            boolean bl = filtroSoggetto = !saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocollo);
                        }
                        if (filtroSoggetto) {
                            ricerca.addFilter(idLista, "filtroSoggetto", saHelper.getSoggettoMultitenantSelezionato());
                        }
                        if (lista == null) {
                            lista = saCore.isVisioneOggettiGlobale(userLogin) ? saCore.soggettiServizioApplicativoList(null, (ISearch)ricerca) : saCore.soggettiServizioApplicativoList(userLogin, (ISearch)ricerca);
                        }
                    } else {
                        ricerca = saHelper.checkSearchParameters(idLista, ricerca);
                        lista = saCore.soggettiServizioApplicativoList((ISearch)ricerca, sa.getIdSoggetto());
                    }
                    if (!saHelper.isPostBackFilterElement()) {
                        ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, lista);
                    }
                    saHelper.prepareServizioApplicativoList((ISearch)ricerca, lista, useIdSogg, false);
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"serviziApplicativiVerificaCertificati", (ForwardParams)CostantiControlStation.TIPO_OPERAZIONE_VERIFICA_CERTIFICATI);
                }
                ConsoleOperationType consoleOperationType = ConsoleOperationType.CHANGE;
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
                IConsoleDynamicConfiguration consoleDynamicConfiguration = protocolFactory.createDynamicConfigurationConsole();
                IRegistryReader registryReader = soggettiCore.getRegistryReader(protocolFactory);
                IConfigIntegrationReader configRegistryReader = soggettiCore.getConfigIntegrationReader(protocolFactory);
                ConsoleConfiguration consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigServizioApplicativo(consoleOperationType, (IConsoleHelper)saHelper, registryReader, configRegistryReader, idServizioApplicativoTmp);
                List oldProtocolPropertyList = sa.getProtocolPropertyList();
                ProtocolProperties protocolProperties = saHelper.estraiProtocolPropertiesDaRequest(consoleConfiguration, consoleOperationType);
                ProtocolPropertiesUtils.mergeProtocolPropertiesConfig((ProtocolProperties)protocolProperties, (List)oldProtocolPropertyList, (ConsoleOperationType)consoleOperationType);
                Properties propertiesProprietario = new Properties();
                propertiesProprietario.setProperty("idProprietario", "" + idServizioApplicativo);
                propertiesProprietario.setProperty("tipoProprietario", "SERVIZIO_APPLICATIVO");
                propertiesProprietario.setProperty("nomeProprietario", idServizioApplicativoTmp.toString());
                propertiesProprietario.setProperty("urlOrigChange", URLEncoder.encode("serviziApplicativiChange.do?" + request.getQueryString(), "UTF-8"));
                propertiesProprietario.setProperty("protocollo", tipoProtocollo);
                String nomeParameter = oldNome = sa.getNome();
                String descrizione = sa.getDescrizione();
                String tipoENomeSoggetto = saHelper.getLabelNomeSoggetto(tipoProtocollo, idSoggettoProprietario.getTipo(), idSoggettoProprietario.getNome());
                InvocazionePortaGestioneErrore ipge = null;
                Credenziali credenziali = null;
                boolean visualizzaModificaCertificato = false;
                boolean visualizzaAddCertificato = false;
                String servletCredenzialiList = "serviziApplicativiCredenzialiList.do";
                ArrayList<Parameter> parametersServletCredenzialiList = null;
                Integer numeroCertificati = 0;
                String servletCredenzialiAdd = "serviziApplicativiCredenzialiAdd.do";
                if (ip != null) {
                    ipge = ip.getGestioneErrore();
                    numeroCertificati = ip.sizeCredenzialiList();
                    if (ip.sizeCredenzialiList() > 0) {
                        credenziali = ip.getCredenziali(0);
                        visualizzaAddCertificato = true;
                        if (ip.sizeCredenzialiList() == 1) {
                            visualizzaModificaCertificato = true;
                        }
                    }
                }
                parametersServletCredenzialiList = new ArrayList<Parameter>();
                parametersServletCredenzialiList.add(pIdSA);
                parametersServletCredenzialiList.add(pIdSoggettoSA);
                if (dominio != null) {
                    Parameter pDominio = new Parameter("dominio", dominio);
                    parametersServletCredenzialiList.add(pDominio);
                }
                String fault = null;
                if (ipge != null && ipge.getFault() != null) {
                    fault = ipge.getFault().toString();
                }
                String faultactor = null;
                if (ipge != null) {
                    faultactor = ipge.getFaultActor();
                }
                String genericfault = null;
                if (ipge != null && ipge.getGenericFaultCode() != null) {
                    genericfault = ipge.getGenericFaultCode().toString();
                }
                if (genericfault == null || "".equals(genericfault)) {
                    genericfault = CostantiConfigurazione.DISABILITATO.toString();
                }
                String prefixfault = null;
                if (ipge != null) {
                    prefixfault = ipge.getPrefixFaultCode();
                }
                String invrifRisposta = null;
                if (ip != null && ip.getInvioPerRiferimento() != null) {
                    invrifRisposta = ip.getInvioPerRiferimento().toString();
                }
                if (invrifRisposta == null || "".equals(invrifRisposta)) {
                    invrifRisposta = CostantiConfigurazione.DISABILITATO.toString();
                }
                String sbustamentoInformazioniProtocolloRisposta = null;
                if (ip != null && ip.getSbustamentoInformazioniProtocollo() != null) {
                    sbustamentoInformazioniProtocolloRisposta = ip.getSbustamentoInformazioniProtocollo().toString();
                }
                if (sbustamentoInformazioniProtocolloRisposta == null || "".equals(sbustamentoInformazioniProtocolloRisposta)) {
                    sbustamentoInformazioniProtocolloRisposta = CostantiConfigurazione.ABILITATO.toString();
                }
                String ruoloFruitore = sa.getTipologiaFruizione();
                String ruoloErogatore = sa.getTipologiaErogazione();
                String tipoSA = sa.getTipo();
                boolean useAsClient = sa.isUseAsClient();
                if (tipoSA == null) {
                    tipoSA = "";
                }
                if ((is = sa.getInvocazioneServizio()) == null) {
                    is = new InvocazioneServizio();
                }
                String sbustamento = null;
                if (is.getSbustamentoSoap() != null) {
                    sbustamento = is.getSbustamentoSoap().toString();
                }
                String sbustamentoInformazioniProtocolloRichiesta = null;
                if (is.getSbustamentoInformazioniProtocollo() != null) {
                    sbustamentoInformazioniProtocolloRichiesta = is.getSbustamentoInformazioniProtocollo().toString();
                }
                String getmsg = null;
                if (is.getGetMessage() != null) {
                    getmsg = is.getGetMessage().toString();
                }
                boolean bl = integrationManagerEnabled = !saHelper.isModalitaStandard() && saCore.isIntegrationManagerEnabled();
                if (!integrationManagerEnabled && CostantiConfigurazione.ABILITATO.toString().equals(getmsg)) {
                    integrationManagerEnabled = true;
                }
                String invrifRichiesta = null;
                if (is.getInvioPerRiferimento() != null) {
                    invrifRichiesta = is.getInvioPerRiferimento().toString();
                }
                if (invrifRichiesta == null || "".equals(invrifRichiesta)) {
                    invrifRichiesta = CostantiConfigurazione.DISABILITATO.toString();
                }
                String risprif = null;
                if (is.getRispostaPerRiferimento() != null) {
                    risprif = is.getRispostaPerRiferimento().toString();
                }
                if (risprif == null || "".equals(risprif)) {
                    risprif = CostantiConfigurazione.DISABILITATO.toString();
                }
                String user = null;
                String password = null;
                InvocazioneCredenziali cis = is.getCredenziali();
                if (user == null && cis != null) {
                    user = cis.getUser();
                    password = cis.getPassword();
                }
                String endpointtype = null;
                String tipoconn = null;
                Connettore connis = is.getConnettore();
                if (endpointtype == null) {
                    if (connis != null && connis.getCustom() != null && connis.getCustom().booleanValue() && !connis.getTipo().equals(TipiConnettore.HTTPS.toString())) {
                        endpointtype = TipiConnettore.CUSTOM.toString();
                        tipoconn = connis.getTipo();
                    } else if (connis != null) {
                        endpointtype = connis.getTipo();
                    }
                }
                if (endpointtype == null) {
                    endpointtype = TipiConnettore.DISABILITATO.toString();
                }
                Map props = null;
                if (connis != null) {
                    props = connis.getProperties();
                }
                if ((connettoreDebug = null) == null && props != null && (v5 = (String)props.get("debug")) != null) {
                    connettoreDebug = "true".equals(v5) ? "yes" : "no";
                }
                String proxyEnabled = null;
                String proxyHostname = null;
                String proxyPort = null;
                String proxyUsername = null;
                String proxyPassword = null;
                if (proxyEnabled == null && props != null && (v4 = (String)props.get("proxyType")) != null && !"".equals(v4)) {
                    proxyEnabled = "true";
                    v4 = (String)props.get("proxyHostname");
                    if (v4 != null && !"".equals(v4)) {
                        proxyHostname = v4.trim();
                    }
                    if ((v4 = (String)props.get("proxyPort")) != null && !"".equals(v4)) {
                        proxyPort = v4.trim();
                    }
                    if ((v4 = (String)props.get("proxyUsername")) != null && !"".equals(v4)) {
                        proxyUsername = v4.trim();
                    }
                    if ((v4 = (String)props.get("proxyPassword")) != null && !"".equals(v4)) {
                        proxyPassword = v4.trim();
                    }
                }
                String tempiRispostaEnabled = null;
                Object tempiRispostaConnectionTimeout = null;
                Object tempiRispostaReadTimeout = null;
                Object tempiRispostaTempoMedioRisposta = null;
                if (tempiRispostaEnabled == null || tempiRispostaConnectionTimeout == null || "".equals(tempiRispostaConnectionTimeout) || tempiRispostaReadTimeout == null || "".equals(tempiRispostaReadTimeout) || tempiRispostaTempoMedioRisposta == null || "".equals(tempiRispostaTempoMedioRisposta)) {
                    ConfigurazioneCore configCore = new ConfigurazioneCore(soggettiCore);
                    ConfigurazioneGenerale configGenerale = configCore.getConfigurazioneControlloTraffico();
                    if (props != null) {
                        if (tempiRispostaConnectionTimeout == null || "".equals(tempiRispostaConnectionTimeout)) {
                            v3 = (String)props.get("connectionTimeout");
                            if (v3 != null && !"".equals(v3)) {
                                tempiRispostaConnectionTimeout = v3.trim();
                                tempiRispostaEnabled = "true";
                            } else {
                                tempiRispostaConnectionTimeout = "" + configGenerale.getTempiRispostaErogazione().getConnectionTimeout();
                            }
                        }
                        if (tempiRispostaReadTimeout == null || "".equals(tempiRispostaReadTimeout)) {
                            v3 = (String)props.get("readConnectionTimeout");
                            if (v3 != null && !"".equals(v3)) {
                                tempiRispostaReadTimeout = v3.trim();
                                tempiRispostaEnabled = "true";
                            } else {
                                tempiRispostaReadTimeout = "" + configGenerale.getTempiRispostaErogazione().getReadTimeout();
                            }
                        }
                        if (tempiRispostaTempoMedioRisposta == null || "".equals(tempiRispostaTempoMedioRisposta)) {
                            v3 = (String)props.get("avgResponseTime");
                            if (v3 != null && !"".equals(v3)) {
                                tempiRispostaTempoMedioRisposta = v3.trim();
                                tempiRispostaEnabled = "true";
                            } else {
                                tempiRispostaTempoMedioRisposta = "" + configGenerale.getTempiRispostaErogazione().getTempoMedioRisposta();
                            }
                        }
                    } else {
                        if (tempiRispostaConnectionTimeout == null || "".equals(tempiRispostaConnectionTimeout)) {
                            tempiRispostaConnectionTimeout = "" + configGenerale.getTempiRispostaErogazione().getConnectionTimeout();
                        }
                        if (tempiRispostaReadTimeout == null || "".equals(tempiRispostaReadTimeout)) {
                            tempiRispostaReadTimeout = "" + configGenerale.getTempiRispostaErogazione().getReadTimeout();
                        }
                        if (tempiRispostaTempoMedioRisposta == null || "".equals(tempiRispostaTempoMedioRisposta)) {
                            tempiRispostaTempoMedioRisposta = "" + configGenerale.getTempiRispostaErogazione().getTempoMedioRisposta();
                        }
                    }
                }
                String transferMode = null;
                String transferModeChunkSize = null;
                if (transferMode == null && props != null && (v3 = (String)props.get("dataTransferMode")) != null && !"".equals(v3)) {
                    transferMode = v3.trim();
                    if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome().equals(transferMode) && (v3 = (String)props.get("transferChunkSize")) != null && !"".equals(v3)) {
                        transferModeChunkSize = v3.trim();
                    }
                }
                String redirectMode = null;
                String redirectMaxHop = null;
                if (redirectMode == null && props != null && (v2 = (String)props.get("followRedirects")) != null && !"".equals(v2)) {
                    redirectMode = "true".equalsIgnoreCase(v2.trim()) || CostantiConfigurazione.ABILITATO.getValue().equalsIgnoreCase(v2.trim()) ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                    if (CostantiConfigurazione.ABILITATO.getValue().equals(redirectMode) && (v2 = (String)props.get("maxHopRedirect")) != null && !"".equals(v2)) {
                        redirectMaxHop = v2.trim();
                    }
                }
                String tokenPolicy = null;
                boolean autenticazioneToken = false;
                if (tokenPolicy == null && props != null && (v = (String)props.get("tokenPolicy")) != null && !"".equals(v)) {
                    tokenPolicy = v;
                    autenticazioneToken = true;
                }
                String opzioniAvanzate = ConnettoriHelper.getOpzioniAvanzate(saHelper, transferMode, redirectMode);
                String autenticazioneHttp = saHelper.getAutenticazioneHttp(null, endpointtype, user);
                String apiKeyValue = null;
                String apiKeyHeader = null;
                String appIdValue = null;
                String appIdHeader = null;
                if (props != null) {
                    apiKeyValue = (String)props.get("apiKey");
                    apiKeyHeader = (String)props.get("apiKeyHeader");
                    appIdValue = (String)props.get("appId");
                    appIdHeader = (String)props.get("appIdHeader");
                }
                String autenticazioneApiKey = saHelper.getAutenticazioneApiKey(null, endpointtype, apiKeyValue);
                boolean useOAS3Names = true;
                boolean useAppId = false;
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneApiKey)) {
                    useOAS3Names = saHelper.isAutenticazioneApiKeyUseOAS3Names(apiKeyHeader, appIdHeader);
                    useAppId = saHelper.isAutenticazioneApiKeyUseAppId(appIdValue);
                }
                List cp = connis != null ? connis.getPropertyList() : null;
                String url = null;
                String nomeCodaJMS = null;
                String tipoCodaJMS = null;
                String connfact = null;
                String sendas = null;
                String initcont = null;
                String urlpgk = null;
                String provurl = null;
                if (connis != null) {
                    for (int i = 0; i < connis.sizePropertyList(); ++i) {
                        Property singlecp = (Property)cp.get(i);
                        if (singlecp.getNome().equals("location") && url == null) {
                            url = singlecp.getValore();
                        }
                        if (singlecp.getNome().equals("location") && nomeCodaJMS == null) {
                            nomeCodaJMS = singlecp.getValore();
                        }
                        if (singlecp.getNome().equals("tipo") && tipoCodaJMS == null) {
                            tipoCodaJMS = singlecp.getValore();
                        }
                        if (singlecp.getNome().equals("connection-factory") && connfact == null) {
                            connfact = singlecp.getValore();
                        }
                        if (singlecp.getNome().equals("send-as") && sendas == null) {
                            sendas = singlecp.getValore();
                        }
                        if (singlecp.getNome().equals("context-java.naming.factory.initial") && initcont == null) {
                            initcont = singlecp.getValore();
                        }
                        if (singlecp.getNome().equals("context-java.naming.factory.url.pkgs") && urlpgk == null) {
                            urlpgk = singlecp.getValore();
                        }
                        if (!singlecp.getNome().equals("context-java.naming.provider.url") || provurl != null) continue;
                        provurl = singlecp.getValore();
                    }
                }
                String httpstipologia = null;
                String httpsurl = null;
                String httpshostverifyS = null;
                boolean httpshostverify = false;
                String httpsTrustVerifyCertS = null;
                boolean httpsTrustVerifyCert = false;
                String httpspath = null;
                String httpstipo = null;
                String httpspwd = null;
                String httpsalgoritmo = null;
                String httpspwdprivatekeytrust = null;
                String httpspathkey = null;
                String httpstipokey = null;
                String httpspwdkey = null;
                String httpspwdprivatekey = null;
                String httpsalgoritmokey = null;
                String httpsKeyAlias = null;
                String httpsTrustStoreCRLs = null;
                String httpsTrustStoreOCSPPolicy = null;
                String httpsKeyStoreBYOKPolicy = null;
                boolean httpsstato = false;
                String httpskeystore = null;
                if (httpstipologia == null && props != null) {
                    httpsurl = (String)props.get("location");
                    httpstipologia = (String)props.get("sslType");
                    httpshostverifyS = (String)props.get("hostnameVerifier");
                    if (httpshostverifyS != null) {
                        httpshostverify = Boolean.valueOf(httpshostverifyS);
                    }
                    httpsTrustVerifyCert = (httpsTrustVerifyCertS = (String)props.get("trustAllCerts")) != null ? Boolean.valueOf(httpsTrustVerifyCertS) == false : true;
                    httpspath = (String)props.get("trustStoreLocation");
                    httpstipo = (String)props.get("trustStoreType");
                    httpspwd = (String)props.get("trustStorePassword");
                    httpsalgoritmo = (String)props.get("trustManagementAlgorithm");
                    httpspwdprivatekeytrust = (String)props.get("keyPassword");
                    httpspathkey = (String)props.get("keyStoreLocation");
                    httpstipokey = (String)props.get("keyStoreType");
                    httpspwdkey = (String)props.get("keyStorePassword");
                    httpspwdprivatekey = (String)props.get("keyPassword");
                    httpsalgoritmokey = (String)props.get("keyManagementAlgorithm");
                    httpsKeyAlias = (String)props.get("keyAlias");
                    httpsTrustStoreCRLs = (String)props.get("trustStoreCRLs");
                    httpsTrustStoreOCSPPolicy = (String)props.get("trustStoreOCSPPolicy");
                    httpsKeyStoreBYOKPolicy = (String)props.get("keyStoreBYOKPolicy");
                    if (httpspathkey == null) {
                        httpsstato = false;
                        httpskeystore = "default";
                    } else {
                        httpsstato = true;
                        httpskeystore = httpspathkey.equals(httpspath) && httpstipokey.equals(httpstipo) && (httpspwdkey != null && httpspwdkey.equals(httpspwd) || httpspwdkey == null && httpspwd == null) ? "default" : "ridefinisci";
                    }
                }
                if (httpsalgoritmo == null || "".equals(httpsalgoritmo)) {
                    httpsalgoritmo = TrustManagerFactory.getDefaultAlgorithm();
                }
                if (httpsalgoritmokey == null || "".equals(httpsalgoritmokey)) {
                    httpsalgoritmokey = KeyManagerFactory.getDefaultAlgorithm();
                }
                if (httpstipologia == null || "".equals(httpstipologia)) {
                    httpstipologia = ConnettoriCostanti.DEFAULT_CONNETTORE_HTTPS_TYPE;
                }
                if (httpshostverifyS == null || "".equals(httpshostverifyS)) {
                    httpshostverifyS = "true";
                    httpshostverify = ServletUtils.isCheckBoxEnabled((String)httpshostverifyS);
                }
                if (httpsTrustVerifyCertS == null || "".equals(httpsTrustVerifyCertS)) {
                    httpsTrustVerifyCertS = "true";
                    httpsTrustVerifyCert = ServletUtils.isCheckBoxEnabled((String)httpsTrustVerifyCertS);
                }
                String responseInputMode = null;
                String requestOutputFileName = null;
                String requestOutputFileNamePermissions = null;
                String requestOutputFileNameHeaders = null;
                String requestOutputFileNameHeadersPermissions = null;
                String requestOutputParentDirCreateIfNotExists = null;
                String requestOutputOverwriteIfExists = null;
                String responseInputFileName = null;
                String responseInputFileNameHeaders = null;
                String responseInputDeleteAfterRead = null;
                String responseInputWaitTime = null;
                if (responseInputMode == null && props != null) {
                    requestOutputFileName = (String)props.get("outputFile");
                    requestOutputFileNamePermissions = saHelper.getParameter("requestOutputFileNameP");
                    requestOutputFileNameHeaders = (String)props.get("outputFileHeaders");
                    requestOutputFileNameHeadersPermissions = saHelper.getParameter("requestOutputFileNameHeadersP");
                    String v6 = (String)props.get("outputFileAutoCreateParentDirectory");
                    if (v6 != null && !"".equals(v6) && ("true".equalsIgnoreCase(v6) || CostantiConfigurazione.ABILITATO.getValue().equalsIgnoreCase(v6))) {
                        requestOutputParentDirCreateIfNotExists = "true";
                    }
                    if ((v6 = (String)props.get("outputFileOverwriteIfExists")) != null && !"".equals(v6) && ("true".equalsIgnoreCase(v6) || CostantiConfigurazione.ABILITATO.getValue().equalsIgnoreCase(v6))) {
                        requestOutputOverwriteIfExists = "true";
                    }
                    if ((v6 = (String)props.get("response")) != null && !"".equals(v6) && ("true".equalsIgnoreCase(v6) || CostantiConfigurazione.ABILITATO.getValue().equalsIgnoreCase(v6))) {
                        responseInputMode = CostantiConfigurazione.ABILITATO.getValue();
                    }
                    if (CostantiConfigurazione.ABILITATO.getValue().equals(responseInputMode)) {
                        responseInputFileName = (String)props.get("inputFile");
                        responseInputFileNameHeaders = (String)props.get("inputFileHeaders");
                        v6 = (String)props.get("inputFileDeleteAfterRead");
                        if (v6 != null && !"".equals(v6) && ("true".equalsIgnoreCase(v6) || CostantiConfigurazione.ABILITATO.getValue().equalsIgnoreCase(v6))) {
                            responseInputDeleteAfterRead = "true";
                        }
                        responseInputWaitTime = (String)props.get("inputFileWaitTimeIfNotExists");
                    }
                }
                ConnettoreStatusParams connettoreStatusParams = ConnettoreStatusParams.fillFrom(props);
                Boolean isConnettoreCustomUltimaImmagineSalvata = connis != null ? connis.getCustom() : null;
                Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)session);
                String provider = "" + sa.getIdSoggetto();
                String tipoauthSA = null;
                String utenteSA = null;
                String passwordSA = null;
                String subjectSA = null;
                String issuerSA = null;
                String principalSA = null;
                String multipleApiKey = null;
                String appId = null;
                String apiKey = null;
                String tokenPolicySA = null;
                String tokenClientIdSA = null;
                boolean tokenWithHttpsEnabledByConfigSA = false;
                BinaryParameter tipoCredenzialiSSLFileCertificato = saHelper.getBinaryParameter("confSSLCredFileCert");
                String tipoCredenzialiSSLSorgente = null;
                String tipoCredenzialiSSLAliasCertificato = null;
                String tipoCredenzialiSSLAliasCertificatoSubject = null;
                String tipoCredenzialiSSLAliasCertificatoIssuer = null;
                String tipoCredenzialiSSLAliasCertificatoType = null;
                Object tipoCredenzialiSSLAliasCertificatoVersion = null;
                Object tipoCredenzialiSSLAliasCertificatoSerialNumber = null;
                String tipoCredenzialiSSLAliasCertificatoSelfSigned = null;
                String tipoCredenzialiSSLAliasCertificatoNotBefore = null;
                String tipoCredenzialiSSLAliasCertificatoNotAfter = null;
                String tipoCredenzialiSSLVerificaTuttiICampi = null;
                String tipoCredenzialiSSLConfigurazioneManualeSelfSigned = null;
                ArchiveType tipoCredenzialiSSLTipoArchivio = ArchiveType.CER;
                String tipoCredenzialiSSLFileCertificatoPassword = null;
                ArrayList<String> listaAliasEstrattiCertificato = new ArrayList<String>();
                String tipoCredenzialiSSLWizardStep = "0";
                if (credenziali != null && credenziali.getTipo() != null) {
                    tipoauthSA = credenziali.getTipo().getValue();
                    if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(tipoauthSA)) {
                        utenteSA = credenziali.getUser();
                        passwordSA = credenziali.getPassword();
                        String string = tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                    }
                    if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(tipoauthSA)) {
                        utenteSA = credenziali.getUser();
                        passwordSA = credenziali.getPassword();
                        tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                        multipleApiKey = credenziali.isAppId() ? "yes" : "no";
                        appId = credenziali.getUser();
                        apiKey = credenziali.getPassword();
                    }
                    if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL.equals(tipoauthSA)) {
                        principalSA = credenziali.getUser();
                    }
                    if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(tipoauthSA)) {
                        tokenClientIdSA = credenziali.getUser();
                        tokenPolicySA = credenziali.getTokenPolicy();
                    } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoauthSA) && tokenWithHttsSupportato) {
                        tokenClientIdSA = credenziali.getUser();
                        tokenPolicySA = credenziali.getTokenPolicy();
                        tokenWithHttpsEnabledByConfigSA = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoauthSA) && StringUtils.isNotEmpty((String)tokenClientIdSA);
                    }
                    boolean bl4 = tokenWithHttpsEnabledByConfigSA = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoauthSA) && StringUtils.isNotEmpty((String)tokenClientIdSA);
                }
                if (credenziali != null) {
                    if (credenziali.getCertificate() != null) {
                        tipoCredenzialiSSLFileCertificato.setValue(credenziali.getCertificate());
                        tipoCredenzialiSSLSorgente = "uploadCert";
                        tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                        try {
                            Certificate cSelezionato = ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue());
                            tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                            tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                            tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                            tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                            tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                            tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                            tipoCredenzialiSSLAliasCertificatoNotBefore = saHelper.getSdfCredenziali().format(cSelezionato.getCertificate().getNotBefore());
                            tipoCredenzialiSSLAliasCertificatoNotAfter = saHelper.getSdfCredenziali().format(cSelezionato.getCertificate().getNotAfter());
                        }
                        catch (UtilsException e) {
                            pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                            tipoCredenzialiSSLAliasCertificato = "";
                            tipoCredenzialiSSLAliasCertificatoSubject = "";
                            tipoCredenzialiSSLAliasCertificatoIssuer = "";
                            tipoCredenzialiSSLAliasCertificatoType = "";
                            tipoCredenzialiSSLAliasCertificatoVersion = "";
                            tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                            tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                            tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                            tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                        }
                    } else {
                        subjectSA = credenziali.getSubject();
                        issuerSA = credenziali.getIssuer();
                        tipoCredenzialiSSLSorgente = "confMan";
                        tipoCredenzialiSSLConfigurazioneManualeSelfSigned = subjectSA != null && subjectSA.equals(issuerSA) ? "yes" : "no";
                    }
                }
                String changepwd = null;
                List<ExtendedConnettore> listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(connis, ConnettoreServletType.SERVIZIO_APPLICATIVO_CHANGE, (ConsoleHelper)saHelper, endpointtype == null, endpointtype);
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                consoleDynamicConfiguration.updateDynamicConfigServizioApplicativo(consoleConfiguration, consoleOperationType, (IConsoleHelper)saHelper, protocolProperties, registryReader, configRegistryReader, idServizioApplicativoTmp);
                dati = saHelper.addServizioApplicativoToDati(dati, oldNome, nomeParameter, descrizione, tipoENomeSoggetto, fault, TipoOperazione.CHANGE, idServizioApplicativo, contaListe, null, null, provider, dominio, utenteSA, passwordSA, subjectSA, principalSA, tipoauthSA, faultactor, genericfault, prefixfault, invrifRisposta, sbustamentoInformazioniProtocolloRisposta, "serviziApplicativiChange.do", id, tipoProtocollo, ruoloFruitore, ruoloErogatore, sbustamento, sbustamentoInformazioniProtocolloRichiesta, getmsg, invrifRichiesta, risprif, endpointtype, autenticazioneHttp, url, nomeCodaJMS, tipoCodaJMS, user, password, initcont, urlpgk, provurl, connfact, sendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, connettoreDebug, isConnettoreCustomUltimaImmagineSalvata, proxyEnabled, proxyHostname, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, (String)tempiRispostaConnectionTimeout, (String)tempiRispostaReadTimeout, (String)tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, tipoProtocollo, null, listExtendedConnettore, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, (String)tipoCredenzialiSSLAliasCertificatoVersion, (String)tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuerSA, tipoCredenzialiSSLWizardStep, changepwd, multipleApiKey, appId, apiKey, autenticazioneToken, tokenPolicy, tipoSA, useAsClient, integrationManagerEnabled, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, tokenPolicySA, tokenClientIdSA, tokenWithHttpsEnabledByConfigSA, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams);
                dati = saHelper.addProtocolPropertiesToDatiConfig(dati, consoleConfiguration, consoleOperationType, protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"serviziApplicativi", (ForwardParams)ForwardParams.CHANGE());
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"serviziApplicativiVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"serviziApplicativiVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }
}

