/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.scope;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCostanti;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class ScopeHelper
extends ConsoleHelper {
    private static boolean mostraFiltroScopeTipologia = false;
    public static int POSIZIONE_FILTRO_PROTOCOLLO = 2;

    public ScopeHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public ScopeHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public List<DataElement> addScopeToDati(TipoOperazione tipoOP, Long scopeId, String nome, String descrizione, String tipologia, String nomeEsterno, String contesto, List<DataElement> dati, String oldNomeScope) throws DriverConfigurazioneException {
        Scope scope = null;
        if (TipoOperazione.CHANGE.equals((Object)tipoOP) && oldNomeScope != null && StringUtils.isNotEmpty((String)oldNomeScope)) {
            scope = this.scopeCore.getScope(oldNomeScope);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOP)) {
            ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
            Parameter pId = new Parameter("scopeId", "" + scopeId);
            listaParametriChange.add(pId);
            this.addComandoInUsoButton(nome, nome, InUsoType.SCOPE);
            if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
                listaParametriChange.add(new Parameter("rmElFromCache", "true"));
                this.pd.addComandoResetCacheElementoButton("scopeChange.do", listaParametriChange);
            }
            if (scope != null && this.existsProprietaOggetto(scope.getProprietaOggetto(), scope.getDescrizione())) {
                this.addComandoProprietaOggettoButton(nome, nome, InUsoType.SCOPE);
            }
        }
        DataElement de = new DataElement();
        de.setLabel("Scope");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (scopeId != null) {
            de = new DataElement();
            de.setLabel("scopeId");
            de.setValue("" + scopeId);
            de.setType(DataElementType.HIDDEN);
            de.setName("scopeId");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("scopeNome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(2);
        de.setName("scopeDescrizione");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Fonte");
        de.setType(DataElementType.SELECT);
        de.setName("scopeTipologia");
        de.setValue(tipologia);
        if (mostraFiltroScopeTipologia) {
            de.setType(DataElementType.TEXT_EDIT);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Identificativo Esterno");
        de.setValue(nomeEsterno);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("scopeNomeEsterno");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Contesto");
        de.setType(DataElementType.SELECT);
        de.setName("scopeContesto");
        de.setLabels(ScopeCostanti.getScopeContestoUtilizzoLabel());
        de.setValues(ScopeCostanti.getScopeContestoUtilizzo());
        de.setSelected(contesto);
        dati.add(de);
        return dati;
    }

    public boolean scopeCheckData(TipoOperazione tipoOp, Scope scope) throws Exception {
        try {
            String nome = this.getParameter("scopeNome");
            String descrizione = this.getParameter("scopeDescrizione");
            String nomeEsterno = this.getParameter("scopeNomeEsterno");
            if (nome.equals("")) {
                String tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + tmpElenco);
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo 'Nome'");
                return false;
            }
            if (!this.checkNCName(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (descrizione != null && !"".equals(descrizione) && !this.checkLength4000(descrizione, "Descrizione")) {
                return false;
            }
            if (nomeEsterno != null && !"".equals(nomeEsterno) && !this.checkLength255(nomeEsterno, "Identificativo Esterno")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (this.scopeCore.existsScope(nome)) {
                    this.pd.setMessage("Un scope con nome '" + nome + "' risulta gi&agrave; stato registrato");
                    return false;
                }
            } else if (!scope.getNome().equals(nome) && this.scopeCore.existsScope(nome)) {
                this.pd.setMessage("Un scope con nome '" + nome + "' risulta gi&agrave; stato registrato");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void prepareScopeList(ISearch ricerca, List<Scope> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"scope", (Parameter[])new Parameter[0]);
            boolean modalitaCompleta = this.isModalitaCompleta();
            if (!modalitaCompleta) {
                this.pd.setCustomListViewName("scope");
            }
            int idLista = Liste.SCOPE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            if (mostraFiltroScopeTipologia) {
                String filterScopeTipologia = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroScopeTipologia");
                this.addFilterScopeTipologia(filterScopeTipologia, false);
            }
            String filterScopeContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroScopeContesto");
            this.addFilterScopeContesto(filterScopeContesto, false);
            String filterApiContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiContesto");
            this.addFilterApiContesto(filterApiContesto, true);
            String filterProtocollo = null;
            String filterSoggetto = null;
            boolean profiloSelezionato = false;
            if (filterApiContesto != null && !"".equals(filterApiContesto)) {
                List<String> protocolli;
                filterProtocollo = this.addFilterProtocol(ricerca, idLista, true);
                String protocollo = filterProtocollo;
                if (protocollo == null && (protocolli = this.core.getProtocolli(this.request, this.session)) != null && protocolli.size() == 1) {
                    protocollo = protocolli.get(0);
                }
                if (filterProtocollo != null && !"".equals(filterProtocollo) || filterProtocollo == null && protocollo != null) {
                    profiloSelezionato = true;
                }
                if (profiloSelezionato && !this.isSoggettoMultitenantSelezionato()) {
                    filterSoggetto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggetto");
                    boolean soloSoggettiOperativi = true;
                    this.addFilterSoggetto(filterSoggetto, protocollo, soloSoggettiOperativi, true);
                } else {
                    filterSoggetto = this.getSoggettoMultitenantSelezionato();
                }
            }
            String filterGruppo = null;
            if (filterApiContesto != null && !"".equals(filterApiContesto)) {
                filterGruppo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
                this.addFilterGruppo(filterProtocollo, filterGruppo, true);
            } else {
                SearchUtils.clearFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
            }
            if (profiloSelezionato && filterApiContesto != null && !"".equals(filterApiContesto)) {
                String filterApiImplementazione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
                this.addFilterApiImplementazione(filterProtocollo, filterSoggetto, filterGruppo, filterApiContesto, filterApiImplementazione, false);
            } else {
                SearchUtils.clearFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Scope", "scopeList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Scope", "scopeList.do"), new Parameter("Risultati ricerca", null)});
            }
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Scope", (String)search);
            }
            this.setLabelColonne(modalitaCompleta);
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (lista != null) {
                Iterator<Scope> it = lista.iterator();
                while (it.hasNext()) {
                    List<DataElement> e = modalitaCompleta ? this.creaEntry(it) : this.creaEntryCustom(it);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.SCOPE, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ScopeCostanti.LABEL_SCOPE_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private List<DataElement> creaEntry(Iterator<Scope> it) {
        Scope scope = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        Parameter pId = new Parameter("scopeId", "" + scope.getId());
        de.setUrl("scopeChange.do", new Parameter[]{pId});
        de.setToolTip(scope.getDescrizione());
        de.setValue(scope.getNome());
        de.setIdToRemove(scope.getNome());
        de.setToolTip(scope.getDescrizione());
        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        e.add(de);
        if (mostraFiltroScopeTipologia) {
            de = new DataElement();
            de.setValue(scope.getTipologia());
            e.add(de);
        }
        de = new DataElement();
        if (ScopeContesto.PORTA_APPLICATIVA.getValue().equals(scope.getContestoUtilizzo().getValue())) {
            de.setValue("Erogazione");
        } else if (ScopeContesto.PORTA_DELEGATA.getValue().equals(scope.getContestoUtilizzo().getValue())) {
            de.setValue("Fruizione");
        } else {
            de.setValue("Qualsiasi");
        }
        e.add(de);
        return e;
    }

    private void setLabelColonne(boolean modalitaCompleta) {
        if (!modalitaCompleta) {
            String[] labels = new String[]{"Scope"};
            this.pd.setLabels(labels);
        } else {
            ArrayList<String> listLabels = new ArrayList<String>();
            listLabels.add("Nome");
            if (mostraFiltroScopeTipologia) {
                listLabels.add("Fonte");
            }
            listLabels.add("Contesto");
            String[] labels = listLabels.toArray(new String[listLabels.size()]);
            this.pd.setLabels(labels);
        }
    }

    private List<DataElement> creaEntryCustom(Iterator<Scope> it) {
        Scope scope = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        Parameter pId = new Parameter("scopeId", "" + scope.getId());
        de.setUrl("scopeChange.do", new Parameter[]{pId});
        de.setToolTip(scope.getDescrizione());
        de.setValue(scope.getNome());
        de.setIdToRemove(scope.getNome());
        de.setToolTip(scope.getDescrizione());
        de.setType(DataElementType.TITLE);
        e.add(de);
        de = new DataElement();
        String contestoLabel = "";
        contestoLabel = ScopeContesto.PORTA_APPLICATIVA.getValue().equals(scope.getContestoUtilizzo().getValue()) ? "Erogazione" : (ScopeContesto.PORTA_DELEGATA.getValue().equals(scope.getContestoUtilizzo().getValue()) ? "Fruizione" : "Qualsiasi");
        String identificativoEsternoLabelPrefix = "";
        if (scope.getNomeEsterno() != null) {
            identificativoEsternoLabelPrefix = MessageFormat.format("Identificativo Esterno: {0}, ", scope.getNomeEsterno());
        }
        if (mostraFiltroScopeTipologia) {
            de.setValue(identificativoEsternoLabelPrefix + MessageFormat.format("Contesto: {0}, Fonte: {1}", contestoLabel, scope.getTipologia()));
        } else {
            de.setValue(identificativoEsternoLabelPrefix + MessageFormat.format("Contesto: {0}", contestoLabel));
        }
        de.setType(DataElementType.SUBTITLE);
        e.add(de);
        ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
        listaParametriChange.add(pId);
        listaParametriChange.add(new Parameter("resetFromLista", "true"));
        this.addInUsoButton(e, scope.getNome(), scope.getNome(), InUsoType.SCOPE);
        if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
            this.addComandoResetCacheButton(e, scope.getNome(), "scopeChange.do", listaParametriChange);
        }
        this.addProprietaOggettoButton(e, scope.getNome(), scope.getNome(), InUsoType.SCOPE);
        return e;
    }

    static {
        if (mostraFiltroScopeTipologia) {
            POSIZIONE_FILTRO_PROTOCOLLO = 3;
        }
    }
}

