/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.pdd.core.autenticazione.ApiKey;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.OggettoDialogEnum;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiChangeStrutsBean;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiUtilities;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public final class SoggettiChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        SoggettiChangeStrutsBean strutsBean = new SoggettiChangeStrutsBean();
        strutsBean.consoleOperationType = ConsoleOperationType.CHANGE;
        TipoOperazione tipoOp = TipoOperazione.CHANGE;
        List oldProtocolPropertyList = null;
        try {
            List<Soggetto> listaSoggetti;
            IDSoggetto oldSoggetto;
            String oldIdentificativoPorta;
            String tipoCredenzialiSSLConfigurazioneManualeSelfSigned;
            SoggettiHelper soggettiHelper = new SoggettiHelper(request, pd, session);
            strutsBean.id = soggettiHelper.getParameter("id");
            if (strutsBean.id == null) {
                throw new ControlStationCoreException("Identificativo soggetto non fornito");
            }
            long idSogg = Long.parseLong(strutsBean.id);
            strutsBean.nomeprov = soggettiHelper.getParameter("nomeprov");
            strutsBean.tipoprov = soggettiHelper.getParameter("tipoprov");
            strutsBean.portadom = soggettiHelper.getParameter("portadom");
            strutsBean.descr = soggettiHelper.getParameter("descr");
            strutsBean.versioneProtocollo = soggettiHelper.getParameter("profilo");
            strutsBean.pdd = soggettiHelper.getParameter("pdd");
            String isRouterParameter = soggettiHelper.getParameter("is_router");
            strutsBean.isRouter = ServletUtils.isCheckBoxEnabled((String)isRouterParameter);
            strutsBean.dominio = soggettiHelper.getParameter("dominio");
            String isPrivatoParameter = soggettiHelper.getParameter("privato");
            strutsBean.privato = ServletUtils.isCheckBoxEnabled((String)isPrivatoParameter);
            strutsBean.codiceIpa = soggettiHelper.getParameter("codice_ipa");
            strutsBean.pd_url_prefix_rewriter = soggettiHelper.getParameter("pd_url_prefix_rewriter");
            strutsBean.pa_url_prefix_rewriter = soggettiHelper.getParameter("pa_url_prefix_rewriter");
            strutsBean.editMode = soggettiHelper.getParameter("edit-mode");
            strutsBean.protocolPropertiesSet = soggettiHelper.getParameter("ppSet");
            strutsBean.tipoauthSoggetto = soggettiHelper.getParameter("tipoauthCredenziali");
            strutsBean.utenteSoggetto = soggettiHelper.getParameter("utenteCredenziali");
            strutsBean.passwordSoggetto = soggettiHelper.getParameter("passwordCredenziali");
            strutsBean.subjectSoggetto = soggettiHelper.getParameter("subjectCredenziali");
            strutsBean.principalSoggetto = soggettiHelper.getParameter("principalCredenziali");
            String changepwd = soggettiHelper.getParameter("changepwd");
            String tipoCredenzialiSSLSorgente = soggettiHelper.getParameter("confSSLCredenziali");
            if (tipoCredenzialiSSLSorgente == null) {
                tipoCredenzialiSSLSorgente = "uploadCert";
            }
            String tipoCredenzialiSSLTipoArchivioS = soggettiHelper.getParameter("confSSLCredTipoArch");
            ArchiveType tipoCredenzialiSSLTipoArchivio = null;
            tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
            BinaryParameter tipoCredenzialiSSLFileCertificato = soggettiHelper.getBinaryParameter("confSSLCredFileCert");
            String tipoCredenzialiSSLFileCertificatoPassword = soggettiHelper.getParameter("confSSLCredFileCertPwd");
            List<String> listaAliasEstrattiCertificato = new ArrayList();
            String tipoCredenzialiSSLAliasCertificato = soggettiHelper.getParameter("confSSLCredAliasCert");
            if (tipoCredenzialiSSLAliasCertificato == null) {
                tipoCredenzialiSSLAliasCertificato = "";
            }
            String tipoCredenzialiSSLAliasCertificatoSubject = soggettiHelper.getParameter("confSSLCredAliasCertSub");
            String tipoCredenzialiSSLAliasCertificatoIssuer = soggettiHelper.getParameter("confSSLCredAliasCertIss");
            String tipoCredenzialiSSLAliasCertificatoType = soggettiHelper.getParameter("confSSLCredAliasCertType");
            Object tipoCredenzialiSSLAliasCertificatoVersion = soggettiHelper.getParameter("confSSLCredAliasCertVers");
            Object tipoCredenzialiSSLAliasCertificatoSerialNumber = soggettiHelper.getParameter("confSSLCredAliasCertSN");
            String tipoCredenzialiSSLAliasCertificatoSelfSigned = soggettiHelper.getParameter("confSSLCredAliasCertSS");
            String tipoCredenzialiSSLAliasCertificatoNotBefore = soggettiHelper.getParameter("confSSLCredAliasCertNB");
            String tipoCredenzialiSSLAliasCertificatoNotAfter = soggettiHelper.getParameter("confSSLCredAliasCertNA");
            String tipoCredenzialiSSLVerificaTuttiICampi = soggettiHelper.getParameter("confSSLCredVerifTutti");
            if ((tipoCredenzialiSSLVerificaTuttiICampi == null || StringUtils.isEmpty((String)tipoCredenzialiSSLVerificaTuttiICampi) || "dominio".equalsIgnoreCase(soggettiHelper.getPostBackElementName()) || "tipologia".equalsIgnoreCase(soggettiHelper.getPostBackElementName())) && soggettiHelper.isEditModeInProgress() && soggettiHelper.getPostBackElementName() == null) {
                tipoCredenzialiSSLVerificaTuttiICampi = "yes";
            }
            if ((tipoCredenzialiSSLConfigurazioneManualeSelfSigned = soggettiHelper.getParameter("confSSLManSS")) == null) {
                tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "no";
            }
            String issuerSoggetto = soggettiHelper.getParameter("subjectIssuer");
            String tipoCredenzialiSSLWizardStep = soggettiHelper.getParameter("confSSLCredWizStep");
            if (tipoCredenzialiSSLWizardStep == null) {
                tipoCredenzialiSSLWizardStep = "0";
            }
            String oldTipoCredenzialiSSLWizardStep = tipoCredenzialiSSLWizardStep;
            String multipleApiKey = soggettiHelper.getParameter("apiKeyMultipleCred");
            String appId = soggettiHelper.getParameter("appIdCred");
            String apiKey = soggettiHelper.getParameter("apiKeyCred");
            boolean visualizzaModificaCertificato = false;
            boolean visualizzaAddCertificato = false;
            String servletCredenzialiList = "soggettiCredenzialiList.do";
            ArrayList<Parameter> parametersServletCredenzialiList = null;
            Integer numeroCertificati = 0;
            String servletCredenzialiAdd = "soggettiCredenzialiAdd.do";
            strutsBean.modificaOperativo = soggettiHelper.getParameter("modificaDatiOperativo");
            String resetElementoCacheS = soggettiHelper.getParameter("rmElFromCache");
            boolean resetElementoCache = ServletUtils.isCheckBoxEnabled((String)resetElementoCacheS);
            soggettiHelper.makeMenu();
            String oldnomeprov = "";
            String oldtipoprov = "";
            String oldpdd = null;
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)session);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            Soggetto soggettoRegistry = null;
            org.openspcoop2.core.config.Soggetto soggettoConfig = null;
            List<String> tipiSoggetti = null;
            int numPA = 0;
            int numPD = 0;
            int numSA = 0;
            String[] pddList = null;
            String[] pddEsterneList = null;
            List<Object> versioniProtocollo = null;
            SoggettiCore soggettiCore = new SoggettiCore();
            PddCore pddCore = new PddCore(soggettiCore);
            PorteDelegateCore porteDelegateCore = new PorteDelegateCore(soggettiCore);
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(soggettiCore);
            ServiziApplicativiCore saCore = new ServiziApplicativiCore(soggettiCore);
            UtentiCore utentiCore = new UtentiCore(soggettiCore);
            String nomePddGestioneLocale = null;
            if (!pddCore.isGestionePddAbilitata(soggettiHelper) && (nomePddGestioneLocale = pddCore.getNomePddOperativa()) == null) {
                throw new ControlStationCoreException("Non \u00e8 stata rilevata una pdd di tipologia 'operativo'");
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistry = soggettiCore.getSoggettoRegistro(idSogg);
            }
            soggettoConfig = soggettiCore.getSoggetto(idSogg);
            if (soggettiCore.isRegistroServiziLocale()) {
                oldnomeprov = soggettoRegistry.getNome();
                oldtipoprov = soggettoRegistry.getTipo();
                oldpdd = soggettoRegistry.getPortaDominio();
            } else {
                oldnomeprov = soggettoConfig.getNome();
                oldtipoprov = soggettoConfig.getTipo();
            }
            Parameter pIdSoggetto = new Parameter("id", strutsBean.id);
            Parameter pNomeSoggetto = new Parameter("nomeprov", oldnomeprov);
            Parameter pTipoSoggetto = new Parameter("tipoprov", oldtipoprov);
            parametersServletCredenzialiList = new ArrayList<Parameter>();
            parametersServletCredenzialiList.add(pIdSoggetto);
            parametersServletCredenzialiList.add(pNomeSoggetto);
            parametersServletCredenzialiList.add(pTipoSoggetto);
            boolean encryptOldPlainPwd = false;
            if (soggettoRegistry != null && soggettoRegistry.sizeCredenzialiList() > 0 && CredenzialeTipo.BASIC.equals((Object)soggettoRegistry.getCredenziali(0).getTipo())) {
                encryptOldPlainPwd = !soggettoRegistry.getCredenziali(0).isCertificateStrictVerification() && soggettiCore.isSoggettiPasswordEncryptEnabled();
            }
            List<String> listaTipiProtocollo = soggettiCore.getProtocolli(request, session);
            strutsBean.protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(strutsBean.tipoprov);
            tipiSoggetti = soggettiCore.getTipiSoggettiGestitiProtocollo(strutsBean.protocollo);
            if (soggettiHelper.isModalitaAvanzata()) {
                versioniProtocollo = soggettiCore.getVersioniProtocollo(strutsBean.protocollo);
            } else {
                versioniProtocollo = new ArrayList();
                strutsBean.versioneProtocollo = soggettiCore.getVersioneDefaultProtocollo(strutsBean.protocollo);
                versioniProtocollo.add(strutsBean.versioneProtocollo);
            }
            boolean isSupportatoAutenticazioneSoggetti = soggettiCore.isSupportatoAutenticazioneSoggetti(strutsBean.protocollo);
            boolean isSupportatoCodiceIPA = soggettiCore.isSupportatoCodiceIPA(strutsBean.protocollo);
            boolean isSupportatoIdentificativoPorta = soggettiCore.isSupportatoIdentificativoPorta(strutsBean.protocollo);
            boolean isPddEsterna = pddCore.isPddEsterna(strutsBean.pdd);
            if (isSupportatoAutenticazioneSoggetti && isPddEsterna && strutsBean.tipoauthSoggetto == null && "nessuna".equals(strutsBean.tipoauthSoggetto)) {
                strutsBean.tipoauthSoggetto = soggettiCore.getAutenticazione_generazioneAutomaticaPorteApplicative();
            }
            if (contaListe != null && contaListe.booleanValue()) {
                IDSoggetto soggetto = new IDSoggetto(soggettoConfig.getTipo(), soggettoConfig.getNome());
                ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                porteApplicativeCore.porteAppList(idSogg, (ISearch)searchForCount);
                numPA = searchForCount.getNumEntries(Liste.PORTE_APPLICATIVE_BY_SOGGETTO);
                porteDelegateCore.porteDelegateList(idSogg, (ISearch)searchForCount);
                numPD = searchForCount.getNumEntries(Liste.PORTE_DELEGATE_BY_SOGGETTO);
                saCore.servizioApplicativoList(soggetto, (ISearch)searchForCount);
                numSA = searchForCount.getNumEntries(Liste.SERVIZIO_APPLICATIVO);
            }
            if (soggettiCore.isSinglePdD() && soggettiCore.isRegistroServiziLocale()) {
                boolean pddOperativa = false;
                if (soggettoRegistry.getPortaDominio() != null && !"".equals(soggettoRegistry.getPortaDominio())) {
                    PdDControlStation pddCtrlstat = pddCore.getPdDControlStation(soggettoRegistry.getPortaDominio());
                    pddOperativa = PddTipologia.OPERATIVO.toString().equals(pddCtrlstat.getTipo());
                }
                ArrayList<PdDControlStation> lista = new ArrayList<PdDControlStation>();
                if (numPA <= 0 && numPD <= 0 && numSA <= 0 || !pddOperativa) {
                    ArrayList<String> pddEsterne = new ArrayList<String>();
                    pddEsterne.add("-");
                    PdDControlStation tmp = new PdDControlStation();
                    tmp.setNome("-");
                    lista.add(tmp);
                    if (soggettiCore.isVisioneOggettiGlobale(userLogin)) {
                        lista.addAll(pddCore.pddList(null, (ISearch)new ConsoleSearch(true)));
                    } else {
                        lista.addAll(pddCore.pddList(userLogin, (ISearch)new ConsoleSearch(true)));
                    }
                    pddList = new String[lista.size()];
                    int i = 0;
                    for (PdDControlStation pddTmp : lista) {
                        pddList[i] = pddTmp.getNome();
                        ++i;
                        if (!PddTipologia.ESTERNO.toString().equals(pddTmp.getTipo())) continue;
                        pddEsterne.add(pddTmp.getNome());
                    }
                    pddEsterneList = pddEsterne.toArray(new String[1]);
                } else {
                    pddList = new String[]{soggettoRegistry.getPortaDominio()};
                }
            }
            Connettore connettore = null;
            if (soggettiCore.isRegistroServiziLocale()) {
                connettore = soggettoRegistry.getConnettore();
            }
            IDSoggetto idSoggetto = new IDSoggetto(oldtipoprov, oldnomeprov);
            strutsBean.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(strutsBean.protocollo);
            strutsBean.consoleDynamicConfiguration = strutsBean.protocolFactory.createDynamicConfigurationConsole();
            strutsBean.registryReader = soggettiCore.getRegistryReader(strutsBean.protocolFactory);
            strutsBean.configRegistryReader = soggettiCore.getConfigIntegrationReader(strutsBean.protocolFactory);
            strutsBean.consoleConfiguration = strutsBean.consoleDynamicConfiguration.getDynamicConfigSoggetto(strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
            strutsBean.protocolProperties = soggettiHelper.estraiProtocolPropertiesDaRequest(strutsBean.consoleConfiguration, strutsBean.consoleOperationType);
            CredenzialiSoggetto oldCredenziali = null;
            try {
                Soggetto soggetto = strutsBean.registryReader.getSoggetto(idSoggetto);
                oldProtocolPropertyList = soggetto.getProtocolPropertyList();
                numeroCertificati = soggetto.sizeCredenzialiList();
                if (soggetto.sizeCredenzialiList() > 0) {
                    oldCredenziali = soggetto.getCredenziali(0);
                    visualizzaAddCertificato = true;
                    if (soggetto.sizeCredenzialiList() == 1) {
                        visualizzaModificaCertificato = true;
                    }
                }
            }
            catch (RegistryNotFound soggetto) {
                // empty catch block
            }
            Properties propertiesProprietario = new Properties();
            propertiesProprietario.setProperty("idProprietario", strutsBean.id);
            propertiesProprietario.setProperty("tipoProprietario", "SOGGETTO");
            propertiesProprietario.setProperty("nomeProprietario", oldtipoprov + "/" + oldnomeprov);
            propertiesProprietario.setProperty("urlOrigChange", URLEncoder.encode("soggettiChange.do?" + request.getQueryString(), "UTF-8"));
            propertiesProprietario.setProperty("protocollo", strutsBean.protocollo);
            String postBackElementName = soggettiHelper.getPostBackElementName();
            String labelButtonSalva = "Salva";
            boolean postBackTipoAuthSoggetto = false;
            if (postBackElementName != null) {
                if (postBackElementName.equalsIgnoreCase("tipoauthCredenziali")) {
                    postBackTipoAuthSoggetto = true;
                    if (strutsBean.tipoauthSoggetto != null && strutsBean.tipoauthSoggetto.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL)) {
                        if (oldCredenziali != null && oldCredenziali.getTipo() != null && oldCredenziali.getTipo().getValue().equals(strutsBean.tipoauthSoggetto)) {
                            tipoCredenzialiSSLWizardStep = "0";
                            if (tipoCredenzialiSSLAliasCertificatoSubject == null || StringUtils.isEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                                if (oldCredenziali.getCertificate() != null) {
                                    try {
                                        Certificate cSelezionato = ArchiveLoader.load((byte[])oldCredenziali.getCertificate());
                                        tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                                        tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                                        tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                                        tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = soggettiHelper.getSdfCredenziali().format(cSelezionato.getCertificate().getNotBefore());
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = soggettiHelper.getSdfCredenziali().format(cSelezionato.getCertificate().getNotAfter());
                                    }
                                    catch (UtilsException e) {
                                        pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                        tipoCredenzialiSSLAliasCertificato = "";
                                        tipoCredenzialiSSLAliasCertificatoSubject = "";
                                        tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                        tipoCredenzialiSSLAliasCertificatoType = "";
                                        tipoCredenzialiSSLAliasCertificatoVersion = "";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                    }
                                }
                                tipoCredenzialiSSLVerificaTuttiICampi = oldCredenziali.isCertificateStrictVerification() ? "yes" : "no";
                            }
                        } else {
                            tipoCredenzialiSSLSorgente = "uploadCert";
                            tipoCredenzialiSSLTipoArchivio = ArchiveType.CER;
                            tipoCredenzialiSSLVerificaTuttiICampi = "yes";
                            tipoCredenzialiSSLAliasCertificato = "";
                            tipoCredenzialiSSLAliasCertificatoSubject = "";
                            tipoCredenzialiSSLAliasCertificatoIssuer = "";
                            tipoCredenzialiSSLAliasCertificatoType = "";
                            tipoCredenzialiSSLAliasCertificatoVersion = "";
                            tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                            tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                            tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                            tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                            listaAliasEstrattiCertificato = new ArrayList();
                            tipoCredenzialiSSLWizardStep = "1";
                        }
                    } else {
                        tipoCredenzialiSSLWizardStep = "0";
                        if (oldCredenziali != null && oldCredenziali.getTipo() != null) {
                            if (oldCredenziali.getTipo().getValue().equals(strutsBean.tipoauthSoggetto)) {
                                if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(strutsBean.tipoauthSoggetto)) {
                                    strutsBean.utenteSoggetto = oldCredenziali.getUser();
                                    strutsBean.passwordSoggetto = oldCredenziali.getPassword();
                                    String string = tipoCredenzialiSSLVerificaTuttiICampi = oldCredenziali.isCertificateStrictVerification() ? "yes" : "no";
                                }
                                if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                                    strutsBean.utenteSoggetto = oldCredenziali.getUser();
                                    strutsBean.passwordSoggetto = oldCredenziali.getPassword();
                                    tipoCredenzialiSSLVerificaTuttiICampi = oldCredenziali.isCertificateStrictVerification() ? "yes" : "no";
                                    multipleApiKey = oldCredenziali.isAppId() ? "yes" : "no";
                                    appId = oldCredenziali.getUser();
                                    apiKey = oldCredenziali.getPassword();
                                }
                                if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL.equals(strutsBean.tipoauthSoggetto)) {
                                    strutsBean.principalSoggetto = oldCredenziali.getUser();
                                }
                            } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(strutsBean.tipoauthSoggetto) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                                tipoCredenzialiSSLVerificaTuttiICampi = "no";
                            }
                        }
                    }
                }
                if (postBackElementName.equalsIgnoreCase("confSSLCredenziali") || postBackElementName.equalsIgnoreCase("confSSLCredFileModificaCertLink")) {
                    listaAliasEstrattiCertificato = new ArrayList();
                    tipoCredenzialiSSLTipoArchivio = ArchiveType.CER;
                    tipoCredenzialiSSLVerificaTuttiICampi = "yes";
                    tipoCredenzialiSSLAliasCertificato = "";
                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                    tipoCredenzialiSSLAliasCertificatoType = "";
                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                    soggettiHelper.deleteBinaryParameters(tipoCredenzialiSSLFileCertificato);
                    tipoCredenzialiSSLWizardStep = "1";
                    if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                        strutsBean.subjectSoggetto = "";
                        issuerSoggetto = "";
                        tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "no";
                        tipoCredenzialiSSLWizardStep = "0";
                    }
                }
                if (postBackElementName.equalsIgnoreCase("confSSLCredTipoArch")) {
                    soggettiHelper.deleteBinaryParameters(tipoCredenzialiSSLFileCertificato);
                    tipoCredenzialiSSLAliasCertificato = "";
                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                    tipoCredenzialiSSLAliasCertificatoType = "";
                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                    listaAliasEstrattiCertificato = new ArrayList();
                    tipoCredenzialiSSLVerificaTuttiICampi = "yes";
                    tipoCredenzialiSSLWizardStep = "1";
                }
                if (postBackElementName.equalsIgnoreCase("confSSLCredAliasCert")) {
                    tipoCredenzialiSSLWizardStep = StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificato) ? "3" : "4";
                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                    tipoCredenzialiSSLAliasCertificatoType = "";
                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                }
                if (postBackElementName.equalsIgnoreCase("changepwd")) {
                    if (!ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                        if (oldCredenziali != null) {
                            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(strutsBean.tipoauthSoggetto)) {
                                strutsBean.passwordSoggetto = oldCredenziali.getPassword();
                                String string = tipoCredenzialiSSLVerificaTuttiICampi = oldCredenziali.isCertificateStrictVerification() ? "yes" : "no";
                            }
                            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                                strutsBean.passwordSoggetto = oldCredenziali.getPassword();
                                tipoCredenzialiSSLVerificaTuttiICampi = oldCredenziali.isCertificateStrictVerification() ? "yes" : "no";
                                multipleApiKey = oldCredenziali.isAppId() ? "yes" : "no";
                                appId = oldCredenziali.getUser();
                                apiKey = oldCredenziali.getPassword();
                            }
                        }
                    } else {
                        appId = null;
                        apiKey = null;
                    }
                }
                if (postBackElementName.equalsIgnoreCase("apiKeyMultipleCred")) {
                    appId = null;
                    apiKey = null;
                }
            }
            if (postBackTipoAuthSoggetto) {
                // empty if block
            }
            if (resetElementoCache) {
                List<String> aliases = soggettiCore.getJmxPdDAliases();
                String alias = null;
                if (aliases != null && !aliases.isEmpty()) {
                    alias = aliases.get(0);
                }
                String labelSoggetto = soggettiHelper.getLabelNomeSoggetto(strutsBean.protocollo, oldtipoprov, oldnomeprov);
                soggettiCore.invokeJmxMethodAllNodesAndSetResult(pd, soggettiCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), soggettiCore.getJmxPdDConfigurazioneSistemaNomeMetodoRipulisciRiferimentiCacheSoggetto(alias), MessageFormat.format("{0} eliminato dalla cache", labelSoggetto), MessageFormat.format("Eliminazione {0} dalla cache non riuscita: ", labelSoggetto), idSogg);
                String resetFromLista = soggettiHelper.getParameter("resetFromLista");
                boolean arrivoDaLista = "true".equalsIgnoreCase(resetFromLista);
                if (arrivoDaLista) {
                    String filterDominioInterno = soggettiHelper.getParameter("internalDomain");
                    boolean forceFilterDominioInterno = false;
                    if ("true".equalsIgnoreCase(filterDominioInterno)) {
                        forceFilterDominioInterno = true;
                    }
                    boolean multiTenant = soggettiCore.isMultitenant();
                    ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                    int idLista = Liste.SOGGETTI;
                    List<Soggetto> lista = null;
                    if (soggettiCore.isRegistroServiziLocale() && !ServletUtils.isSearchDone((IConsoleHelper)soggettiHelper)) {
                        lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, Soggetto.class);
                    }
                    ricerca = soggettiHelper.checkSearchParameters(idLista, ricerca);
                    if (forceFilterDominioInterno) {
                        ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
                    } else if (!multiTenant && !soggettiHelper.isModalitaCompleta()) {
                        ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE);
                    }
                    if (soggettiCore.isRegistroServiziLocale()) {
                        if (lista == null) {
                            lista = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiRegistroList(null, (ISearch)ricerca) : soggettiCore.soggettiRegistroList(userLogin, (ISearch)ricerca);
                        }
                        if (!soggettiHelper.isPostBackFilterElement()) {
                            ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
                        }
                        soggettiHelper.prepareSoggettiList(lista, (ISearch)ricerca);
                    } else {
                        List<org.openspcoop2.core.config.Soggetto> listaSoggetti2 = null;
                        listaSoggetti2 = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiList(null, (ISearch)ricerca) : soggettiCore.soggettiList(userLogin, (ISearch)ricerca);
                        soggettiHelper.prepareSoggettiConfigList(listaSoggetti2, (ISearch)ricerca);
                    }
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.CHANGE());
                }
            }
            boolean checkWizard = false;
            if (strutsBean.tipoauthSoggetto != null && strutsBean.tipoauthSoggetto.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL)) {
                block212: {
                    boolean changeTipoDominio = false;
                    if ("dominio".equalsIgnoreCase(postBackElementName)) {
                        changeTipoDominio = true;
                    }
                    if (!changeTipoDominio && tipoCredenzialiSSLSorgente.equals("uploadCert") && !"confSSLCredVerifTutti".equals(postBackElementName)) {
                        if (tipoCredenzialiSSLFileCertificato.getValue() != null && tipoCredenzialiSSLFileCertificato.getValue().length > 0) {
                            Certificate cSelezionato;
                            tipoCredenzialiSSLWizardStep = "4";
                            if (!tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER)) {
                                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLFileCertificatoPassword) || KeystoreType.JKS.isType(tipoCredenzialiSSLTipoArchivio.name()) && !soggettiCore.isLoadCertificateWizardJksPasswordRequiredRequired() || KeystoreType.PKCS12.isType(tipoCredenzialiSSLTipoArchivio.name()) && !soggettiCore.isLoadCertificateWizardPkcs12PasswordRequiredRequired()) {
                                    try {
                                        listaAliasEstrattiCertificato = ArchiveLoader.readAliases((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLFileCertificatoPassword);
                                        Collections.sort(listaAliasEstrattiCertificato);
                                        if (!listaAliasEstrattiCertificato.isEmpty() && listaAliasEstrattiCertificato.size() == 1) {
                                            tipoCredenzialiSSLAliasCertificato = (String)listaAliasEstrattiCertificato.get(0);
                                        }
                                        if (oldTipoCredenzialiSSLWizardStep.equals("1") || oldTipoCredenzialiSSLWizardStep.equals("5") || oldTipoCredenzialiSSLWizardStep.equals("2")) {
                                            checkWizard = true;
                                            if (listaAliasEstrattiCertificato.size() > 1) {
                                                pd.setMessage("Il file caricato contiene pi&ugrave; certificati, selezionare un'Alias", MessageType.INFO);
                                            }
                                        }
                                    }
                                    catch (UtilsException e) {
                                        pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                        tipoCredenzialiSSLWizardStep = "2";
                                        tipoCredenzialiSSLAliasCertificato = "";
                                        tipoCredenzialiSSLAliasCertificatoSubject = "";
                                        tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                        tipoCredenzialiSSLAliasCertificatoType = "";
                                        tipoCredenzialiSSLAliasCertificatoVersion = "";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                    }
                                    if (!listaAliasEstrattiCertificato.isEmpty() && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificato)) {
                                        try {
                                            cSelezionato = ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword);
                                            tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                                            tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                                            tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                                            tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                                            tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                                            tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                                            tipoCredenzialiSSLAliasCertificatoNotBefore = strutsBean.sdf.format(cSelezionato.getCertificate().getNotBefore());
                                            tipoCredenzialiSSLAliasCertificatoNotAfter = strutsBean.sdf.format(cSelezionato.getCertificate().getNotAfter());
                                            tipoCredenzialiSSLWizardStep = "3";
                                        }
                                        catch (UtilsException e) {
                                            pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                            tipoCredenzialiSSLWizardStep = "2";
                                            tipoCredenzialiSSLAliasCertificato = "";
                                            tipoCredenzialiSSLAliasCertificatoSubject = "";
                                            tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                            tipoCredenzialiSSLAliasCertificatoType = "";
                                            tipoCredenzialiSSLAliasCertificatoVersion = "";
                                            tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                            tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                            tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                            tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                        }
                                    }
                                } else {
                                    tipoCredenzialiSSLWizardStep = "5";
                                }
                            } else {
                                try {
                                    cSelezionato = ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue());
                                    tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                                    tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                                    tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                                    tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                                    tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                                    tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                                    tipoCredenzialiSSLAliasCertificatoNotBefore = strutsBean.sdf.format(cSelezionato.getCertificate().getNotBefore());
                                    tipoCredenzialiSSLAliasCertificatoNotAfter = strutsBean.sdf.format(cSelezionato.getCertificate().getNotAfter());
                                    if (oldTipoCredenzialiSSLWizardStep.equals("6") || oldTipoCredenzialiSSLWizardStep.equals("3")) {
                                        tipoCredenzialiSSLWizardStep = "3";
                                        break block212;
                                    }
                                    tipoCredenzialiSSLWizardStep = "6";
                                    checkWizard = true;
                                }
                                catch (UtilsException e) {
                                    pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                    tipoCredenzialiSSLWizardStep = "2";
                                    tipoCredenzialiSSLAliasCertificato = "";
                                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                    tipoCredenzialiSSLAliasCertificatoType = "";
                                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                }
                            }
                        } else if (tipoCredenzialiSSLAliasCertificatoSubject == null || StringUtils.isEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                            tipoCredenzialiSSLWizardStep = "1";
                        }
                    }
                }
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLWizardStep) && (tipoCredenzialiSSLWizardStep.equals("1") || tipoCredenzialiSSLWizardStep.equals("5") || tipoCredenzialiSSLWizardStep.equals("2"))) {
                    if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                        labelButtonSalva = "Carica Certificato";
                    }
                } else {
                    labelButtonSalva = "Salva";
                }
            } else {
                labelButtonSalva = "Salva";
            }
            if (postBackElementName == null && oldTipoCredenzialiSSLWizardStep.equals("0")) {
                tipoCredenzialiSSLWizardStep = "0";
            }
            if (labelButtonSalva != null) {
                pd.setLabelBottoneInvia(labelButtonSalva);
            }
            boolean multipleApiKeysEnabled = false;
            boolean appIdModificabile = false;
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                multipleApiKeysEnabled = ServletUtils.isCheckBoxEnabled((String)multipleApiKey);
                if (appIdModificabile && multipleApiKeysEnabled) {
                    boolean soggettoDefined;
                    boolean bl = soggettoDefined = idSoggetto != null && idSoggetto.getTipo() != null && !"".equals(idSoggetto.getTipo()) && idSoggetto.getNome() != null && !"".equals(idSoggetto.getNome());
                    if ((appId == null || "".equals(appId)) && soggettoDefined) {
                        appId = soggettiCore.toAppId(strutsBean.protocollo, idSoggetto, multipleApiKeysEnabled);
                    }
                }
            }
            boolean modificataTipoAutenticazione = false;
            if (oldCredenziali != null && oldCredenziali.getTipo() != null) {
                if (!oldCredenziali.getTipo().getValue().equals(strutsBean.tipoauthSoggetto)) {
                    modificataTipoAutenticazione = true;
                }
            } else if (strutsBean.tipoauthSoggetto != null && !"".equals(strutsBean.tipoauthSoggetto) && !"nessuna".equals(strutsBean.tipoauthSoggetto)) {
                modificataTipoAutenticazione = true;
            }
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode) || checkWizard) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Soggetti", (String)"soggettiList.do", (String)soggettiHelper.getLabelNomeSoggetto(strutsBean.protocollo, oldtipoprov, oldnomeprov));
                if (isRouterParameter == null) {
                    strutsBean.isRouter = soggettoConfig.getRouter();
                }
                if (soggettiCore.isRegistroServiziLocale()) {
                    if (strutsBean.portadom == null) {
                        strutsBean.portadom = soggettoRegistry.getIdentificativoPorta();
                    } else {
                        String oldProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(oldtipoprov);
                        if (!oldProtocollo.equals(strutsBean.protocollo)) {
                            strutsBean.portadom = null;
                        }
                    }
                    if (strutsBean.descr == null) {
                        strutsBean.descr = soggettoRegistry.getDescrizione();
                    }
                    if (strutsBean.pdd == null) {
                        strutsBean.pdd = soggettoRegistry.getPortaDominio();
                    }
                    if (!pddCore.isGestionePddAbilitata(soggettiHelper)) {
                        if (strutsBean.dominio == null) {
                            strutsBean.dominio = pddCore.isPddEsterna(strutsBean.pdd) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
                        } else {
                            strutsBean.pdd = SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE.equals(strutsBean.dominio) ? nomePddGestioneLocale : null;
                        }
                    }
                    if (strutsBean.versioneProtocollo == null) {
                        strutsBean.versioneProtocollo = soggettoRegistry.getVersioneProtocollo();
                    }
                    if (soggettiHelper.getParameter("privato") == null) {
                        boolean bl = strutsBean.privato = soggettoRegistry.getPrivato() != null && soggettoRegistry.getPrivato() != false;
                    }
                    if (strutsBean.codiceIpa == null) {
                        strutsBean.codiceIpa = soggettoRegistry.getCodiceIpa();
                    }
                    if (isSupportatoAutenticazioneSoggetti) {
                        if (strutsBean.tipoauthSoggetto == null) {
                            CredenzialiSoggetto credenziali = null;
                            if (soggettoRegistry.sizeCredenzialiList() > 0) {
                                credenziali = soggettoRegistry.getCredenziali(0);
                            }
                            if (credenziali != null) {
                                if (credenziali.getTipo() != null) {
                                    strutsBean.tipoauthSoggetto = credenziali.getTipo().toString();
                                }
                                strutsBean.utenteSoggetto = credenziali.getUser();
                                strutsBean.passwordSoggetto = credenziali.getPassword();
                                if (strutsBean.tipoauthSoggetto != null && ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(strutsBean.tipoauthSoggetto)) {
                                    tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                                } else if (strutsBean.tipoauthSoggetto != null && ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                                    tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                                    multipleApiKey = credenziali.isAppId() ? "yes" : "no";
                                    appId = credenziali.getUser();
                                    apiKey = credenziali.getPassword();
                                }
                                strutsBean.principalSoggetto = credenziali.getUser();
                                if (credenziali.getCertificate() != null) {
                                    tipoCredenzialiSSLFileCertificato.setValue(credenziali.getCertificate());
                                    tipoCredenzialiSSLSorgente = "uploadCert";
                                    tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                                    try {
                                        Certificate cSelezionato = ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue());
                                        tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                                        tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                                        tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                                        tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = strutsBean.sdf.format(cSelezionato.getCertificate().getNotBefore());
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = strutsBean.sdf.format(cSelezionato.getCertificate().getNotAfter());
                                    }
                                    catch (UtilsException e) {
                                        pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                        tipoCredenzialiSSLAliasCertificato = "";
                                        tipoCredenzialiSSLAliasCertificatoSubject = "";
                                        tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                        tipoCredenzialiSSLAliasCertificatoType = "";
                                        tipoCredenzialiSSLAliasCertificatoVersion = "";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                    }
                                } else {
                                    strutsBean.subjectSoggetto = credenziali.getSubject();
                                    issuerSoggetto = credenziali.getIssuer();
                                    tipoCredenzialiSSLSorgente = "confMan";
                                    String string = tipoCredenzialiSSLConfigurazioneManualeSelfSigned = strutsBean.subjectSoggetto != null && strutsBean.subjectSoggetto.equals(issuerSoggetto) ? "yes" : "no";
                                }
                            }
                        }
                        if (strutsBean.tipoauthSoggetto == null) {
                            strutsBean.tipoauthSoggetto = "nessuna";
                        }
                    }
                } else {
                    if (strutsBean.portadom == null) {
                        strutsBean.portadom = soggettoConfig.getIdentificativoPorta();
                    } else {
                        String oldProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(oldtipoprov);
                        if (!oldProtocollo.equals(strutsBean.protocollo)) {
                            strutsBean.portadom = null;
                        }
                    }
                    if (strutsBean.descr == null) {
                        strutsBean.descr = soggettoConfig.getDescrizione();
                    }
                    if (isRouterParameter == null) {
                        strutsBean.isRouter = soggettoConfig.getRouter();
                    }
                }
                if (strutsBean.pd_url_prefix_rewriter == null) {
                    strutsBean.pd_url_prefix_rewriter = soggettoConfig.getPdUrlPrefixRewriter();
                }
                if (strutsBean.pa_url_prefix_rewriter == null) {
                    strutsBean.pa_url_prefix_rewriter = soggettoConfig.getPaUrlPrefixRewriter();
                }
                if (strutsBean.tipoprov == null) {
                    strutsBean.tipoprov = oldtipoprov;
                }
                if (strutsBean.nomeprov == null) {
                    strutsBean.nomeprov = oldnomeprov;
                }
                idSoggetto = new IDSoggetto(strutsBean.tipoprov, strutsBean.nomeprov);
                try {
                    Soggetto soggetto = strutsBean.registryReader.getSoggetto(idSoggetto);
                    oldProtocolPropertyList = soggetto.getProtocolPropertyList();
                }
                catch (RegistryNotFound soggetto) {
                    // empty catch block
                }
                if (strutsBean.protocolPropertiesSet == null) {
                    ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (List)oldProtocolPropertyList, (ConsoleOperationType)strutsBean.consoleOperationType);
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
                dati = soggettiHelper.addSoggettiToDati(tipoOp, dati, strutsBean.nomeprov, strutsBean.tipoprov, strutsBean.portadom, strutsBean.descr, strutsBean.isRouter, tipiSoggetti, strutsBean.versioneProtocollo, strutsBean.privato, strutsBean.codiceIpa, versioniProtocollo, isSupportatoCodiceIPA, isSupportatoIdentificativoPorta, pddList, pddEsterneList, nomePddGestioneLocale, strutsBean.pdd, strutsBean.id, oldnomeprov, oldtipoprov, connettore, numPD, strutsBean.pd_url_prefix_rewriter, numPA, strutsBean.pa_url_prefix_rewriter, listaTipiProtocollo, strutsBean.protocollo, isSupportatoAutenticazioneSoggetti, strutsBean.utenteSoggetto, strutsBean.passwordSoggetto, strutsBean.subjectSoggetto, strutsBean.principalSoggetto, strutsBean.tipoauthSoggetto, isPddEsterna, null, strutsBean.dominio, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, (String)tipoCredenzialiSSLAliasCertificatoVersion, (String)tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuerSoggetto, tipoCredenzialiSSLWizardStep, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, soggettoRegistry.sizeProprietaList());
                dati = soggettiHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                if (strutsBean.modificaOperativo != null && !"".equals(strutsBean.modificaOperativo)) {
                    DataElement de = new DataElement();
                    de.setName("modificaDatiOperativo");
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(strutsBean.modificaOperativo);
                    dati.add(de);
                }
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = SoggettiUtilities.soggettiCheckData(soggettiCore, soggettiHelper, "<br/>", oldnomeprov, oldtipoprov, strutsBean.privato, tipoOp, strutsBean.id, strutsBean.tipoprov, strutsBean.nomeprov, strutsBean.codiceIpa, strutsBean.pd_url_prefix_rewriter, strutsBean.pa_url_prefix_rewriter, soggettoRegistry, isSupportatoAutenticazioneSoggetti, strutsBean.descr, strutsBean.pdd);
            if (isOk) {
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
            }
            if (isOk) {
                try {
                    soggettiHelper.validaProtocolProperties(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (isOk) {
                try {
                    strutsBean.consoleDynamicConfiguration.validateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (!isOk) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Soggetti", (String)"soggettiList.do", (String)soggettiHelper.getLabelNomeSoggetto(strutsBean.protocollo, oldtipoprov, oldnomeprov));
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
                dati = soggettiHelper.addSoggettiToDati(tipoOp, dati, strutsBean.nomeprov, strutsBean.tipoprov, strutsBean.portadom, strutsBean.descr, strutsBean.isRouter, tipiSoggetti, strutsBean.versioneProtocollo, strutsBean.privato, strutsBean.codiceIpa, versioniProtocollo, isSupportatoCodiceIPA, isSupportatoIdentificativoPorta, pddList, pddEsterneList, nomePddGestioneLocale, strutsBean.pdd, strutsBean.id, oldnomeprov, oldtipoprov, connettore, numPD, strutsBean.pd_url_prefix_rewriter, numPA, strutsBean.pa_url_prefix_rewriter, listaTipiProtocollo, strutsBean.protocollo, isSupportatoAutenticazioneSoggetti, strutsBean.utenteSoggetto, strutsBean.passwordSoggetto, strutsBean.subjectSoggetto, strutsBean.principalSoggetto, strutsBean.tipoauthSoggetto, isPddEsterna, null, strutsBean.dominio, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, (String)tipoCredenzialiSSLAliasCertificatoVersion, (String)tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuerSoggetto, tipoCredenzialiSSLWizardStep, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, soggettoRegistry.sizeProprietaList());
                dati = soggettiHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.CHANGE());
            }
            String identificativoPortaCalcolato = null;
            String identificativoPortaAttuale = strutsBean.portadom;
            if (!soggettiCore.isRegistroServiziLocale()) {
                identificativoPortaAttuale = soggettoConfig.getIdentificativoPorta();
            }
            idSoggetto = new IDSoggetto(strutsBean.tipoprov, strutsBean.nomeprov);
            identificativoPortaCalcolato = strutsBean.portadom != null && !strutsBean.portadom.equals("") ? ((oldIdentificativoPorta = soggettiCore.getIdentificativoPortaDefault(strutsBean.protocollo, oldSoggetto = new IDSoggetto(oldtipoprov, oldnomeprov))).equals(strutsBean.portadom) ? soggettiCore.getIdentificativoPortaDefault(strutsBean.protocollo, idSoggetto) : identificativoPortaAttuale) : soggettiCore.getIdentificativoPortaDefault(strutsBean.protocollo, idSoggetto);
            boolean secret = false;
            String secretPassword = null;
            String secretUser = null;
            boolean secretAppId = false;
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistry.setIdentificativoPorta(identificativoPortaCalcolato);
                soggettoRegistry.setNome(strutsBean.nomeprov);
                soggettoRegistry.setTipo(strutsBean.tipoprov);
                if (oldtipoprov != null && oldnomeprov != null) {
                    soggettoRegistry.setOldIDSoggettoForUpdate(new IDSoggetto(oldtipoprov, oldnomeprov));
                }
                soggettoRegistry.setDescrizione(strutsBean.descr);
                soggettoRegistry.setVersioneProtocollo(strutsBean.versioneProtocollo);
                soggettoRegistry.setPrivato(Boolean.valueOf(strutsBean.privato));
                soggettoRegistry.setPortaDominio(strutsBean.pdd);
                if (isSupportatoAutenticazioneSoggetti) {
                    if (strutsBean.tipoauthSoggetto != null && !"".equals(strutsBean.tipoauthSoggetto) && !"nessuna".equals(strutsBean.tipoauthSoggetto)) {
                        CredenzialiSoggetto credenziali = new CredenzialiSoggetto();
                        credenziali.setTipo(CredenzialeTipo.toEnumConstant((String)strutsBean.tipoauthSoggetto));
                        credenziali.setUser(strutsBean.utenteSoggetto);
                        if (strutsBean.principalSoggetto != null && !"".equals(strutsBean.principalSoggetto)) {
                            credenziali.setUser(strutsBean.principalSoggetto);
                        }
                        credenziali.setPassword(strutsBean.passwordSoggetto);
                        ApiKey apiKeyGenerated = null;
                        if (strutsBean.tipoauthSoggetto != null && ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(strutsBean.tipoauthSoggetto)) {
                            if (ServletUtils.isCheckBoxEnabled((String)changepwd) || modificataTipoAutenticazione) {
                                credenziali.setCertificateStrictVerification(false);
                                if (soggettiCore.isSoggettiPasswordEncryptEnabled()) {
                                    secret = true;
                                }
                            } else if (encryptOldPlainPwd) {
                                secret = true;
                            } else {
                                credenziali.setCertificateStrictVerification(ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi));
                            }
                        } else if (strutsBean.tipoauthSoggetto != null && ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                            credenziali.setAppId(multipleApiKeysEnabled);
                            credenziali.setUser(appId);
                            credenziali.setPassword(apiKey);
                            if (ServletUtils.isCheckBoxEnabled((String)changepwd) || modificataTipoAutenticazione) {
                                credenziali.setCertificateStrictVerification(false);
                                if (multipleApiKeysEnabled) {
                                    apiKeyGenerated = soggettiCore.newMultipleApiKey();
                                    if (!appIdModificabile) {
                                        appId = soggettiCore.toAppId(strutsBean.protocollo, idSoggetto, multipleApiKeysEnabled);
                                    }
                                } else {
                                    appId = soggettiCore.toAppId(strutsBean.protocollo, idSoggetto, multipleApiKeysEnabled);
                                    apiKeyGenerated = soggettiCore.newApiKey(strutsBean.protocollo, idSoggetto);
                                }
                                credenziali.setUser(appId);
                                credenziali.setPassword(apiKeyGenerated.getPassword());
                                if (soggettiCore.isSoggettiPasswordEncryptEnabled()) {
                                    secret = true;
                                }
                            } else {
                                credenziali.setCertificateStrictVerification(ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi));
                            }
                        } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(strutsBean.tipoauthSoggetto)) {
                            if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                                Certificate cSelezionato = null;
                                cSelezionato = tipoCredenzialiSSLWizardStep.equals("0") ? ArchiveLoader.load((byte[])oldCredenziali.getCertificate()) : (tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER) ? ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue()) : ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword));
                                credenziali.setCnIssuer(cSelezionato.getCertificate().getIssuer().getCN());
                                credenziali.setCnSubject(cSelezionato.getCertificate().getSubject().getCN());
                                credenziali.setCertificate(cSelezionato.getCertificate().getCertificate().getEncoded());
                                credenziali.setCertificateStrictVerification(ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi));
                            } else {
                                credenziali.setSubject(strutsBean.subjectSoggetto);
                                if (ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned)) {
                                    credenziali.setIssuer(strutsBean.subjectSoggetto);
                                } else {
                                    credenziali.setIssuer(issuerSoggetto);
                                }
                            }
                        } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL.equals(strutsBean.tipoauthSoggetto)) {
                            credenziali.setUser(strutsBean.principalSoggetto);
                        }
                        if (secret) {
                            secretUser = credenziali.getUser();
                            secretPassword = apiKeyGenerated != null ? apiKeyGenerated.getApiKey() : credenziali.getPassword();
                            secretAppId = credenziali.isAppId();
                        }
                        if (strutsBean.tipoauthSoggetto != null && strutsBean.tipoauthSoggetto.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL)) {
                            if (soggettoRegistry.sizeCredenzialiList() > 0) {
                                soggettoRegistry.removeCredenziali(0);
                            }
                        } else if (soggettoRegistry.getCredenzialiList() != null) {
                            soggettoRegistry.getCredenzialiList().clear();
                        }
                        if (soggettoRegistry.getCredenzialiList() == null) {
                            soggettoRegistry.setCredenzialiList(new ArrayList());
                        }
                        if (soggettoRegistry.getCredenzialiList().isEmpty()) {
                            soggettoRegistry.getCredenzialiList().add(credenziali);
                        } else {
                            soggettoRegistry.getCredenzialiList().add(0, credenziali);
                        }
                    } else {
                        soggettoRegistry.getCredenzialiList().clear();
                    }
                }
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                if (strutsBean.codiceIpa != null && !"".equals(strutsBean.codiceIpa)) {
                    IDSoggetto oldIdSoggetto = new IDSoggetto(oldtipoprov, oldnomeprov);
                    String oldCodiceIpa = soggettiCore.getCodiceIPADefault(strutsBean.protocollo, oldIdSoggetto, false);
                    boolean isPrecedenteCodice = oldCodiceIpa.equals(strutsBean.codiceIpa);
                    if (!isPrecedenteCodice && oldCodiceIpa != null && oldCodiceIpa.contains("/") && !strutsBean.codiceIpa.contains("/") && oldCodiceIpa.replace("/", "").equals(strutsBean.codiceIpa)) {
                        isPrecedenteCodice = true;
                    }
                    if (isPrecedenteCodice) {
                        soggettoRegistry.setCodiceIpa(soggettiCore.getCodiceIPADefault(strutsBean.protocollo, new IDSoggetto(strutsBean.tipoprov, strutsBean.nomeprov), false));
                    } else {
                        soggettoRegistry.setCodiceIpa(strutsBean.codiceIpa);
                    }
                } else {
                    strutsBean.codiceIpa = soggettiCore.getCodiceIPADefault(strutsBean.protocollo, new IDSoggetto(strutsBean.tipoprov, strutsBean.nomeprov), false);
                    soggettoRegistry.setCodiceIpa(strutsBean.codiceIpa);
                }
            }
            if (!pddCore.isGestionePddAbilitata(soggettiHelper)) {
                strutsBean.pdd = SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE.equals(strutsBean.dominio) ? nomePddGestioneLocale : null;
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                if (soggettiCore.isSinglePdD()) {
                    if (strutsBean.pdd == null || strutsBean.pdd.equals("-")) {
                        soggettoRegistry.setPortaDominio(null);
                    } else {
                        soggettoRegistry.setPortaDominio(strutsBean.pdd);
                    }
                } else {
                    soggettoRegistry.setPortaDominio(strutsBean.pdd);
                }
            }
            if (oldtipoprov != null && oldnomeprov != null) {
                soggettoConfig.setOldIDSoggettoForUpdate(new IDSoggetto(oldtipoprov, oldnomeprov));
            }
            soggettoConfig.setDescrizione(strutsBean.descr);
            soggettoConfig.setTipo(strutsBean.tipoprov);
            soggettoConfig.setNome(strutsBean.nomeprov);
            soggettoConfig.setDescrizione(strutsBean.descr);
            soggettoConfig.setIdentificativoPorta(identificativoPortaCalcolato);
            soggettoConfig.setRouter(strutsBean.isRouter);
            soggettoConfig.setPdUrlPrefixRewriter(strutsBean.pd_url_prefix_rewriter);
            soggettoConfig.setPaUrlPrefixRewriter(strutsBean.pa_url_prefix_rewriter);
            soggettoRegistry.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (ConsoleOperationType)strutsBean.consoleOperationType, (List)oldProtocolPropertyList));
            SoggettoCtrlStat sog = new SoggettoCtrlStat(soggettoRegistry, soggettoConfig);
            sog.setOldNomeForUpdate(oldnomeprov);
            sog.setOldTipoForUpdate(oldtipoprov);
            List<Object> listOggettiDaAggiornare = SoggettiUtilities.getOggettiDaAggiornare(soggettiCore, oldnomeprov, strutsBean.nomeprov, oldtipoprov, strutsBean.tipoprov, sog);
            soggettiCore.performUpdateOperation(userLogin, soggettiHelper.smista(), listOggettiDaAggiornare.toArray());
            IDSoggetto idSoggettoSelezionato = new IDSoggetto(oldtipoprov, oldnomeprov);
            if (oldpdd != null && !oldpdd.equals(strutsBean.pdd) && pddCore.isPddEsterna(strutsBean.pdd)) {
                utentiCore.modificaSoggettoUtilizzatoConsole(idSoggettoSelezionato.toString(), null);
            } else if (!strutsBean.tipoprov.equals(oldtipoprov) || !strutsBean.nomeprov.equals(oldnomeprov)) {
                IDSoggetto idNuovoSoggettoSelezionato = new IDSoggetto(strutsBean.tipoprov, strutsBean.nomeprov);
                utentiCore.modificaSoggettoUtilizzatoConsole(idSoggettoSelezionato.toString(), idNuovoSoggettoSelezionato.toString());
            }
            soggettiHelper.deleteBinaryParameters(tipoCredenzialiSSLFileCertificato);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            if (oldnomeprov != null && !oldnomeprov.equals(strutsBean.nomeprov) || oldtipoprov != null && !oldtipoprov.equals(strutsBean.tipoprov)) {
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.SOGGETTI);
                User user = ServletUtils.getUserFromSession((HttpServletRequest)request, (HttpSession)session);
                String oldSog = oldtipoprov + "/" + oldnomeprov;
                if (user != null && oldSog.equals(user.getSoggettoSelezionatoPddConsole())) {
                    user.setSoggettoSelezionatoPddConsole(strutsBean.tipoprov + "/" + strutsBean.nomeprov);
                    ricerca.clearFilter(Liste.SERVIZI, "filtroSoggetto");
                }
            }
            if (secret) {
                soggettiHelper.setSecretPleaseCopy(secretPassword, secretUser, secretAppId, strutsBean.tipoauthSoggetto, OggettoDialogEnum.SOGGETTO, sog.getNome());
            }
            if (strutsBean.modificaOperativo != null && !"".equals(strutsBean.modificaOperativo)) {
                ArrayList dati = new ArrayList();
                pd.setDati(dati);
                pd.setMessage("Configurazione del soggetto modificata con successo", Costanti.MESSAGE_TYPE_INFO);
                pd.disableEditMode();
                generalHelper = new GeneralHelper(session);
                gd = generalHelper.initGeneralData(request);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneGenerale", (ForwardParams)ConfigurazioneCostanti.TIPO_OPERAZIONE_CONFIGURAZIONE_GENERALE);
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                listaSoggetti = null;
                listaSoggetti = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiRegistroList(null, (ISearch)ricerca) : soggettiCore.soggettiRegistroList(userLogin, (ISearch)ricerca);
                soggettiHelper.prepareSoggettiList(listaSoggetti, (ISearch)ricerca);
            } else {
                listaSoggetti = null;
                listaSoggetti = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiList(null, (ISearch)ricerca) : soggettiCore.soggettiList(userLogin, (ISearch)ricerca);
                soggettiHelper.prepareSoggettiConfigList(listaSoggetti, (ISearch)ricerca);
            }
            generalHelper = new GeneralHelper(session);
            gd = generalHelper.initGeneralData(request);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

