/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.web.ctrlstat.core.CertificateChecker;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class SoggettiVerificaCertificati
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            Object labelVerifica;
            SoggettiHelper soggettiHelper = new SoggettiHelper(request, pd, session);
            String id = soggettiHelper.getParameter("id");
            long idSogg = Long.parseLong(id);
            String nomeprov = soggettiHelper.getParameter("nomeprov");
            String tipoprov = soggettiHelper.getParameter("tipoprov");
            String alias = soggettiHelper.getParameter("aliasNodo");
            soggettiHelper.makeMenu();
            SoggettiCore soggettiCore = new SoggettiCore();
            ConfigurazioneCore confCore = new ConfigurazioneCore(soggettiCore);
            PddCore pddCore = new PddCore(soggettiCore);
            String verificaCertificatiFromLista = soggettiHelper.getParameter("certVerFromLista");
            boolean arrivoDaLista = "true".equalsIgnoreCase(verificaCertificatiFromLista);
            List<String> aliases = confCore.getJmxPdDAliases();
            if (aliases == null || aliases.isEmpty()) {
                throw new Exception("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
            }
            Soggetto soggettoRegistry = null;
            org.openspcoop2.core.config.Soggetto soggettoConfig = null;
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistry = soggettiCore.getSoggettoRegistro(idSogg);
            }
            soggettoConfig = soggettiCore.getSoggetto(idSogg);
            if (soggettiCore.isRegistroServiziLocale()) {
                nomeprov = soggettoRegistry.getNome();
                tipoprov = soggettoRegistry.getTipo();
            } else {
                nomeprov = soggettoConfig.getNome();
                tipoprov = soggettoConfig.getTipo();
            }
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoprov);
            ArrayList<Parameter> parametersServletSoggettoChange = new ArrayList<Parameter>();
            Parameter pIdSoggetto = new Parameter("id", id);
            Parameter pNomeSoggetto = new Parameter("nomeprov", nomeprov);
            Parameter pTipoSoggetto = new Parameter("tipoprov", tipoprov);
            parametersServletSoggettoChange.add(pIdSoggetto);
            parametersServletSoggettoChange.add(pNomeSoggetto);
            parametersServletSoggettoChange.add(pTipoSoggetto);
            ArrayList<Parameter> listParameter = new ArrayList<Parameter>();
            listParameter.add(new Parameter("Soggetti", "soggettiList.do"));
            Object labelSoggetto = null;
            labelSoggetto = soggettoRegistry != null ? soggettiHelper.getLabelNomeSoggetto(protocollo, soggettoRegistry.getTipo(), soggettoRegistry.getNome()) : tipoprov + "/" + nomeprov;
            if (arrivoDaLista) {
                labelVerifica = "Verifica Certificati di " + (String)labelSoggetto;
                listParameter.add(new Parameter((String)labelVerifica, null));
            } else {
                listParameter.add(new Parameter((String)labelSoggetto, "soggettiChange.do", new Parameter[]{new Parameter("id", "" + soggettoRegistry.getId()), new Parameter("nomeprov", soggettoRegistry.getNome()), new Parameter("tipoprov", soggettoRegistry.getTipo())}));
                labelVerifica = "Verifica Certificati";
                listParameter.add(new Parameter((String)labelVerifica, null));
            }
            ServletUtils.setPageDataTitle((PageData)pd, listParameter);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            boolean ssl = false;
            boolean sslManuale = false;
            int countSsl = 0;
            if (soggettoRegistry != null) {
                for (int i = 0; i < soggettoRegistry.sizeCredenzialiList(); ++i) {
                    CredenzialiSoggetto c = soggettoRegistry.getCredenziali(i);
                    if (!CredenzialeTipo.SSL.equals((Object)c.getTipo())) continue;
                    if (c.getCertificate() != null) {
                        ssl = true;
                        ++countSsl;
                        continue;
                    }
                    sslManuale = true;
                }
            }
            boolean piuCertificatiAssociatiEntita = countSsl > 1;
            boolean verificaCertificatiEffettuata = false;
            if (!ssl) {
                if (sslManuale) {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati.<br/>\u00c8 presente una configurazione manuale del Subject e dell'Issuer", Costanti.MESSAGE_TYPE_INFO);
                } else {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati", Costanti.MESSAGE_TYPE_INFO);
                }
                pd.disableEditMode();
                verificaCertificatiEffettuata = true;
            } else {
                boolean sceltaClusterId = soggettiCore.isVerificaCertificatiSceltaClusterId();
                if (aliases.size() == 1 || alias != null || !sceltaClusterId) {
                    if (alias == null && !sceltaClusterId) {
                        alias = "Verifica su tutti i nodi";
                    }
                    ArrayList<String> aliasesForCheck = new ArrayList<String>();
                    boolean all = false;
                    if (aliases.size() == 1) {
                        aliasesForCheck.add(aliases.get(0));
                    } else if ("Verifica su tutti i nodi".equals(alias)) {
                        aliasesForCheck.addAll(aliases);
                        all = true;
                    } else {
                        aliasesForCheck.add(alias);
                    }
                    CertificateChecker certificateChecker = null;
                    certificateChecker = all ? soggettiCore.getJmxPdDCertificateChecker() : soggettiCore.newJmxPdDCertificateChecker(aliasesForCheck);
                    StringBuilder sbDetailsError = new StringBuilder();
                    int sogliaWarningGiorni = soggettiCore.getVerificaCertificatiWarningExpirationDays();
                    Object posizioneErrore = null;
                    String extraErrore = null;
                    StringBuilder sbDetailsWarningSsl = new StringBuilder();
                    Object posizioneWarningSsl = null;
                    if (ssl) {
                        certificateChecker.checkSoggetto(sbDetailsError, sbDetailsWarningSsl, ssl, soggettoRegistry, sogliaWarningGiorni);
                        if (sbDetailsError.length() > 0) {
                            posizioneErrore = labelSoggetto;
                        } else if (sbDetailsWarningSsl.length() > 0) {
                            posizioneWarningSsl = labelSoggetto;
                        }
                    }
                    String warning = null;
                    Object posizioneWarning = null;
                    String extraWarning = null;
                    if (sbDetailsError.length() <= 0 && sbDetailsWarningSsl.length() > 0) {
                        warning = sbDetailsWarningSsl.toString();
                        posizioneWarning = posizioneWarningSsl;
                    }
                    ArrayList<String> formatIds = new ArrayList<String>();
                    soggettiCore.formatVerificaCertificatiEsito(pd, formatIds, sbDetailsError.length() > 0 ? sbDetailsError.toString() : null, extraErrore, (String)posizioneErrore, warning, extraWarning, (String)posizioneWarning, piuCertificatiAssociatiEntita);
                    pd.disableEditMode();
                    verificaCertificatiEffettuata = true;
                } else {
                    DataElement deTestConnettivita = new DataElement();
                    deTestConnettivita.setType(DataElementType.TITLE);
                    deTestConnettivita.setLabel("Verifica Certificati");
                    dati.add(deTestConnettivita);
                    soggettiHelper.addVerificaCertificatoSceltaAlias(aliases, dati);
                }
            }
            pd.setLabelBottoneInvia("Verifica");
            dati = soggettiHelper.addSoggettoHiddenToDati(dati, id, nomeprov, tipoprov);
            DataElement de = new DataElement();
            de.setValue("" + arrivoDaLista);
            de.setType(DataElementType.HIDDEN);
            de.setName("certVerFromLista");
            dati.add(de);
            pd.setDati(dati);
            if (verificaCertificatiEffettuata) {
                if (arrivoDaLista) {
                    String filterDominioInterno = soggettiHelper.getParameter("internalDomain");
                    boolean forceFilterDominioInterno = false;
                    if ("true".equalsIgnoreCase(filterDominioInterno)) {
                        forceFilterDominioInterno = true;
                    }
                    boolean multiTenant = soggettiCore.isMultitenant();
                    String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
                    ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                    int idLista = Liste.SOGGETTI;
                    List<Soggetto> lista = null;
                    if (soggettiCore.isRegistroServiziLocale() && !ServletUtils.isSearchDone((IConsoleHelper)soggettiHelper)) {
                        lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, Soggetto.class);
                    }
                    ricerca = soggettiHelper.checkSearchParameters(idLista, ricerca);
                    if (forceFilterDominioInterno) {
                        ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
                    } else if (!multiTenant && !soggettiHelper.isModalitaCompleta()) {
                        ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE);
                    }
                    if (soggettiCore.isRegistroServiziLocale()) {
                        if (lista == null) {
                            lista = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiRegistroList(null, (ISearch)ricerca) : soggettiCore.soggettiRegistroList(userLogin, (ISearch)ricerca);
                        }
                        if (!soggettiHelper.isPostBackFilterElement()) {
                            ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
                        }
                        soggettiHelper.prepareSoggettiList(lista, (ISearch)ricerca);
                    } else {
                        List<org.openspcoop2.core.config.Soggetto> listaConfig = null;
                        listaConfig = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiList(null, (ISearch)ricerca) : soggettiCore.soggettiList(userLogin, (ISearch)ricerca);
                        soggettiHelper.prepareSoggettiConfigList(listaConfig, (ISearch)ricerca);
                    }
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"soggettiVerificaCertificati", (ForwardParams)CostantiControlStation.TIPO_OPERAZIONE_VERIFICA_CERTIFICATI);
                }
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Soggetti", (String)"soggettiList.do", (String)soggettiHelper.getLabelNomeSoggetto(protocollo, tipoprov, nomeprov));
                String portadom = null;
                String descr = null;
                String versioneProtocollo = null;
                String pdd = null;
                String codiceIpa = null;
                String pdUrlPrefixRewriter = null;
                String paUrlPrefixRewriter = null;
                String dominio = null;
                boolean isRouter = false;
                boolean privato = false;
                String tipoauthSoggetto = null;
                String utenteSoggetto = null;
                String passwordSoggetto = null;
                String subjectSoggetto = null;
                String issuerSoggetto = null;
                String principalSoggetto = null;
                String multipleApiKey = null;
                String appId = null;
                String apiKey = null;
                BinaryParameter tipoCredenzialiSSLFileCertificato = soggettiHelper.getBinaryParameter("confSSLCredFileCert");
                String tipoCredenzialiSSLSorgente = null;
                String tipoCredenzialiSSLAliasCertificato = null;
                String tipoCredenzialiSSLAliasCertificatoSubject = null;
                String tipoCredenzialiSSLAliasCertificatoIssuer = null;
                String tipoCredenzialiSSLAliasCertificatoType = null;
                Object tipoCredenzialiSSLAliasCertificatoVersion = null;
                Object tipoCredenzialiSSLAliasCertificatoSerialNumber = null;
                String tipoCredenzialiSSLAliasCertificatoSelfSigned = null;
                String tipoCredenzialiSSLAliasCertificatoNotBefore = null;
                String tipoCredenzialiSSLAliasCertificatoNotAfter = null;
                String tipoCredenzialiSSLVerificaTuttiICampi = null;
                String tipoCredenzialiSSLConfigurazioneManualeSelfSigned = null;
                ArchiveType tipoCredenzialiSSLTipoArchivio = ArchiveType.CER;
                String tipoCredenzialiSSLFileCertificatoPassword = null;
                ArrayList<String> listaAliasEstrattiCertificato = new ArrayList<String>();
                String tipoCredenzialiSSLWizardStep = "0";
                String changepwd = null;
                boolean isSupportatoAutenticazioneSoggetti = soggettiCore.isSupportatoAutenticazioneSoggetti(protocollo);
                boolean isSupportatoCodiceIPA = soggettiCore.isSupportatoCodiceIPA(protocollo);
                boolean isSupportatoIdentificativoPorta = soggettiCore.isSupportatoIdentificativoPorta(protocollo);
                String nomePddGestioneLocale = null;
                if (!pddCore.isGestionePddAbilitata(soggettiHelper) && (nomePddGestioneLocale = pddCore.getNomePddOperativa()) == null) {
                    throw new Exception("Non \u00e8 stata rilevata una pdd di tipologia 'operativo'");
                }
                if (soggettiCore.isRegistroServiziLocale()) {
                    portadom = soggettoRegistry.getIdentificativoPorta();
                    descr = soggettoRegistry.getDescrizione();
                    pdd = soggettoRegistry.getPortaDominio();
                    if (!pddCore.isGestionePddAbilitata(soggettiHelper)) {
                        dominio = pddCore.isPddEsterna(pdd) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
                    }
                    versioneProtocollo = soggettoRegistry.getVersioneProtocollo();
                    privato = soggettoRegistry.getPrivato() != null && soggettoRegistry.getPrivato() != false;
                    codiceIpa = soggettoRegistry.getCodiceIpa();
                    if (isSupportatoAutenticazioneSoggetti) {
                        if (tipoauthSoggetto == null) {
                            CredenzialiSoggetto credenziali = null;
                            if (soggettoRegistry.sizeCredenzialiList() > 0) {
                                credenziali = soggettoRegistry.getCredenziali(0);
                            }
                            if (credenziali != null) {
                                if (credenziali.getTipo() != null) {
                                    tipoauthSoggetto = credenziali.getTipo().toString();
                                }
                                utenteSoggetto = credenziali.getUser();
                                passwordSoggetto = credenziali.getPassword();
                                if (tipoauthSoggetto != null && ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(tipoauthSoggetto)) {
                                    tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                                } else if (tipoauthSoggetto != null && ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(tipoauthSoggetto)) {
                                    tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                                    multipleApiKey = credenziali.isAppId() ? "yes" : "no";
                                    appId = credenziali.getUser();
                                    apiKey = credenziali.getPassword();
                                }
                                principalSoggetto = credenziali.getUser();
                                if (credenziali.getCertificate() != null) {
                                    tipoCredenzialiSSLFileCertificato.setValue(credenziali.getCertificate());
                                    tipoCredenzialiSSLSorgente = "uploadCert";
                                    tipoCredenzialiSSLVerificaTuttiICampi = credenziali.isCertificateStrictVerification() ? "yes" : "no";
                                    try {
                                        Certificate cSelezionato = ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue());
                                        tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                                        tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                                        tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                                        tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                                        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS");
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = sdf.format(cSelezionato.getCertificate().getNotBefore());
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = sdf.format(cSelezionato.getCertificate().getNotAfter());
                                    }
                                    catch (UtilsException e) {
                                        pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                        tipoCredenzialiSSLAliasCertificato = "";
                                        tipoCredenzialiSSLAliasCertificatoSubject = "";
                                        tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                        tipoCredenzialiSSLAliasCertificatoType = "";
                                        tipoCredenzialiSSLAliasCertificatoVersion = "";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                    }
                                } else {
                                    subjectSoggetto = credenziali.getSubject();
                                    issuerSoggetto = credenziali.getIssuer();
                                    tipoCredenzialiSSLSorgente = "confMan";
                                    String string = tipoCredenzialiSSLConfigurazioneManualeSelfSigned = subjectSoggetto != null && subjectSoggetto.equals(issuerSoggetto) ? "yes" : "no";
                                }
                            }
                        }
                        if (tipoauthSoggetto == null) {
                            tipoauthSoggetto = "nessuna";
                        }
                    }
                } else {
                    portadom = soggettoConfig.getIdentificativoPorta();
                    descr = soggettoConfig.getDescrizione();
                    isRouter = soggettoConfig.getRouter();
                }
                pdUrlPrefixRewriter = soggettoConfig.getPdUrlPrefixRewriter();
                paUrlPrefixRewriter = soggettoConfig.getPaUrlPrefixRewriter();
                boolean isPddEsterna = pddCore.isPddEsterna(pdd);
                if (isSupportatoAutenticazioneSoggetti && isPddEsterna && tipoauthSoggetto == null && "nessuna".equals(tipoauthSoggetto)) {
                    tipoauthSoggetto = soggettiCore.getAutenticazione_generazioneAutomaticaPorteApplicative();
                }
                IDSoggetto idSoggetto = new IDSoggetto(tipoprov, nomeprov);
                List<String> tipiSoggetti = soggettiCore.getTipiSoggettiGestitiProtocollo(protocollo);
                List<String> versioniProtocollo = null;
                if (soggettiHelper.isModalitaAvanzata()) {
                    versioniProtocollo = soggettiCore.getVersioniProtocollo(protocollo);
                } else {
                    versioniProtocollo = new ArrayList<String>();
                    versioneProtocollo = soggettiCore.getVersioneDefaultProtocollo(protocollo);
                    versioniProtocollo.add(versioneProtocollo);
                }
                List<String> listaTipiProtocollo = soggettiCore.getProtocolli(request, session);
                boolean pddOperativa = false;
                if (soggettoRegistry.getPortaDominio() != null && !"".equals(soggettoRegistry.getPortaDominio())) {
                    PdDControlStation pddCtrlstat = pddCore.getPdDControlStation(soggettoRegistry.getPortaDominio());
                    pddOperativa = PddTipologia.OPERATIVO.toString().equals(pddCtrlstat.getTipo());
                }
                String[] pddList = null;
                if (!pddOperativa && soggettoRegistry.getPortaDominio() != null) {
                    pddList = new String[]{soggettoRegistry.getPortaDominio()};
                }
                String[] pddEsterneList = null;
                Connettore connettore = null;
                if (soggettiCore.isRegistroServiziLocale()) {
                    connettore = soggettoRegistry.getConnettore();
                }
                int numPA = 0;
                int numPD = 0;
                ProtocolProperties protocolProperties = null;
                List oldProtocolPropertyList = null;
                IConsoleDynamicConfiguration consoleDynamicConfiguration = null;
                IRegistryReader registryReader = null;
                IConfigIntegrationReader configRegistryReader = null;
                ConsoleConfiguration consoleConfiguration = null;
                ConsoleOperationType consoleOperationType = ConsoleOperationType.CHANGE;
                try {
                    IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                    consoleDynamicConfiguration = protocolFactory.createDynamicConfigurationConsole();
                    registryReader = soggettiCore.getRegistryReader(protocolFactory);
                    configRegistryReader = soggettiCore.getConfigIntegrationReader(protocolFactory);
                    consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigSoggetto(consoleOperationType, (IConsoleHelper)soggettiHelper, registryReader, configRegistryReader, idSoggetto);
                    Soggetto soggetto = registryReader.getSoggetto(idSoggetto);
                    oldProtocolPropertyList = soggetto.getProtocolPropertyList();
                    protocolProperties = soggettiHelper.estraiProtocolPropertiesDaRequest(consoleConfiguration, consoleOperationType);
                }
                catch (RegistryNotFound protocolFactory) {
                    // empty catch block
                }
                Properties propertiesProprietario = new Properties();
                propertiesProprietario.setProperty("idProprietario", id);
                propertiesProprietario.setProperty("tipoProprietario", "SOGGETTO");
                propertiesProprietario.setProperty("nomeProprietario", tipoprov + "/" + nomeprov);
                propertiesProprietario.setProperty("urlOrigChange", URLEncoder.encode("soggettiChange.do?" + request.getQueryString(), "UTF-8"));
                propertiesProprietario.setProperty("protocollo", protocollo);
                boolean visualizzaModificaCertificato = false;
                boolean visualizzaAddCertificato = false;
                Integer numeroCertificati = soggettoRegistry.sizeCredenzialiList();
                if (soggettoRegistry.sizeCredenzialiList() > 0) {
                    visualizzaAddCertificato = true;
                    if (soggettoRegistry.sizeCredenzialiList() == 1) {
                        visualizzaModificaCertificato = true;
                    }
                }
                String servletCredenzialiList = "soggettiCredenzialiList.do";
                String servletCredenzialiAdd = "soggettiCredenzialiAdd.do";
                ArrayList<Parameter> parametersServletCredenzialiList = new ArrayList<Parameter>();
                parametersServletCredenzialiList.add(pIdSoggetto);
                parametersServletCredenzialiList.add(pNomeSoggetto);
                parametersServletCredenzialiList.add(pTipoSoggetto);
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                consoleDynamicConfiguration.updateDynamicConfigSoggetto(consoleConfiguration, consoleOperationType, (IConsoleHelper)soggettiHelper, protocolProperties, registryReader, configRegistryReader, idSoggetto);
                dati = soggettiHelper.addSoggettiToDati(TipoOperazione.CHANGE, dati, nomeprov, tipoprov, portadom, descr, isRouter, tipiSoggetti, versioneProtocollo, privato, codiceIpa, versioniProtocollo, isSupportatoCodiceIPA, isSupportatoIdentificativoPorta, pddList, pddEsterneList, nomePddGestioneLocale, pdd, id, nomeprov, tipoprov, connettore, numPD, pdUrlPrefixRewriter, numPA, paUrlPrefixRewriter, listaTipiProtocollo, protocollo, isSupportatoAutenticazioneSoggetti, utenteSoggetto, passwordSoggetto, subjectSoggetto, principalSoggetto, tipoauthSoggetto, isPddEsterna, null, dominio, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, (String)tipoCredenzialiSSLAliasCertificatoVersion, (String)tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuerSoggetto, tipoCredenzialiSSLWizardStep, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, soggettoRegistry.sizeProprietaList());
                dati = soggettiHelper.addProtocolPropertiesToDatiRegistry(dati, consoleConfiguration, consoleOperationType, protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.CHANGE());
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"soggettiVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"soggettiVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }
}

