/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utenti;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.utils.ProtocolUtils;
import org.openspcoop2.utils.crypt.PasswordGenerator;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCostanti;
import org.openspcoop2.web.lib.mvc.CheckboxStatusType;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.Permessi;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.lib.users.dao.UserPassword;

public class UtentiHelper
extends ConsoleHelper {
    public UtentiHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        super(request, pd, session);
    }

    public UtentiHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        super(core, request, pd, session);
    }

    private boolean hasOnlyPermessiUtenti(String isServizi, String isDiagnostica, String isReportistica, String isSistema, String isMessaggi, String isUtenti, String isAuditing, String isAccordiCooperazione, boolean singlePdD) {
        return !(isServizi != null && ServletUtils.isCheckBoxEnabled((String)isServizi) || singlePdD && (isDiagnostica != null && ServletUtils.isCheckBoxEnabled((String)isDiagnostica) || isReportistica != null && ServletUtils.isCheckBoxEnabled((String)isReportistica)) || isSistema != null && ServletUtils.isCheckBoxEnabled((String)isSistema) || isMessaggi != null && ServletUtils.isCheckBoxEnabled((String)isMessaggi) || isUtenti == null && !ServletUtils.isCheckBoxEnabled((String)isUtenti) || isAuditing != null && ServletUtils.isCheckBoxEnabled((String)isAuditing) || isAccordiCooperazione != null && ServletUtils.isCheckBoxEnabled((String)isAccordiCooperazione));
    }

    private String getLabelSezionePddMonitorSoggettiServizi(boolean isDiagnosticaEnabled, boolean isReportisticaEnabled) {
        if (isDiagnosticaEnabled && isReportisticaEnabled) {
            return "L'utente \u00e8 abilitato al Monitoraggio e alla Reportistica";
        }
        if (isDiagnosticaEnabled) {
            return "L'utente \u00e8 abilitato al Monitoraggio";
        }
        return "L'utente \u00e8 abilitato alla Reportistica";
    }

    public List<DataElement> addUtentiToDati(List<DataElement> dati, TipoOperazione tipoOperazione, boolean singlePdD, String nomesu, String pwsu, InterfaceType interfaceType, String isServizi, String isDiagnostica, String isReportistica, String isSistema, String isMessaggi, String isUtenti, String isAuditing, String isAccordiCooperazione, String changepwd, String[] modalitaGateway, String isSoggettiAll, String isServiziAll, User oldImgUser, String scadenza, Date dataUltimoAggiornamentoPassword, boolean oldScadenza, String profiloDefaultConsoleGestione, String soggettoDefaultConsoleGestione, String profiloDefaultConsoleMonitoraggio, String soggettoDefaultConsoleMonitoraggio, String homePageMonitoraggio, String intervalloTemporaleReportStatistico) throws Exception {
        PasswordVerifier passwordVerifier;
        boolean utenteMonitorEnabled;
        Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
        boolean onlyUser = ServletUtils.isCheckBoxEnabled((String)isUtenti) && !ServletUtils.isCheckBoxEnabled((String)isServizi) && !ServletUtils.isCheckBoxEnabled((String)isAccordiCooperazione) && !ServletUtils.isCheckBoxEnabled((String)isDiagnostica) && !ServletUtils.isCheckBoxEnabled((String)isReportistica) && !ServletUtils.isCheckBoxEnabled((String)isSistema) && !ServletUtils.isCheckBoxEnabled((String)isMessaggi) && !ServletUtils.isCheckBoxEnabled((String)isAuditing);
        DataElement de = new DataElement();
        de.setLabel("Informazioni Utente");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nomesu);
        if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nomesu");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Permessi di Gestione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Registro");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Gestione API [S]");
        de.setType(DataElementType.CHECKBOX);
        de.setName("isServizi");
        ServletUtils.setCheckBox((DataElement)de, (String)isServizi);
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Accordi Cooperazione [P]");
        de.setName("isAccordiCooperazione");
        if (this.utentiCore.isAccordiCooperazioneEnabled()) {
            de.setType(DataElementType.CHECKBOX);
            de.setPostBack(true);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        ServletUtils.setCheckBox((DataElement)de, (String)isAccordiCooperazione);
        de.setValue(de.getSelected());
        dati.add(de);
        if (singlePdD) {
            de = new DataElement();
            de.setLabel("GovWay Monitor");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Monitoraggio [D]");
        if (singlePdD) {
            de.setType(DataElementType.CHECKBOX);
            ServletUtils.setCheckBox((DataElement)de, (String)isDiagnostica);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        de.setName("isDiagnostica");
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Reportistica [R]");
        if (singlePdD) {
            de.setType(DataElementType.CHECKBOX);
            ServletUtils.setCheckBox((DataElement)de, (String)isReportistica);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        de.setName("isReportistica");
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Strumenti");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Coda Messaggi [M]");
        de.setName("isMessaggi");
        if (this.utentiCore.showCodaMessage()) {
            de.setType(DataElementType.CHECKBOX);
            de.setPostBack(true);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        ServletUtils.setCheckBox((DataElement)de, (String)isMessaggi);
        de.setValue(de.getSelected());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Auditing [A]");
        de.setType(DataElementType.CHECKBOX);
        de.setName("isAuditing");
        ServletUtils.setCheckBox((DataElement)de, (String)isAuditing);
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Configurazione");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Configurazione Generale [C]");
        de.setType(DataElementType.CHECKBOX);
        de.setName("isSistema");
        ServletUtils.setCheckBox((DataElement)de, (String)isSistema);
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Utenti [U]");
        de.setType(DataElementType.CHECKBOX);
        de.setName("isUtenti");
        ServletUtils.setCheckBox((DataElement)de, (String)isUtenti);
        de.setPostBack(true);
        dati.add(de);
        if (!onlyUser) {
            de = new DataElement();
            de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_DI_HTML_ESCAPE);
            de.setType(DataElementType.TITLE);
            dati.add(de);
            List<String> protocolliRegistratiConsole = this.core.getProtocolli();
            for (int i = 0; i < protocolliRegistratiConsole.size(); ++i) {
                String protocolloName = protocolliRegistratiConsole.get(i);
                de = new DataElement();
                de.setLabel(this.getLabelProtocollo(protocolloName));
                de.setType(DataElementType.CHECKBOX);
                de.setName("mod_" + protocolloName);
                ServletUtils.setCheckBox((DataElement)de, (String)modalitaGateway[i]);
                de.setPostBack(true);
                dati.add(de);
            }
        }
        boolean isDiagnosticaEnabled = ServletUtils.isCheckBoxEnabled((String)isDiagnostica);
        boolean isReportisticaEnabled = ServletUtils.isCheckBoxEnabled((String)isReportistica);
        if (isDiagnosticaEnabled || isReportisticaEnabled) {
            int num;
            ConsoleSearch searchForCount;
            String nomeLink;
            de = new DataElement();
            de.setLabel("Visibilit\u00e0 dati tramite govwayMonitor");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            if (this.utentiCore.isMultitenant()) {
                de = new DataElement();
                de.setLabel("Soggetti");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.CHECKBOX);
                de.setLabel("Tutti");
                de.setName("isSoggettiAll");
                de.setSelected(ServletUtils.isCheckBoxEnabled((String)isSoggettiAll));
                de.setPostBack(true);
                dati.add(de);
                if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && !oldImgUser.isPermitAllSoggetti() && !ServletUtils.isCheckBoxEnabled((String)isSoggettiAll)) {
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("utentiSoggettiList.do", new Parameter[]{new Parameter("nomesu", nomesu)});
                    nomeLink = "Soggetti";
                    if (Boolean.TRUE.equals(contaListe)) {
                        searchForCount = new ConsoleSearch(true, 1);
                        this.utentiCore.utentiSoggettiList(nomesu, (ISearch)searchForCount);
                        num = searchForCount.getNumEntries(Liste.UTENTI_SOGGETTI);
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)nomeLink, (Long)Long.valueOf(num));
                    } else {
                        de.setValue(nomeLink);
                    }
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("isSoggettiAll");
                de.setValue("yes");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("API");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.CHECKBOX);
            de.setLabel("Tutte");
            de.setName("isServiziAll");
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)isServiziAll));
            de.setPostBack(true);
            dati.add(de);
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && !oldImgUser.isPermitAllServizi() && !ServletUtils.isCheckBoxEnabled((String)isServiziAll)) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("utentiServiziList.do", new Parameter[]{new Parameter("nomesu", nomesu)});
                nomeLink = "API";
                if (Boolean.TRUE.equals(contaListe)) {
                    searchForCount = new ConsoleSearch(true, 1);
                    this.utentiCore.utentiServiziList(nomesu, (ISearch)searchForCount);
                    num = searchForCount.getNumEntries(Liste.UTENTI_SERVIZI);
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)nomeLink, (Long)Long.valueOf(num));
                } else {
                    de.setValue(nomeLink);
                }
                dati.add(de);
            }
        }
        boolean utenteConsoleEnabled = ServletUtils.isCheckBoxEnabled((String)isServizi) || ServletUtils.isCheckBoxEnabled((String)isMessaggi) || ServletUtils.isCheckBoxEnabled((String)isAuditing) || ServletUtils.isCheckBoxEnabled((String)isSistema) || ServletUtils.isCheckBoxEnabled((String)isUtenti) || ServletUtils.isCheckBoxEnabled((String)isAccordiCooperazione);
        boolean bl = utenteMonitorEnabled = isDiagnosticaEnabled || isReportisticaEnabled;
        if (utenteConsoleEnabled || utenteMonitorEnabled) {
            de = new DataElement();
            de.setLabel("Profilo Utente");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            boolean protocolloSelezionato = false;
            for (String modalitaI : modalitaGateway) {
                if (!ServletUtils.isCheckBoxEnabled((String)modalitaI)) continue;
                protocolloSelezionato = true;
                break;
            }
            if (utenteConsoleEnabled) {
                de = new DataElement();
                de.setLabel("govwayConsole");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Modalit&agrave; Interfaccia");
                de.setName("tipo_gui");
                boolean permitInterfaceComplete = false;
                boolean showSelectTipoInterfaccia = true;
                if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                    User user = this.utentiCore.getUser(nomesu);
                    permitInterfaceComplete = user.isPermitInterfaceComplete();
                    boolean bl2 = showSelectTipoInterfaccia = !interfaceType.equals((Object)InterfaceType.COMPLETA);
                }
                if (showSelectTipoInterfaccia) {
                    de.setType(DataElementType.SELECT);
                    String[] tipiInterfacce = null;
                    String[] tipiInterfacceLabel = null;
                    tipiInterfacce = permitInterfaceComplete ? new String[3] : new String[]{InterfaceType.STANDARD.toString(), InterfaceType.AVANZATA.toString()};
                    if (permitInterfaceComplete) {
                        tipiInterfacce[2] = InterfaceType.COMPLETA.toString();
                    }
                    tipiInterfacceLabel = new String[tipiInterfacce.length];
                    for (int i = 0; i < tipiInterfacce.length; ++i) {
                        tipiInterfacceLabel[i] = tipiInterfacce[i].toLowerCase();
                    }
                    de.setValues(tipiInterfacce);
                    de.setLabels(tipiInterfacceLabel);
                    de.setSelected(interfaceType.toString());
                    dati.add(de);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(interfaceType.toString());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Modalit&agrave; Interfaccia");
                    de.setName("tipo_gui_text");
                    de.setType(DataElementType.TEXT);
                    de.setValue(interfaceType.toString().toLowerCase());
                    dati.add(de);
                }
                if (!onlyUser) {
                    if (protocolloSelezionato) {
                        List<String> protocolliRegistratiConsole = this.core.getProtocolli();
                        ArrayList<String> profiloValues = new ArrayList<String>();
                        ArrayList<String> profiloLabels = new ArrayList<String>();
                        for (int i = 0; i < protocolliRegistratiConsole.size(); ++i) {
                            String protocolloName = protocolliRegistratiConsole.get(i);
                            if (!ServletUtils.isCheckBoxEnabled((String)modalitaGateway[i])) continue;
                            profiloValues.add(protocolloName);
                            String labelProt = ConsoleHelper._getLabelProtocollo(protocolloName);
                            profiloLabels.add(labelProt);
                        }
                        if (profiloValues.size() > 1) {
                            de = new DataElement();
                            de.setType(DataElementType.SELECT);
                            de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                            profiloLabels.add(0, "Tutti");
                            profiloValues.add(0, "all");
                            de.setName("tipo_mod");
                            de.setValues(profiloValues);
                            de.setLabels(profiloLabels);
                            de.setSelected(profiloDefaultConsoleGestione);
                            de.setPostBack(true);
                            dati.add(de);
                        } else {
                            de = new DataElement();
                            de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                            de.setType(DataElementType.HIDDEN);
                            de.setName("tipo_mod");
                            de.setValue(profiloDefaultConsoleGestione);
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                            de.setType(DataElementType.TEXT);
                            de.setName("tipo_mod_txt");
                            String protocolloName = (String)profiloValues.get(0);
                            String labelProt = ConsoleHelper._getLabelProtocollo(protocolloName);
                            de.setValue(labelProt);
                            dati.add(de);
                        }
                        if (profiloDefaultConsoleGestione != null && !"all".equals(profiloDefaultConsoleGestione) || profiloValues.size() == 1) {
                            String profiloDefaultCorrente = profiloValues.size() == 1 ? (String)profiloValues.get(0) : profiloDefaultConsoleGestione;
                            List<IDSoggetto> idSoggettiOperativi = this.soggettiCore.getIdSoggettiOperativi(profiloDefaultCorrente);
                            if (idSoggettiOperativi != null && idSoggettiOperativi.size() > 1) {
                                ArrayList<String> listaLabel = new ArrayList<String>();
                                HashMap<String, IDSoggetto> mapLabelIds = new HashMap<String, IDSoggetto>();
                                for (IDSoggetto idSoggetto : idSoggettiOperativi) {
                                    String labelSoggetto = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                                    if (listaLabel.contains(labelSoggetto)) continue;
                                    listaLabel.add(labelSoggetto);
                                    mapLabelIds.put(labelSoggetto, idSoggetto);
                                }
                                Collections.sort(listaLabel, new Comparator<String>(){

                                    @Override
                                    public int compare(String o1, String o2) {
                                        return o1.toLowerCase().compareTo(o2.toLowerCase());
                                    }
                                });
                                ArrayList<String> listaValues = new ArrayList<String>();
                                for (String label : listaLabel) {
                                    listaValues.add(NamingUtils.getSoggettoFromLabel((String)profiloDefaultCorrente, (String)label).toString());
                                }
                                de = new DataElement();
                                de.setType(DataElementType.SELECT);
                                de.setLabel("Soggetto Operativo");
                                listaLabel.add(0, "Tutti");
                                listaValues.add(0, "all");
                                de.setValues(listaValues);
                                de.setLabels(listaLabel);
                                de.setName("id_sog");
                                de.setSelected(soggettoDefaultConsoleGestione);
                                dati.add(de);
                            } else {
                                de = new DataElement();
                                de.setLabel("Soggetto Operativo");
                                de.setType(DataElementType.HIDDEN);
                                de.setName("id_sog");
                                de.setValue(soggettoDefaultConsoleGestione);
                                dati.add(de);
                                de = new DataElement();
                                de.setLabel("Soggetto Operativo");
                                de.setType(DataElementType.TEXT);
                                de.setName("id_sog_txt");
                                if (idSoggettiOperativi != null) {
                                    IDSoggetto idSoggetto = idSoggettiOperativi.get(0);
                                    String labelSoggetto = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                                    de.setValue(labelSoggetto);
                                }
                                dati.add(de);
                            }
                        } else {
                            de = new DataElement();
                            de.setLabel("Soggetto Operativo");
                            de.setType(DataElementType.HIDDEN);
                            de.setName("id_sog");
                            de.setValue(soggettoDefaultConsoleGestione);
                            dati.add(de);
                        }
                    } else {
                        de = new DataElement();
                        de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                        de.setType(DataElementType.HIDDEN);
                        de.setName("tipo_mod");
                        de.setValue(profiloDefaultConsoleGestione);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("Soggetto Operativo");
                        de.setType(DataElementType.HIDDEN);
                        de.setName("id_sog");
                        de.setValue(soggettoDefaultConsoleGestione);
                        dati.add(de);
                    }
                }
            }
            if (utenteMonitorEnabled) {
                de = new DataElement();
                de.setLabel("govwayMonitor");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
                if (protocolloSelezionato) {
                    List<String> protocolliRegistratiConsole = this.core.getProtocolli();
                    ArrayList<String> profiloValues = new ArrayList<String>();
                    ArrayList<String> profiloLabels = new ArrayList<String>();
                    for (int i = 0; i < protocolliRegistratiConsole.size(); ++i) {
                        String protocolloName = protocolliRegistratiConsole.get(i);
                        if (!ServletUtils.isCheckBoxEnabled((String)modalitaGateway[i])) continue;
                        profiloValues.add(protocolloName);
                        String labelProt = ConsoleHelper._getLabelProtocollo(protocolloName);
                        profiloLabels.add(labelProt);
                    }
                    if (profiloValues.size() > 1) {
                        de = new DataElement();
                        de.setType(DataElementType.SELECT);
                        de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                        profiloLabels.add(0, "Tutti");
                        profiloValues.add(0, "all");
                        de.setName("tipo_mod_mon");
                        de.setValues(profiloValues);
                        de.setLabels(profiloLabels);
                        de.setSelected(profiloDefaultConsoleMonitoraggio);
                        de.setPostBack(true);
                        dati.add(de);
                    } else {
                        de = new DataElement();
                        de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                        de.setType(DataElementType.HIDDEN);
                        de.setName("tipo_mod_mon");
                        de.setValue(profiloDefaultConsoleMonitoraggio);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                        de.setType(DataElementType.TEXT);
                        de.setName("tipo_mod_mon_txt");
                        String protocolloName = (String)profiloValues.get(0);
                        String labelProt = ConsoleHelper._getLabelProtocollo(protocolloName);
                        de.setValue(labelProt);
                        dati.add(de);
                    }
                    if (profiloDefaultConsoleMonitoraggio != null && !"all".equals(profiloDefaultConsoleMonitoraggio) || profiloValues.size() == 1) {
                        String profiloDefaultCorrente = profiloValues.size() == 1 ? (String)profiloValues.get(0) : profiloDefaultConsoleMonitoraggio;
                        List<IDSoggetto> idSoggettiOperativi = this.soggettiCore.getIdSoggettiOperativi(profiloDefaultCorrente);
                        if (idSoggettiOperativi != null && idSoggettiOperativi.size() > 1) {
                            ArrayList<String> listaLabel = new ArrayList<String>();
                            HashMap<String, IDSoggetto> mapLabelIds = new HashMap<String, IDSoggetto>();
                            for (IDSoggetto idSoggetto : idSoggettiOperativi) {
                                String labelSoggetto = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                                if (listaLabel.contains(labelSoggetto)) continue;
                                listaLabel.add(labelSoggetto);
                                mapLabelIds.put(labelSoggetto, idSoggetto);
                            }
                            Collections.sort(listaLabel, new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return o1.toLowerCase().compareTo(o2.toLowerCase());
                                }
                            });
                            ArrayList<String> listaValues = new ArrayList<String>();
                            for (String label : listaLabel) {
                                listaValues.add(NamingUtils.getSoggettoFromLabel((String)profiloDefaultCorrente, (String)label).toString());
                            }
                            de = new DataElement();
                            de.setType(DataElementType.SELECT);
                            de.setLabel("Soggetto Operativo");
                            listaLabel.add(0, "Tutti");
                            listaValues.add(0, "all");
                            de.setValues(listaValues);
                            de.setLabels(listaLabel);
                            de.setName("id_sog_mon");
                            de.setSelected(soggettoDefaultConsoleMonitoraggio);
                            dati.add(de);
                        } else {
                            de = new DataElement();
                            de.setLabel("Soggetto Operativo");
                            de.setType(DataElementType.HIDDEN);
                            de.setName("id_sog_mon");
                            de.setValue(soggettoDefaultConsoleMonitoraggio);
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("Soggetto Operativo");
                            de.setType(DataElementType.TEXT);
                            de.setName("id_sog_mon_txt");
                            if (idSoggettiOperativi != null) {
                                IDSoggetto idSoggetto = idSoggettiOperativi.get(0);
                                String labelSoggetto = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                                de.setValue(labelSoggetto);
                            }
                            dati.add(de);
                        }
                    } else {
                        de = new DataElement();
                        de.setLabel("Soggetto Operativo");
                        de.setType(DataElementType.HIDDEN);
                        de.setName("id_sog_mon");
                        de.setValue(soggettoDefaultConsoleMonitoraggio);
                        dati.add(de);
                    }
                } else {
                    de = new DataElement();
                    de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("tipo_mod_mon");
                    de.setValue(profiloDefaultConsoleMonitoraggio);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Soggetto Operativo");
                    de.setType(DataElementType.HIDDEN);
                    de.setName("id_sog_mon");
                    de.setValue(soggettoDefaultConsoleMonitoraggio);
                    dati.add(de);
                }
                de = new DataElement();
                de.setType(DataElementType.SELECT);
                de.setLabel("Home Page");
                String[] homePageLabels = new String[]{"Ricerca Transazioni", "Report Statistico"};
                de.setValues(UtentiCostanti.getValuesParametroUtentiHomePageMonitoraggio());
                de.setLabels(homePageLabels);
                de.setName("hp_mon");
                de.setPostBack(true);
                de.setSelected(homePageMonitoraggio);
                dati.add(de);
                if (homePageMonitoraggio.equals("summary")) {
                    de = new DataElement();
                    de.setType(DataElementType.SELECT);
                    de.setLabel("Intervallo Temporale");
                    String[] intervalloTemporaleLabels = new String[]{"No Grafico", "Ultime 24 ore", "Ultimi 7 giorni", "Ultimi 30 giorni", "Ultimo anno"};
                    de.setValues(UtentiCostanti.getValuesParametroUtentiIntervalloTemporaleHomePageMonitoraggio());
                    de.setLabels(intervalloTemporaleLabels);
                    de.setName("int_temp_mon");
                    de.setSelected(intervalloTemporaleReportStatistico);
                    dati.add(de);
                } else {
                    de = new DataElement();
                    de.setLabel("Intervallo Temporale");
                    de.setType(DataElementType.HIDDEN);
                    de.setName("int_temp_mon");
                    de.setValue(intervalloTemporaleReportStatistico);
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                de.setType(DataElementType.HIDDEN);
                de.setName("tipo_mod_mon");
                de.setValue(profiloDefaultConsoleMonitoraggio);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Soggetto Operativo");
                de.setType(DataElementType.HIDDEN);
                de.setName("id_sog_mon");
                de.setValue(soggettoDefaultConsoleMonitoraggio);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Home Page");
                de.setType(DataElementType.HIDDEN);
                de.setName("hp_mon");
                de.setValue(homePageMonitoraggio);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Intervallo Temporale");
                de.setType(DataElementType.HIDDEN);
                de.setName("int_temp_mon");
                de.setValue(intervalloTemporaleReportStatistico);
                dati.add(de);
            }
        } else {
            de = new DataElement();
            de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipo_mod_mon");
            de.setValue(profiloDefaultConsoleMonitoraggio);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Soggetto Operativo");
            de.setType(DataElementType.HIDDEN);
            de.setName("id_sog_mon");
            de.setValue(soggettoDefaultConsoleMonitoraggio);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Home Page");
            de.setType(DataElementType.HIDDEN);
            de.setName("hp_mon");
            de.setValue(homePageMonitoraggio);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Intervallo Temporale");
            de.setType(DataElementType.HIDDEN);
            de.setName("int_temp_mon");
            de.setValue(intervalloTemporaleReportStatistico);
            dati.add(de);
        }
        boolean visualizzaFormPassword = this.core.isLoginApplication();
        if (visualizzaFormPassword) {
            de = new DataElement();
            de.setLabel("Password");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        if (this.utentiCore.isCheckPasswordExpire(passwordVerifier = this.utentiCore.getUtenzePasswordVerifier())) {
            de = new DataElement();
            de.setLabel("Scadenza");
            de.setType(DataElementType.CHECKBOX);
            de.setName("scadenza");
            de.setSelected(scadenza);
            de.setSize(this.getSize());
            if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
                de.setLabelAffiancata(true);
                de.setNote(MessageFormat.format("La password scade dopo {0} giorni", passwordVerifier.getExpireDays()));
            }
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                de.setLabelAffiancata(true);
                boolean passwordExpire = passwordVerifier.isPasswordExpire(dataUltimoAggiornamentoPassword);
                if (oldScadenza) {
                    if (passwordExpire) {
                        de.setNote("Password scaduta");
                        de.setValoreBoldRed();
                    } else {
                        long giorni = 0L;
                        Calendar c = Calendar.getInstance();
                        c.setTime(dataUltimoAggiornamentoPassword);
                        c.add(5, passwordVerifier.getExpireDays());
                        Date end = c.getTime();
                        Date now = new Date();
                        long endMs = end.getTime();
                        long nowMs = now.getTime();
                        long diff = endMs - nowMs;
                        giorni = diff / 1000L / 60L / 60L / 24L;
                        de.setNote(MessageFormat.format("La password scade fra {0} giorni", giorni));
                    }
                }
            }
            dati.add(de);
        }
        if (visualizzaFormPassword && TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            de = new DataElement();
            de.setLabel("Modifica");
            de.setType(DataElementType.CHECKBOX);
            de.setName("changepwd");
            de.setPostBack(true);
            de.setSelected(changepwd);
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (TipoOperazione.ADD.equals((Object)tipoOperazione) || ServletUtils.isCheckBoxEnabled((String)changepwd)) {
            de = new DataElement();
            de.setLabel("Password");
            if (visualizzaFormPassword) {
                de.setValue(pwsu);
                de.setType(DataElementType.CRYPT);
                de.getPassword().setVisualizzaPasswordChiaro(true);
                de.getPassword().setVisualizzaBottoneGeneraPassword(true);
                if (passwordVerifier != null) {
                    PasswordGenerator passwordGenerator = new PasswordGenerator(passwordVerifier);
                    passwordGenerator.setDefaultLength(this.utentiCore.getUtenzeLunghezzaPasswordGenerate());
                    de.getPassword().setPasswordGenerator(passwordGenerator);
                    de.setNote(passwordVerifier.help("<br/>"));
                }
                de.setRequired(!this.core.isMultiLoginEnabled());
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue("");
            }
            de.setName("pwsu");
            de.setSize(this.getSize());
            dati.add(de);
        }
        return dati;
    }

    public void addChangeUtenteInfoToDati(List<DataElement> dati, String nomesu, String changepwd, String pwsu, InterfaceType interfaceType, String isServizi, String isDiagnostica, String isReportistica, String isSistema, String isMessaggi, String isUtenti, String isAuditing, String isAccordiCooperazione, boolean scegliSuServizi, String[] uws, boolean scegliSuAccordi, String[] uwp, String[] modalitaGateway, String profiloDefaultConsoleGestione, String soggettoDefaultConsoleGestione, String profiloDefaultConsoleMonitoraggio, String soggettoDefaultConsoleMonitoraggio, String homePageMonitoraggio, String intervalloTemporaleReportStatistico) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nomesu);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomesu");
        dati.add(de);
        if (ServletUtils.isCheckBoxEnabled((String)changepwd)) {
            de = new DataElement();
            de.setLabel("Password");
            de.setValue(pwsu);
            de.setType(DataElementType.HIDDEN);
            de.setName("pwsu");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nuova Password");
            de.setValue(changepwd);
            de.setType(DataElementType.HIDDEN);
            de.setName("changepwd");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipo_mod");
        de.setValue(profiloDefaultConsoleGestione);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Soggetto Operativo");
        de.setType(DataElementType.HIDDEN);
        de.setName("id_sog");
        de.setValue(soggettoDefaultConsoleGestione);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Modalit&agrave; Interfaccia");
        de.setValue(interfaceType.toString());
        de.setType(DataElementType.HIDDEN);
        de.setName("tipo_gui");
        dati.add(de);
        de = new DataElement();
        de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipo_mod_mon");
        de.setValue(profiloDefaultConsoleMonitoraggio);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Soggetto Operativo");
        de.setType(DataElementType.HIDDEN);
        de.setName("id_sog_mon");
        de.setValue(soggettoDefaultConsoleMonitoraggio);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Home Page");
        de.setType(DataElementType.HIDDEN);
        de.setName("hp_mon");
        de.setValue(homePageMonitoraggio);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Intervallo Temporale");
        de.setType(DataElementType.HIDDEN);
        de.setName("int_temp_mon");
        de.setValue(intervalloTemporaleReportStatistico);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Gestione API [S]");
        de.setValue(isServizi);
        de.setType(DataElementType.HIDDEN);
        de.setName("isServizi");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Configurazione Generale [C]");
        de.setValue(isSistema);
        de.setType(DataElementType.HIDDEN);
        de.setName("isSistema");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Coda Messaggi [M]");
        de.setValue(isMessaggi);
        de.setType(DataElementType.HIDDEN);
        de.setName("isMessaggi");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Monitoraggio [D]");
        de.setValue(isDiagnostica);
        de.setType(DataElementType.HIDDEN);
        de.setName("isDiagnostica");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Reportistica [R]");
        de.setValue(isReportistica);
        de.setType(DataElementType.HIDDEN);
        de.setName("isReportistica");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Utenti [U]");
        de.setValue(isUtenti);
        de.setType(DataElementType.HIDDEN);
        de.setName("isUtenti");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Auditing [A]");
        de.setValue(isAuditing);
        de.setType(DataElementType.HIDDEN);
        de.setName("isAuditing");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Accordi Cooperazione [P]");
        de.setType(DataElementType.HIDDEN);
        de.setName("isAccordiCooperazione");
        de.setValue(isAccordiCooperazione);
        dati.add(de);
        if (scegliSuServizi) {
            de = new DataElement();
            de.setNote("Utente a cui verranno assegnati gli oggetti creati con il permesso 'Gestione API [S]'");
            de.setLabel("Utente");
            de.setType(DataElementType.SELECT);
            de.setName("singleSuS");
            de.setValues(uws);
            dati.add(de);
        }
        if (scegliSuAccordi) {
            de = new DataElement();
            de.setNote("Utente a cui verranno assegnati gli oggetti creati con il permesso 'Accordi Cooperazione [P]'");
            de.setLabel("Profilo Utente");
            de.setType(DataElementType.SELECT);
            de.setName("singleSuAC");
            de.setValues(uwp);
            dati.add(de);
        }
        List<String> protocolliRegistratiConsole = this.core.getProtocolli();
        for (int i = 0; i < protocolliRegistratiConsole.size(); ++i) {
            String protocolloName = protocolliRegistratiConsole.get(i);
            de = new DataElement();
            de.setLabel(this.getLabelProtocollo(protocolloName));
            de.setType(DataElementType.HIDDEN);
            de.setName("mod_" + protocolloName);
            de.setValue(modalitaGateway[i]);
            dati.add(de);
        }
    }

    public void addChooseUtenteForPermessiSToDati(List<DataElement> dati, String objToRemove, boolean scegliSuServizi, String[] uws, boolean scegliSuAccordi, String[] uwp) {
        DataElement de = new DataElement();
        de.setLabel("obj");
        de.setValue(objToRemove);
        de.setType(DataElementType.HIDDEN);
        de.setName("obj");
        dati.add(de);
        if (scegliSuServizi) {
            de = new DataElement();
            de.setNote("Utente a cui verranno assegnati gli oggetti creati con il permesso 'Gestione API [S]'");
            de.setLabel("Utente");
            de.setType(DataElementType.SELECT);
            de.setName("singleSuS");
            de.setValues(uws);
            dati.add(de);
        }
        if (scegliSuAccordi) {
            de = new DataElement();
            de.setNote("Utente a cui verranno assegnati gli oggetti creati con il permesso 'Accordi Cooperazione [P]'");
            de.setLabel("Profilo Utente");
            de.setType(DataElementType.SELECT);
            de.setName("singleSuAC");
            de.setValues(uwp);
            dati.add(de);
        }
    }

    public void addUtenteChangeToDati(List<DataElement> dati, InterfaceType interfaceType, String changepw, String nomeUtente, String profiloSelezionatoUtente, String soggettoSelezionatoUtente) throws Exception {
        List<String> protocolliDispondibili;
        DataElement de = new DataElement();
        de.setName("first");
        de.setType(DataElementType.HIDDEN);
        de.setValue("false");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Utente");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setName("login");
        de.setType(DataElementType.TEXT);
        de.setValue(nomeUtente);
        dati.add(de);
        User utente = this.utentiCore.getUser(nomeUtente);
        if (!utente.hasOnlyPermessiUtenti()) {
            de = new DataElement();
            de.setType(DataElementType.SUBTITLE);
            de.setLabel("Profilo");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Modalit&agrave; Interfaccia");
        de.setName("tipo_gui");
        if (utente.hasOnlyPermessiUtenti()) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(interfaceType.toString());
        } else if (interfaceType.equals((Object)InterfaceType.COMPLETA)) {
            de.setLabel("Modalit&agrave; Interfaccia");
            de.setType(DataElementType.TEXT);
            de.setName("tipo_gui_text");
            de.setValue(interfaceType.toString().toLowerCase());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Modalit&agrave; Interfaccia");
            de.setName("tipo_gui");
            de.setType(DataElementType.HIDDEN);
            de.setValue(interfaceType.toString());
        } else {
            de.setType(DataElementType.SELECT);
            User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
            String[] tipiInterfacce = null;
            Object tipiInterfacceLabel = null;
            tipiInterfacce = user.isPermitInterfaceComplete() ? new String[3] : new String[]{InterfaceType.STANDARD.toString(), InterfaceType.AVANZATA.toString()};
            if (user.isPermitInterfaceComplete()) {
                tipiInterfacce[2] = InterfaceType.COMPLETA.toString();
            }
            tipiInterfacceLabel = new String[tipiInterfacce.length];
            for (int i = 0; i < tipiInterfacce.length; ++i) {
                tipiInterfacceLabel[i] = tipiInterfacce[i].toLowerCase();
            }
            de.setValues(tipiInterfacce);
            de.setLabels((String[])tipiInterfacceLabel);
            de.setSelected(interfaceType.toString());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
        if (utente.hasOnlyPermessiUtenti()) {
            de.setType(DataElementType.HIDDEN);
            de.setName("tipo_mod");
            de.setValue(profiloSelezionatoUtente);
            dati.add(de);
        } else {
            protocolliDispondibili = this.core.getProtocolli(this.request, this.session, true);
            if (protocolliDispondibili != null && protocolliDispondibili.size() > 1) {
                de.setType(DataElementType.SELECT);
                ArrayList<String> labelProtocolli = new ArrayList<String>();
                for (String protocolloDisponibile : ProtocolUtils.orderProtocolli(protocolliDispondibili)) {
                    String labelProt = ConsoleHelper._getLabelProtocollo(protocolloDisponibile);
                    labelProtocolli.add(labelProt);
                }
                labelProtocolli.add(0, "Tutti");
                protocolliDispondibili.add(0, "all");
                de.setName("tipo_mod");
                de.setValues(protocolliDispondibili);
                de.setLabels(labelProtocolli);
                de.setSelected(profiloSelezionatoUtente);
                de.setPostBack(true);
                dati.add(de);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setName("tipo_mod");
                de.setValue(profiloSelezionatoUtente);
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setLabel(Costanti.LABEL_PARAMETRO_PROTOCOLLO_HTML_ESCAPE);
                de.setName("tipo_mod_txt");
                if (protocolliDispondibili != null) {
                    String labelProt = ConsoleHelper._getLabelProtocollo(protocolliDispondibili.get(0));
                    de.setValue(labelProt);
                }
                dati.add(de);
            }
        }
        if (utente.hasOnlyPermessiUtenti()) {
            de = new DataElement();
            de.setLabel("Soggetto Operativo");
            de.setType(DataElementType.HIDDEN);
            de.setName("id_sog");
            de.setValue(soggettoSelezionatoUtente);
            dati.add(de);
        } else {
            protocolliDispondibili = this.core.getProtocolli(this.request, this.session, true);
            if (profiloSelezionatoUtente != null && !"all".equals(profiloSelezionatoUtente) || protocolliDispondibili.size() == 1) {
                String profiloDefaultCorrente = protocolliDispondibili.size() == 1 ? protocolliDispondibili.get(0) : profiloSelezionatoUtente;
                List<IDSoggetto> idSoggettiOperativi = this.soggettiCore.getIdSoggettiOperativi(profiloDefaultCorrente);
                if (idSoggettiOperativi != null && idSoggettiOperativi.size() > 1) {
                    ArrayList<String> listaLabel = new ArrayList<String>();
                    HashMap<String, IDSoggetto> mapLabelIds = new HashMap<String, IDSoggetto>();
                    for (IDSoggetto idSoggetto : idSoggettiOperativi) {
                        String labelSoggetto = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                        if (listaLabel.contains(labelSoggetto)) continue;
                        listaLabel.add(labelSoggetto);
                        mapLabelIds.put(labelSoggetto, idSoggetto);
                    }
                    Collections.sort(listaLabel, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.toLowerCase().compareTo(o2.toLowerCase());
                        }
                    });
                    ArrayList<String> listaValues = new ArrayList<String>();
                    for (String label : listaLabel) {
                        listaValues.add(NamingUtils.getSoggettoFromLabel((String)profiloDefaultCorrente, (String)label).toString());
                    }
                    de = new DataElement();
                    de.setType(DataElementType.SELECT);
                    de.setLabel("Soggetto Operativo");
                    listaLabel.add(0, "Tutti");
                    listaValues.add(0, "all");
                    de.setValues(listaValues);
                    de.setLabels(listaLabel);
                    de.setName("id_sog");
                    de.setSelected(soggettoSelezionatoUtente);
                    dati.add(de);
                } else {
                    de = new DataElement();
                    de.setLabel("Soggetto Operativo");
                    de.setType(DataElementType.HIDDEN);
                    de.setName("id_sog");
                    de.setValue(soggettoSelezionatoUtente);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Soggetto Operativo");
                    de.setType(DataElementType.TEXT);
                    de.setName("id_sog_txt");
                    if (idSoggettiOperativi != null) {
                        IDSoggetto idSoggetto = idSoggettiOperativi.get(0);
                        String labelSoggetto = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                        de.setValue(labelSoggetto);
                    }
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setLabel("Soggetto Operativo");
                de.setType(DataElementType.HIDDEN);
                de.setName("id_sog");
                de.setValue(soggettoSelezionatoUtente);
                dati.add(de);
            }
        }
        if (this.core.isLoginApplication() && !ServletUtils.isUtenteLoggatoConOAuth2((HttpSession)this.session)) {
            de = new DataElement();
            de.setLabel("Password");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Modifica");
            de.setType(DataElementType.CHECKBOX);
            de.setName("changepwd");
            de.setPostBack(true);
            de.setSelected(changepw);
            de.setSize(this.getSize());
            dati.add(de);
            if (ServletUtils.isCheckBoxEnabled((String)changepw)) {
                PasswordVerifier passwordVerifier = this.utentiCore.getUtenzePasswordVerifier();
                boolean passwordObbligatoria = this.core.isLoginApplication() && !this.core.isMultiLoginEnabled();
                de = new DataElement();
                de.setLabel("Vecchia");
                de.setType(DataElementType.CRYPT);
                de.setName("oldpw");
                de.setValue("");
                de.setSize(this.getSize());
                de.setRequired(passwordObbligatoria);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Nuova");
                de.setType(DataElementType.CRYPT);
                de.setName("newpw");
                de.setSize(this.getSize());
                de.setValue("");
                de.setRequired(passwordObbligatoria);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Conferma Nuova");
                de.setType(DataElementType.CRYPT);
                de.setName("confpw");
                de.setSize(this.getSize());
                de.setValue("");
                de.setRequired(passwordObbligatoria);
                if (passwordVerifier != null) {
                    de.setNote(passwordVerifier.helpUpdate("<br/>"));
                }
                dati.add(de);
            }
        }
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("changePw");
        de.setValue("changePw");
        dati.add(de);
    }

    public boolean utentiCheckData(TipoOperazione tipoOperazione, boolean singlePdD, List<String> oldProtocolliSupportati, boolean oldUserHasOnlyPermessiUtenti) throws Exception {
        try {
            List<String> usersWithU;
            boolean trovato;
            StringBuilder motivazioneErrore;
            PasswordVerifier passwordVerifier;
            boolean utenteConsoleEnabled;
            String nomesu = this.getParameter("nomesu");
            String pwsu = this.getParameter("pwsu");
            String tipoGui = this.getParameter("tipo_gui");
            String isServizi = this.getParameter("isServizi");
            String isDiagnostica = this.getParameter("isDiagnostica");
            String isReportistica = this.getParameter("isReportistica");
            String isSistema = this.getParameter("isSistema");
            String isMessaggi = this.getParameter("isMessaggi");
            String isUtenti = this.getParameter("isUtenti");
            String isAccordiCooperazione = this.getParameter("isAccordiCooperazione");
            String isAuditing = this.getParameter("isAuditing");
            String changepwd = this.getParameter("changepwd");
            List<String> protocolliRegistratiConsole = this.utentiCore.getProtocolli();
            String[] modalitaScelte = new String[protocolliRegistratiConsole.size()];
            ArrayList<String> nuoviProtocolliSupportati = new ArrayList<String>();
            for (int i = 0; i < protocolliRegistratiConsole.size(); ++i) {
                String protocolloName = protocolliRegistratiConsole.get(i);
                modalitaScelte[i] = this.getParameter("mod_" + protocolloName);
                if (!ServletUtils.isCheckBoxEnabled((String)modalitaScelte[i])) continue;
                nuoviProtocolliSupportati.add(protocolloName);
            }
            if (TipoOperazione.ADD.equals((Object)tipoOperazione) || ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                Object tmpElenco = "";
                if (nomesu.equals("")) {
                    tmpElenco = "Nome";
                }
                boolean checkPassword = true;
                if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && !ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                    checkPassword = false;
                }
                if (this.core.isMultiLoginEnabled() || !this.core.isLoginApplication()) {
                    checkPassword = false;
                }
                if (checkPassword && (pwsu == null || pwsu.equals(""))) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Password" : (String)tmpElenco + ", Password";
                }
                if (!((String)tmpElenco).equals("")) {
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                    return false;
                }
            }
            if (nomesu.indexOf(" ") != -1 || ServletUtils.isCheckBoxEnabled((String)changepwd) && pwsu.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkLength255(nomesu, "Nome")) {
                return false;
            }
            User user = null;
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                user = this.utentiCore.getUser(nomesu);
                if (!oldUserHasOnlyPermessiUtenti) {
                    if (oldProtocolliSupportati == null) {
                        oldProtocolliSupportati = this.utentiCore.getProtocolli();
                    }
                    Collections.sort(oldProtocolliSupportati);
                    Collections.sort(nuoviProtocolliSupportati);
                    ArrayList<String> protocolliEliminati = new ArrayList<String>();
                    for (String vecchioProtocollo : oldProtocolliSupportati) {
                        boolean protocolloEliminato = !nuoviProtocolliSupportati.contains(vecchioProtocollo);
                        if (!protocolloEliminato) continue;
                        protocolliEliminati.add(vecchioProtocollo);
                    }
                    if (!protocolliEliminati.isEmpty()) {
                        ArrayList<String> nomiUtentiDaRimuovere = new ArrayList<String>();
                        nomiUtentiDaRimuovere.add(nomesu);
                        ArrayList<String> utentiDaNonEliminare = new ArrayList<String>();
                        ArrayList<String> protocolliNonValidi = new ArrayList<String>();
                        for (String string : protocolliEliminati) {
                            boolean protocolloNonPiuAssociato = this.controllaEsistenzaUtentePerAssociareIlProtocollo(nomiUtentiDaRimuovere, utentiDaNonEliminare, nomesu, string);
                            if (!protocolloNonPiuAssociato) continue;
                            protocolliNonValidi.add(this.getLabelProtocollo(string));
                        }
                        if (!utentiDaNonEliminare.isEmpty()) {
                            if (protocolliNonValidi.size() > 1) {
                                StringBuilder sbPnV = new StringBuilder();
                                for (String protNonVal : protocolliNonValidi) {
                                    if (sbPnV.length() > 0) {
                                        sbPnV.append(", ");
                                    }
                                    sbPnV.append(protNonVal);
                                }
                                this.pd.setMessage("L'utente " + (String)utentiDaNonEliminare.get(0) + " non pu&ograve; essere modificato poich&egrave; sono stati rilevati oggetti, appartenenti ai " + Costanti.LABEL_PARAMETRO_PROTOCOLLI_DI_HTML_ESCAPE + " '" + sbPnV.toString() + "', non assegnati a nessun altro utente");
                            } else {
                                this.pd.setMessage("L'utente " + (String)utentiDaNonEliminare.get(0) + " non pu&ograve; essere modificato poich&egrave; sono stati rilevati oggetti, appartenenti al " + Costanti.LABEL_PARAMETRO_PROTOCOLLO_DI_HTML_ESCAPE + " '" + (String)protocolliNonValidi.get(0) + "', non assegnati a nessun altro utente");
                            }
                            return false;
                        }
                        for (String string : protocolliEliminati) {
                            String protocolloAssociatoTipoSoggetto;
                            if (!user.getServizi().isEmpty()) {
                                for (IDServizio idServizio : user.getServizi()) {
                                    protocolloAssociatoTipoSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(idServizio.getTipo());
                                    if (!protocolloAssociatoTipoSoggetto.equals(string)) continue;
                                    this.pd.setMessage("L'utente " + nomesu + " non pu&ograve; essere modificato poich&egrave; sono stati rilevati delle API, appartenenti al " + Costanti.LABEL_PARAMETRO_PROTOCOLLO_DI_HTML_ESCAPE + " '" + this.getLabelProtocollo(string) + "', registrate tra le restrizioni dell'utente");
                                    return false;
                                }
                            }
                            if (user.getSoggetti().isEmpty()) continue;
                            for (IDSoggetto idSoggetto : user.getSoggetti()) {
                                protocolloAssociatoTipoSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(idSoggetto.getTipo());
                                if (!protocolloAssociatoTipoSoggetto.equals(string)) continue;
                                this.pd.setMessage("L'utente " + nomesu + " non pu&ograve; essere modificato poich&egrave; sono stati rilevati dei soggetti, appartenenti al " + Costanti.LABEL_PARAMETRO_PROTOCOLLO_DI_HTML_ESCAPE + " '" + this.getLabelProtocollo(string) + "', registrati tra le restrizioni dell'utente");
                                return false;
                            }
                        }
                    }
                }
                if (!(isDiagnostica != null && ServletUtils.isCheckBoxEnabled((String)isDiagnostica) || isReportistica != null && ServletUtils.isCheckBoxEnabled((String)isReportistica))) {
                    boolean oldDiagnostica = user.getPermessi().isDiagnostica();
                    boolean oldReportistica = user.getPermessi().isReportistica();
                    if ((oldDiagnostica || oldReportistica) && !user.getServizi().isEmpty()) {
                        this.pd.setMessage("L'utente " + nomesu + " non pu&ograve; essere modificato poich&egrave; sono stati rilevate delle API registrate tra le restrizioni dell'utente");
                        return false;
                    }
                    if ((oldDiagnostica || oldReportistica) && !user.getSoggetti().isEmpty()) {
                        this.pd.setMessage("L'utente " + nomesu + " non pu&ograve; essere modificato poich&egrave; sono stati rilevati dei soggetti registrati tra le restrizioni dell'utente");
                        return false;
                    }
                }
            }
            boolean bl = utenteConsoleEnabled = ServletUtils.isCheckBoxEnabled((String)isServizi) || ServletUtils.isCheckBoxEnabled((String)isMessaggi) || ServletUtils.isCheckBoxEnabled((String)isAuditing) || ServletUtils.isCheckBoxEnabled((String)isSistema) || ServletUtils.isCheckBoxEnabled((String)isUtenti) || ServletUtils.isCheckBoxEnabled((String)isAccordiCooperazione);
            if (utenteConsoleEnabled) {
                try {
                    InterfaceType.convert((String)tipoGui, (boolean)true);
                }
                catch (Exception e) {
                    this.pd.setMessage("Tipo dev'essere uno dei seguenti valori: " + InterfaceType.AVANZATA + ", " + InterfaceType.STANDARD + ".");
                    return false;
                }
                String homePageMonitoraggio = this.getParameter("hp_mon");
                String intervalloTemporaleHomePageConsoleMonitoraggio = this.getParameter("int_temp_mon");
                if (!Arrays.asList(UtentiCostanti.getValuesParametroUtentiHomePageMonitoraggio()).contains(homePageMonitoraggio)) {
                    this.pd.setMessage("Home Page contiene un valore non valido.");
                    return false;
                }
                if (!Arrays.asList(UtentiCostanti.getValuesParametroUtentiIntervalloTemporaleHomePageMonitoraggio()).contains(intervalloTemporaleHomePageConsoleMonitoraggio)) {
                    this.pd.setMessage("Intervallo Temporale contiene un valore non valido.");
                    return false;
                }
            }
            boolean checkPassword = true;
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && !ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                checkPassword = false;
            }
            if (this.core.isMultiLoginEnabled() || !this.core.isLoginApplication()) {
                checkPassword = false;
            }
            if (checkPassword && (passwordVerifier = this.utentiCore.getUtenzePasswordVerifier()) != null && !passwordVerifier.validate(nomesu, pwsu, motivazioneErrore = new StringBuilder())) {
                this.pd.setMessage(motivazioneErrore.toString());
                return false;
            }
            if (!(isServizi != null && ServletUtils.isCheckBoxEnabled((String)isServizi) || singlePdD && (isDiagnostica != null && ServletUtils.isCheckBoxEnabled((String)isDiagnostica) || isReportistica != null && ServletUtils.isCheckBoxEnabled((String)isReportistica)) || isSistema != null && ServletUtils.isCheckBoxEnabled((String)isSistema) || isMessaggi != null && ServletUtils.isCheckBoxEnabled((String)isMessaggi) || isUtenti != null && ServletUtils.isCheckBoxEnabled((String)isUtenti) || isAuditing != null && ServletUtils.isCheckBoxEnabled((String)isAuditing) || isAccordiCooperazione != null && ServletUtils.isCheckBoxEnabled((String)isAccordiCooperazione))) {
                this.pd.setMessage("Selezionare almeno un Permesso");
                return false;
            }
            boolean modalitaPresenti = false;
            for (int i = 0; i < modalitaScelte.length; ++i) {
                boolean bl2 = modalitaPresenti = modalitaScelte[i] != null && ServletUtils.isCheckBoxEnabled((String)modalitaScelte[i]);
                if (modalitaPresenti) break;
            }
            if (!this.hasOnlyPermessiUtenti(isServizi, isDiagnostica, isReportistica, isSistema, isMessaggi, isUtenti, isAuditing, isAccordiCooperazione, singlePdD)) {
                if (!modalitaPresenti) {
                    this.pd.setMessage("Selezionare almeno un " + Costanti.LABEL_PARAMETRO_PROTOCOLLO_DI_HTML_ESCAPE);
                    return false;
                }
            } else if (modalitaPresenti) {
                this.pd.setMessage("Se all'utente viene assegnato solamente il Permesso 'U' non deve essere selezionata alcun " + Costanti.LABEL_PARAMETRO_PROTOCOLLO_DI_HTML_ESCAPE);
                return false;
            }
            if (TipoOperazione.ADD.equals((Object)tipoOperazione) && (trovato = this.utentiCore.existsUser(nomesu))) {
                this.pd.setMessage("Esiste gi&agrave; un utente con nome " + nomesu);
                return false;
            }
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && (isUtenti == null || !ServletUtils.isCheckBoxEnabled((String)isUtenti)) && (usersWithU = this.utentiCore.getUsersWithType(Permessi.UTENTI.toString())).size() == 1 && usersWithU.get(0).equals(nomesu)) {
                this.pd.setMessage("Non \u00e8 possibile eliminare il permesso 'Utenti', poich\u00e8 non esistono altri utenti con tale permesso");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    boolean changePwCheckData() throws Exception {
        try {
            boolean passwordObbligatoria;
            String oldpw = this.getParameter("oldpw");
            String newpw = this.getParameter("newpw");
            String confpw = this.getParameter("confpw");
            String changepwd = this.getParameter("changepwd");
            if (!ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                return true;
            }
            User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
            boolean bl = passwordObbligatoria = this.core.isLoginApplication() && !this.core.isMultiLoginEnabled();
            if (!user.getPermessi().isUtenti()) {
                boolean trovato = this.utentiCore.getUtenzePasswordManager().check(oldpw, user.getPassword());
                if (!trovato && this.utentiCore.getUtenzePasswordManagerBackwardCompatibility() != null) {
                    trovato = this.utentiCore.getUtenzePasswordManagerBackwardCompatibility().check(oldpw, user.getPassword());
                }
                if (!trovato) {
                    this.pd.setMessage("La vecchia password indicata non e' corretta");
                    return false;
                }
                if (oldpw.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
            }
            if (passwordObbligatoria && (newpw == null || newpw.equals("")) || confpw == null || confpw.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare una password");
                return false;
            }
            if (newpw.indexOf(" ") != -1 || confpw.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!user.getPermessi().isUtenti() && passwordObbligatoria && oldpw.equals(newpw)) {
                this.pd.setMessage("La nuova password deve essere differente dalla vecchia");
                return false;
            }
            if (!newpw.equals(confpw)) {
                this.pd.setMessage("Le password inserite nei campi Nuova e Conferma Nuova non corrispondono");
                return false;
            }
            PasswordVerifier passwordVerifier = this.utentiCore.getUtenzePasswordVerifier();
            if (passwordVerifier != null) {
                StringBuilder motivazioneErrore = new StringBuilder();
                if (!passwordVerifier.validate(user.getLogin(), newpw, motivazioneErrore)) {
                    this.pd.setMessage(motivazioneErrore.toString());
                    return false;
                }
                if (passwordVerifier.isHistory()) {
                    List precedentiPassword = user.getPrecedentiPassword();
                    if (precedentiPassword == null || precedentiPassword.isEmpty()) {
                        boolean trovato = this.utentiCore.getUtenzePasswordManager().check(newpw, user.getPassword());
                        if (!trovato && this.utentiCore.getUtenzePasswordManagerBackwardCompatibility() != null) {
                            trovato = this.utentiCore.getUtenzePasswordManagerBackwardCompatibility().check(newpw, user.getPassword());
                        }
                        if (trovato) {
                            this.pd.setMessage("La password scelta non deve corrispondere ad una precedente password");
                            return false;
                        }
                    }
                    for (UserPassword userPassword : precedentiPassword) {
                        boolean trovato = this.utentiCore.getUtenzePasswordManager().check(newpw, userPassword.getPassword());
                        if (!trovato && this.utentiCore.getUtenzePasswordManagerBackwardCompatibility() != null) {
                            trovato = this.utentiCore.getUtenzePasswordManagerBackwardCompatibility().check(newpw, userPassword.getPassword());
                        }
                        if (!trovato) continue;
                        this.pd.setMessage("La password scelta non deve corrispondere ad una precedente password");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (DriverControlStationException e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)((Object)e));
            throw new Exception((Throwable)((Object)e));
        }
    }

    public void prepareUtentiList(ISearch ricerca, List<User> lista, boolean singlePdD) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"utenti", (Parameter[])new Parameter[0]);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)this.session);
            int idLista = Liste.SU;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Utenti", "utentiList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Utenti", "utentiList.do"), new Parameter("Risultati ricerca", null)});
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Utenti", (String)search);
            }
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("");
            labels.add("Profilo Utente");
            if (this.utentiCore.isMultiLoginEnabled()) {
                labels.add("Tipo Account");
            }
            labels.add("Modalit&agrave; Interfaccia");
            labels.add("Profilo");
            labels.add("Permessi di Gestione");
            labels.add("Cambia identit\u00e0");
            this.pd.setLabels(labels.toArray(new String[1]));
            ArrayList dati = new ArrayList();
            PasswordVerifier passwordVerifier = this.utentiCore.getUtenzePasswordVerifier();
            if (lista != null) {
                for (User mySU : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setWidthPx(10);
                    de.setType(DataElementType.CHECKBOX);
                    if (mySU.isConfigurazioneValidaAbilitazioni()) {
                        de.setSelected(CheckboxStatusType.ABILITATO);
                    } else {
                        de.setToolTip(mySU.getReasonInvalidConfiguration());
                        de.setValue(mySU.getReasonInvalidConfiguration());
                        de.setSelected(CheckboxStatusType.DISABILITATO);
                    }
                    if (this.core.isCheckPasswordExpire(passwordVerifier) && mySU.isCheckLastUpdatePassword() && passwordVerifier.isPasswordExpire(mySU.getLastUpdatePassword())) {
                        de.setToolTip("Password scaduta");
                        de.setValue("Password scaduta");
                        de.setSelected(CheckboxStatusType.DISABILITATO);
                    }
                    de.setUrl("utentiChange.do", new Parameter[]{new Parameter("nomesu", mySU.getLogin())});
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("utentiChange.do", new Parameter[]{new Parameter("nomesu", mySU.getLogin())});
                    de.setIdToRemove(mySU.getId().toString());
                    de.setValue(mySU.getLogin());
                    e.add(de);
                    if (this.utentiCore.isMultiLoginEnabled()) {
                        de = new DataElement();
                        boolean utenteEsterno = this.utentiCore.getUtenzePasswordManager().check("", mySU.getPassword());
                        de.setValue(utenteEsterno ? "Esterno" : "Locale");
                        e.add(de);
                    }
                    de = new DataElement();
                    if (mySU.hasOnlyPermessiUtenti()) {
                        de.setValue("-");
                    } else {
                        de.setValue(mySU.getInterfaceType().toString().toLowerCase());
                    }
                    e.add(de);
                    de = new DataElement();
                    ArrayList protocolliSupportati = mySU.getProtocolliSupportati();
                    if (protocolliSupportati == null) {
                        protocolliSupportati = new ArrayList();
                    }
                    if (mySU.hasOnlyPermessiUtenti()) {
                        de.setValue("-");
                    } else if (!protocolliSupportati.isEmpty()) {
                        int i;
                        Collections.sort(protocolliSupportati);
                        List<String> protocolliInstallati = this.core.getProtocolli();
                        Collections.sort(protocolliInstallati);
                        String labelProtocolli = null;
                        if (protocolliSupportati.size() == protocolliInstallati.size()) {
                            boolean all = true;
                            for (i = 0; i < protocolliInstallati.size(); ++i) {
                                String pS;
                                String pI = protocolliInstallati.get(i);
                                if (pI.equals(pS = (String)protocolliSupportati.get(i))) continue;
                                all = false;
                                break;
                            }
                            if (all) {
                                labelProtocolli = "Tutti";
                            }
                        }
                        if (labelProtocolli == null) {
                            StringBuilder sb = new StringBuilder();
                            for (i = 0; i < protocolliSupportati.size(); ++i) {
                                String pS = (String)protocolliSupportati.get(i);
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                sb.append(this.getLabelProtocollo(pS));
                            }
                            labelProtocolli = sb.toString();
                        }
                        de.setValue(labelProtocolli);
                    } else {
                        de.setValue("Tutti");
                    }
                    e.add(de);
                    de = new DataElement();
                    if (singlePdD) {
                        de.setValue(mySU.getPermessi().toString(","));
                    } else {
                        PermessiUtente maschera = new PermessiUtente();
                        maschera.setAuditing(true);
                        maschera.setServizi(true);
                        maschera.setSistema(true);
                        maschera.setUtenti(true);
                        maschera.setCodeMessaggi(true);
                        maschera.setAccordiCooperazione(true);
                        de.setValue(mySU.getPermessi().toString(",", maschera));
                    }
                    e.add(de);
                    de = new DataElement();
                    if (!userLogin.equals(mySU.getLogin()) && !this.hasOnlyPermessiDiagnosticaReportistica(mySU) && mySU.isConfigurazioneValidaAbilitazioni()) {
                        de.setUrl("loginAsSu.do", new Parameter[]{new Parameter("login", mySU.getLogin())});
                        de.setValue("Accedi");
                    } else {
                        de.setValue("");
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public List<String> controlloModalitaUtenteDaEliminare(List<String> nomiUtentiDaRimuovere, List<String> utentiDaNonEliminare, User user) throws DriverRegistroServiziException, DriverUsersDBException {
        return this.controlloModalitaUtenteDaEliminare(nomiUtentiDaRimuovere, utentiDaNonEliminare, user, user.getProtocolliSupportati());
    }

    public List<String> controlloModalitaUtenteDaEliminare(List<String> nomiUtentiDaRimuovere, List<String> utentiDaNonEliminare, User user, List<String> protocolliSupportati) throws DriverRegistroServiziException, DriverUsersDBException {
        ArrayList<String> protocolliNonPiuAssociati = new ArrayList<String>();
        if (protocolliSupportati != null && !protocolliSupportati.isEmpty()) {
            for (String protocollo : protocolliSupportati) {
                boolean protocolloNonPiuAssociato = this.controllaEsistenzaUtentePerAssociareIlProtocollo(nomiUtentiDaRimuovere, utentiDaNonEliminare, user.getLogin(), protocollo);
                if (!protocolloNonPiuAssociato) continue;
                protocolliNonPiuAssociati.add(protocollo);
            }
        }
        return protocolliNonPiuAssociati;
    }

    public boolean controllaEsistenzaUtentePerAssociareIlProtocollo(List<String> nomiUtentiDaRimuovere, List<String> utentiDaNonEliminare, String userLogin, String protocollo) throws DriverRegistroServiziException, DriverUsersDBException {
        boolean protocolloNonPiuAssociato = false;
        boolean existsAlmostOneOrganization = this.utentiCore.existsAlmostOneOrganization(null, userLogin, protocollo);
        if (existsAlmostOneOrganization) {
            List<String> usersByProtocolloSupportatoTmp = this.utentiCore.getUsersByProtocolloSupportato(protocollo, true);
            ArrayList<String> usersByProtocolloSupportato = new ArrayList<String>();
            for (String uDE : usersByProtocolloSupportatoTmp) {
                if (nomiUtentiDaRimuovere.contains(uDE)) continue;
                usersByProtocolloSupportato.add(uDE);
            }
            if (usersByProtocolloSupportato.isEmpty()) {
                protocolloNonPiuAssociato = true;
                if (!utentiDaNonEliminare.contains(userLogin)) {
                    utentiDaNonEliminare.add(userLogin);
                }
            }
        }
        return protocolloNonPiuAssociato;
    }

    public boolean checkUsersModalitaGatewayCompatibili(String userLoginToCheck, String userLogin) throws DriverUsersDBException {
        User userToCheck = this.utentiCore.getUser(userLoginToCheck);
        User user = this.utentiCore.getUser(userLogin);
        return this.checkUsersModalitaGatewayCompatibili(userToCheck, user);
    }

    public boolean checkUsersModalitaGatewayCompatibili(User userToCheck, User user) {
        if (userToCheck.hasOnlyPermessiUtenti()) {
            return true;
        }
        List<String> protocolliRegistratiConsole = this.utentiCore.getProtocolli();
        if (user.getProtocolliSupportati() == null) {
            return true;
        }
        boolean userHasAll = true;
        for (String protocolloConsole : protocolliRegistratiConsole) {
            if (user.getProtocolliSupportati().contains(protocolloConsole)) continue;
            userHasAll = false;
            break;
        }
        if (userHasAll) {
            return true;
        }
        if (userToCheck.getProtocolliSupportati() == null) {
            return false;
        }
        boolean usertoCheckHasAll = true;
        for (String protocolloConsole : protocolliRegistratiConsole) {
            if (userToCheck.getProtocolliSupportati().contains(protocolloConsole)) continue;
            usertoCheckHasAll = false;
            break;
        }
        if (usertoCheckHasAll) {
            return false;
        }
        for (String protocolloUserToCheck : userToCheck.getProtocolliSupportati()) {
            if (user.getProtocolliSupportati().contains(protocolloUserToCheck)) continue;
            return false;
        }
        return true;
    }

    public void prepareUtentiSoggettiList(ConsoleSearch ricerca, List<IDSoggetto> lista, User user) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"utentiSoggetti", (Parameter[])new Parameter[]{new Parameter("nomesu", user.getLogin())});
            int idLista = Liste.UTENTI_SOGGETTI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.addFilterProtocol((ISearch)ricerca, idLista, user.getProtocolliSupportati());
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            boolean showProtocolli = user.getProtocolliSupportati() != null && user.getProtocolliSupportati().size() > 1;
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Utenti", "utentiList.do"));
            lstParam.add(new Parameter(user.getLogin(), "utentiChange.do", new Parameter[]{new Parameter("nomesu", user.getLogin())}));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("Soggetti", null));
            } else {
                lstParam.add(new Parameter("Soggetti", "utentiSoggettiList.do", new Parameter[]{new Parameter("nomesu", user.getLogin())}));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            this.pd.setSearchLabel("Soggetto");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Soggetti", (String)search);
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            int totEl = 1;
            if (showProtocolli) {
                ++totEl;
            }
            String[] labels = new String[totEl];
            int i = 0;
            labels[i++] = "Soggetto";
            if (showProtocolli) {
                labels[i++] = "Profilo Interoperabilit\u00e0";
            }
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (IDSoggetto soggetto : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggetto.getTipo());
                    DataElement de = new DataElement();
                    de.setValue(this.getLabelNomeSoggetto(protocollo, soggetto.getTipo(), soggetto.getNome()));
                    de.setIdToRemove(soggetto.getTipo() + "/" + soggetto.getNome());
                    de.setToolTip(this.getLabelNomeSoggetto(protocollo, soggetto.getTipo(), soggetto.getNome()));
                    e.add(de);
                    if (showProtocolli) {
                        de = new DataElement();
                        de.setValue(this.getLabelProtocollo(this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggetto.getTipo())));
                        e.add(de);
                    }
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void prepareUtentiServiziList(ConsoleSearch ricerca, List<IDServizio> lista, User user) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"utentiServizi", (Parameter[])new Parameter[]{new Parameter("nomesu", user.getLogin())});
            int idLista = Liste.UTENTI_SERVIZI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.addFilterProtocol((ISearch)ricerca, idLista, user.getProtocolliSupportati());
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            boolean showProtocolli = user.getProtocolliSupportati() != null && user.getProtocolliSupportati().size() > 1;
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Utenti", "utentiList.do"));
            lstParam.add(new Parameter(user.getLogin(), "utentiChange.do", new Parameter[]{new Parameter("nomesu", user.getLogin())}));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("API", null));
            } else {
                lstParam.add(new Parameter("API", "utentiServiziList.do", new Parameter[]{new Parameter("nomesu", user.getLogin())}));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            this.pd.setSearchLabel("API");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"API", (String)search);
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            int totEl = 2;
            if (showProtocolli) {
                ++totEl;
            }
            String[] labels = new String[totEl];
            int i = 0;
            labels[i++] = "API";
            labels[i++] = "Soggetto Erogatore";
            if (showProtocolli) {
                labels[i++] = "Profilo Interoperabilit\u00e0";
            }
            this.pd.setLabels(labels);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (IDServizio servizio : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(servizio.getTipo());
                    String uriASPS = this.idServizioFactory.getUriFromIDServizio(servizio);
                    DataElement de = new DataElement();
                    de.setValue(this.getLabelNomeServizio(protocollo, servizio.getTipo(), servizio.getNome(), servizio.getVersione()));
                    de.setIdToRemove(uriASPS);
                    e.add(de);
                    de = new DataElement();
                    de.setValue(this.getLabelNomeSoggetto(protocollo, servizio.getSoggettoErogatore().getTipo(), servizio.getSoggettoErogatore().getNome()));
                    e.add(de);
                    if (showProtocolli) {
                        de = new DataElement();
                        de.setValue(this.getLabelProtocollo(protocollo));
                        e.add(de);
                    }
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void addUtentiSoggettiToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String nomesu, String soggetto, String[] soggettiValues, String[] soggettiLabels, List<String> listaTipiProtocollo, String tipoProtocollo) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Soggetti");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nomesu);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomesu");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Profilo Interoperabilit\u00e0");
        de.setName("protocollo");
        if (listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
            de.setLabel("Profilo Interoperabilit\u00e0");
            de.setValues(listaTipiProtocollo);
            de.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
            de.setSelected(tipoProtocollo);
            de.setType(DataElementType.SELECT);
            de.setPostBack(true);
        } else {
            de.setValue(tipoProtocollo);
            de.setType(DataElementType.HIDDEN);
        }
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Soggetto");
        de.setName("soggetto");
        if (soggettiValues != null && soggettiValues.length > 1) {
            de.setType(DataElementType.SELECT);
            de.setValues(soggettiValues);
            de.setLabels(soggettiLabels);
            de.setSelected(soggetto);
            de.setRequired(true);
        } else {
            de.setValue(soggetto);
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
    }

    public void addUtentiServiziToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String nomesu, String servizio, String[] serviziValues, String[] serviziLabels, List<String> listaTipiProtocollo, String tipoProtocollo) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("API");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nomesu);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomesu");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Profilo Interoperabilit\u00e0");
        de.setName("protocollo");
        if (listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
            de.setLabel("Profilo Interoperabilit\u00e0");
            de.setValues(listaTipiProtocollo);
            de.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
            de.setSelected(tipoProtocollo);
            de.setType(DataElementType.SELECT);
            de.setPostBack(true);
        } else {
            de.setValue(tipoProtocollo);
            de.setType(DataElementType.HIDDEN);
        }
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("API");
        de.setName("servizio");
        if (serviziValues != null && serviziValues.length > 1) {
            de.setType(DataElementType.SELECT);
            de.setValues(serviziValues);
            de.setLabels(serviziLabels);
            de.setSelected(servizio);
            de.setRequired(true);
        } else {
            de.setValue(servizio);
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
    }

    public boolean utentiSoggettiCheckData(TipoOperazione tipoOperazione, String nomesu, String soggetto) {
        if (StringUtils.isEmpty((String)soggetto) || soggetto.equals("-")) {
            this.pd.setMessage("Selezionare un soggetto");
            return false;
        }
        return true;
    }

    public boolean utentiServiziCheckData(String nomesu, String servizio) {
        if (StringUtils.isEmpty((String)servizio) || servizio.equals("-")) {
            this.pd.setMessage("Selezionare un servizio");
            return false;
        }
        return true;
    }

    public void addUtenteChangePasswordScadutaToDati(List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setName("first");
        de.setType(DataElementType.HIDDEN);
        de.setValue("false");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        PasswordVerifier passwordVerifier = this.utentiCore.getUtenzePasswordVerifier();
        de = new DataElement();
        de.setLabel("Vecchia");
        de.setType(DataElementType.CRYPT);
        de.setName("oldpw");
        de.setValue("");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nuova");
        de.setType(DataElementType.CRYPT);
        de.setName("newpw");
        de.setSize(this.getSize());
        de.setValue("");
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Conferma Nuova");
        de.setType(DataElementType.CRYPT);
        de.setName("confpw");
        de.setSize(this.getSize());
        de.setValue("");
        de.setRequired(true);
        if (passwordVerifier != null) {
            de.setNote(passwordVerifier.helpUpdate("<br/>"));
        }
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("changePw");
        de.setValue("changePw");
        dati.add(de);
    }

    boolean changePwScadutaCheckData() throws DriverControlStationException, DriverUsersDBException {
        try {
            String oldpw = this.getParameter("oldpw");
            String newpw = this.getParameter("newpw");
            String confpw = this.getParameter("confpw");
            String userToUpdate = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"changePwdScaduta");
            User user = this.utentiCore.getUser(userToUpdate);
            boolean trovato = this.utentiCore.getUtenzePasswordManager().check(oldpw, user.getPassword());
            if (!trovato && this.utentiCore.getUtenzePasswordManagerBackwardCompatibility() != null) {
                trovato = this.utentiCore.getUtenzePasswordManagerBackwardCompatibility().check(oldpw, user.getPassword());
            }
            if (!trovato) {
                this.pd.setMessage("La vecchia password indicata non &egrave; corretta");
                return false;
            }
            if (oldpw.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (newpw.equals("") || confpw.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare una password");
                return false;
            }
            if (newpw.indexOf(" ") != -1 || confpw.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (oldpw.equals(newpw)) {
                this.pd.setMessage("La nuova password deve essere differente dalla vecchia");
                return false;
            }
            if (!newpw.equals(confpw)) {
                this.pd.setMessage("Le password inserite nei campi Nuova e Conferma Nuova non corrispondono");
                return false;
            }
            PasswordVerifier passwordVerifier = this.utentiCore.getUtenzePasswordVerifier();
            if (passwordVerifier != null) {
                StringBuilder motivazioneErrore = new StringBuilder();
                if (!passwordVerifier.validate(user.getLogin(), newpw, motivazioneErrore)) {
                    this.pd.setMessage(motivazioneErrore.toString());
                    return false;
                }
                if (passwordVerifier.isHistory()) {
                    List precedentiPassword = user.getPrecedentiPassword();
                    if (precedentiPassword == null || precedentiPassword.isEmpty()) {
                        trovato = this.utentiCore.getUtenzePasswordManager().check(newpw, user.getPassword());
                        if (!trovato && this.utentiCore.getUtenzePasswordManagerBackwardCompatibility() != null) {
                            trovato = this.utentiCore.getUtenzePasswordManagerBackwardCompatibility().check(newpw, user.getPassword());
                        }
                        if (trovato) {
                            this.pd.setMessage("La password scelta non deve corrispondere ad una precedente password");
                            return false;
                        }
                    }
                    for (UserPassword userPassword : precedentiPassword) {
                        trovato = this.utentiCore.getUtenzePasswordManager().check(newpw, userPassword.getPassword());
                        if (!trovato && this.utentiCore.getUtenzePasswordManagerBackwardCompatibility() != null) {
                            trovato = this.utentiCore.getUtenzePasswordManagerBackwardCompatibility().check(newpw, userPassword.getPassword());
                        }
                        if (!trovato) continue;
                        this.pd.setMessage("La password scelta non deve corrispondere ad una precedente password");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (DriverControlStationException | DriverUsersDBException e) {
            this.log.error("Exception: " + ((Throwable)e).getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String incapsulaValoreStato(String valoreStato) {
        if (valoreStato != null) {
            valoreStato = "{" + (String)valoreStato + "}";
        }
        return valoreStato;
    }

    public String extractValoreStato(String valoreStato) {
        if (valoreStato != null) {
            if (valoreStato.startsWith("{")) {
                valoreStato = valoreStato.substring(1);
            }
            if (valoreStato.endsWith("}")) {
                valoreStato = valoreStato.substring(0, valoreStato.length() - 1);
            }
        }
        return valoreStato;
    }
}

