/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.allarmi.bean;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.monitor.sdk.condition.AlarmContext;
import org.openspcoop2.monitor.sdk.constants.CRUDType;
import org.openspcoop2.monitor.sdk.constants.SearchType;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.web.monitor.allarmi.dao.AllarmiRuntimeException;
import org.openspcoop2.web.monitor.allarmi.mbean.AllarmiBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class AllarmiContext
implements AlarmContext {
    private AllarmiBean allarmiBean = null;
    private TipiDatabase tipoDatabase = null;

    public AllarmiContext(AllarmiBean allarmiBean) {
        this.allarmiBean = allarmiBean;
    }

    public SearchType getTipoRicerca() {
        return SearchType.ALL;
    }

    public Date getIntervalloInferiore() {
        return null;
    }

    public Date getIntervalloSuperiore() {
        return null;
    }

    public String getTipoSoggettoMittente() {
        String tipoNome = this.allarmiBean.getTipoNomeMittenteFiltro();
        if (tipoNome != null && tipoNome.contains("/")) {
            return tipoNome.split("/")[0];
        }
        return null;
    }

    public String getSoggettoMittente() {
        String tipoNome = this.allarmiBean.getTipoNomeMittenteFiltro();
        if (tipoNome != null && tipoNome.contains("/")) {
            return tipoNome.split("/")[1];
        }
        return null;
    }

    public String getTipoSoggettoDestinatario() {
        String tipoNome = this.allarmiBean.getTipoNomeDestinatarioFiltro();
        if (tipoNome != null && tipoNome.contains("/")) {
            return tipoNome.split("/")[0];
        }
        return null;
    }

    public String getSoggettoDestinatario() {
        String tipoNome = this.allarmiBean.getTipoNomeDestinatarioFiltro();
        if (tipoNome != null && tipoNome.contains("/")) {
            return tipoNome.split("/")[1];
        }
        return null;
    }

    public String getTipoServizio() {
        String tipoNome = this.allarmiBean.getTipoNomeServizioFiltro();
        if (tipoNome != null && tipoNome.contains("/")) {
            return tipoNome.split("/")[0];
        }
        return null;
    }

    public String getServizio() {
        String tipoNome = this.allarmiBean.getTipoNomeServizioFiltro();
        if (tipoNome != null && tipoNome.contains("/")) {
            return tipoNome.split("/")[1];
        }
        return null;
    }

    public Integer getVersioneServizio() {
        String tipoNome = this.allarmiBean.getTipoNomeServizioFiltro();
        if (tipoNome != null && tipoNome.contains("/")) {
            return Integer.valueOf(tipoNome.split("/")[2]);
        }
        return null;
    }

    public String getAzione() {
        return this.allarmiBean.getAzioneFiltro();
    }

    public String getInterfaccia() {
        if (this.allarmiBean != null && this.allarmiBean.getAllarme() != null && this.allarmiBean.getAllarme().getFiltro() != null && StringUtils.isNotEmpty((String)this.allarmiBean.getAllarme().getFiltro().getNomePorta()) && !"*".equals(this.allarmiBean.getAllarme().getFiltro().getNomePorta())) {
            return this.allarmiBean.getAllarme().getFiltro().getNomePorta();
        }
        return null;
    }

    public TipoPdD getRuolo() {
        if (this.allarmiBean != null && this.allarmiBean.getAllarme() != null && this.allarmiBean.getAllarme().getFiltro() != null && this.allarmiBean.getAllarme().getFiltro().getRuoloPorta() != null) {
            switch (this.allarmiBean.getAllarme().getFiltro().getRuoloPorta()) {
                case DELEGATA: {
                    return TipoPdD.DELEGATA;
                }
                case APPLICATIVA: {
                    return TipoPdD.APPLICATIVA;
                }
            }
            return null;
        }
        return null;
    }

    public EsitoTransazione getEsitoTransazione() {
        return null;
    }

    public Parameter<?> getParameter(String paramID) {
        return this.getParameters().get(paramID);
    }

    public Map<String, Parameter<?>> getParameters() {
        List<Parameter<?>> parameters = this.allarmiBean.getParameters();
        HashMap map = new HashMap();
        if (parameters != null) {
            for (Parameter<?> param : parameters) {
                map.put(param.getId(), param);
            }
        }
        return map;
    }

    public TipiDatabase getDatabaseType() {
        return this.getTipoDatabase((IProjectInfo)ProjectInfo.getInstance());
    }

    public TipiDatabase getTipoDatabase(IProjectInfo projectInfo) {
        if (this.tipoDatabase == null) {
            try {
                PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance((Logger)this.getLogger());
                this.tipoDatabase = pddMonitorProperties.tipoDatabase(projectInfo);
            }
            catch (Exception e) {
                this.getLogger().error("Errore la get Tipo Database: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.tipoDatabase;
    }

    public Logger getLogger() {
        return LoggerManager.getPddMonitorCoreLogger();
    }

    public DAOFactory getDAOFactory() {
        try {
            return DAOFactory.getInstance((Logger)LoggerManager.getPddMonitorSqlLogger());
        }
        catch (Exception e) {
            throw new AllarmiRuntimeException(e.getMessage(), e);
        }
    }

    public CRUDType getTipoOperazione() {
        if (this.allarmiBean != null && this.allarmiBean.getAllarme() != null && this.allarmiBean.getAllarme().getId() != null && this.allarmiBean.getAllarme().getId() > 0L) {
            return CRUDType.UPDATE;
        }
        return CRUDType.CREATE;
    }

    public void setShowFilter(boolean filter) {
        if (this.allarmiBean != null) {
            this.allarmiBean.setShowFilter(filter);
        }
    }

    public Allarme getConfigAllarme() {
        if (this.allarmiBean != null) {
            return this.allarmiBean.getAllarme();
        }
        return null;
    }
}

