/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.allarmi.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.dao.IAllarmeHistoryService;
import org.openspcoop2.core.allarmi.dao.IAllarmeHistoryServiceSearch;
import org.openspcoop2.core.allarmi.dao.IAllarmeService;
import org.openspcoop2.core.allarmi.dao.IAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.IDBAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.IServiceManager;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeHistoryServiceSearch;
import org.openspcoop2.core.allarmi.utils.ProjectInfo;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.dao.IPortaApplicativaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaDelegataServiceSearch;
import org.openspcoop2.core.commons.search.model.PortaApplicativaModel;
import org.openspcoop2.core.commons.search.model.PortaDelegataModel;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.dao.IServiceSearchWithId;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.monitor.engine.alarm.AlarmManager;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeHistoryBean;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.exceptions.AlarmException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.plugins.DialogInfo;
import org.openspcoop2.monitor.sdk.plugins.IAlarmProcessing;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.web.monitor.allarmi.bean.AllarmiSearchForm;
import org.openspcoop2.web.monitor.allarmi.dao.AllarmiDriverParams;
import org.openspcoop2.web.monitor.allarmi.dao.IAllarmiService;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsServiceEngine;
import org.openspcoop2.web.monitor.core.dynamic.DynamicComponentUtils;
import org.openspcoop2.web.monitor.core.dynamic.components.BaseComponent;
import org.openspcoop2.web.monitor.core.exception.UserInvalidException;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.DynamicPdDBeanUtils;
import org.openspcoop2.web.monitor.core.utils.ParseUtility;
import org.slf4j.Logger;

public class AllarmiService
implements IAllarmiService {
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private int lIMIT_SEARCH = 10000;
    private static final String TIPOLOGIA_SOLO_ASSOCIATE = "SOLO_ASSOCIATE";
    private IServiceManager pluginsServiceManager;
    private DriverRegistroServiziDB driverRegistroDB = null;
    private DriverConfigurazioneDB driverConfigDB = null;
    private IAllarmeService allarmeDAO;
    private IAllarmeServiceSearch allarmeSearchDAO;
    private IAllarmeHistoryServiceSearch allarmeHistorySearchDAO;
    private IAllarmeHistoryService allarmeHistoryDAO;
    private org.openspcoop2.core.plugins.dao.IServiceManager pluginsBaseServiceManager;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsServiceManager;
    protected DynamicPdDBeanUtils dynamicUtils = null;
    private IPortaDelegataServiceSearch portaDelegataDAO = null;
    private IPortaApplicativaServiceSearch portaApplicativaDAO = null;
    private AllarmiSearchForm searchForm;
    private static final boolean USE_DRIVER_CONFIG = true;

    public AllarmiService() {
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.pluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            this.allarmeDAO = this.pluginsServiceManager.getAllarmeService();
            this.allarmeSearchDAO = this.pluginsServiceManager.getAllarmeServiceSearch();
            this.allarmeHistorySearchDAO = this.pluginsServiceManager.getAllarmeHistoryServiceSearch();
            this.allarmeHistoryDAO = this.pluginsServiceManager.getAllarmeHistoryService();
            this.pluginsBaseServiceManager = (org.openspcoop2.core.plugins.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), log);
            this.lIMIT_SEARCH = pddMonitorProperties.getSearchFormLimit();
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log);
            this.portaApplicativaDAO = this.utilsServiceManager.getPortaApplicativaServiceSearch();
            this.portaDelegataDAO = this.utilsServiceManager.getPortaDelegataServiceSearch();
            String tipoDatabase = DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            String datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIName((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            Properties datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIContext((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverRegistroDB = new DriverRegistroServiziDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
            this.driverConfigDB = new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase);
            this.dynamicUtils = new DynamicPdDBeanUtils(this.utilsServiceManager, this.pluginsBaseServiceManager, this.driverRegistroDB, this.driverConfigDB, log);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public AllarmiSearchForm getSearch() {
        return this.searchForm;
    }

    public void setSearch(AllarmiSearchForm search) {
        this.searchForm = search;
    }

    private AllarmiDriverParams buildDriverParams(AllarmiSearchForm search) throws Exception {
        AllarmiDriverParams driverParams = new AllarmiDriverParams();
        String tipologiaRicerca = search.getTipologiaAllarme();
        driverParams.setTipologiaRicerca(tipologiaRicerca);
        Boolean enabledParam = null;
        StatoAllarme statoParam = null;
        Boolean acknowledgedParam = null;
        if (StringUtils.isNotEmpty((String)search.getStatoSelezionato()) && !StringUtils.equals((String)search.getStatoSelezionato(), (String)"Qualsiasi")) {
            if (StringUtils.equals((String)search.getStatoSelezionato(), (String)"Disabilitato")) {
                enabledParam = false;
            } else {
                enabledParam = true;
                if (!StringUtils.equals((String)search.getStatoSelezionato(), (String)"Non Disabilitato")) {
                    String statoCheck = search.getStatoSelezionato();
                    if ("Ok".equals(statoCheck)) {
                        statoParam = StatoAllarme.OK;
                    }
                    if ("Warn".equals(statoCheck)) {
                        statoParam = StatoAllarme.WARNING;
                    }
                    if ("Warn (Acknowledged)".equals(statoCheck)) {
                        statoParam = StatoAllarme.WARNING;
                        acknowledgedParam = true;
                    }
                    if ("Warn (Unacknowledged)".equals(statoCheck)) {
                        statoParam = StatoAllarme.WARNING;
                        acknowledgedParam = false;
                    }
                    if ("Error".equals(statoCheck)) {
                        statoParam = StatoAllarme.ERROR;
                    }
                    if ("Error (Acknowledged)".equals(statoCheck)) {
                        statoParam = StatoAllarme.ERROR;
                        acknowledgedParam = true;
                    }
                    if ("Error (Unacknowledged)".equals(statoCheck)) {
                        statoParam = StatoAllarme.ERROR;
                        acknowledgedParam = false;
                    }
                }
            }
        }
        driverParams.setEnabled(enabledParam);
        driverParams.setStato(statoParam);
        driverParams.setAcknowledged(acknowledgedParam);
        String nomeAllarme = null;
        if (StringUtils.isNotEmpty((String)search.getNomeAllarme())) {
            nomeAllarme = search.getNomeAllarme();
        }
        driverParams.setNomeAllarme(nomeAllarme);
        List listSoggettiProprietariAbilitati = null;
        List listIDServizioAbilitati = null;
        if (search.getPermessiUtenteOperatore() != null) {
            if (search.getPermessiUtenteOperatore().getListIDSoggetti() != null && !search.getPermessiUtenteOperatore().getListIDSoggetti().isEmpty()) {
                listSoggettiProprietariAbilitati = search.getPermessiUtenteOperatore().getListIDSoggetti();
            }
            if (search.getPermessiUtenteOperatore().getListIDServizi() != null && !search.getPermessiUtenteOperatore().getListIDServizi().isEmpty()) {
                listIDServizioAbilitati = search.getPermessiUtenteOperatore().getListIDServizi();
            }
        }
        driverParams.setListSoggettiProprietariAbilitati(listSoggettiProprietariAbilitati);
        driverParams.setListIDServizioAbilitati(listIDServizioAbilitati);
        List tipoSoggettiByProtocollo = null;
        ArrayList tipoServiziByProtocollo = null;
        String protocollo = null;
        if (search.isSetFiltroProtocollo() && StringUtils.isNotEmpty((String)(protocollo = search.getProtocollo()))) {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            IProtocolConfiguration pConfig = protocolFactory.createProtocolConfiguration();
            tipoSoggettiByProtocollo = pConfig.getTipiSoggetti();
            tipoServiziByProtocollo = new ArrayList();
            tipoServiziByProtocollo.addAll(pConfig.getTipiServizi(ServiceBinding.SOAP));
            tipoServiziByProtocollo.addAll(pConfig.getTipiServizi(ServiceBinding.REST));
        }
        driverParams.setTipoSoggettiByProtocollo(tipoSoggettiByProtocollo);
        driverParams.setTipoServiziByProtocollo(tipoServiziByProtocollo);
        IDSoggetto idSoggettoProprietario = null;
        if (search.getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)search.getTipoNomeSoggettoLocale()) && !"--".equals(search.getTipoNomeSoggettoLocale())) {
            String tipoSoggetto = search.getTipoSoggettoLocale();
            String nomeSoggetto = search.getSoggettoLocale();
            if (tipoSoggetto != null && !"qualsiasi".equals(tipoSoggetto) && nomeSoggetto != null && !"qualsiasi".equals(nomeSoggetto)) {
                idSoggettoProprietario = new IDSoggetto(tipoSoggetto, nomeSoggetto);
            }
        }
        driverParams.setIdSoggettoProprietario(idSoggettoProprietario);
        String gruppo = search.getGruppo();
        String tipoProtocollo = search.getProtocollo();
        String tipoSoggetto = search.getTipoSoggettoLocale();
        String nomeSoggetto = search.getSoggettoLocale();
        String input = null;
        boolean apiImplSelected = StringUtils.isNotBlank((String)search.getNomeServizio());
        IDAccordo idAccordo = null;
        IDAccordoFactory idAccordoFactory = null;
        String api = search.getApi();
        if (!apiImplSelected && api != null && !"".equals(api)) {
            idAccordoFactory = IDAccordoFactory.getInstance();
            idAccordo = idAccordoFactory.getIDAccordoFromUri(api);
        }
        ArrayList<IDServizio> listIDServizio = null;
        if (!apiImplSelected && (gruppo != null && !"".equals(gruppo) || idAccordo != null)) {
            listIDServizio = new ArrayList();
            List list = null;
            boolean distinct = true;
            list = PddRuolo.DELEGATA.equals(search.getTipologiaAllarme()) ? this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, null, null, input, false, search.getPermessiUtenteOperatore(), distinct) : this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, input, true, search.getPermessiUtenteOperatore(), distinct);
            if (list != null && list.size() > 0) {
                for (SelectItem selectItem : list) {
                    String servizioString = (String)selectItem.getValue();
                    IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
                    listIDServizio.add(idServizio);
                }
            } else {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues("-", "-", "-", "-", -1);
                listIDServizio.add(idServizio);
            }
        }
        if (apiImplSelected) {
            listIDServizio = new ArrayList<IDServizio>();
            String servizioString = search.getNomeServizio();
            IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
            listIDServizio.add(idServizio);
        }
        driverParams.setListIDServizio(listIDServizio);
        return driverParams;
    }

    @Override
    public Long getCountAllarmiByStato(String stato, Integer acknowledged) {
        Long retValue = 0L;
        try {
            AllarmiSearchForm search = new AllarmiSearchForm();
            if (Utility.isAmministratore()) {
                search.ripulisci();
                search.setTipologiaAllarme("*");
            } else {
                search.ripulisci();
                search.setTipologiaAllarme(TIPOLOGIA_SOLO_ASSOCIATE);
            }
            search.setStatoSelezionato(stato);
            AllarmiDriverParams params = this.buildDriverParams(search);
            String tipologiaRicerca = params.getTipologiaRicerca();
            Boolean enabledParam = params.getEnabled();
            StatoAllarme statoParam = params.getStato();
            Boolean acknowledgedParam = params.getAcknowledged();
            String nomeAllarme = params.getNomeAllarme();
            List<IDSoggetto> listSoggettiProprietariAbilitati = params.getListSoggettiProprietariAbilitati();
            List<IDServizio> listIDServizioAbilitati = params.getListIDServizioAbilitati();
            List<String> tipoSoggettiByProtocollo = params.getTipoSoggettiByProtocollo();
            List<String> tipoServiziByProtocollo = params.getTipoServiziByProtocollo();
            IDSoggetto idSoggettoProprietario = params.getIdSoggettoProprietario();
            List<IDServizio> listIDServizio = params.getListIDServizio();
            if (acknowledged != null) {
                acknowledgedParam = acknowledged == 1;
            }
            retValue = this.driverConfigDB.countAllarmi(tipologiaRicerca, enabledParam, statoParam, acknowledgedParam, nomeAllarme, listSoggettiProprietariAbilitati, listIDServizioAbilitati, tipoSoggettiByProtocollo, tipoServiziByProtocollo, idSoggettoProprietario, listIDServizio);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (CloneNotSupportedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return retValue;
    }

    public List<ConfigurazioneAllarmeBean> findAll(int start, int limit) {
        if (this.searchForm == null) {
            return new ArrayList<ConfigurazioneAllarmeBean>();
        }
        try {
            List findAll = null;
            AllarmiDriverParams params = this.buildDriverParams(this.searchForm);
            String tipologiaRicerca = params.getTipologiaRicerca();
            Boolean enabledParam = params.getEnabled();
            StatoAllarme statoParam = params.getStato();
            Boolean acknowledgedParam = params.getAcknowledged();
            String nomeAllarme = params.getNomeAllarme();
            List<IDSoggetto> listSoggettiProprietariAbilitati = params.getListSoggettiProprietariAbilitati();
            List<IDServizio> listIDServizioAbilitati = params.getListIDServizioAbilitati();
            List<String> tipoSoggettiByProtocollo = params.getTipoSoggettiByProtocollo();
            List<String> tipoServiziByProtocollo = params.getTipoServiziByProtocollo();
            IDSoggetto idSoggettoProprietario = params.getIdSoggettoProprietario();
            List<IDServizio> listIDServizio = params.getListIDServizio();
            findAll = this.driverConfigDB.findAllAllarmi(tipologiaRicerca, enabledParam, statoParam, acknowledgedParam, nomeAllarme, listSoggettiProprietariAbilitati, listIDServizioAbilitati, tipoSoggettiByProtocollo, tipoServiziByProtocollo, idSoggettoProprietario, listIDServizio, Integer.valueOf(start), Integer.valueOf(limit));
            if (findAll != null && findAll.size() > 0) {
                ArrayList<ConfigurazioneAllarmeBean> toRet = new ArrayList<ConfigurazioneAllarmeBean>();
                boolean existsAlmostOneManuallyUpdateState = false;
                boolean existsAlmostOneManuallyAckCriteria = false;
                for (Allarme al : findAll) {
                    IdPlugin idPlugin = new IdPlugin();
                    idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
                    idPlugin.setTipo(al.getTipo());
                    Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
                    ConfigurazioneAllarmeBean allarmeBean = new ConfigurazioneAllarmeBean(al, plugin);
                    this.valorizzaDettaglioAPI(allarmeBean);
                    if (allarmeBean.isManuallyUpdateState()) {
                        existsAlmostOneManuallyUpdateState = true;
                    }
                    if (allarmeBean.isManuallyAckCriteria()) {
                        existsAlmostOneManuallyAckCriteria = true;
                    }
                    toRet.add(allarmeBean);
                }
                for (ConfigurazioneAllarmeBean allarmeBean : toRet) {
                    allarmeBean.setExistsAlmostOneManuallyUpdateState(existsAlmostOneManuallyUpdateState);
                    allarmeBean.setExistsAlmostOneManuallyAckCriteria(existsAlmostOneManuallyAckCriteria);
                }
                return toRet;
            }
        }
        catch (ServiceException e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        catch (NotImplementedException e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        catch (ExpressionNotImplementedException e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        catch (ExpressionException e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        catch (Exception e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        return new ArrayList<ConfigurazioneAllarmeBean>();
    }

    private void valorizzaDettaglioAPI(ConfigurazioneAllarmeBean allarmeBean) throws DriverRegistroServiziException, Exception {
        if (!allarmeBean.isAllarmeConfigurazione()) {
            String nomePorta = allarmeBean.getFiltro().getNomePorta();
            Object labelServizio = null;
            String erogatore = null;
            String fruitore = null;
            String tipoProtocollo = allarmeBean.getFiltro().getProtocollo();
            if (allarmeBean.isRuoloPortaDelegata()) {
                PortaDelegata portaDelegata = this.dynamicUtils.getPortaDelegata(nomePorta);
                labelServizio = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)tipoProtocollo, (String)portaDelegata.getTipoServizio(), (String)portaDelegata.getNomeServizio(), (Integer)portaDelegata.getVersioneServizio());
                erogatore = NamingUtils.getLabelSoggetto((String)tipoProtocollo, (String)portaDelegata.getTipoSoggettoErogatore(), (String)portaDelegata.getNomeSoggettoErogatore());
                fruitore = NamingUtils.getLabelSoggetto((String)tipoProtocollo, (String)portaDelegata.getIdSoggetto().getTipo(), (String)portaDelegata.getIdSoggetto().getNome());
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore(), portaDelegata.getVersioneServizio().intValue());
                IDSoggetto idFruitore = new IDSoggetto(portaDelegata.getIdSoggetto().getTipo(), portaDelegata.getIdSoggetto().getNome());
                IDPortaDelegata idPortaDelegata = new IDPortaDelegata();
                idPortaDelegata.setNome(portaDelegata.getNome());
                MappingFruizionePortaDelegata mapping = this.dynamicUtils.getMappingFruizione(idServizio, idFruitore, idPortaDelegata);
                if (mapping != null && !mapping.isDefault()) {
                    labelServizio = (String)labelServizio + " (gruppo: " + mapping.getDescrizione() + ")";
                }
            } else if (allarmeBean.isRuoloPortaApplicativa()) {
                PortaApplicativa portaApplicativa = this.dynamicUtils.getPortaApplicativa(nomePorta);
                labelServizio = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)allarmeBean.getFiltro().getProtocollo(), (String)portaApplicativa.getTipoServizio(), (String)portaApplicativa.getNomeServizio(), (Integer)portaApplicativa.getVersioneServizio());
                erogatore = NamingUtils.getLabelSoggetto((String)tipoProtocollo, (String)portaApplicativa.getIdSoggetto().getTipo(), (String)portaApplicativa.getIdSoggetto().getNome());
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome(), portaApplicativa.getVersioneServizio().intValue());
                IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                idPortaApplicativa.setNome(portaApplicativa.getNome());
                MappingErogazionePortaApplicativa mapping = this.dynamicUtils.getMappingErogazione(idServizio, idPortaApplicativa);
                if (mapping != null && !mapping.isDefault()) {
                    labelServizio = (String)labelServizio + " (gruppo: " + mapping.getDescrizione() + ")";
                }
            }
            allarmeBean.setDettaglioAPI(labelServizio);
            allarmeBean.setDettaglioFruitore(fruitore);
            allarmeBean.setDettaglioErogatore(erogatore);
        }
    }

    public int totalCount() {
        if (this.searchForm == null) {
            return 0;
        }
        try {
            AllarmiDriverParams params = this.buildDriverParams(this.searchForm);
            String tipologiaRicerca = params.getTipologiaRicerca();
            Boolean enabledParam = params.getEnabled();
            StatoAllarme statoParam = params.getStato();
            Boolean acknowledgedParam = params.getAcknowledged();
            String nomeAllarme = params.getNomeAllarme();
            List<IDSoggetto> listSoggettiProprietariAbilitati = params.getListSoggettiProprietariAbilitati();
            List<IDServizio> listIDServizioAbilitati = params.getListIDServizioAbilitati();
            List<String> tipoSoggettiByProtocollo = params.getTipoSoggettiByProtocollo();
            List<String> tipoServiziByProtocollo = params.getTipoServiziByProtocollo();
            IDSoggetto idSoggettoProprietario = params.getIdSoggettoProprietario();
            List<IDServizio> listIDServizio = params.getListIDServizio();
            long retValue = this.driverConfigDB.countAllarmi(tipologiaRicerca, enabledParam, statoParam, acknowledgedParam, nomeAllarme, listSoggettiProprietariAbilitati, listIDServizioAbilitati, tipoSoggettiByProtocollo, tipoServiziByProtocollo, idSoggettoProprietario, listIDServizio);
            return (int)retValue;
        }
        catch (ServiceException e1) {
            log.error("Errore durante il calcolo del numero dei record", (Throwable)e1);
        }
        catch (NotImplementedException e1) {
            log.error("Errore durante il calcolo del numero dei record", (Throwable)e1);
        }
        catch (Exception e1) {
            log.error("Errore durante il calcolo del numero dei record", (Throwable)e1);
        }
        return 0;
    }

    public void delete(ConfigurazioneAllarmeBean obj) {
        try {
            this.allarmeDAO.delete((Object)obj);
        }
        catch (ServiceException e) {
            log.error("Errore durante la rimozione dell'Allarme con id:" + obj.getId(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error("Errore durante la rimozione dell'Allarme con id:" + obj.getId(), (Throwable)e);
        }
    }

    public void deleteById(Long key) {
        IdAllarme idConfigurazioneAllarme = new IdAllarme();
        idConfigurazioneAllarme.setId(key);
        try {
            this.allarmeDAO.deleteById((Object)idConfigurazioneAllarme);
        }
        catch (ServiceException e) {
            log.error("Errore durante la rimozione dell'Allarme con id:" + key, (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error("Errore durante la rimozione dell'Allarme con id:" + key, (Throwable)e);
        }
    }

    public List<ConfigurazioneAllarmeBean> findAll() {
        if (this.searchForm == null) {
            return new ArrayList<ConfigurazioneAllarmeBean>();
        }
        try {
            List findAll = null;
            AllarmiDriverParams params = this.buildDriverParams(this.searchForm);
            String tipologiaRicerca = params.getTipologiaRicerca();
            Boolean enabledParam = params.getEnabled();
            StatoAllarme statoParam = params.getStato();
            Boolean acknowledgedParam = params.getAcknowledged();
            String nomeAllarme = params.getNomeAllarme();
            List<IDSoggetto> listSoggettiProprietariAbilitati = params.getListSoggettiProprietariAbilitati();
            List<IDServizio> listIDServizioAbilitati = params.getListIDServizioAbilitati();
            List<String> tipoSoggettiByProtocollo = params.getTipoSoggettiByProtocollo();
            List<String> tipoServiziByProtocollo = params.getTipoServiziByProtocollo();
            IDSoggetto idSoggettoProprietario = params.getIdSoggettoProprietario();
            List<IDServizio> listIDServizio = params.getListIDServizio();
            findAll = this.driverConfigDB.findAllAllarmi(tipologiaRicerca, enabledParam, statoParam, acknowledgedParam, nomeAllarme, listSoggettiProprietariAbilitati, listIDServizioAbilitati, tipoSoggettiByProtocollo, tipoServiziByProtocollo, idSoggettoProprietario, listIDServizio, null, null);
            if (findAll != null && findAll.size() > 0) {
                ArrayList<ConfigurazioneAllarmeBean> toRet = new ArrayList<ConfigurazioneAllarmeBean>();
                for (Allarme al : findAll) {
                    IdPlugin idPlugin = new IdPlugin();
                    idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
                    idPlugin.setTipo(al.getTipo());
                    Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
                    ConfigurazioneAllarmeBean allarmeBean = new ConfigurazioneAllarmeBean(al, plugin);
                    this.valorizzaDettaglioAPI(allarmeBean);
                    toRet.add(allarmeBean);
                }
                return toRet;
            }
        }
        catch (ServiceException e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        catch (NotImplementedException e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        catch (Exception e1) {
            log.error("Errore durante la ricerca degli Allarmi", (Throwable)e1);
        }
        return new ArrayList<ConfigurazioneAllarmeBean>();
    }

    public ConfigurazioneAllarmeBean findById(Long key) {
        IdAllarme idAllarme = new IdAllarme();
        idAllarme.setId(key);
        IDBAllarmeServiceSearch idSearch = (IDBAllarmeServiceSearch)this.allarmeSearchDAO;
        try {
            Allarme configurazioneAllarme = (Allarme)idSearch.get((Object)idAllarme);
            if (configurazioneAllarme != null) {
                IdPlugin idPlugin = new IdPlugin();
                idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
                idPlugin.setTipo(configurazioneAllarme.getTipo());
                Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
                ConfigurazioneAllarmeBean allarmeBean = new ConfigurazioneAllarmeBean(configurazioneAllarme, plugin);
                this.valorizzaDettaglioAPI(allarmeBean);
                return allarmeBean;
            }
        }
        catch (ServiceException e) {
            log.error("Errore durante la ricerca dell'Allarme con id:" + key, (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug("Errore durante la ricerca dell'Allarme con id:" + key, (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error("Errore durante la ricerca dell'Allarme con id:" + key, (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error("Errore durante la ricerca dell'Allarme con id:" + key, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Errore durante la ricerca dell'Allarme con id:" + key, (Throwable)e);
        }
        return null;
    }

    public void store(ConfigurazioneAllarmeBean allarme) throws Exception {
        IdAllarme idAll = new IdAllarme();
        idAll.setNome(allarme.getNome());
        if (!this.allarmeDAO.exists((Object)idAll)) {
            throw new Exception("Allarme con id '" + allarme.getNome() + "' non esistente");
        }
        this.allarmeDAO.update((Object)idAll, (Object)allarme);
    }

    private IExpression createQuery(boolean isCount, AllarmiSearchForm formRicerca) throws Exception {
        IExpression expr = null;
        try {
            IExpression exprNomePorta;
            ArrayList<IExpression> exprOrList;
            expr = this.allarmeSearchDAO.newExpression();
            String gruppo = formRicerca.getGruppo();
            String tipoProtocollo = formRicerca.getProtocollo();
            String tipoSoggetto = formRicerca.getTipoSoggettoLocale();
            String nomeSoggetto = formRicerca.getSoggettoLocale();
            String input = null;
            boolean apiImplSelected = StringUtils.isNotBlank((String)formRicerca.getNomeServizio());
            IDAccordo idAccordo = null;
            IDAccordoFactory idAccordoFactory = null;
            String api = formRicerca.getApi();
            if (!apiImplSelected && api != null && !"".equals(api)) {
                idAccordoFactory = IDAccordoFactory.getInstance();
                idAccordo = idAccordoFactory.getIDAccordoFromUri(api);
            }
            ArrayList<IDServizio> listIDServizio = null;
            if (!apiImplSelected && (gruppo != null && !"".equals(gruppo) || idAccordo != null)) {
                listIDServizio = new ArrayList<IDServizio>();
                List list = null;
                boolean distinct = true;
                list = PddRuolo.DELEGATA.equals(formRicerca.getTipologiaAllarme()) ? this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziFruizione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, null, null, input, false, formRicerca.getPermessiUtenteOperatore(), distinct) : this.dynamicUtils.getListaSelectItemsElencoConfigurazioneServiziErogazione(tipoProtocollo, gruppo, idAccordo, tipoSoggetto, nomeSoggetto, input, true, formRicerca.getPermessiUtenteOperatore(), distinct);
                if (list != null && list.size() > 0) {
                    for (SelectItem selectItem : list) {
                        String string = (String)selectItem.getValue();
                        IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)string);
                        listIDServizio.add(idServizio);
                    }
                } else {
                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues("-", "-", "-", "-", -1);
                    listIDServizio.add(idServizio);
                }
            }
            boolean addAnd = false;
            if (formRicerca.getTipologiaAllarme().equals("configurazione")) {
                expr.isNull(Allarme.model().FILTRO.NOME_PORTA);
                addAnd = true;
            } else if (formRicerca.getTipologiaAllarme().equals(AllarmiSearchForm.TIPOLOGIA_APPLICATIVA)) {
                List<PortaApplicativa> findAll = this.estraiPAAssociate(formRicerca, apiImplSelected, listIDServizio);
                exprOrList = new ArrayList<IExpression>();
                for (PortaApplicativa portaApplicativa : findAll) {
                    exprNomePorta = this.allarmeSearchDAO.newExpression();
                    exprNomePorta.equals(Allarme.model().FILTRO.NOME_PORTA, (Object)portaApplicativa.getNome());
                    exprOrList.add(exprNomePorta);
                }
                expr.or(exprOrList.toArray(new IExpression[1]));
                expr.isNotNull(Allarme.model().FILTRO.NOME_PORTA).and().equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)RuoloPorta.APPLICATIVA.getValue());
                addAnd = true;
            } else if (formRicerca.getTipologiaAllarme().equals(AllarmiSearchForm.TIPOLOGIA_DELEGATA)) {
                List<PortaDelegata> findAll = this.estraiPDAssociate(formRicerca, apiImplSelected, listIDServizio);
                exprOrList = new ArrayList();
                for (PortaDelegata portaDelegata : findAll) {
                    exprNomePorta = this.allarmeSearchDAO.newExpression();
                    exprNomePorta.equals(Allarme.model().FILTRO.NOME_PORTA, (Object)portaDelegata.getNome());
                    exprOrList.add(exprNomePorta);
                }
                expr.or(exprOrList.toArray(new IExpression[1]));
                expr.isNotNull(Allarme.model().FILTRO.NOME_PORTA).and().equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)RuoloPorta.DELEGATA.getValue());
                addAnd = true;
            } else if (formRicerca.getTipologiaAllarme().equals(TIPOLOGIA_SOLO_ASSOCIATE)) {
                List<PortaApplicativa> findAllPA = this.estraiPAAssociate(formRicerca, apiImplSelected, listIDServizio);
                List<PortaDelegata> findAllPD = this.estraiPDAssociate(formRicerca, apiImplSelected, listIDServizio);
                ArrayList<IExpression> exprOrListPA = new ArrayList<IExpression>();
                for (PortaApplicativa portaApplicativa : findAllPA) {
                    IExpression exprNomePorta2 = this.allarmeSearchDAO.newExpression();
                    exprNomePorta2.equals(Allarme.model().FILTRO.NOME_PORTA, (Object)portaApplicativa.getNome());
                    exprOrListPA.add(exprNomePorta2);
                }
                IExpression iExpression = this.allarmeSearchDAO.newExpression();
                iExpression.equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)RuoloPorta.APPLICATIVA.getValue());
                iExpression.and().or(exprOrListPA.toArray(new IExpression[1]));
                ArrayList<IExpression> exprOrListPD = new ArrayList<IExpression>();
                for (PortaDelegata portaDelegata : findAllPD) {
                    IExpression exprNomePorta3 = this.allarmeSearchDAO.newExpression();
                    exprNomePorta3.equals(Allarme.model().FILTRO.NOME_PORTA, (Object)portaDelegata.getNome());
                    exprOrListPD.add(exprNomePorta3);
                }
                IExpression exprRuoloPortaPD = this.allarmeSearchDAO.newExpression();
                exprRuoloPortaPD.equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)RuoloPorta.DELEGATA.getValue());
                exprRuoloPortaPD.and().or(exprOrListPD.toArray(new IExpression[1]));
                IExpression exprPortOr = this.allarmeSearchDAO.newExpression();
                exprPortOr.or();
                exprPortOr.or(iExpression, exprRuoloPortaPD);
                expr.and(new IExpression[]{exprPortOr});
                expr.and().isNotNull(Allarme.model().FILTRO.NOME_PORTA).and();
            }
            if (StringUtils.isNotEmpty((String)formRicerca.getNomeAllarme())) {
                if (addAnd) {
                    expr.and();
                }
                expr.ilike(Allarme.model().ALIAS, formRicerca.getNomeAllarme(), LikeMode.ANYWHERE);
                addAnd = true;
            }
            if (StringUtils.isNotEmpty((String)formRicerca.getStatoSelezionato()) && !StringUtils.equals((String)formRicerca.getStatoSelezionato(), (String)"Qualsiasi")) {
                if (addAnd) {
                    expr.and();
                }
                if (StringUtils.equals((String)formRicerca.getStatoSelezionato(), (String)"Disabilitato")) {
                    expr.equals(Allarme.model().ENABLED, (Object)0);
                } else {
                    expr.equals(Allarme.model().ENABLED, (Object)1).and();
                    if (StringUtils.equals((String)formRicerca.getStatoSelezionato(), (String)"Non Disabilitato")) {
                        expr.in(Allarme.model().STATO, new Object[]{0, 1, 2});
                    } else {
                        String stato = formRicerca.getStatoSelezionato();
                        if ("Ok".equals(stato)) {
                            expr.equals(Allarme.model().STATO, (Object)0);
                        }
                        if ("Warn".equals(stato)) {
                            expr.equals(Allarme.model().STATO, (Object)1);
                        }
                        if ("Warn (Acknowledged)".equals(stato)) {
                            expr.equals(Allarme.model().STATO, (Object)1);
                            expr.equals(Allarme.model().ACKNOWLEDGED, (Object)1);
                        }
                        if ("Warn (Unacknowledged)".equals(stato)) {
                            expr.equals(Allarme.model().STATO, (Object)1);
                            expr.equals(Allarme.model().ACKNOWLEDGED, (Object)0);
                        }
                        if ("Error".equals(stato)) {
                            expr.equals(Allarme.model().STATO, (Object)2);
                        }
                        if ("Error (Acknowledged)".equals(stato)) {
                            expr.equals(Allarme.model().STATO, (Object)2);
                            expr.equals(Allarme.model().ACKNOWLEDGED, (Object)1);
                        }
                        if ("Error (Unacknowledged)".equals(stato)) {
                            expr.equals(Allarme.model().STATO, (Object)2);
                            expr.equals(Allarme.model().ACKNOWLEDGED, (Object)0);
                        }
                    }
                }
                addAnd = true;
            }
            if (!isCount) {
                expr.sortOrder(SortOrder.ASC).addOrder(Allarme.model().ALIAS);
            }
        }
        catch (ServiceException e) {
            log.error("Errore durante la creazione della query di ricerca", (Throwable)e);
            throw e;
        }
        catch (NotImplementedException e) {
            log.error("Errore durante la creazione della query di ricerca", (Throwable)e);
            throw e;
        }
        catch (ExpressionNotImplementedException e) {
            log.error("Errore durante la creazione della query di ricerca", (Throwable)e);
            throw e;
        }
        catch (ExpressionException e) {
            log.error("Errore durante la creazione della query di ricerca", (Throwable)e);
            throw e;
        }
        catch (CoreException e) {
            log.error("Errore durante la creazione della query di ricerca", (Throwable)e);
            throw e;
        }
        return expr;
    }

    private List<PortaDelegata> estraiPDAssociate(AllarmiSearchForm formRicerca, boolean apiImplSelected, List<IDServizio> listIDServizio) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException, CoreException, UserInvalidException {
        IExpression exprPD = this.createPDExpression((IServiceSearchWithId<?, ?>)this.portaDelegataDAO, formRicerca, false);
        IPaginatedExpression pagExpr = this.portaDelegataDAO.toPaginatedExpression(exprPD);
        pagExpr.offset(0).limit(this.lIMIT_SEARCH);
        if (!apiImplSelected && listIDServizio != null && !listIDServizio.isEmpty()) {
            ArrayList<IExpression> exprOrList = new ArrayList<IExpression>();
            for (IDServizio idServizio : listIDServizio) {
                IExpression exprIdServizio = this.portaDelegataDAO.newExpression();
                exprIdServizio.equals(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getTipo());
                exprIdServizio.equals(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getNome());
                exprIdServizio.equals(PortaDelegata.model().TIPO_SERVIZIO, (Object)idServizio.getTipo());
                exprIdServizio.equals(PortaDelegata.model().NOME_SERVIZIO, (Object)idServizio.getNome());
                exprIdServizio.equals(PortaDelegata.model().VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                exprOrList.add(exprIdServizio);
            }
            pagExpr.or(exprOrList.toArray(new IExpression[1]));
        }
        List findAll = this.portaDelegataDAO.findAll(pagExpr);
        return findAll;
    }

    private List<PortaApplicativa> estraiPAAssociate(AllarmiSearchForm formRicerca, boolean apiImplSelected, List<IDServizio> listIDServizio) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException, CoreException, UserInvalidException {
        IExpression exprPA = this.createPAExpression((IServiceSearchWithId<?, ?>)this.portaApplicativaDAO, formRicerca, false);
        IPaginatedExpression pagExpr = this.portaApplicativaDAO.toPaginatedExpression(exprPA);
        pagExpr.offset(0).limit(this.lIMIT_SEARCH);
        if (!apiImplSelected && listIDServizio != null && !listIDServizio.isEmpty()) {
            ArrayList<IExpression> exprOrList = new ArrayList<IExpression>();
            for (IDServizio idServizio : listIDServizio) {
                IExpression exprIdServizio = this.portaApplicativaDAO.newExpression();
                exprIdServizio.equals(PortaApplicativa.model().TIPO_SERVIZIO, (Object)idServizio.getTipo());
                exprIdServizio.equals(PortaApplicativa.model().NOME_SERVIZIO, (Object)idServizio.getNome());
                exprIdServizio.equals(PortaApplicativa.model().VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
                boolean setSoggettoProprietario = false;
                if (formRicerca != null && formRicerca.getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)formRicerca.getTipoNomeSoggettoLocale()) && !"--".equals(formRicerca.getTipoNomeSoggettoLocale())) {
                    setSoggettoProprietario = true;
                }
                if (!setSoggettoProprietario) {
                    exprIdServizio.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)idServizio.getSoggettoErogatore().getTipo());
                    exprIdServizio.equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)idServizio.getSoggettoErogatore().getNome());
                }
                exprOrList.add(exprIdServizio);
            }
            pagExpr.or(exprOrList.toArray(new IExpression[1]));
        }
        List findAll = this.portaApplicativaDAO.findAll(pagExpr);
        return findAll;
    }

    private IExpression createPDExpression(IServiceSearchWithId<?, ?> dao, AllarmiSearchForm searchForm, boolean count) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException, CoreException, UserInvalidException {
        IExpression expr = dao.newExpression();
        if (searchForm == null) {
            return expr;
        }
        expr.and();
        PortaDelegataModel model = PortaDelegata.model();
        expr.isNotNull(model.TIPO_SOGGETTO_EROGATORE);
        expr.isNotNull(model.NOME_SOGGETTO_EROGATORE);
        expr.isNotNull(model.TIPO_SERVIZIO);
        expr.isNotNull(model.NOME_SERVIZIO);
        expr.isNotNull(model.VERSIONE_SERVIZIO);
        if (searchForm.getPermessiUtenteOperatore() != null) {
            IExpression permessi = searchForm.getPermessiUtenteOperatore().toExpressionConfigurazioneServizi(dao, model.ID_SOGGETTO.TIPO, model.ID_SOGGETTO.NOME, model.TIPO_SOGGETTO_EROGATORE, model.NOME_SOGGETTO_EROGATORE, model.TIPO_SERVIZIO, model.NOME_SERVIZIO, model.VERSIONE_SERVIZIO, false);
            expr.and(new IExpression[]{permessi});
        }
        String protocollo = null;
        if (searchForm.isSetFiltroProtocollo()) {
            protocollo = searchForm.getProtocollo();
            this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo);
        }
        if (searchForm.getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)searchForm.getTipoNomeSoggettoLocale()) && !"--".equals(searchForm.getTipoNomeSoggettoLocale())) {
            String tipoSoggettoDestinatario = searchForm.getTipoSoggettoLocale();
            String nomeSoggettoDestinatario = searchForm.getSoggettoLocale();
            if (tipoSoggettoDestinatario != null && !"qualsiasi".equals(tipoSoggettoDestinatario)) {
                expr.equals(model.ID_SOGGETTO.TIPO, (Object)tipoSoggettoDestinatario);
            }
            if (nomeSoggettoDestinatario != null && !"qualsiasi".equals(nomeSoggettoDestinatario)) {
                expr.equals(model.ID_SOGGETTO.NOME, (Object)nomeSoggettoDestinatario);
            }
        }
        if (StringUtils.isNotBlank((String)searchForm.getNomeServizio())) {
            String servizioString = searchForm.getNomeServizio();
            IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
            expr.equals(model.TIPO_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getTipo());
            expr.equals(model.NOME_SOGGETTO_EROGATORE, (Object)idServizio.getSoggettoErogatore().getNome());
            expr.equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo());
            expr.equals(model.NOME_SERVIZIO, (Object)idServizio.getNome());
            expr.equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
        }
        if (!count) {
            expr.sortOrder(SortOrder.ASC);
            expr.addOrder(model.ID_SOGGETTO.TIPO);
            expr.addOrder(model.ID_SOGGETTO.NOME);
            expr.addOrder(model.TIPO_SOGGETTO_EROGATORE);
            expr.addOrder(model.NOME_SOGGETTO_EROGATORE);
            expr.addOrder(model.TIPO_SERVIZIO);
            expr.addOrder(model.NOME_SERVIZIO);
            expr.addOrder(model.VERSIONE_SERVIZIO);
            expr.addOrder(model.NOME_AZIONE);
        }
        return expr;
    }

    private IExpression createPAExpression(IServiceSearchWithId<?, ?> dao, AllarmiSearchForm searchForm, boolean count) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException, CoreException, UserInvalidException {
        IExpression expr = dao.newExpression();
        if (searchForm == null) {
            return expr;
        }
        PortaApplicativaModel model = PortaApplicativa.model();
        expr.isNotNull(model.TIPO_SERVIZIO);
        expr.isNotNull(model.NOME_SERVIZIO);
        expr.isNotNull(model.VERSIONE_SERVIZIO);
        if (searchForm.getPermessiUtenteOperatore() != null) {
            IExpression permessi = searchForm.getPermessiUtenteOperatore().toExpressionConfigurazioneServizi(dao, model.ID_SOGGETTO.TIPO, model.ID_SOGGETTO.NOME, model.ID_SOGGETTO.TIPO, model.ID_SOGGETTO.NOME, model.TIPO_SERVIZIO, model.NOME_SERVIZIO, model.VERSIONE_SERVIZIO, false);
            expr.and(new IExpression[]{permessi});
        }
        String protocollo = null;
        if (searchForm.isSetFiltroProtocollo()) {
            protocollo = searchForm.getProtocollo();
            this.impostaTipiCompatibiliConProtocollo(dao, model, expr, protocollo);
        }
        boolean setSoggettoProprietario = false;
        if (searchForm.getTipoNomeSoggettoLocale() != null && !StringUtils.isEmpty((String)searchForm.getTipoNomeSoggettoLocale()) && !"--".equals(searchForm.getTipoNomeSoggettoLocale())) {
            String tipoSoggettoDestinatario = searchForm.getTipoSoggettoLocale();
            String nomeSoggettoDestinatario = searchForm.getSoggettoLocale();
            if (tipoSoggettoDestinatario != null && !"qualsiasi".equals(tipoSoggettoDestinatario)) {
                expr.equals(model.ID_SOGGETTO.TIPO, (Object)tipoSoggettoDestinatario);
            }
            if (nomeSoggettoDestinatario != null && !"qualsiasi".equals(nomeSoggettoDestinatario)) {
                expr.equals(model.ID_SOGGETTO.NOME, (Object)nomeSoggettoDestinatario);
            }
            setSoggettoProprietario = true;
        }
        if (StringUtils.isNotBlank((String)searchForm.getNomeServizio())) {
            String servizioString = searchForm.getNomeServizio();
            IDServizio idServizio = ParseUtility.parseServizioSoggetto((String)servizioString);
            expr.equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo());
            expr.equals(model.NOME_SERVIZIO, (Object)idServizio.getNome());
            expr.equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
            if (!setSoggettoProprietario) {
                expr.equals(model.ID_SOGGETTO.TIPO, (Object)idServizio.getSoggettoErogatore().getTipo());
                expr.equals(model.ID_SOGGETTO.NOME, (Object)idServizio.getSoggettoErogatore().getNome());
            }
        }
        if (!count) {
            expr.sortOrder(SortOrder.ASC);
            expr.addOrder(model.ID_SOGGETTO.TIPO);
            expr.addOrder(model.ID_SOGGETTO.NOME);
            expr.addOrder(model.TIPO_SERVIZIO);
            expr.addOrder(model.NOME_SERVIZIO);
            expr.addOrder(model.VERSIONE_SERVIZIO);
            expr.addOrder(model.NOME_AZIONE);
        }
        return expr;
    }

    private void impostaTipiCompatibiliConProtocollo(IServiceSearchWithId<?, ?> dao, PortaDelegataModel model, IExpression expr, String protocollo) throws ExpressionNotImplementedException, ExpressionException {
        IExpression expressionTipoServiziCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoServiziCompatibili = DynamicUtilsServiceEngine.getExpressionTipiServiziCompatibiliConProtocollo(dao, (IField)model.TIPO_SERVIZIO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi servizio compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoServiziCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoServiziCompatibili});
        }
        IExpression expressionTipoSoggettiMittenteCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoSoggettiMittenteCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.ID_SOGGETTO.TIPO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi soggetto mittente compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoSoggettiMittenteCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiMittenteCompatibili});
        }
        IExpression expressionTipoSoggettiDestinatarioCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoSoggettiDestinatarioCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.TIPO_SOGGETTO_EROGATORE, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi soggetto destinatario compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoSoggettiDestinatarioCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiDestinatarioCompatibili});
        }
    }

    private void impostaTipiCompatibiliConProtocollo(IServiceSearchWithId<?, ?> dao, PortaApplicativaModel model, IExpression expr, String protocollo) throws ExpressionNotImplementedException, ExpressionException {
        IExpression expressionTipoServiziCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoServiziCompatibili = DynamicUtilsServiceEngine.getExpressionTipiServiziCompatibiliConProtocollo(dao, (IField)model.TIPO_SERVIZIO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi servizio compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoServiziCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoServiziCompatibili});
        }
        IExpression expressionTipoSoggettiDestinatarioCompatibili = null;
        try {
            if (protocollo != null) {
                expressionTipoSoggettiDestinatarioCompatibili = DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(dao, (IField)model.ID_SOGGETTO.TIPO, (String)protocollo);
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il calcolo dei tipi soggetto destinatario compatibili con il protocollo scelto: " + e.getMessage(), (Throwable)e);
        }
        if (expressionTipoSoggettiDestinatarioCompatibili != null) {
            expr.and(new IExpression[]{expressionTipoSoggettiDestinatarioCompatibili});
        }
    }

    @Override
    public boolean isShowParameters(Allarme configurazioneAllarme, Context context) throws Exception {
        try {
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
            idPlugin.setTipo(configurazioneAllarme.getTipo());
            Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, configurazioneAllarme.getTipo(), plugin.getClassName(), log);
            List sdkParameters = bl.getParameters(context);
            return sdkParameters != null && sdkParameters.size() > 0;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<Parameter<?>> instanceParameters(Allarme configurazioneAllarme, Context context) throws Exception {
        try {
            ArrayList<Parameter> res = null;
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
            idPlugin.setTipo(configurazioneAllarme.getTipo());
            Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, configurazioneAllarme.getTipo(), plugin.getClassName(), log);
            List sdkParameters = bl.getParameters(context);
            if (sdkParameters != null && sdkParameters.size() > 0) {
                res = new ArrayList<Parameter>();
                for (Parameter sdkParameter : sdkParameters) {
                    Parameter par = DynamicComponentUtils.createDynamicComponentParameter((Parameter)sdkParameter, (IDynamicLoader)bl);
                    ((BaseComponent)par).setContext(context);
                    res.add(par);
                }
            }
            return res;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isUsableFilter(Allarme configurazioneAllarme, Context context) throws Exception {
        return this._isUsable(configurazioneAllarme, context, true);
    }

    @Override
    public boolean isUsableGroupBy(Allarme configurazioneAllarme, Context context) throws Exception {
        return this._isUsable(configurazioneAllarme, context, false);
    }

    public boolean _isUsable(Allarme configurazioneAllarme, Context context, boolean filter) throws Exception {
        try {
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
            idPlugin.setTipo(configurazioneAllarme.getTipo());
            Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, configurazioneAllarme.getTipo(), plugin.getClassName(), log);
            IAlarmProcessing alarmProcessing = (IAlarmProcessing)bl.newInstance();
            return filter ? alarmProcessing.isUsableFilter(context) : alarmProcessing.isUsableGroupBy(context);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String getParameterSectionTitle(Allarme configurazioneAllarme, Context context) throws Exception {
        try {
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
            idPlugin.setTipo(configurazioneAllarme.getTipo());
            Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, configurazioneAllarme.getTipo(), plugin.getClassName(), log);
            IAlarmProcessing alarmProcessing = (IAlarmProcessing)bl.newInstance();
            boolean groupBy = alarmProcessing.isUsableGroupBy(context);
            String s = alarmProcessing.getParameterSectionTitle();
            if (s == null || StringUtils.isEmpty((String)s)) {
                s = groupBy ? "Valori di Soglia" : "Parametri";
            }
            return s;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public DialogInfo getCriteriAckDialogInfo(Allarme configurazioneAllarme, Context context) throws Exception {
        try {
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
            idPlugin.setTipo(configurazioneAllarme.getTipo());
            Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, configurazioneAllarme.getTipo(), plugin.getClassName(), log);
            IAlarmProcessing alarmProcessing = (IAlarmProcessing)bl.newInstance();
            return alarmProcessing.getDialogInfoAckCriteria(context);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteAll() throws Exception {
    }

    @Override
    public ConfigurazioneAllarmeBean getAllarme(String nome) throws NotFoundException, ServiceException {
        try {
            Allarme find = (Allarme)this.allarmeSearchDAO.find(this.allarmeSearchDAO.newExpression().equals(Allarme.model().NOME, (Object)nome));
            if (find != null) {
                IdPlugin idPlugin = new IdPlugin();
                idPlugin.setTipoPlugin(TipoPlugin.ALLARME.getValue());
                idPlugin.setTipo(find.getTipo());
                Plugin plugin = this.dynamicUtils.getPlugin(idPlugin);
                return new ConfigurazioneAllarmeBean(find, plugin);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public AllarmeParametro getParametroByIdParametro(ConfigurazioneAllarmeBean allarme, String idParametro) throws NotFoundException, ServiceException {
        try {
            IExpression expr = this.allarmeSearchDAO.newExpression();
            expr.equals(Allarme.model().ALLARME_PARAMETRO.ID_PARAMETRO, (Object)idParametro);
            expr.and().equals(Allarme.model().NOME, (Object)allarme.getNome());
            Allarme c = (Allarme)this.allarmeSearchDAO.find(expr);
            if (c != null && c.getAllarmeParametroList().size() > 0) {
                for (AllarmeParametro par : allarme.getAllarmeParametroList()) {
                    if (!par.getIdParametro().equals(idParametro)) continue;
                    return par;
                }
            }
            return null;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<String> nomeAllarmeAutoComplete(String input) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IExpression expr = this.createQuery(false, this.searchForm);
            if (!StringUtils.isEmpty((String)input)) {
                int idx = input.indexOf("/");
                if (idx != -1) {
                    input = input.substring(idx + 1, input.length());
                }
                expr.ilike(Allarme.model().ALIAS, input.toLowerCase(), LikeMode.ANYWHERE);
            }
            IPaginatedExpression pagExpr = this.allarmeSearchDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(this.lIMIT_SEARCH);
            List select = this.allarmeSearchDAO.select(pagExpr, true, Allarme.model().ALIAS);
            if (select != null && select.size() > 0) {
                for (Object object : select) {
                    list.add((String)object);
                }
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage());
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    public List<AllarmeHistory> findAllHistory(long idAllarme, int start, int limit) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IPaginatedExpression pagExpr = this.allarmeHistorySearchDAO.newPaginatedExpression();
        JDBCAllarmeHistoryServiceSearch jdbcInterfaceAudit = (JDBCAllarmeHistoryServiceSearch)this.allarmeHistorySearchDAO;
        CustomField cf = new CustomField("id_allarme", Long.class, "id_allarme", jdbcInterfaceAudit.getFieldConverter().toTable((IModel)AllarmeHistory.model()));
        pagExpr.equals((IField)cf, (Object)idAllarme);
        pagExpr.offset(start);
        pagExpr.limit(limit);
        pagExpr.sortOrder(SortOrder.DESC);
        pagExpr.addOrder(AllarmeHistory.model().TIMESTAMP_UPDATE);
        List findAll = this.allarmeHistorySearchDAO.findAll(pagExpr);
        if (findAll != null && findAll.size() > 0) {
            ArrayList<AllarmeHistory> toRet = new ArrayList<AllarmeHistory>();
            for (AllarmeHistory al : findAll) {
                toRet.add((AllarmeHistory)new ConfigurazioneAllarmeHistoryBean(al));
            }
            return toRet;
        }
        return new ArrayList<AllarmeHistory>();
    }

    @Override
    public long countAllHistory(long idAllarme) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IExpression expr = this.allarmeHistorySearchDAO.newExpression();
        JDBCAllarmeHistoryServiceSearch jdbcInterfaceAudit = (JDBCAllarmeHistoryServiceSearch)this.allarmeHistorySearchDAO;
        CustomField cf = new CustomField("id_allarme", Long.class, "id_allarme", jdbcInterfaceAudit.getFieldConverter().toTable((IModel)AllarmeHistory.model()));
        expr.equals((IField)cf, (Object)idAllarme);
        return this.allarmeHistorySearchDAO.count(expr).longValue();
    }

    @Override
    public void addHistory(AllarmeHistory history) throws ServiceException, NotImplementedException {
        this.allarmeHistoryDAO.create((Object)history);
    }

    @Override
    public IAlarm getAlarm(String name) throws AlarmException {
        try {
            return AlarmManager.getAlarm((String)name, (Logger)LoggerManager.getPddMonitorCoreLogger(), (DAOFactory)DAOFactory.getInstance((Logger)log));
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), (Throwable)e);
        }
    }
}

