/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4;

import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.protocol.as4.archive.AS4Archive;
import org.openspcoop2.protocol.as4.builder.AS4BustaBuilder;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.config.AS4ProtocolConfiguration;
import org.openspcoop2.protocol.as4.config.AS4ProtocolManager;
import org.openspcoop2.protocol.as4.config.AS4ProtocolVersionManager;
import org.openspcoop2.protocol.as4.properties.AS4DynamicConfiguration;
import org.openspcoop2.protocol.as4.validator.AS4ValidazioneSintattica;
import org.openspcoop2.protocol.basic.BasicFactory;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.state.IState;
import org.slf4j.Logger;

public class AS4Factory
extends BasicFactory<SOAPElement> {
    private static final long serialVersionUID = -4246311511752079753L;
    private static IProtocolManager staticInstanceProtocolManager = null;
    private static Map<String, IProtocolVersionManager> staticInstanceProtocolVersionManager = null;
    private static IProtocolConfiguration staticInstanceProtocolConfiguration = null;

    public void init(Logger log, String protocol, ConfigurazionePdD configPdD, Openspcoop2 manifest) throws ProtocolException {
        super.init(log, protocol, configPdD, manifest);
        AS4Properties.initialize(configPdD.getConfigurationDir(), log);
        AS4Properties properties = AS4Properties.getInstance();
        properties.validaConfigurazione(configPdD.getLoader());
        BasicStaticInstanceConfig staticInstanceConfig = properties.getStaticInstanceConfig();
        super.initStaticInstance(staticInstanceConfig);
        if (staticInstanceConfig != null && staticInstanceConfig.isStaticConfig()) {
            staticInstanceProtocolManager = new AS4ProtocolManager((IProtocolFactory<?>)this);
            staticInstanceProtocolVersionManager = new HashMap<String, IProtocolVersionManager>();
            staticInstanceProtocolConfiguration = new AS4ProtocolConfiguration((IProtocolFactory<?>)this);
        }
    }

    public AS4BustaBuilder createBustaBuilder(IState state) throws ProtocolException {
        return new AS4BustaBuilder((IProtocolFactory<?>)this, state);
    }

    public AS4ValidazioneSintattica createValidazioneSintattica(IState state) throws ProtocolException {
        return new AS4ValidazioneSintattica((IProtocolFactory<SOAPElement>)this, state);
    }

    public IArchive createArchive() throws ProtocolException {
        return new AS4Archive((IProtocolFactory<?>)this);
    }

    public IProtocolManager createProtocolManager() throws ProtocolException {
        return staticInstanceProtocolManager != null ? staticInstanceProtocolManager : new AS4ProtocolManager((IProtocolFactory<?>)this);
    }

    public IProtocolVersionManager createProtocolVersionManager(String version) throws ProtocolException {
        if (staticInstanceProtocolVersionManager != null) {
            if (!staticInstanceProtocolVersionManager.containsKey(version)) {
                this.initProtocolVersionManager(version);
            }
            return staticInstanceProtocolVersionManager.get(version);
        }
        return new AS4ProtocolVersionManager((IProtocolFactory<?>)this, version);
    }

    private synchronized void initProtocolVersionManager(String version) throws ProtocolException {
        if (!staticInstanceProtocolVersionManager.containsKey(version)) {
            staticInstanceProtocolVersionManager.put(version, (IProtocolVersionManager)new AS4ProtocolVersionManager((IProtocolFactory<?>)this, version));
        }
    }

    public IProtocolConfiguration createProtocolConfiguration() throws ProtocolException {
        return staticInstanceProtocolConfiguration != null ? staticInstanceProtocolConfiguration : new AS4ProtocolConfiguration((IProtocolFactory<?>)this);
    }

    public IConsoleDynamicConfiguration createDynamicConfigurationConsole() throws ProtocolException {
        return new AS4DynamicConfiguration((IProtocolFactory<?>)this);
    }
}

