/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode.beans;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.protocol.as4.pmode.beans.Azione;
import org.openspcoop2.protocol.as4.pmode.beans.Index;
import org.openspcoop2.protocol.as4.pmode.beans.PayloadProfiles;
import org.openspcoop2.protocol.as4.pmode.beans.Properties;

public class API {
    private AccordoServizioParteComune base;
    private String id;
    private Map<String, Azione> actions;
    private Map<String, Map<String, Azione>> actionsByPortType;
    protected static final String PORT_TYPE_NON_ESISTENTE = "@@ACCORDO_DIRETTO@@";

    public API(AccordoServizioParteComune base, String id, Index index, PayloadProfiles payloadProfiles, Properties properties) throws Exception {
        block7: {
            block6: {
                this.base = base;
                this.id = id;
                this.actions = new HashMap<String, Azione>();
                if (!ServiceBinding.SOAP.equals((Object)base.getServiceBinding())) break block6;
                this.actionsByPortType = new HashMap<String, Map<String, Azione>>();
                if (base.sizeAzioneList() > 0) {
                    HashMap<CallSite, Azione> map = new HashMap<CallSite, Azione>();
                    for (org.openspcoop2.core.registry.Azione az : base.getAzioneList()) {
                        String idAzione = this.id + "_AzioneAccordo_" + index.getNextActionId();
                        Azione azione = new Azione(az, idAzione, payloadProfiles, properties);
                        this.actions.put(idAzione, azione);
                        map.put((CallSite)((Object)idAzione), azione);
                    }
                    this.actionsByPortType.put(PORT_TYPE_NON_ESISTENTE, map);
                }
                if (base.sizePortTypeList() <= 0) break block7;
                for (PortType pt : base.getPortTypeList()) {
                    if (pt.sizeAzioneList() <= 0) continue;
                    HashMap<CallSite, Azione> map = new HashMap<CallSite, Azione>();
                    for (Operation az : pt.getAzioneList()) {
                        String idAzione = this.id + "_Azione_" + index.getNextActionId();
                        Azione azione = new Azione(az, idAzione, payloadProfiles, properties);
                        this.actions.put(idAzione, azione);
                        map.put((CallSite)((Object)idAzione), azione);
                    }
                    this.actionsByPortType.put(pt.getNome(), map);
                }
                break block7;
            }
            if (base.sizeResourceList() > 0) {
                for (Resource resource : base.getResourceList()) {
                    String idAzione = this.id + "_Resource_" + index.getNextActionId();
                    this.actions.put(idAzione, new Azione(resource, idAzione, payloadProfiles, properties));
                }
            }
        }
    }

    public AccordoServizioParteComune getBase() {
        return this.base;
    }

    public void setBase(AccordoServizioParteComune base) {
        this.base = base;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Azione> getActions() {
        return this.actions;
    }

    public Map<String, Azione> getActionsWithoutPortType() {
        if (this.actionsByPortType != null) {
            return this.actionsByPortType.get(PORT_TYPE_NON_ESISTENTE);
        }
        return null;
    }

    public Map<String, Azione> getActions(String portType) {
        if (this.actionsByPortType != null) {
            return this.actionsByPortType.get(portType);
        }
        return null;
    }

    public void setActions(Map<String, Azione> actions) {
        this.actions = actions;
    }
}

