/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.properties;

import eu.domibus.configuration.Payload;
import eu.domibus.configuration.PayloadProfile;
import eu.domibus.configuration.PayloadProfiles;
import eu.domibus.configuration.Properties;
import eu.domibus.configuration.Property;
import eu.domibus.configuration.PropertySet;
import eu.domibus.configuration.utils.PayloadProfilesXSDValidator;
import eu.domibus.configuration.utils.PropertiesXSDValidator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.protocol.as4.builder.AS4BuilderUtils;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.constants.AS4ConsoleCostanti;
import org.openspcoop2.protocol.as4.pmode.PModeRegistryReader;
import org.openspcoop2.protocol.as4.pmode.TranslatorPayloadProfilesDefault;
import org.openspcoop2.protocol.as4.pmode.TranslatorPropertiesDefault;
import org.openspcoop2.protocol.as4.pmode.beans.Policy;
import org.openspcoop2.protocol.basic.properties.BasicDynamicConfiguration;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordoAzioni;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPortTypeAzioni;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaRisorse;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaSoggetti;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.beans.BaseBean;

public class AS4DynamicConfiguration
extends BasicDynamicConfiguration
implements IConsoleDynamicConfiguration {
    public AS4DynamicConfiguration(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public ConsoleConfiguration getDynamicConfigSoggetto(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDSoggetto id) throws ProtocolException {
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"as4SoggettiTitleId", (String)"eDelivery");
        configuration.addConsoleItem(titolo);
        BaseConsoleItem subTitleInfo = ProtocolPropertiesFactory.newSubTitleItem((String)"as4SoggettiPartyInfoSubTitleId", (String)"Party Info");
        configuration.addConsoleItem(subTitleInfo);
        AbstractConsoleItem userMessagePartyIdItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessagePartyId", (String)"Id");
        userMessagePartyIdItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)userMessagePartyIdItem);
        StringConsoleItem userMessagePartyTypeNameItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessagePartyIdTypeName", (String)"Type Name");
        userMessagePartyTypeNameItem.setDefaultValue((Object)"partyTypeUrn");
        userMessagePartyTypeNameItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)userMessagePartyTypeNameItem);
        StringConsoleItem userMessagePartyTypeValueItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessagePartyIdTypeValue", (String)"Type Value");
        userMessagePartyTypeValueItem.setDefaultValue((Object)"urn:oasis:names:tc:ebcore:partyid-type:unregistered");
        userMessagePartyTypeValueItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)userMessagePartyTypeValueItem);
        BaseConsoleItem subTitleEndpoint = ProtocolPropertiesFactory.newSubTitleItem((String)"as4SoggettiPartyEndpointSubTitleId", (String)"Party Endpoint");
        configuration.addConsoleItem(subTitleEndpoint);
        StringConsoleItem userMessagePartyEndpointItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessagePartyEndpoint", (String)"URL");
        userMessagePartyEndpointItem.setDefaultValue((Object)"http://HOST:PORT/domibus/services/msh");
        userMessagePartyEndpointItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)userMessagePartyEndpointItem);
        StringConsoleItem userMessagePartyCNItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessagePartyCommonName", (String)"Common Name");
        userMessagePartyCNItem.setDefaultValue((Object)id.getNome());
        userMessagePartyCNItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)userMessagePartyCNItem);
        return configuration;
    }

    public void validateDynamicConfigSoggetto(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDSoggetto id) throws ProtocolException {
        StringProperty userMessagePartyIdItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessagePartyId");
        List idSoggettiList = null;
        ProtocolFiltroRicercaSoggetti filtroSoggetti = new ProtocolFiltroRicercaSoggetti();
        filtroSoggetti.setProtocolProperties(new ProtocolProperties());
        filtroSoggetti.getProtocolProperties().addProperty((AbstractProperty)userMessagePartyIdItem);
        try {
            idSoggettiList = registryReader.findIdSoggetti(filtroSoggetti);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca dei soggetti: " + e.getMessage(), (Throwable)e);
        }
        if (idSoggettiList != null && idSoggettiList.size() > 0) {
            StringBuilder bfExc = new StringBuilder();
            for (IDSoggetto idSoggetto : idSoggettiList) {
                if (!ConsoleOperationType.ADD.equals((Object)consoleOperationType) && id.equals((Object)idSoggetto)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append(idSoggetto);
            }
            if (bfExc.length() > 0) {
                throw new ProtocolException("Party Id '" + (String)userMessagePartyIdItem.getValue() + "', indicato nel parametro 'Id', gi\u00e0 utilizzato per il soggetto: " + bfExc.toString());
            }
        }
        StringProperty userMessagePartyTypeValueItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessagePartyIdTypeValue");
        try {
            URI uri = new URI((String)userMessagePartyTypeValueItem.getValue());
            uri.toString();
        }
        catch (Exception e) {
            throw new ProtocolException("Deve essere indicata una URI valida per il parametro 'Type Value'");
        }
        StringProperty userMessagePartyEndpointValueItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessagePartyEndpoint");
        if (userMessagePartyEndpointValueItem.getValue() != null) {
            try {
                URL url = new URL((String)userMessagePartyEndpointValueItem.getValue());
                url.toString();
            }
            catch (Exception e) {
                throw new ProtocolException("Deve essere indicata una URL valida per il parametro 'URL'");
            }
        }
    }

    public ConsoleConfiguration getDynamicConfigAccordoServizioParteComune(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordo id) throws ProtocolException {
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"as4ApiTitleId", (String)"eDelivery");
        configuration.addConsoleItem(titolo);
        BaseConsoleItem subTitleService = ProtocolPropertiesFactory.newSubTitleItem((String)"as4ApiServiceSubTitleId", (String)"Service Info");
        configuration.addConsoleItem(subTitleService);
        AbstractConsoleItem serviceTypeItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessageCollaborationInfoServiceType", (String)"Type");
        serviceTypeItem.setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)serviceTypeItem);
        AbstractConsoleItem serviceNameItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessageCollaborationInfoService", (String)"Name");
        serviceNameItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)serviceNameItem);
        String labelSubTitlePayload = "Payload";
        if (ConsoleOperationType.ADD.equals((Object)consoleOperationType)) {
            labelSubTitlePayload = "Payload Profiles";
        }
        BaseConsoleItem subTitlePayload = ProtocolPropertiesFactory.newSubTitleItem((String)"as4ApiPayloadSubTitleId", (String)labelSubTitlePayload);
        configuration.addConsoleItem(subTitlePayload);
        String labelPayloadProfileItem = "API Profiles";
        if (ConsoleOperationType.ADD.equals((Object)consoleOperationType)) {
            labelPayloadProfileItem = "";
        }
        AbstractConsoleItem payloadProfileItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BINARY, (ConsoleItemType)ConsoleItemType.FILE, (String)"ebmsServicePayloadProfile", (String)labelPayloadProfileItem);
        payloadProfileItem.setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)payloadProfileItem);
        if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
            AbstractConsoleItem payloadProfileDefaultItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BINARY, (ConsoleItemType)ConsoleItemType.FILE, (String)"ebmsServicePayloadProfileDefault", (String)" Default Profiles");
            TranslatorPayloadProfilesDefault t = TranslatorPayloadProfilesDefault.getTranslator();
            byte[] defaultValue = t.getPayloadProfilesDefaultAsCompleteXml();
            BinaryConsoleItem binary = (BinaryConsoleItem)payloadProfileDefaultItem;
            binary.setDefaultValue((Object)defaultValue);
            binary.setReadOnly(true);
            configuration.addConsoleItem((BaseConsoleItem)payloadProfileDefaultItem);
        }
        BaseConsoleItem subTitleProperties = ProtocolPropertiesFactory.newSubTitleItem((String)"as4ApiPropertiesSubTitleId", (String)"Properties");
        configuration.addConsoleItem(subTitleProperties);
        String labelPropertiesItem = "API Properties";
        if (ConsoleOperationType.ADD.equals((Object)consoleOperationType)) {
            labelPropertiesItem = "";
        }
        AbstractConsoleItem propertiesItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BINARY, (ConsoleItemType)ConsoleItemType.FILE, (String)"ebmsServiceProperties", (String)labelPropertiesItem);
        propertiesItem.setRequired(false);
        configuration.addConsoleItem((BaseConsoleItem)propertiesItem);
        if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
            AbstractConsoleItem propertiesDefaultItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BINARY, (ConsoleItemType)ConsoleItemType.FILE, (String)"ebmsServicePropertiesDefault", (String)" Default Properties");
            TranslatorPropertiesDefault t = TranslatorPropertiesDefault.getTranslator();
            byte[] defaultValue = t.getPropertiesDefaultAsCompleteXml(false);
            BinaryConsoleItem binary = (BinaryConsoleItem)propertiesDefaultItem;
            binary.setDefaultValue((Object)defaultValue);
            binary.setReadOnly(true);
            configuration.addConsoleItem((BaseConsoleItem)propertiesDefaultItem);
        }
        return configuration;
    }

    public void validateDynamicConfigAccordoServizioParteComune(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordo id) throws ProtocolException {
        BinaryProperty propertiesItem;
        BinaryProperty payloadProfileItem;
        StringProperty serviceTypeItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessageCollaborationInfoServiceType");
        StringProperty serviceNameItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessageCollaborationInfoService");
        boolean tipoDefinito = false;
        if (serviceTypeItem.getValue() == null || "".equals(serviceTypeItem.getValue())) {
            try {
                URI uri = new URI((String)serviceNameItem.getValue());
                uri.toString();
            }
            catch (Exception e) {
                throw new ProtocolException("Se non viene definito il parametro 'Type', il valore indicato nel parametro 'Name' deve essere una URI valida.");
            }
        } else {
            tipoDefinito = true;
        }
        List idAccordiList = null;
        ProtocolFiltroRicercaAccordi filtroAccordi = new ProtocolFiltroRicercaAccordi();
        filtroAccordi.setProtocolProperties(new ProtocolProperties());
        filtroAccordi.getProtocolProperties().addProperty((AbstractProperty)serviceTypeItem);
        filtroAccordi.getProtocolProperties().addProperty((AbstractProperty)serviceNameItem);
        try {
            idAccordiList = registryReader.findIdAccordiServizioParteComune(filtroAccordi);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca di accordi di servizio: " + e.getMessage(), (Throwable)e);
        }
        if (idAccordiList != null && idAccordiList.size() > 0) {
            StringBuilder bfExc = new StringBuilder();
            for (IDAccordo idAccordo : idAccordiList) {
                if (!ConsoleOperationType.ADD.equals((Object)consoleOperationType) && id.equals((Object)idAccordo)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append(idAccordo);
            }
            if (bfExc.length() > 0) {
                Object tipo = "";
                if (tipoDefinito) {
                    tipo = "(Type:" + (String)serviceTypeItem.getValue() + ") ";
                }
                throw new ProtocolException((String)tipo + "'" + (String)serviceNameItem.getValue() + "', indicato nel parametro 'Name', gi\u00e0 utilizzato per l'accordo: " + bfExc.toString());
            }
        }
        if ((payloadProfileItem = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsServicePayloadProfile")) != null && payloadProfileItem.getValue() != null) {
            BaseBean p;
            int i;
            List<BaseBean> l;
            try {
                PayloadProfilesXSDValidator.getXSDValidator(this.log).valida((InputStream)new ByteArrayInputStream((byte[])payloadProfileItem.getValue()));
            }
            catch (Exception e) {
                throw new ProtocolException("File caricato nel parametro 'API Profiles', presenta una struttura non valida: " + e.getMessage(), (Throwable)e);
            }
            TranslatorPayloadProfilesDefault t = TranslatorPayloadProfilesDefault.getTranslator();
            PayloadProfiles pps = AS4BuilderUtils.readPayloadProfiles(t, (byte[])payloadProfileItem.getValue(), id, false);
            if (pps == null) {
                throw new ProtocolException("File caricato nel parametro 'API Profiles', presenta una struttura vuota ?");
            }
            if (pps.sizePayloadList() <= 0 && pps.sizePayloadProfileList() <= 0) {
                throw new ProtocolException("File caricato nel parametro 'API Profiles', presenta una struttura senza payload o profile");
            }
            if (pps.sizePayloadList() > 0) {
                l = t.getListPayloadDefault();
                for (i = 0; i < pps.sizePayloadList(); ++i) {
                    p = pps.getPayload(i);
                    for (Payload payload : l) {
                        if (!p.getName().equals(payload.getName())) continue;
                        throw new ProtocolException("File caricato nel parametro 'API Profiles', presenta un payload '" + p.getName() + "' con un nome gi\u00e0 utilizzato tra i payload di default");
                    }
                }
            }
            if (pps.sizePayloadProfileList() > 0) {
                l = t.getListPayloadProfileDefault();
                for (i = 0; i < pps.sizePayloadProfileList(); ++i) {
                    p = pps.getPayloadProfile(i);
                    for (PayloadProfile payloadProfile : l) {
                        if (!p.getName().equals(payloadProfile.getName())) continue;
                        throw new ProtocolException("File caricato nel parametro 'API Profiles', presenta un payload profile '" + p.getName() + "' con un nome gi\u00e0 utilizzato tra i payload di default");
                    }
                }
            }
        }
        if ((propertiesItem = (BinaryProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsServiceProperties")) != null && propertiesItem.getValue() != null) {
            BaseBean p;
            try {
                PropertiesXSDValidator.getXSDValidator(this.log).valida((InputStream)new ByteArrayInputStream((byte[])propertiesItem.getValue()));
            }
            catch (Exception e) {
                throw new ProtocolException("File caricato nel parametro 'API Properties', presenta una struttura non valida: " + e.getMessage(), (Throwable)e);
            }
            TranslatorPropertiesDefault t = TranslatorPropertiesDefault.getTranslator();
            Properties pps = AS4BuilderUtils.readProperties(t, (byte[])propertiesItem.getValue(), id, false);
            if (pps == null) {
                throw new ProtocolException("File caricato nel parametro 'API Properties', presenta una struttura vuota ?");
            }
            if (pps.sizePropertyList() <= 0 && pps.sizePropertySetList() <= 0) {
                throw new ProtocolException("File caricato nel parametro 'API Properties', presenta una struttura senza property o propertySet");
            }
            if (pps.sizePropertyList() > 0) {
                List<Property> l = t.getListPropertyDefault();
                for (int i = 0; i < pps.sizePropertyList(); ++i) {
                    p = pps.getProperty(i);
                    for (Property pDefault : l) {
                        if (!p.getName().equals(pDefault.getName())) continue;
                        throw new ProtocolException("File caricato nel parametro 'API Properties', presenta una propriet\u00e0 '" + p.getName() + "' con un nome gi\u00e0 utilizzato tra le propriet\u00e0 di default");
                    }
                }
            }
            if (pps.sizePropertySetList() > 0) {
                List<PropertySet> l = t.getListPropertySetDefault();
                for (int i = 0; i < pps.sizePropertySetList(); ++i) {
                    p = pps.getPropertySet(i);
                    for (PropertySet psDefault : l) {
                        if (!p.getName().equals(psDefault.getName())) continue;
                        throw new ProtocolException("File caricato nel parametro 'API Properties', presenta un insieme di propriet\u00e0 (property-set) '" + p.getName() + "' con un nome gi\u00e0 utilizzato tra gli insiemi di default");
                    }
                }
            }
        }
    }

    public ConsoleConfiguration getDynamicConfigAzione(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordoAzione id) throws ProtocolException {
        return this._getDynamicConfigAzione(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id.getIdAccordo());
    }

    public void validateDynamicConfigAzione(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordoAzione id) throws ProtocolException {
        StringProperty actionTypeItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessageCollaborationInfoAction");
        List idAccordiAzioniList = null;
        ProtocolFiltroRicercaAccordoAzioni filtroAccordi = new ProtocolFiltroRicercaAccordoAzioni();
        filtroAccordi.setNome(id.getIdAccordo().getNome());
        filtroAccordi.setSoggetto(id.getIdAccordo().getSoggettoReferente());
        filtroAccordi.setVersione(id.getIdAccordo().getVersione());
        filtroAccordi.setProtocolPropertiesAzione(new ProtocolProperties());
        filtroAccordi.getProtocolPropertiesAzione().addProperty((AbstractProperty)actionTypeItem);
        try {
            idAccordiAzioniList = registryReader.findIdAzioneAccordo(filtroAccordi);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca di azioni di un accordo di servizio: " + e.getMessage(), (Throwable)e);
        }
        if (idAccordiAzioniList != null && idAccordiAzioniList.size() > 0) {
            StringBuilder bfExc = new StringBuilder();
            for (IDAccordoAzione idAccordoAzione : idAccordiAzioniList) {
                if (!ConsoleOperationType.ADD.equals((Object)consoleOperationType) && id.equals((Object)idAccordoAzione)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append(idAccordoAzione.getNome());
            }
            if (bfExc.length() > 0) {
                throw new ProtocolException("'" + (String)actionTypeItem.getValue() + "', indicato nel parametro 'ebmsUserMessageCollaborationInfoAction', gi\u00e0 utilizzato all'interno dell'accordo per l'azione: " + bfExc.toString());
            }
        }
        this._validateDynamicConfigResource(actionTypeItem, registryReader, id, null, null);
    }

    public ConsoleConfiguration getDynamicConfigOperation(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDPortTypeAzione id) throws ProtocolException {
        return this._getDynamicConfigAzione(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id.getIdPortType().getIdAccordo());
    }

    public void validateDynamicConfigOperation(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDPortTypeAzione id) throws ProtocolException {
        StringProperty actionTypeItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessageCollaborationInfoAction");
        List idAccordiAzioniList = null;
        ProtocolFiltroRicercaPortTypeAzioni filtroAccordi = new ProtocolFiltroRicercaPortTypeAzioni();
        filtroAccordi.setNome(id.getIdPortType().getIdAccordo().getNome());
        filtroAccordi.setSoggetto(id.getIdPortType().getIdAccordo().getSoggettoReferente());
        filtroAccordi.setVersione(id.getIdPortType().getIdAccordo().getVersione());
        filtroAccordi.setNomePortType(id.getIdPortType().getNome());
        filtroAccordi.setProtocolPropertiesAzione(new ProtocolProperties());
        filtroAccordi.getProtocolPropertiesAzione().addProperty((AbstractProperty)actionTypeItem);
        try {
            idAccordiAzioniList = registryReader.findIdAzionePortType(filtroAccordi);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca di azioni di un accordo di servizio: " + e.getMessage(), (Throwable)e);
        }
        if (idAccordiAzioniList != null && idAccordiAzioniList.size() > 0) {
            StringBuilder bfExc = new StringBuilder();
            for (IDPortTypeAzione idAccordoAzione : idAccordiAzioniList) {
                if (!ConsoleOperationType.ADD.equals((Object)consoleOperationType) && id.equals((Object)idAccordoAzione)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append(idAccordoAzione.getNome());
            }
            if (bfExc.length() > 0) {
                throw new ProtocolException("'" + (String)actionTypeItem.getValue() + "', indicato nel parametro 'ebmsUserMessageCollaborationInfoAction', gi\u00e0 utilizzato all'interno dell'accordo per l'azione: " + bfExc.toString());
            }
        }
        this._validateDynamicConfigResource(actionTypeItem, registryReader, null, id, null);
    }

    public ConsoleConfiguration getDynamicConfigResource(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDResource id, String httpMethod, String path) throws ProtocolException {
        return this._getDynamicConfigAzione(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id.getIdAccordo());
    }

    public void validateDynamicConfigResource(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDResource id, String httpMethod, String path) throws ProtocolException {
        StringProperty actionTypeItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsUserMessageCollaborationInfoAction");
        List idAccordiAzioniList = null;
        ProtocolFiltroRicercaRisorse filtroAccordi = new ProtocolFiltroRicercaRisorse();
        filtroAccordi.setNome(id.getIdAccordo().getNome());
        filtroAccordi.setSoggetto(id.getIdAccordo().getSoggettoReferente());
        filtroAccordi.setVersione(id.getIdAccordo().getVersione());
        filtroAccordi.setProtocolPropertiesRisorsa(new ProtocolProperties());
        filtroAccordi.getProtocolPropertiesRisorsa().addProperty((AbstractProperty)actionTypeItem);
        try {
            idAccordiAzioniList = registryReader.findIdResourceAccordo(filtroAccordi);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca di risorse di un accordo di servizio: " + e.getMessage(), (Throwable)e);
        }
        if (idAccordiAzioniList != null && idAccordiAzioniList.size() > 0) {
            StringBuilder bfExc = new StringBuilder();
            for (IDResource idAccordoAzione : idAccordiAzioniList) {
                if (!ConsoleOperationType.ADD.equals((Object)consoleOperationType) && id.equals((Object)idAccordoAzione)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append(idAccordoAzione.getNome());
            }
            if (bfExc.length() > 0) {
                throw new ProtocolException("'" + (String)actionTypeItem.getValue() + "', indicato nel parametro 'ebmsUserMessageCollaborationInfoAction', gi\u00e0 utilizzato all'interno dell'accordo per la risorsa: " + bfExc.toString());
            }
        }
        this._validateDynamicConfigResource(actionTypeItem, registryReader, null, null, id);
    }

    private ConsoleConfiguration _getDynamicConfigAzione(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordo id) throws ProtocolException {
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"as4AzioneTitleId", (String)"eDelivery");
        configuration.addConsoleItem(titolo);
        AccordoServizioParteComune as = null;
        try {
            as = registryReader.getAccordoServizioParteComune(id);
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile recuperare l'accordo con id [" + id + "]: " + e.getMessage(), (Throwable)e);
        }
        BaseConsoleItem subTitleAction = ProtocolPropertiesFactory.newSubTitleItem((String)"as4AzioneActionSubTitleId", (String)"Action Info");
        configuration.addConsoleItem(subTitleAction);
        AbstractConsoleItem actionTypeItem = ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.TEXT_EDIT, (String)"ebmsUserMessageCollaborationInfoAction", (String)"Name");
        actionTypeItem.setRequired(true);
        configuration.addConsoleItem((BaseConsoleItem)actionTypeItem);
        StringConsoleItem actionBindingItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"ebmsUserMessageCollaborationInfoActionBinding", (String)"Binding");
        actionBindingItem.addLabelValue("oneway", (Object)"push");
        actionBindingItem.addLabelValue("twoway", (Object)"pushAndPush");
        actionBindingItem.setDefaultValue((Object)"push");
        configuration.addConsoleItem((BaseConsoleItem)actionBindingItem);
        BaseConsoleItem subTitlePayload = ProtocolPropertiesFactory.newSubTitleItem((String)"as4AzionePayloadSubTitleId", (String)"Payload");
        configuration.addConsoleItem(subTitlePayload);
        TranslatorPayloadProfilesDefault tPayload = TranslatorPayloadProfilesDefault.getTranslator();
        PayloadProfiles pps = AS4BuilderUtils.readPayloadProfiles(tPayload, as, id, false);
        ArrayList<String> profiles = new ArrayList<String>();
        if (pps != null && pps.sizePayloadProfileList() > 0) {
            for (PayloadProfile pp : pps.getPayloadProfileList()) {
                profiles.add(pp.getName());
            }
        }
        List<PayloadProfile> listDefault = tPayload.getListPayloadProfileDefault();
        if (profiles.size() > 0 || listDefault.size() > 1) {
            StringConsoleItem actionPayloadProfile = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"ebmsActionPayloadProfile", (String)"Profile");
            String defaultProfile = null;
            if (listDefault != null && listDefault.size() > 0) {
                for (PayloadProfile payloadProfileDefault : listDefault) {
                    String defaultProfileL = payloadProfileDefault.getName();
                    if (defaultProfile == null) {
                        defaultProfile = defaultProfileL;
                    }
                    if (profiles.contains(defaultProfileL)) continue;
                    actionPayloadProfile.addLabelValue(defaultProfileL, (Object)defaultProfileL);
                }
            }
            for (String p : profiles) {
                actionPayloadProfile.addLabelValue(p, (Object)p);
            }
            actionPayloadProfile.setDefaultValue(defaultProfile);
            actionPayloadProfile.setRequired(false);
            configuration.addConsoleItem((BaseConsoleItem)actionPayloadProfile);
        }
        BooleanConsoleItem actionCompressPayloadItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"ebmsActionCompressPayload", (String)"Compress");
        actionCompressPayloadItem.setRequired(false);
        actionCompressPayloadItem.setDefaultValue((Object)AS4ConsoleCostanti.AS4_AZIONE_ACTION_PAYLOAD_COMPRESS_DEFAULT);
        configuration.addConsoleItem((BaseConsoleItem)actionCompressPayloadItem);
        TranslatorPropertiesDefault tProperties = TranslatorPropertiesDefault.getTranslator();
        Properties properties = AS4BuilderUtils.readProperties(tProperties, as, id, false);
        ArrayList<String> propertySetList = new ArrayList<String>();
        if (properties != null && properties.sizePropertySetList() > 0) {
            for (PropertySet pp : properties.getPropertySetList()) {
                propertySetList.add(pp.getName());
            }
        }
        List<PropertySet> listPropertySetDefault = tProperties.getListPropertySetDefault();
        if (propertySetList.size() > 0 || listPropertySetDefault.size() > 1) {
            BaseConsoleItem subTitleProperties = ProtocolPropertiesFactory.newSubTitleItem((String)"as4AzionePropertiesSubTitleId", (String)"Properties");
            configuration.addConsoleItem(subTitleProperties);
            StringConsoleItem actionPropertySet = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"ebmsActionPropertySet", (String)"PropertySet");
            String defaultPropertySet = null;
            if (listPropertySetDefault != null && listPropertySetDefault.size() > 0) {
                for (PropertySet propertySetDefault : listPropertySetDefault) {
                    String defaultPropertySetL = propertySetDefault.getName();
                    if (defaultPropertySet == null) {
                        defaultPropertySet = defaultPropertySetL;
                    }
                    if (propertySetList.contains(defaultPropertySetL)) continue;
                    actionPropertySet.addLabelValue(defaultPropertySetL, (Object)defaultPropertySetL);
                }
            }
            for (String p : propertySetList) {
                actionPropertySet.addLabelValue(p, (Object)p);
            }
            actionPropertySet.setDefaultValue(defaultPropertySet);
            actionPropertySet.setRequired(false);
            configuration.addConsoleItem((BaseConsoleItem)actionPropertySet);
        }
        return configuration;
    }

    public void _validateDynamicConfigResource(StringProperty actionTypeItem, IRegistryReader registryReader, IDAccordoAzione idAccordoAzione, IDPortTypeAzione idPTOperation, IDResource idResource) throws ProtocolException {
        StringBuilder bfExc = new StringBuilder();
        List idAccordiAzioniList = null;
        ProtocolFiltroRicercaAccordoAzioni filtroAccordi = new ProtocolFiltroRicercaAccordoAzioni();
        filtroAccordi.setProtocolPropertiesAzione(new ProtocolProperties());
        filtroAccordi.getProtocolPropertiesAzione().addProperty((AbstractProperty)actionTypeItem);
        try {
            idAccordiAzioniList = registryReader.findIdAzioneAccordo(filtroAccordi);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca di azioni di un accordo di servizio: " + e.getMessage(), (Throwable)e);
        }
        if (idAccordiAzioniList != null && idAccordiAzioniList.size() > 0) {
            for (IDAccordoAzione id : idAccordiAzioniList) {
                if (idAccordoAzione != null && idAccordoAzione.equals((Object)id)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append("api:" + id.getIdAccordo().getNome() + " versione:" + id.getIdAccordo().getVersione() + " azione:" + id.getNome());
            }
        }
        List idAccordiPTOperationsList = null;
        ProtocolFiltroRicercaPortTypeAzioni filtroOperations = new ProtocolFiltroRicercaPortTypeAzioni();
        filtroOperations.setProtocolPropertiesAzione(new ProtocolProperties());
        filtroOperations.getProtocolPropertiesAzione().addProperty((AbstractProperty)actionTypeItem);
        try {
            idAccordiPTOperationsList = registryReader.findIdAzionePortType(filtroOperations);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca di azioni di un accordo di servizio: " + e.getMessage(), (Throwable)e);
        }
        if (idAccordiPTOperationsList != null && idAccordiPTOperationsList.size() > 0) {
            for (IDPortTypeAzione id : idAccordiPTOperationsList) {
                if (idPTOperation != null && idPTOperation.equals((Object)id)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append("api:" + id.getIdPortType().getIdAccordo().getNome() + " versione:" + id.getIdPortType().getIdAccordo().getVersione() + " servizio:" + id.getIdPortType().getNome() + " azione:" + id.getNome());
            }
        }
        List idAccordiResourceList = null;
        ProtocolFiltroRicercaRisorse filtroResource = new ProtocolFiltroRicercaRisorse();
        filtroResource.setProtocolPropertiesRisorsa(new ProtocolProperties());
        filtroResource.getProtocolPropertiesRisorsa().addProperty((AbstractProperty)actionTypeItem);
        try {
            idAccordiResourceList = registryReader.findIdResourceAccordo(filtroResource);
        }
        catch (RegistryNotFound registryNotFound) {
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante la ricerca di risorse di un accordo di servizio: " + e.getMessage(), (Throwable)e);
        }
        if (idAccordiResourceList != null && idAccordiResourceList.size() > 0) {
            for (IDResource id : idAccordiResourceList) {
                if (idResource != null && idResource.equals((Object)id)) continue;
                if (bfExc.length() > 0) {
                    bfExc.append(",");
                }
                bfExc.append("api:" + id.getIdAccordo().getNome() + " versione:" + id.getIdAccordo().getVersione() + " risorsa:" + id.getNome());
            }
        }
        if (bfExc.length() > 0) {
            throw new ProtocolException("'" + (String)actionTypeItem.getValue() + "', indicato nel parametro 'ebmsUserMessageCollaborationInfoAction', gi\u00e0 utilizzato in un'altra azione: " + bfExc.toString());
        }
    }

    public ConsoleConfiguration getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id) throws ProtocolException {
        ConsoleConfiguration configuration = this._getDynamicConfigAccordoServizioParteSpecifica(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id, false);
        if (configuration != null) {
            return configuration;
        }
        return super.getDynamicConfigAccordoServizioParteSpecifica(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
    }

    public void updateDynamicConfigAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id) throws ProtocolException {
        boolean operazioneGestita = this._updateDynamicConfigParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, id, registryReader, false);
        if (!operazioneGestita) {
            super.updateDynamicConfigAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id);
            return;
        }
    }

    public void validateDynamicConfigAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id) throws ProtocolException {
        this._validateDynamicConfigAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id, false);
    }

    public ConsoleConfiguration getDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDFruizione id) throws ProtocolException {
        ConsoleConfiguration configuration = this._getDynamicConfigAccordoServizioParteSpecifica(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id.getIdServizio(), true);
        if (configuration != null) {
            return configuration;
        }
        return super.getDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
    }

    public void updateDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDFruizione id) throws ProtocolException {
        boolean operazioneGestita = this._updateDynamicConfigParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, id.getIdServizio(), registryReader, true);
        if (!operazioneGestita) {
            super.updateDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id);
        }
    }

    public void validateDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDFruizione id) throws ProtocolException {
        this._validateDynamicConfigAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id.getIdServizio(), true);
    }

    private ConsoleConfiguration _getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id, boolean fruizioni) throws ProtocolException {
        PModeRegistryReader pmodeRR = new PModeRegistryReader(registryReader, configIntegrationReader, this.protocolFactory);
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"as4ErogazioneTitleId", (String)"eDelivery");
        configuration.addConsoleItem(titolo);
        BaseConsoleItem subTitleSecurity = ProtocolPropertiesFactory.newSubTitleItem((String)"as4ErogazioneSecuritySubTitleId", (String)"Security");
        configuration.addConsoleItem(subTitleSecurity);
        StringConsoleItem securityProfileItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"ebmsSecurityProfile", (String)"Profile");
        List<Policy> listPolicy = null;
        try {
            listPolicy = pmodeRR.findAllPolicies();
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante il recupero delle policy: " + e.getMessage(), (Throwable)e);
        }
        for (Policy policy : listPolicy) {
            securityProfileItem.addLabelValue(policy.getName(), (Object)policy.getName());
        }
        AS4Properties props = AS4Properties.getInstance();
        if (props.getSecurityPolicyDefault() != null) {
            securityProfileItem.setDefaultValue((Object)props.getSecurityPolicyDefault());
        }
        configuration.addConsoleItem((BaseConsoleItem)securityProfileItem);
        BaseConsoleItem subTitleReliability = ProtocolPropertiesFactory.newSubTitleItem((String)"as4ErogazioneReliabilitySubTitleId", (String)"Reliability");
        configuration.addConsoleItem(subTitleReliability);
        BooleanConsoleItem reliabilityNonRepudiationItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"ebmsReliabilityNonRepudiation", (String)"Non Repudiation");
        reliabilityNonRepudiationItem.setRequired(false);
        reliabilityNonRepudiationItem.setDefaultValue((Object)AS4ConsoleCostanti.AS4_EROGAZIONE_RELIABILITY_NON_REPUDIATION_DEFAULT);
        configuration.addConsoleItem((BaseConsoleItem)reliabilityNonRepudiationItem);
        StringConsoleItem reliabilityReplyPatternItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"ebmsReliabilityReplyPattern", (String)"Reply Pattern");
        reliabilityReplyPatternItem.addLabelValue("Response", (Object)"response");
        reliabilityReplyPatternItem.addLabelValue("Callback", (Object)"callback");
        reliabilityReplyPatternItem.setDefaultValue((Object)"response");
        configuration.addConsoleItem((BaseConsoleItem)reliabilityReplyPatternItem);
        return configuration;
    }

    private boolean _updateDynamicConfigParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IDServizio id, IRegistryReader registryReader, boolean fruizioni) throws ProtocolException {
        return false;
    }

    private boolean _validateDynamicConfigAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id, boolean fruizioni) throws ProtocolException {
        StringProperty securityProfileItem = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"ebmsSecurityProfile");
        if (securityProfileItem == null || securityProfileItem.getValue() == null || "".equals(securityProfileItem.getValue())) {
            throw new ProtocolException("Deve essere selezionato uno dei valori presenti nel parametro 'Type Value'");
        }
        return true;
    }
}

