/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.services.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.transport.TransportUtils;

public class AS4ConnectorOutMessage
implements ConnectorOutMessage {
    private OpenSPCoop2Message message;
    private DumpByteArrayOutputStream messageAsBytes;
    private OpenSPCoop2Message responseHeaderMessage;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private int length;
    String type;
    private int status = 200;

    public OpenSPCoop2Message getMessage() {
        return this.message;
    }

    public void sendResponse(OpenSPCoop2Message msg, boolean consume) throws ConnectorException {
        this.message = msg;
    }

    public DumpByteArrayOutputStream getMessageAsBytes() {
        return this.messageAsBytes;
    }

    public void sendResponse(DumpByteArrayOutputStream message) throws ConnectorException {
        this.messageAsBytes = message;
    }

    public OpenSPCoop2Message getResponseHeaderMessage() {
        return this.responseHeaderMessage;
    }

    public void sendResponseHeaders(OpenSPCoop2Message message) throws ConnectorException {
        this.responseHeaderMessage = message;
    }

    public String getHeaderFirstValue(String key) throws ConnectorException {
        return TransportUtils.getFirstValue(this.headers, (String)key);
    }

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.putAll(this.headers);
        return map;
    }

    public void setHeader(String key, String value) throws ConnectorException {
        try {
            TransportUtils.setHeader(this.headers, (String)key, (String)value);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public void addHeader(String key, String value) throws ConnectorException {
        try {
            TransportUtils.addHeader(this.headers, (String)key, (String)value);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), (Throwable)e);
        }
    }

    public int getContentLength() {
        return this.length;
    }

    public void setContentLength(int length) throws ConnectorException {
        this.length = length;
    }

    public String getContentType() {
        return this.type;
    }

    public void setContentType(String type) throws ConnectorException {
        this.type = type;
    }

    public void setStatus(int status) throws ConnectorException {
        this.status = status;
    }

    public int getResponseStatus() throws ConnectorException {
        return this.status;
    }

    public void flush(boolean throwException) throws ConnectorException {
    }

    public void close(boolean throwException) throws ConnectorException {
    }
}

