/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.soap.SOAPElement;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyId;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.utils.serializer.JaxbSerializer;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.as4.AS4RawContent;
import org.openspcoop2.protocol.as4.constants.AS4Costanti;
import org.openspcoop2.protocol.basic.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaSoggetti;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSintatticaResult;
import org.openspcoop2.protocol.sdk.validator.ValidazioneUtils;

public class AS4ValidazioneSintattica
extends ValidazioneSintattica<SOAPElement> {
    protected ValidazioneUtils validazioneUtils;
    private AS4RawContent headerElement;
    protected List<Eccezione> erroriValidazione = new ArrayList<Eccezione>();
    protected List<Eccezione> erroriProcessamento = new ArrayList<Eccezione>();
    private CodiceErroreCooperazione codiceErrore;
    private String msgErrore;

    public AS4ValidazioneSintattica(IProtocolFactory<SOAPElement> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.validazioneUtils = new ValidazioneUtils(factory);
    }

    public AS4RawContent getBustaRawContent_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        try {
            if (this.headerElement != null) {
                return this.headerElement;
            }
            Object o = msg.getContextProperty(AS4Costanti.AS4_CONTEXT_USER_MESSAGE);
            if (o == null) {
                return null;
            }
            if (!(o instanceof UserMessage)) {
                throw new Exception("UserMessage in context message with wrong type (expected:" + UserMessage.class.getName() + " founded:" + o.getClass().getName() + ")");
            }
            JaxbSerializer as4Serializer = new JaxbSerializer();
            byte[] as4Header = as4Serializer.toByteArray((UserMessage)o);
            SOAPElement soapElementAs4Header = msg.castAsSoap().createSOAPElement(as4Header);
            this.headerElement = new AS4RawContent(soapElementAs4Header);
            return this.headerElement;
        }
        catch (Exception e) {
            this.log.debug("getHeaderProtocollo_senzaControlli error: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ValidazioneSintatticaResult<SOAPElement> validaRichiesta(OpenSPCoop2Message msg, Busta datiBustaLettiURLMappingProperties, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        ValidazioneSintatticaResult basicResult = super.validaRichiesta(msg, datiBustaLettiURLMappingProperties, proprietaValidazioneErrori);
        this.headerElement = this.getBustaRawContent_senzaControlli(msg);
        boolean isValido = this.valida(msg, basicResult.getBusta(), true, null);
        ErroreCooperazione errore = null;
        if (this.msgErrore != null && this.codiceErrore != null) {
            errore = new ErroreCooperazione(this.msgErrore, this.codiceErrore);
        }
        List<Eccezione> erroriValidazione = null;
        if (this.erroriValidazione.size() > 0) {
            erroriValidazione = this.erroriValidazione;
        }
        List erroriProcessamento = null;
        if (this.erroriProcessamento.size() > 0) {
            erroriValidazione = this.erroriProcessamento;
        }
        ValidazioneSintatticaResult result = new ValidazioneSintatticaResult(erroriValidazione, erroriProcessamento, null, basicResult.getBusta(), errore, null, (BustaRawContent)this.headerElement, isValido);
        return result;
    }

    private boolean valida(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, Busta bustaRichiesta) {
        try {
            this._valida(msg, busta, isRichiesta);
            return true;
        }
        catch (Exception e) {
            this.msgErrore = "[ErroreInterno]: " + e.getMessage();
            this.log.error(this.msgErrore, (Throwable)e);
            this.codiceErrore = CodiceErroreCooperazione.FORMATO_NON_CORRETTO;
            return false;
        }
    }

    private void _valida(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta) throws Exception {
        if (msg == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_NON_CORRETTO, "Messaggio non presente"));
            return;
        }
        Object o = msg.getContextProperty(AS4Costanti.AS4_CONTEXT_USER_MESSAGE);
        if (o == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_PRESENTE, "UserMessage non presente"));
            return;
        }
        if (!(o instanceof UserMessage)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO, "UserMessage in context message with wrong type (expected:" + UserMessage.class.getName() + " founded:" + o.getClass().getName() + ")"));
            return;
        }
        UserMessage userMessage = (UserMessage)o;
        Object oContent = msg.getContextProperty(AS4Costanti.AS4_CONTEXT_CONTENT);
        if (oContent == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_PRESENTE, "Contenuti non presenti"));
            return;
        }
        if (!(oContent instanceof HashMap)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Contenuti in context message with wrong type (expected:" + HashMap.class.getName() + " founded:" + oContent.getClass().getName() + ")"));
            return;
        }
        HashMap content = (HashMap)oContent;
        RequestInfo requestInfo = null;
        if (this.context != null && this.context.containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)this.context.getObject(Costanti.REQUEST_INFO);
        }
        IRegistryReader registryReader = this.getProtocolFactory().getCachedRegistryReader(this.state, requestInfo);
        if (userMessage != null) {
            this._fillBusta(userMessage, busta);
        }
        if (userMessage.getPartyInfo() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA, "PartyInfo non presente"));
            return;
        }
        if (userMessage.getPartyInfo().getFrom() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, "PartyInfo/From"));
            return;
        }
        if (userMessage.getPartyInfo().getFrom().getPartyIdList() == null || userMessage.getPartyInfo().getFrom().getPartyIdList().size() <= 0) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, "PartyInfo/From/PartyId"));
            return;
        }
        if (userMessage.getPartyInfo().getFrom().getPartyIdList().size() > 1) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_PRESENTE_PIU_VOLTE, "PartyInfo/From/PartyId"));
            return;
        }
        PartyId from = userMessage.getPartyInfo().getFrom().getPartyId(0);
        if (from == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_VALORIZZATO, "PartyInfo/From/PartyId"));
            return;
        }
        if (from.getBase() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_VALORIZZATO, "PartyInfo/From/PartyId/Base"));
            return;
        }
        if (from.getType() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_MITTENTE_NON_VALORIZZATO, "PartyInfo/From/PartyId/Type"));
            return;
        }
        ProtocolFiltroRicercaSoggetti filtroSoggetti = new ProtocolFiltroRicercaSoggetti();
        filtroSoggetti.setProtocolProperties(new ProtocolProperties());
        filtroSoggetti.getProtocolProperties().addProperty("ebmsUserMessagePartyId", from.getBase());
        List list = null;
        try {
            list = registryReader.findIdSoggetti(filtroSoggetti);
            if (list == null || list.size() <= 0) {
                throw new RegistryNotFound();
            }
        }
        catch (RegistryNotFound notFound) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_NON_VALIDO, "PartyInfo/From/PartyId/Base"));
            return;
        }
        if (list.size() > 1) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.MITTENTE_PRESENTE_PIU_VOLTE, "PartyInfo/From/PartyId/Base"));
            return;
        }
        IDSoggetto idMittente = (IDSoggetto)list.get(0);
        busta.setTipoMittente(idMittente.getTipo());
        busta.setMittente(idMittente.getNome());
        if (userMessage.getPartyInfo().getTo() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_NON_PRESENTE, "PartyInfo/To"));
            return;
        }
        if (userMessage.getPartyInfo().getTo().getPartyIdList() == null || userMessage.getPartyInfo().getTo().getPartyIdList().size() <= 0) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_NON_PRESENTE, "PartyInfo/To/PartyId"));
            return;
        }
        if (userMessage.getPartyInfo().getTo().getPartyIdList().size() > 1) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_PRESENTE_PIU_VOLTE, "PartyInfo/To/PartyId"));
            return;
        }
        PartyId to = userMessage.getPartyInfo().getTo().getPartyId(0);
        if (to == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_NON_VALORIZZATO, "PartyInfo/To/PartyId"));
            return;
        }
        if (to.getBase() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_NON_VALORIZZATO, "PartyInfo/To/PartyId/Base"));
            return;
        }
        if (to.getType() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.TIPO_DESTINATARIO_NON_VALORIZZATO, "PartyInfo/To/PartyId/Type"));
            return;
        }
        filtroSoggetti = new ProtocolFiltroRicercaSoggetti();
        filtroSoggetti.setProtocolProperties(new ProtocolProperties());
        filtroSoggetti.getProtocolProperties().addProperty("ebmsUserMessagePartyId", to.getBase());
        list = null;
        try {
            list = registryReader.findIdSoggetti(filtroSoggetti);
            if (list == null || list.size() <= 0) {
                throw new RegistryNotFound();
            }
        }
        catch (RegistryNotFound notFound) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_NON_VALIDO, "PartyInfo/To/PartyId/Base"));
            return;
        }
        if (list.size() > 1) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.DESTINATARIO_PRESENTE_PIU_VOLTE, "PartyInfo/To/PartyId/Base"));
            return;
        }
        IDSoggetto idDestinatario = (IDSoggetto)list.get(0);
        busta.setTipoDestinatario(idDestinatario.getTipo());
        busta.setDestinatario(idDestinatario.getNome());
        if (userMessage.getCollaborationInfo() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA, "CollaborationInfo non presente"));
            return;
        }
        if (userMessage.getCollaborationInfo().getService() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_NON_PRESENTE, "CollaborationInfo/Service"));
            return;
        }
        if (userMessage.getCollaborationInfo().getService().getBase() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_NON_VALORIZZATO, "CollaborationInfo/Service/Base"));
            return;
        }
        if (userMessage.getCollaborationInfo().getService().getType() == null) {
            // empty if block
        }
        ProtocolFiltroRicercaAccordi filtroAccordi = new ProtocolFiltroRicercaAccordi();
        filtroAccordi.setProtocolProperties(new ProtocolProperties());
        filtroAccordi.getProtocolProperties().addProperty("ebmsUserMessageCollaborationInfoService", userMessage.getCollaborationInfo().getService().getBase());
        filtroAccordi.getProtocolProperties().addProperty("ebmsUserMessageCollaborationInfoServiceType", userMessage.getCollaborationInfo().getService().getType());
        List listAccordi = null;
        try {
            listAccordi = registryReader.findIdAccordiServizioParteComune(filtroAccordi);
            if (listAccordi == null || listAccordi.size() <= 0) {
                throw new RegistryNotFound();
            }
        }
        catch (RegistryNotFound notFound) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_NON_VALIDO, "CollaborationInfo/Service"));
            return;
        }
        if (listAccordi.size() > 1) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_PRESENTE_PIU_VOLTE, "CollaborationInfo/Service"));
            return;
        }
        IDAccordo idAccordo = (IDAccordo)listAccordi.get(0);
        AccordoServizioParteComune aspc = registryReader.getAccordoServizioParteComune(idAccordo, false, false);
        ProtocolFiltroRicercaServizi filtroServizi = new ProtocolFiltroRicercaServizi();
        filtroServizi.setIdAccordoServizioParteComune(idAccordo);
        filtroServizi.setSoggettoErogatore(idDestinatario);
        List listServizi = null;
        try {
            listServizi = registryReader.findIdAccordiServizioParteSpecifica(filtroServizi);
            if (listServizi == null || listServizi.size() <= 0) {
                throw new RegistryNotFound();
            }
        }
        catch (RegistryNotFound notFound) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_NON_VALIDO, "CollaborationInfo/ServiceImpl"));
            return;
        }
        if (listServizi.size() > 1) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.SERVIZIO_PRESENTE_PIU_VOLTE, "CollaborationInfo/ServiceImpl"));
            return;
        }
        IDServizio idServizio = (IDServizio)listServizi.get(0);
        busta.setTipoServizio(idServizio.getTipo());
        busta.setServizio(idServizio.getNome());
        String as4Action = userMessage.getCollaborationInfo().getAction();
        if (as4Action == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_PRESENTE, "CollaborationInfo/Action"));
            return;
        }
        if (ServiceBinding.REST.equals((Object)aspc.getServiceBinding())) {
            block8: for (Object resource : aspc.getResourceList()) {
                if (resource.sizeProtocolPropertyList() <= 0) continue;
                for (ProtocolProperty pp : resource.getProtocolPropertyList()) {
                    if (!"ebmsUserMessageCollaborationInfoAction".equals(pp.getName()) || !as4Action.equals(pp.getValue())) continue;
                    busta.setAzione(resource.getNome());
                    continue block8;
                }
            }
        } else {
            AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio, false);
            if (asps.getPortType() != null) {
                for (PortType pt : aspc.getPortTypeList()) {
                    block11: for (Operation azione : pt.getAzioneList()) {
                        if (azione.sizeProtocolPropertyList() <= 0) continue;
                        for (ProtocolProperty pp : azione.getProtocolPropertyList()) {
                            if (!"ebmsUserMessageCollaborationInfoAction".equals(pp.getName()) || !as4Action.equals(pp.getValue())) continue;
                            busta.setAzione(azione.getNome());
                            continue block11;
                        }
                    }
                }
            } else {
                block13: for (Azione azione : aspc.getAzioneList()) {
                    if (azione.sizeProtocolPropertyList() <= 0) continue;
                    for (ProtocolProperty pp : azione.getProtocolPropertyList()) {
                        if (!"ebmsUserMessageCollaborationInfoAction".equals(pp.getName()) || !as4Action.equals(pp.getValue())) continue;
                        busta.setAzione(azione.getNome());
                        continue block13;
                    }
                }
            }
        }
        if (busta.getAzione() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA, "CollaborationInfo/Action"));
            return;
        }
        String as4ConversationId = userMessage.getCollaborationInfo().getConversationId();
        if (as4ConversationId == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.COLLABORAZIONE_NON_PRESENTE, "CollaborationInfo/ConversationId"));
            return;
        }
        busta.setCollaborazione(as4ConversationId);
        if (userMessage.getMessageInfo() == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA, "MessageInfo non presente"));
            return;
        }
        String as4MessageId = userMessage.getMessageInfo().getMessageId();
        if (as4MessageId == null) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, "MessageInfo/MessageId"));
            return;
        }
        busta.setID(as4MessageId);
        String as4RefToMessageId = userMessage.getMessageInfo().getRefToMessageId();
        if (as4RefToMessageId != null) {
            busta.setRiferimentoMessaggio(as4RefToMessageId);
        }
        if (userMessage.getPayloadInfo() == null || userMessage.getPayloadInfo().sizePartInfoList() <= 0) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "PayloadInfo non presente"));
            return;
        }
        for (PartInfo partInfo : userMessage.getPayloadInfo().getPartInfoList()) {
            if (partInfo.getHref() == null) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_PRESENTE, "PayloadInfo/Href"));
                return;
            }
            if (!content.containsKey(partInfo.getHref())) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ALLEGATO_NON_PRESENTE, "PayloadInfo/Href"));
                return;
            }
            if (partInfo.getPartProperties() == null || partInfo.getPartProperties().sizePropertyList() <= 0) {
                this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_PRESENTE, "PayloadInfo/ContentType"));
                return;
            }
            boolean found = false;
            for (Property property : partInfo.getPartProperties().getPropertyList()) {
                if (!"MimeType".equals(property.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_PRESENTE, "PayloadInfo/MimeType"));
            return;
        }
    }

    private void _fillBusta(UserMessage userMessage, Busta busta) {
        if (userMessage != null) {
            if (userMessage.getPartyInfo() != null) {
                if (userMessage.getPartyInfo().getFrom() != null) {
                    PartyId from = userMessage.getPartyInfo().getFrom().getPartyId(0);
                    busta.addProperty("ebmsUserMessageFromPartyId", from.getBase());
                    busta.addProperty("ebmsUserMessageFromPartyIdType", from.getType());
                }
                if (userMessage.getPartyInfo().getTo() != null) {
                    PartyId to = userMessage.getPartyInfo().getTo().getPartyId(0);
                    busta.addProperty("ebmsUserMessageToPartyId", to.getBase());
                    busta.addProperty("ebmsUserMessageToPartyIdType", to.getType());
                }
            }
            if (userMessage.getCollaborationInfo() != null) {
                if (userMessage.getCollaborationInfo().getService() != null) {
                    busta.addProperty("ebmsUserMessageCollaborationInfoService", userMessage.getCollaborationInfo().getService().getBase());
                    busta.addProperty("ebmsUserMessageCollaborationInfoServiceType", userMessage.getCollaborationInfo().getService().getType());
                }
                busta.addProperty("ebmsUserMessageCollaborationInfoAction", userMessage.getCollaborationInfo().getAction());
                busta.addProperty("ebmsUserMessageCollaborationInfoConversationId", userMessage.getCollaborationInfo().getConversationId());
            }
            if (userMessage.getMessageInfo() != null) {
                busta.addProperty("ebmsUserMessageId", userMessage.getMessageInfo().getMessageId());
                busta.addProperty("ebmsUserMessageRefToMessageId", userMessage.getMessageInfo().getRefToMessageId());
            }
            if (userMessage.getMessageProperties() != null && userMessage.getMessageProperties().sizePropertyList() > 0) {
                for (Property p : userMessage.getMessageProperties().getPropertyList()) {
                    busta.addProperty("ebmsUserMessageProperty_" + p.getName(), p.getBase());
                }
            }
        }
    }

    public Busta getBusta_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        try {
            if (msg == null) {
                return null;
            }
            Object o = msg.getContextProperty(AS4Costanti.AS4_CONTEXT_USER_MESSAGE);
            if (o == null) {
                return null;
            }
            if (!(o instanceof UserMessage)) {
                return null;
            }
            UserMessage userMessage = (UserMessage)o;
            RequestInfo requestInfo = null;
            if (this.context != null && this.context.containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)this.context.getObject(Costanti.REQUEST_INFO);
            }
            IRegistryReader registryReader = this.getProtocolFactory().getCachedRegistryReader(this.state, requestInfo);
            Busta busta = new Busta("as4");
            IDSoggetto idMittente = null;
            IDSoggetto idDestinatario = null;
            if (userMessage != null) {
                this._fillBusta(userMessage, busta);
            }
            if (userMessage.getPartyInfo() != null) {
                PartyId to;
                List list;
                ProtocolFiltroRicercaSoggetti filtroSoggetti;
                PartyId from;
                if (userMessage.getPartyInfo().getFrom() != null && userMessage.getPartyInfo().getFrom().getPartyIdList() != null && userMessage.getPartyInfo().getFrom().getPartyIdList().size() > 0 && (from = userMessage.getPartyInfo().getFrom().getPartyId(0)).getBase() != null && from.getType() != null) {
                    filtroSoggetti = new ProtocolFiltroRicercaSoggetti();
                    filtroSoggetti.setProtocolProperties(new ProtocolProperties());
                    filtroSoggetti.getProtocolProperties().addProperty("ebmsUserMessagePartyId", from.getBase());
                    list = null;
                    try {
                        list = registryReader.findIdSoggetti(filtroSoggetti);
                        if (list == null || list.size() <= 0) {
                            throw new RegistryNotFound();
                        }
                    }
                    catch (RegistryNotFound registryNotFound) {
                        // empty catch block
                    }
                    if (list != null && list.size() > 0) {
                        idMittente = (IDSoggetto)list.get(0);
                        busta.setTipoMittente(idMittente.getTipo());
                        busta.setMittente(idMittente.getNome());
                    }
                }
                if (userMessage.getPartyInfo().getTo() != null && userMessage.getPartyInfo().getTo().getPartyIdList() != null && userMessage.getPartyInfo().getTo().getPartyIdList().size() > 0 && (to = userMessage.getPartyInfo().getTo().getPartyId(0)).getBase() != null && to.getType() != null) {
                    filtroSoggetti = new ProtocolFiltroRicercaSoggetti();
                    filtroSoggetti.setProtocolProperties(new ProtocolProperties());
                    filtroSoggetti.getProtocolProperties().addProperty("ebmsUserMessagePartyId", to.getBase());
                    list = null;
                    try {
                        list = registryReader.findIdSoggetti(filtroSoggetti);
                        if (list == null || list.size() <= 0) {
                            throw new RegistryNotFound();
                        }
                    }
                    catch (RegistryNotFound registryNotFound) {
                        // empty catch block
                    }
                    if (list != null && list.size() > 0) {
                        idDestinatario = (IDSoggetto)list.get(0);
                        busta.setTipoDestinatario(idDestinatario.getTipo());
                        busta.setDestinatario(idDestinatario.getNome());
                    }
                }
            }
            if (idMittente == null || idDestinatario == null) {
                return null;
            }
            IDServizio idServizio = null;
            IDAccordo idAccordo = null;
            AccordoServizioParteComune aspc = null;
            if (userMessage.getCollaborationInfo() != null) {
                if (userMessage.getCollaborationInfo().getService() != null && userMessage.getCollaborationInfo().getService().getBase() != null) {
                    ProtocolFiltroRicercaAccordi filtroAccordi = new ProtocolFiltroRicercaAccordi();
                    filtroAccordi.setProtocolProperties(new ProtocolProperties());
                    filtroAccordi.getProtocolProperties().addProperty("ebmsUserMessageCollaborationInfoService", userMessage.getCollaborationInfo().getService().getBase());
                    filtroAccordi.getProtocolProperties().addProperty("ebmsUserMessageCollaborationInfoServiceType", userMessage.getCollaborationInfo().getService().getType());
                    Object listAccordi = null;
                    try {
                        listAccordi = registryReader.findIdAccordiServizioParteComune(filtroAccordi);
                        if (listAccordi == null || listAccordi.size() <= 0) {
                            throw new RegistryNotFound();
                        }
                    }
                    catch (RegistryNotFound registryNotFound) {
                        // empty catch block
                    }
                    if (listAccordi != null && listAccordi.size() > 0) {
                        idAccordo = (IDAccordo)listAccordi.get(0);
                        aspc = registryReader.getAccordoServizioParteComune(idAccordo, false, false);
                        ProtocolFiltroRicercaServizi filtroServizi = new ProtocolFiltroRicercaServizi();
                        filtroServizi.setIdAccordoServizioParteComune(idAccordo);
                        filtroServizi.setSoggettoErogatore(idDestinatario);
                        Object listServizi = null;
                        try {
                            listServizi = registryReader.findIdAccordiServizioParteSpecifica(filtroServizi);
                            if (listServizi == null || listServizi.size() <= 0) {
                                throw new RegistryNotFound();
                            }
                        }
                        catch (RegistryNotFound registryNotFound) {
                            // empty catch block
                        }
                        if (listServizi != null && listServizi.size() > 0) {
                            idServizio = (IDServizio)listServizi.get(0);
                            busta.setTipoServizio(idServizio.getTipo());
                            busta.setServizio(idServizio.getNome());
                            busta.setVersioneServizio(idServizio.getVersione());
                        }
                    }
                }
                if (userMessage.getCollaborationInfo().getAction() != null) {
                    String as4Action = userMessage.getCollaborationInfo().getAction();
                    if (aspc != null) {
                        if (ServiceBinding.REST.equals((Object)aspc.getServiceBinding())) {
                            block10: for (Resource resource : aspc.getResourceList()) {
                                if (resource.sizeProtocolPropertyList() <= 0) continue;
                                for (ProtocolProperty pp : resource.getProtocolPropertyList()) {
                                    if (!"ebmsUserMessageCollaborationInfoAction".equals(pp.getName()) || !as4Action.equals(pp.getValue())) continue;
                                    busta.setAzione(resource.getNome());
                                    continue block10;
                                }
                            }
                        } else {
                            AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio, false);
                            if (asps.getPortType() != null) {
                                for (PortType pt : aspc.getPortTypeList()) {
                                    block13: for (Operation azione : pt.getAzioneList()) {
                                        if (azione.sizeProtocolPropertyList() <= 0) continue;
                                        for (ProtocolProperty pp : azione.getProtocolPropertyList()) {
                                            if (!"ebmsUserMessageCollaborationInfoAction".equals(pp.getName()) || !as4Action.equals(pp.getValue())) continue;
                                            busta.setAzione(azione.getNome());
                                            continue block13;
                                        }
                                    }
                                }
                            } else {
                                block15: for (Azione azione : aspc.getAzioneList()) {
                                    if (azione.sizeProtocolPropertyList() <= 0) continue;
                                    for (ProtocolProperty pp : azione.getProtocolPropertyList()) {
                                        if (!"ebmsUserMessageCollaborationInfoAction".equals(pp.getName()) || !as4Action.equals(pp.getValue())) continue;
                                        busta.setAzione(azione.getNome());
                                        continue block15;
                                    }
                                }
                            }
                        }
                    }
                }
                if (userMessage.getCollaborationInfo().getConversationId() != null) {
                    String as4ConversationId = userMessage.getCollaborationInfo().getConversationId();
                    busta.setCollaborazione(as4ConversationId);
                }
            }
            if (userMessage.getMessageInfo() != null) {
                if (userMessage.getMessageInfo().getMessageId() != null) {
                    String as4MessageId = userMessage.getMessageInfo().getMessageId();
                    busta.setID(as4MessageId);
                }
                if (userMessage.getMessageInfo().getRefToMessageId() != null) {
                    String as4RefToMessageId = userMessage.getMessageInfo().getRefToMessageId();
                    busta.setRiferimentoMessaggio(as4RefToMessageId);
                }
            }
            return busta;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

