/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.batch;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.pdd.core.batch.AbstractGestore;
import org.openspcoop2.pdd.core.batch.GeneratorProperties;
import org.openspcoop2.pdd.core.batch.GestoreBuste;
import org.openspcoop2.pdd.core.batch.GestoreMessaggi;
import org.openspcoop2.pdd.core.batch.TipoRuntimeRepository;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.slf4j.Logger;

public class Generator {
    private static final String LOGGER_PREFIX = "govway.batch.runtime_repository.";

    public static void main(String[] args) throws UtilsException {
        StringBuilder bf = new StringBuilder();
        String[] tipi = TipoRuntimeRepository.toStringArray();
        if (tipi != null) {
            for (String t : tipi) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(t);
            }
        }
        String usage = "\n\nUse: generator.sh tipo\n\ttipo: " + bf.toString();
        if (args.length <= 0) {
            throw new UtilsException("ERROR: tipo gestore non fornito" + usage);
        }
        String tipo = args[0].trim();
        TipoRuntimeRepository tipoGestoreArg = null;
        try {
            tipoGestoreArg = TipoRuntimeRepository.toEnumConstant(tipo, true);
        }
        catch (Exception e) {
            throw new UtilsException("ERROR: tipo gestore fornito (" + tipo + ") sconosciuto" + usage);
        }
        ArrayList<TipoRuntimeRepository> listTipiDaProcessare = new ArrayList<TipoRuntimeRepository>();
        if (TipoRuntimeRepository.ALL.equals(tipoGestoreArg)) {
            listTipiDaProcessare.add(TipoRuntimeRepository.MESSAGGI);
            listTipiDaProcessare.add(TipoRuntimeRepository.BUSTE);
        } else {
            listTipiDaProcessare.add(tipoGestoreArg);
        }
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(Generator.class.getResource("/batch-runtime-repository.log4j2.properties").getFile());){
                props.load(fis);
                PropertiesEnvUtils.resolveGovWayEnvVariables((Properties)props);
                LoggerWrapperFactory.setDefaultConsoleLogConfiguration((Level)Level.ERROR);
                LoggerWrapperFactory.setLogConfiguration((Properties)props);
            }
        }
        catch (Exception e) {
            throw new UtilsException("Impostazione logging fallita: " + e.getMessage());
        }
        TipoRuntimeRepository tipoGestoreDefault = null;
        tipoGestoreDefault = listTipiDaProcessare != null && !listTipiDaProcessare.isEmpty() ? (TipoRuntimeRepository)listTipiDaProcessare.get(0) : TipoRuntimeRepository.MESSAGGI;
        Logger logStartup = LoggerWrapperFactory.getLogger((String)(LOGGER_PREFIX + tipoGestoreDefault.getValue() + ".error"));
        GeneratorProperties generatorProperties = GeneratorProperties.getInstance(logStartup);
        if (generatorProperties.isMessaggiDebug()) {
            logStartup = LoggerWrapperFactory.getLogger((String)(LOGGER_PREFIX + tipoGestoreDefault.getValue()));
        }
        try {
            String mapConfig = generatorProperties.getEnvMapConfig();
            if (StringUtils.isNotEmpty((String)mapConfig)) {
                logStartup.info("Inizializzazione environment in corso...");
                MapProperties.initialize((Logger)logStartup, (String)mapConfig, (boolean)generatorProperties.isEnvMapConfigRequired());
                MapProperties mapProperties = MapProperties.getInstance();
                mapProperties.initEnvironment();
                String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + mapProperties.getJavaMap().keys() + "\n\tEnvProperties: " + mapProperties.getEnvMap().keys() + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + mapProperties.getObfuscatedJavaKeys() + "\n\tObfuscatedEnvKeys: " + mapProperties.getObfuscatedEnvKeys();
                logStartup.info(msgInit);
            }
        }
        catch (Exception e) {
            Generator.doError(logStartup, "Errore durante l'inizializzazione dell'ambiente", e);
        }
        logStartup.info("Inizializzazione security provider...");
        try {
            if (generatorProperties.isSecurityLoadBouncyCastleProvider()) {
                ProviderUtils.addBouncyCastleAfterSun((boolean)true);
                logStartup.info("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
            }
        }
        catch (Exception e) {
            Generator.doError(logStartup, "Errore durante l'inizializzazione dei security provider", e);
        }
        logStartup.info("Inizializzazione security provider effettuata con successo");
        try {
            String hsmConfig = generatorProperties.getHSMConfigurazione();
            if (StringUtils.isNotEmpty((String)hsmConfig)) {
                logStartup.info("Inizializzazione HSM in corso...");
                File f = new File(hsmConfig);
                HSMManager.init((File)f, (boolean)generatorProperties.isHSMRequired(), (Logger)logStartup, (boolean)false);
                HSMUtils.setHsmConfigurableKeyPassword((boolean)generatorProperties.isHSMKeyPasswordConfigurable());
                logStartup.info("Inizializzazione HSM effettuata con successo");
            }
        }
        catch (Exception e) {
            Generator.doError(logStartup, "Errore durante l'inizializzazione del manager HSM", e);
        }
        BYOKManager byokManager = null;
        try {
            String byokConfig = generatorProperties.getBYOKConfigurazione();
            if (StringUtils.isNotEmpty((String)byokConfig)) {
                logStartup.info("Inizializzazione BYOK in corso...");
                File f = new File(byokConfig);
                BYOKManager.init((File)f, (boolean)generatorProperties.isBYOKRequired(), (Logger)logStartup);
                byokManager = BYOKManager.getInstance();
                String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + byokManager.getKeystoreTypes() + "\n\tSecurityEngine registrati: " + byokManager.getSecurityEngineTypes() + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
                logStartup.info(msgInit);
            }
        }
        catch (Exception e) {
            Generator.doError(logStartup, "Errore durante l'inizializzazione del manager BYOK", e);
        }
        try {
            String secretsConfig = generatorProperties.getBYOKEnvSecretsConfig();
            if (byokManager != null && StringUtils.isNotEmpty((String)secretsConfig)) {
                logStartup.info("Inizializzazione secrets in corso...");
                HashMap dynamicMap = new HashMap();
                DynamicInfo dynamicInfo = new DynamicInfo();
                DynamicUtils.fillDynamicMap((Logger)logStartup, dynamicMap, (DynamicInfo)dynamicInfo);
                BYOKMapProperties.initialize((Logger)logStartup, (String)secretsConfig, (boolean)generatorProperties.isBYOKEnvSecretsConfigRequired(), (boolean)true, dynamicMap, (boolean)true);
                BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                secretsProperties.initEnvironment();
                String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + secretsProperties.getJavaMap().keys() + "\n\tEnvProperties: " + secretsProperties.getEnvMap().keys() + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                logStartup.info(msgInit);
            }
        }
        catch (Exception e) {
            Generator.doError(logStartup, "Errore durante l'inizializzazione dell'ambiente (secrets)", e);
        }
        generatorProperties.initProperties();
        int refreshConnection = generatorProperties.getRefreshConnessione();
        int scadenzaMessaggi = generatorProperties.getScadenzaMessaggiMinuti();
        String tipoRepositoryBuste = generatorProperties.getRepositoryBuste();
        boolean useDataRegistrazione = generatorProperties.isUseDataRegistrazione();
        boolean debug = generatorProperties.isMessaggiDebug();
        boolean logQuery = generatorProperties.isMessaggiLogQuery();
        int finestraSecondi = generatorProperties.getMessaggiFinestraSecondi();
        for (TipoRuntimeRepository tipoGestore : listTipiDaProcessare) {
            Logger logCore = null;
            Logger logSql = null;
            logCore = debug ? LoggerWrapperFactory.getLogger((String)(LOGGER_PREFIX + tipoGestore.getValue())) : LoggerWrapperFactory.getLogger((String)(LOGGER_PREFIX + tipoGestore.getValue() + ".error"));
            logSql = logQuery ? LoggerWrapperFactory.getLogger((String)(LOGGER_PREFIX + tipoGestore.getValue() + ".sql")) : LoggerWrapperFactory.getLogger((String)(LOGGER_PREFIX + tipoGestore.getValue() + ".sql.error"));
            try {
                ConfigurazionePdD configPdD = new ConfigurazionePdD();
                configPdD.setAttesaAttivaJDBC(-1L);
                configPdD.setCheckIntervalJDBC(-1);
                configPdD.setLoader(new Loader(Generator.class.getClassLoader()));
                configPdD.setLog(logCore);
                ProtocolFactoryManager.initialize((Logger)logCore, (ConfigurazionePdD)configPdD, (String)generatorProperties.getProtocolloDefault());
                DateManager.initializeDataManager((String)SystemDate.class.getName(), (Properties)new Properties(), (Logger)LoggerWrapperFactory.getLogger(Generator.class));
            }
            catch (Exception e) {
                throw new UtilsException("Errore durante la gestione del repository '" + tipoGestore + "' (InitConfigurazione - ProtocolFactoryManager): " + e.getMessage(), (Throwable)e);
            }
            try {
                switch (tipoGestore) {
                    case MESSAGGI: {
                        AbstractGestore gestore = new GestoreMessaggi(debug, logQuery, logCore, logSql, finestraSecondi, refreshConnection, (Integer)scadenzaMessaggi, tipoRepositoryBuste);
                        ((GestoreMessaggi)gestore).process();
                        break;
                    }
                    case BUSTE: {
                        AbstractGestore gestore = new GestoreBuste(debug, logQuery, logCore, logSql, finestraSecondi, refreshConnection, tipoRepositoryBuste, useDataRegistrazione);
                        ((GestoreBuste)gestore).process();
                        break;
                    }
                    case ALL: {
                        throw new UtilsException("Tipo '" + tipoGestore + "' non supportato");
                    }
                }
            }
            catch (Exception e) {
                throw new UtilsException("Errore durante la gestione del repository '" + tipoGestore + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void doError(Logger logCore, String msg, Exception e) throws UtilsException {
        String msgErrore = msg + ": " + e.getMessage();
        logCore.error(msgErrore, (Throwable)e);
        throw new UtilsException(msgErrore, (Throwable)e);
    }
}

