/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.event.PhaseId;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UICalendar;
import org.richfaces.component.util.ComponentUtil;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.context.RequestContext;
import org.richfaces.event.CurrentDateChangeEvent;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarRendererBase
extends TemplateEncoderRendererBase {
    private static final String MARKUP_PARAMETER_SUFFIX = "Markup";
    protected static final String MONTH_LABELS_SHORT = "monthLabelsShort";
    protected static final String MONTH_LABELS = "monthLabels";
    protected static final String WEEK_DAY_LABELS_SHORT = "weekDayLabelsShort";
    protected static final String WEEK_DAY_LABELS = "weekDayLabels";
    private static String HOURS_VALUE = "hours";
    private static String MINUTES_VALUE = "minutes";
    public static final String CURRENT_DATE_INPUT = "InputCurrentDate";
    public static final String CURRENT_DATE_PRELOAD = "PreloadCurrentDate";
    public static final String CALENDAR_BUNDLE = "org.richfaces.renderkit.calendar";
    private static final String LOCALES_KEY = "rich:locales";
    private static final Log log = LogFactory.getLog(CalendarRendererBase.class);

    protected Class<? extends UIComponent> getComponentClass() {
        return UICalendar.class;
    }

    public void addPopupToAjaxRendered(FacesContext context, UICalendar component) {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        Set ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
        String clientId = component.getClientId(context);
        if (ajaxContext.isAjaxRequest() && ajaxRenderedAreas.contains(clientId)) {
            ajaxRenderedAreas.add(clientId + "Popup");
            ajaxRenderedAreas.add(clientId + "IFrame");
            ajaxRenderedAreas.add(clientId + "Script");
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Class converterType;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (submittedValue instanceof Date) {
            return (Date)submittedValue;
        }
        String newValue = (String)submittedValue;
        ValueExpression valueExpression = component.getValueExpression("value");
        Converter converter = null;
        UICalendar calendar = (UICalendar)component;
        converter = calendar.getConverter();
        if (converter == null && valueExpression != null && (converterType = valueExpression.getType(context.getELContext())) != null && converterType != Object.class) {
            converter = this.getConverterForClass(converterType, context);
        }
        if (converter == null) {
            converter = CalendarRendererBase.createDefaultConverter();
        }
        CalendarRendererBase.setupDefaultConverter(converter, calendar);
        return converter.getAsObject(context, component, newValue);
    }

    private Converter getConverterForClass(Class<? extends Object> converterClass, FacesContext context) {
        if (converterClass == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> getPreparedDefaultTime(UICalendar component) {
        Date date = component.getFormattedDefaultTime();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (date != null) {
            Calendar calendar = component.getCalendar();
            calendar.setTime(date);
            int hours = calendar.get(11);
            int minutes = calendar.get(12);
            if (hours != 12 || minutes != 0) {
                result.put(HOURS_VALUE, hours);
                result.put(MINUTES_VALUE, minutes);
            }
        }
        return result;
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue, Converter converter) throws ConverterException {
        if (!(component instanceof UICalendar)) {
            if (currentValue != null) {
                return currentValue.toString();
            }
            return null;
        }
        UICalendar calendar = (UICalendar)component;
        if (currentValue == null) {
            return "";
        }
        if (converter == null) {
            converter = calendar.getConverter();
        }
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = this.getConverterForClass(converterType, context);
            if (converter == null) {
                converter = CalendarRendererBase.createDefaultConverter();
            }
        }
        CalendarRendererBase.setupDefaultConverter(converter, calendar);
        return converter.getAsString(context, (UIComponent)calendar, currentValue);
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return this.getFormattedValue(context, component, currentValue, null);
    }

    protected static Converter createDefaultConverter() {
        return new DateTimeConverter();
    }

    protected static Converter setupDefaultConverter(Converter converter, UICalendar calendar) {
        if (converter == null) {
            return null;
        }
        if (converter instanceof DateTimeConverter) {
            DateTimeConverter defaultConverter = (DateTimeConverter)converter;
            defaultConverter.setPattern(calendar.getDatePattern());
            defaultConverter.setLocale(calendar.getAsLocale(calendar.getLocale()));
            defaultConverter.setTimeZone(calendar.getTimeZone());
        }
        return converter;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String selectedDateString;
        if (((UICalendar)component).isDisabled()) {
            return;
        }
        super.doDecode(context, component);
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String currentDateString = (String)requestParameterMap.get(clientId + CURRENT_DATE_INPUT);
        if (currentDateString != null) {
            CurrentDateChangeEvent ev = new CurrentDateChangeEvent(component, currentDateString);
            ev.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
            ev.queue();
        }
        if (requestParameterMap.get(clientId + CURRENT_DATE_PRELOAD) != null) {
            new AjaxEvent(component).queue();
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
            if (ajaxContext.isAjaxRequest(context)) {
                ajaxContext.addAreasToProcessFromComponent(context, component);
            }
        }
        if ((selectedDateString = (String)requestParameterMap.get(clientId + "InputDate")) != null) {
            ((UICalendar)component).setSubmittedValue(selectedDateString);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent calendar) throws IOException {
    }

    public JSReference getIsDayEnabled(FacesContext context, UIComponent component) {
        UICalendar calendar = (UICalendar)component;
        String isDayEnabled = (String)calendar.getAttributes().get("isDayEnabled");
        if (isDayEnabled != null && isDayEnabled.length() != 0) {
            return new JSReference(isDayEnabled);
        }
        return null;
    }

    public JSReference getDayStyleClass(FacesContext context, UIComponent component) {
        UICalendar calendar = (UICalendar)component;
        String dayStyleClass = (String)calendar.getAttributes().get("dayStyleClass");
        if (dayStyleClass != null && dayStyleClass.length() != 0) {
            return new JSReference(dayStyleClass);
        }
        return null;
    }

    public String getMarkupScriptBody(FacesContext context, UIComponent component, boolean children) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringWriter dumpingWriter = new StringWriter();
        ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)dumpingWriter);
        context.setResponseWriter(clonedWriter);
        this.writeScriptBody(context, component, children);
        clonedWriter.flush();
        context.setResponseWriter(writer);
        return ((Object)dumpingWriter).toString();
    }

    public String getOptionalFacetMarkupScriptBody(FacesContext context, UIComponent component, String facetName) throws IOException {
        UIComponent facet = component.getFacet(facetName);
        if (facet != null && facet.isRendered()) {
            return this.getMarkupScriptBody(context, facet, false);
        }
        return null;
    }

    public void dayCellClass(FacesContext context, UIComponent component) throws IOException {
        String cellwidth = (String)component.getAttributes().get("cellWidth");
        String cellheight = (String)component.getAttributes().get("cellHeight");
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String divStyle = "";
        if (cellwidth != null && cellwidth.length() != 0) {
            divStyle = cellwidth.contains("px") || cellwidth.contains("%") ? divStyle + "width:" + cellwidth + ";" : divStyle + "width:" + cellwidth + "px;";
        }
        if (cellheight != null && cellheight.length() != 0) {
            divStyle = cellheight.contains("px") || cellheight.contains("%") ? divStyle + "height:" + cellheight.toString() + ";" : divStyle + "height:" + cellheight.toString() + "px;";
        }
        if (divStyle.length() != 0) {
            writer.startElement("style", component);
            this.getUtils().writeAttribute(writer, "type", (Object)"text/css");
            writer.writeText((Object)("." + clientId.replace(':', '_') + "DayCell{" + divStyle + "}"), null);
            writer.endElement("style");
        }
    }

    public String getDayCellClass(FacesContext context, UIComponent component) {
        String cellwidth = (String)component.getAttributes().get("cellWidth");
        String cellheight = (String)component.getAttributes().get("cellHeight");
        if (cellwidth != null && cellwidth.length() != 0 || cellheight != null && cellheight.length() != 0) {
            String clientId = component.getClientId(context);
            String value = clientId.replace(':', '_') + "DayCell";
            return value;
        }
        return null;
    }

    public void writeFacetMarkup(FacesContext context, UIComponent component) throws IOException {
        HashMap<String, JSLiteral> jsonMap = new HashMap<String, JSLiteral>();
        if (component.getChildCount() != 0) {
            String markupScriptBody = this.getMarkupScriptBody(context, component, true);
            jsonMap.put("dayListMarkup", new JSLiteral(markupScriptBody));
        }
        this.addFacetMarkupScriptBody(context, component, jsonMap, "optionalHeader");
        this.addFacetMarkupScriptBody(context, component, jsonMap, "optionalFooter");
        this.addFacetMarkupScriptBody(context, component, jsonMap, "weekDay");
        this.addFacetMarkupScriptBody(context, component, jsonMap, "weekNumber");
        this.addFacetMarkupScriptBody(context, component, jsonMap, "header");
        this.addFacetMarkupScriptBody(context, component, jsonMap, "footer");
        context.getResponseWriter().writeText((Object)ScriptUtils.toScript(jsonMap), null);
    }

    private void addFacetMarkupScriptBody(FacesContext context, UIComponent component, Map<String, JSLiteral> jsonMap, String facetName) throws IOException {
        String res = this.getOptionalFacetMarkupScriptBody(context, component, facetName);
        if (res != null) {
            jsonMap.put(facetName + MARKUP_PARAMETER_SUFFIX, new JSLiteral(res));
        }
    }

    public void writePreloadBody(FacesContext context, UICalendar calendar) throws IOException {
        Object preload = calendar.getPreload();
        if (preload != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)ScriptUtils.toScript((Object)preload), null);
        }
    }

    public Object getSubmitFunction(FacesContext context, UICalendar calendar) throws IOException {
        if (!"ajax".equals(calendar.getAttributes().get("mode"))) {
            return null;
        }
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)calendar, (FacesContext)context, (String)"A4J.AJAX.Submit");
        ajaxFunction.addParameter((Object)JSReference.NULL);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(calendar.getClientId(context) + CURRENT_DATE_PRELOAD, Boolean.TRUE);
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)calendar, params, (boolean)true);
        options.put("calendar", JSReference.THIS);
        String oncomplete = AjaxRendererUtils.getAjaxOncomplete((UIComponent)calendar);
        JSFunctionDefinition oncompleteDefinition = new JSFunctionDefinition(new Object[0]);
        oncompleteDefinition.addParameter((Object)"request");
        oncompleteDefinition.addParameter((Object)"event");
        oncompleteDefinition.addParameter((Object)"data");
        oncompleteDefinition.addToBody((Object)"this.calendar.load(data, true);");
        if (oncomplete != null) {
            oncompleteDefinition.addToBody((Object)oncomplete);
        }
        options.put("oncomplete", oncompleteDefinition);
        JSReference requestValue = new JSReference("requestValue");
        ajaxFunction.addParameter((Object)options);
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[0]);
        definition.addParameter((Object)requestValue);
        definition.addToBody((Object)ajaxFunction);
        return definition;
    }

    public String getInputValue(FacesContext context, UIComponent component) {
        UICalendar calendar = (UICalendar)component;
        String returnValue = null;
        Object value = calendar.getSubmittedValue();
        if (value != null) {
            try {
                returnValue = this.getFormattedValue(context, (UIComponent)calendar, value);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" InputValue: " + e.toString()), (Throwable)e);
                }
                returnValue = (String)value;
            }
        } else {
            returnValue = this.getFormattedValue(context, (UIComponent)calendar, calendar.getValue());
        }
        return returnValue;
    }

    public void writeDefaultSymbols(FacesContext facesContext, UICalendar calendar) throws IOException {
        String locale;
        RequestContext context = RequestContext.getInstance((FacesContext)facesContext);
        HashSet<String> locales = (HashSet<String>)context.getAttribute(LOCALES_KEY);
        if (locales == null) {
            locales = new HashSet<String>(1);
            context.setAttribute(LOCALES_KEY, locales);
        }
        if (!locales.contains(locale = calendar.getAsLocale().toString())) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.writeText((Object)("Richfaces.Calendar.addLocale('" + locale + "', "), null);
            writer.writeText((Object)ScriptUtils.toScript(this.getDefaultSymbolsMap(calendar)), null);
            writer.writeText((Object)");\n", null);
            locales.add(locale);
        }
    }

    private static String[] shiftDates(int minimum, int maximum, String[] labels) {
        if (minimum == 0 && maximum - minimum == labels.length - 1) {
            return labels;
        }
        String[] shiftedLabels = new String[maximum - minimum + 1];
        System.arraycopy(labels, minimum, shiftedLabels, 0, maximum - minimum + 1);
        return shiftedLabels;
    }

    protected Map<String, Object> getSymbolsMap(FacesContext facesContext, UICalendar calendar) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        RendererUtils utils = this.getUtils();
        utils.addToScriptHash(map, WEEK_DAY_LABELS, (Object)ComponentUtil.asArray((Object)calendar.getWeekDayLabels()));
        utils.addToScriptHash(map, WEEK_DAY_LABELS_SHORT, (Object)ComponentUtil.asArray((Object)calendar.getWeekDayLabelsShort()));
        utils.addToScriptHash(map, MONTH_LABELS, (Object)ComponentUtil.asArray((Object)calendar.getMonthLabels()));
        utils.addToScriptHash(map, MONTH_LABELS_SHORT, (Object)ComponentUtil.asArray((Object)calendar.getMonthLabelsShort()));
        int day = calendar.getFirstWeekDay();
        if (0 <= day && day <= 6) {
            utils.addToScriptHash(map, "firstWeekDay", (Object)day);
        } else if (day != Integer.MIN_VALUE) {
            facesContext.getExternalContext().log(day + " value of firstWeekDay attribute is not a legal one for component: " + MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)calendar) + ". Default value was applied.");
        }
        return map;
    }

    protected Map<String, Object> getDefaultSymbolsMap(UICalendar calendar) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Locale locale = calendar.getAsLocale();
        Calendar cal = calendar.getCalendar();
        int maximum = cal.getActualMaximum(7);
        int minimum = cal.getActualMinimum(7);
        int monthMax = cal.getActualMaximum(2);
        int monthMin = cal.getActualMinimum(2);
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String[] weekDayLabels = symbols.getWeekdays();
        weekDayLabels = CalendarRendererBase.shiftDates(minimum, maximum, weekDayLabels);
        String[] weekDayLabelsShort = symbols.getShortWeekdays();
        weekDayLabelsShort = CalendarRendererBase.shiftDates(minimum, maximum, weekDayLabelsShort);
        String[] monthLabels = symbols.getMonths();
        monthLabels = CalendarRendererBase.shiftDates(monthMin, monthMax, monthLabels);
        String[] monthLabelsShort = symbols.getShortMonths();
        monthLabelsShort = CalendarRendererBase.shiftDates(monthMin, monthMax, monthLabelsShort);
        map.put(WEEK_DAY_LABELS, weekDayLabels);
        map.put(WEEK_DAY_LABELS_SHORT, weekDayLabelsShort);
        map.put(MONTH_LABELS, monthLabels);
        map.put(MONTH_LABELS_SHORT, monthLabelsShort);
        map.put("minDaysInFirstWeek", cal.getMinimalDaysInFirstWeek());
        map.put("firstWeekDay", cal.getFirstDayOfWeek() - cal.getActualMinimum(7));
        return map;
    }

    public String getCurrentDateAsString(FacesContext context, UICalendar calendar, Date date) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/yyyy");
        return formatter.format((Object)date);
    }

    public Object getCurrentDate(FacesContext context, UICalendar calendar, Date date) throws IOException {
        return CalendarRendererBase.formatDate(date);
    }

    public Object getSelectedDate(FacesContext context, UICalendar calendar) throws IOException {
        Object value;
        Date date;
        Object returnValue = null;
        if (calendar.isValid() && (date = calendar.getAsDate(value = calendar.getValue())) != null) {
            returnValue = CalendarRendererBase.formatSelectedDate(calendar.getTimeZone(), date);
        }
        return returnValue;
    }

    public static Object formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        JSFunction result = new JSFunction("new Date", new Object[0]);
        result.addParameter((Object)calendar.get(1));
        result.addParameter((Object)calendar.get(2));
        result.addParameter((Object)calendar.get(5));
        return result;
    }

    public static Object formatSelectedDate(TimeZone timeZone, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        JSFunction result = new JSFunction("new Date", new Object[0]);
        result.addParameter((Object)calendar.get(1));
        result.addParameter((Object)calendar.get(2));
        result.addParameter((Object)calendar.get(5));
        result.addParameter((Object)calendar.get(11));
        result.addParameter((Object)calendar.get(12));
        result.addParameter((Object)new Integer(0));
        return result;
    }

    public Map<String, Object> getLabels(FacesContext context, UICalendar calendar) {
        ResourceBundle bundle1 = null;
        ResourceBundle bundle2 = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String messageBundle = context.getApplication().getMessageBundle();
        Object locale = calendar.getLocale();
        if (null != messageBundle) {
            bundle1 = ResourceBundle.getBundle(messageBundle, calendar.getAsLocale(locale), loader);
        }
        try {
            bundle2 = ResourceBundle.getBundle(CALENDAR_BUNDLE, calendar.getAsLocale(locale), loader);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        HashMap<String, Object> labels = new HashMap<String, Object>();
        if (null != bundle1 || null != bundle2) {
            String[] names = new String[]{"apply", "today", "clean", "cancel", "ok", "close"};
            RendererUtils utils = this.getUtils();
            for (String name : names) {
                String label = null;
                String bundleKey = "RICH_CALENDAR_" + name.toUpperCase() + "_LABEL";
                if (bundle1 != null) {
                    try {
                        label = bundle1.getString(bundleKey);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                if (label == null && bundle2 != null) {
                    try {
                        label = bundle2.getString(bundleKey);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                utils.addToScriptHash(labels, name, (Object)label);
            }
        }
        return labels;
    }
}

