/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.util.InputUtils;
import org.richfaces.component.UIEditor;
import org.richfaces.renderkit.InputRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorRendererBase
extends InputRendererBase {
    private static final String SPECIFIC_SCRIPT_RESOURCE_NAME = "org/richfaces/renderkit/html/1$1.js";
    private static final String SPECIFIC_XCSS_RESOURCE_NAME = "org/richfaces/renderkit/html/1$1.xcss";
    private static final String TINY_MCE_DISABLED_MODE = "source";

    protected Class<? extends UIComponent> getComponentClass() {
        return UIEditor.class;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return InputUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context) + "TextArea";
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(clientId);
        if (null != newValue) {
            UIInput input = (UIInput)component;
            input.setSubmittedValue((Object)newValue);
        }
    }

    protected String getFormattedComponentStringValue(FacesContext context, UIEditor component) {
        String fieldValue = (String)component.getSubmittedValue();
        if (fieldValue == null) {
            fieldValue = InputUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Object)component.getValue());
        }
        return fieldValue;
    }

    protected String getSriptMappingSuffix(FacesContext context) {
        return this.getResourceSuffix(context, SPECIFIC_SCRIPT_RESOURCE_NAME);
    }

    protected String getCssMappingSuffix(FacesContext context) {
        return this.getResourceSuffix(context, SPECIFIC_XCSS_RESOURCE_NAME);
    }

    private String getResourceSuffix(FacesContext context, String resourceName) {
        InternetResource resource = this.getResource(resourceName);
        String resourceUri = resource.getUri(context, null);
        String suffix = resourceUri.substring(resourceUri.indexOf(resourceName) + resourceName.length());
        return suffix;
    }

    public void writeEditorConfigurationParameters(FacesContext context, UIEditor component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)"var tinyMceParams = ", null);
        String parametersConfigName = component.getConfiguration();
        if (parametersConfigName != null && parametersConfigName.length() > 0) {
            this.loadPropertiesAndWrite(context, parametersConfigName, writer, false);
        } else {
            writer.writeText((Object)"{};\n", null);
        }
    }

    public void writeEditorCustomPluginsParameters(FacesContext context, UIEditor component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String customPluginsConfigName = component.getCustomPlugins();
        if (customPluginsConfigName != null && customPluginsConfigName.length() > 0) {
            this.loadPropertiesAndWrite(context, customPluginsConfigName, writer, true);
        }
    }

    private void loadPropertiesAndWrite(FacesContext context, String configName, ResponseWriter writer, boolean cutomPlugins) {
        Properties parameters = new Properties();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(configName + ".properties");
            InputStream is = URLToStreamHelper.urlToStream((URL)url);
            if (is == null) {
                throw new FacesException("Editor configuration properties file with name '" + configName + "' was not found in class path");
            }
            try {
                parameters.load(is);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                is.close();
            }
            writer.writeText((Object)"\n", null);
            if (cutomPlugins) {
                writer.writeText((Object)this.getCustomPluginsCode(context, parameters), null);
            } else {
                writer.writeText((Object)this.convertProperties(parameters), null);
            }
            writer.writeText((Object)";\n", null);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private String convertProperties(Map map) {
        StringBuilder ret = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry entry : map.entrySet()) {
            if (!first) {
                ret.append(",\n");
            }
            ret.append(entry.getKey());
            ret.append(":");
            ret.append(entry.getValue());
            first = false;
        }
        return ret.append("} ").toString();
    }

    private String getCustomPluginsCode(FacesContext context, Map map) {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            ret.append("tinymce.PluginManager.load('");
            ret.append(entry.getKey());
            ret.append("','");
            ret.append(context.getExternalContext().getRequestContextPath() + entry.getValue());
            ret.append("',null,{richfaces:true});");
        }
        return ret.toString();
    }

    public void writeEditorConfigurationAttributes(FacesContext context, UIEditor component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String theme = component.getTheme();
        String language = component.getLanguage();
        String plugins = component.getPlugins();
        String oninit = component.getOninit();
        String onsave = component.getOnsave();
        String onchange = component.getOnchange();
        String onsetup = component.getOnsetup();
        String dialogType = component.getDialogType();
        String skin = component.getSkin();
        Integer width = component.getWidth();
        Integer height = component.getHeight();
        if (theme != null && theme.length() > 0) {
            writer.writeText((Object)("tinyMceParams.theme = " + ScriptUtils.toScript((Object)theme) + ";\n"), null);
        }
        if (language != null && language.length() > 0) {
            writer.writeText((Object)("tinyMceParams.language = " + ScriptUtils.toScript((Object)language) + ";\n"), null);
        }
        writer.writeText((Object)("tinyMceParams.auto_resize = " + ScriptUtils.toScript((Object)component.isAutoResize()) + ";\n"), null);
        writer.writeText((Object)("tinyMceParams.readonly = " + ScriptUtils.toScript((Object)component.isReadonly()) + ";\n"), null);
        if (plugins != null && plugins.length() > 0) {
            writer.writeText((Object)("tinyMceParams.plugins = " + ScriptUtils.toScript((Object)plugins) + ";\n"), null);
        }
        if (width != null) {
            writer.writeText((Object)("tinyMceParams.width = " + ScriptUtils.toScript((Object)width) + ";\n"), null);
        }
        if (height != null) {
            writer.writeText((Object)("tinyMceParams.height = " + ScriptUtils.toScript((Object)height) + ";\n"), null);
        }
        if (oninit != null && oninit.length() > 0) {
            writer.writeText((Object)("tinyMceParams.oninit = function (event) {\n" + oninit + "\n};\n"), null);
        }
        if (onsave != null && onsave.length() > 0) {
            writer.writeText((Object)("tinyMceParams.save_callback = function (event, element_id, html, body) {\n\t\treturn " + onsave + "\n};\n"), null);
        }
        if (onchange != null && onchange.length() > 0) {
            writer.writeText((Object)("tinyMceParams.onchange_callback = function (event, inst) {\n" + onchange + "\n};\n"), null);
        }
        if (onsetup != null && onsetup.length() > 0) {
            writer.writeText((Object)("tinyMceParams.setup = function (ed, event) {\n" + onsetup + "\n};\n"), null);
        }
        if (dialogType != null && dialogType.length() > 0) {
            writer.writeText((Object)("tinyMceParams.dialog_type = " + ScriptUtils.toScript((Object)dialogType) + ";\n"), null);
        }
        if (skin != null && skin.length() > 0) {
            writer.writeText((Object)("tinyMceParams.skin = " + ScriptUtils.toScript((Object)skin) + ";\n"), null);
        } else {
            writer.writeText((Object)"if(!tinyMceParams.skin){\n", null);
            writer.writeText((Object)"\ttinyMceParams.skin = 'richfaces';\n", null);
            writer.writeText((Object)"}\n", null);
        }
        writer.writeText((Object)"if(tinyMceParams.strict_loading_mode == null){\n", null);
        writer.writeText((Object)"\ttinyMceParams.strict_loading_mode = true;\n", null);
        writer.writeText((Object)"}\n", null);
    }

    public void writeEditorParameters(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List children = component.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            StringBuilder b = new StringBuilder();
            b.append("tinyMceParams.");
            ScriptUtils.addEncoded((StringBuilder)b, (Object)parameter.getName());
            b.append(" = ");
            if (parameter.getValue() != null && (parameter.getValue().equals("true") || parameter.getValue().equals("false"))) {
                ScriptUtils.addEncoded((StringBuilder)b, (Object)parameter.getValue());
            } else {
                b.append(ScriptUtils.toScript((Object)parameter.getValue()));
            }
            b.append(";\n");
            writer.writeText((Object)b.toString(), null);
        }
    }

    public boolean shouldRenderTinyMCE(UIEditor component) {
        return !TINY_MCE_DISABLED_MODE.equalsIgnoreCase(component.getViewMode());
    }

    public String getTextAreaStyle(UIEditor component) {
        StringBuilder b = new StringBuilder();
        if (component.getWidth() != null) {
            b.append("width: " + component.getWidth() + "px;");
        }
        if (component.getHeight() != null) {
            b.append("height: " + component.getHeight() + "px;");
        }
        return b.toString();
    }
}

