/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpSession;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.request.MultipartRequest;
import org.ajax4jsf.resource.CountingOutputWriter;
import org.richfaces.component.UIFileUpload;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.event.UploadAjaxActionEvent;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUploadRendererBase
extends TemplateEncoderRendererBase {
    private static final String _FILES_UPLOADED_ATTRIBUTE_NAME = "uploadData";
    private static final String FILE_UPLOAD_BUNDLE = "org.richfaces.renderkit.fileUpload";
    private static final String bundlePrefix = "RICH_FILE_UPLOAD_";
    private static final String bundlePostfix = "_LABEL";
    private static final String[] bundlesLables = new String[]{"add", "upload", "stop", "clear_all", "entry_cancel", "entry_clear", "entry_stop", "done", "size_error", "transfer_error", "progress"};
    private static final String[] defaultLables = new String[]{"Add...", "Upload", "Stop", "Clear All", "Cancel", "Clear", "Stop", "Done", "File size restricted", "Transfer error occurred", "uploading"};
    private static final String[] labelAttribues = new String[]{"addControlLabel", "uploadControlLabel", "stopControlLabel", "clearAllControlLabel", "cancelEntryControlLabel", "clearControlLabel", "stopEntryControlLabel", "doneLabel", "sizeErrorLabel", "transferErrorLabel", "progressLabel"};

    protected void doDecode(FacesContext context, UIComponent component) {
        UIFileUpload fileUpload = (UIFileUpload)component;
        String clientId = component.getClientId(context);
        ExternalContext externalContext = context.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        if (requestParameterMap.get(clientId) != null) {
            String fileUploadIndicator;
            String actionString = (String)requestParameterMap.get("_richfaces_file_upload_action");
            String uid = (String)requestParameterMap.get("_richfaces_upload_uid");
            if (actionString != null) {
                new UploadAjaxActionEvent(component, actionString, uid).queue();
            }
            if ((fileUploadIndicator = (String)requestParameterMap.get("_richfaces_upload_file_indicator")) != null && Boolean.TRUE.toString().equals(fileUploadIndicator)) {
                this.decreaseFileCounter(context, clientId);
                MultipartRequest multipartRequest = MultipartRequest.lookupRequest((FacesContext)context, (String)uid);
                boolean isFlash = requestParameterMap.get("_richfaces_send_http_error") != null;
                List fileList = multipartRequest.getUploadItems();
                if (fileList == null || fileList.size() == 0) {
                    return;
                }
                boolean formUpload = multipartRequest.isFormUpload();
                if (isFlash && !formUpload && fileList.size() > 0) {
                    try {
                        UploadItem item = (UploadItem)fileList.get(0);
                        int actualSize = item.getFileSize();
                        int clientSize = Integer.parseInt((String)requestParameterMap.get("_richfaces_size"));
                        if (actualSize != clientSize) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                this.onUploadComplete(context, fileList, fileUpload, formUpload);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer initMaxFilesCount(FacesContext context, UIComponent component, String clientId) {
        Object session;
        Integer max = (Integer)component.getAttributes().get("maxFilesQuantity");
        Object object = session = context.getExternalContext().getSession(false);
        synchronized (object) {
            Map<String, Integer> map = (Map<String, Integer>)context.getExternalContext().getSessionMap().get("_richfaces_uploaded_file_counter");
            if (map == null) {
                map = Collections.synchronizedMap(new HashMap());
            }
            map.put(clientId, max);
        }
        return max;
    }

    public String getFormId(FacesContext context, UIComponent component) {
        UIComponent form = AjaxRendererUtils.getNestingForm((UIComponent)component);
        if (form != null) {
            return form.getClientId(context);
        }
        return "";
    }

    public Object _getLabels(Object o) {
        return ScriptUtils.toScript((Object)o);
    }

    public Map<String, String> getLabels(FacesContext context, UIComponent component) {
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        ResourceBundle bundle1 = null;
        ResourceBundle bundle2 = null;
        UIFileUpload fileUpload = (UIFileUpload)component;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String messageBundle = context.getApplication().getMessageBundle();
        Object locale = fileUpload.getLocale();
        if (locale == null) {
            locale = context.getExternalContext().getRequestLocale();
        }
        if (null != messageBundle) {
            bundle1 = ResourceBundle.getBundle(messageBundle, fileUpload.getAsLocale(locale), loader);
        }
        try {
            bundle2 = ResourceBundle.getBundle(FILE_UPLOAD_BUNDLE, fileUpload.getAsLocale(locale), loader);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.initLabels(labelsMap, bundle1, bundle2, fileUpload);
        return labelsMap;
    }

    private void initLabels(Map<String, String> map, ResourceBundle bundle1, ResourceBundle bundle2, UIFileUpload fileUpload) {
        int i = 0;
        String key = null;
        String value = null;
        for (String name : bundlesLables) {
            String label;
            boolean found = false;
            if (labelAttribues[i] != null) {
                String attributeName = labelAttribues[i];
                if (fileUpload.getAttributes().get(attributeName) != null) {
                    String attribbuteValue = (String)fileUpload.getAttributes().get(attributeName);
                    key = name;
                    value = attribbuteValue;
                    found = true;
                }
            }
            if (!(found || bundle1 == null && bundle2 == null || (label = this.getFromBundle(name, bundle1, bundle2)) == null)) {
                key = name;
                value = label;
                found = true;
            }
            if (!found) {
                key = name;
                value = defaultLables[i];
            }
            if (key != null && value != null) {
                try {
                    ResponseWriter writer = FacesContext.getCurrentInstance().getResponseWriter();
                    StringWriter dumpingWriter = new StringWriter();
                    ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)dumpingWriter);
                    clonedWriter.writeText((Object)value, null);
                    value = dumpingWriter.toString();
                    map.put(key, value);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private String getFromBundle(String name, ResourceBundle bundle1, ResourceBundle bundle2) {
        String v;
        block7: {
            block8: {
                name = bundlePrefix + name.toUpperCase() + bundlePostfix;
                v = null;
                if (bundle1 == null) break block8;
                try {
                    v = bundle1.getString(name);
                }
                catch (Exception e) {
                    if (bundle2 == null) break block7;
                    try {
                        v = bundle2.getString(name);
                        break block7;
                    }
                    catch (Exception exception) {}
                }
                break block7;
            }
            if (bundle2 != null) {
                try {
                    v = bundle2.getString(name);
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    b.write(v.getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return v;
    }

    private void decreaseFileCounter(FacesContext context, String id) {
        Map map = (Map)context.getExternalContext().getSessionMap().get("_richfaces_uploaded_file_counter");
        if (map != null) {
            Integer i = (Integer)map.get(id);
            if (i == null) {
                i = 0;
            } else {
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i - 1);
            }
            map.put(id, i);
        }
    }

    private void storeData(FacesContext context, UIFileUpload fileUpload, List<UploadItem> fileList) {
        ValueExpression data = fileUpload.getValueExpression(_FILES_UPLOADED_ATTRIBUTE_NAME);
        if (data != null && data.getValue(context.getELContext()) instanceof Collection) {
            Collection collection = (Collection)data.getValue(context.getELContext());
            collection.addAll(fileList);
        }
        new UploadEvent((UIComponent)fileUpload, fileList).queue();
    }

    private void onUploadComplete(FacesContext context, List<UploadItem> fileList, UIFileUpload fileUpload, boolean formUpload) {
        this.storeData(context, fileUpload, fileList);
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (((Boolean)fileUpload.getAttributes().get("ajaxSingle")).booleanValue()) {
            ajaxContext.setAjaxSingleClientId(fileUpload.getClientId(context));
        }
        ajaxContext.setAjaxRequest(!formUpload);
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIFileUpload.class;
    }

    public String getActionScript(FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("_richfaces_file_upload_action", new JSReference("action"));
        parameters.put("_richfaces_upload_uid", new JSReference("uid"));
        parameters.put("ajaxSingle", clientId);
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component, parameters, (boolean)true);
        options.put("onbeforedomupdate", new JSReference("callback"));
        ajaxFunction.addParameter((Object)options);
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"uid", "action", "callback"});
        function.addParameter((Object)"event");
        function.addToBody((Object)ajaxFunction.toScript());
        return function.toScript();
    }

    public String getActionUrl(FacesContext context) {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        String ajaxActionUrl = ajaxContext.getAjaxActionURL(context);
        return ajaxActionUrl;
    }

    public Object getAcceptedTypes(FacesContext context, UIComponent component) {
        String[] types;
        String acceptedTypes = (String)component.getAttributes().get("acceptedTypes");
        HashMap<String, Boolean> accepted = new HashMap<String, Boolean>();
        if (acceptedTypes != null && acceptedTypes.length() > 0 && (types = (acceptedTypes = acceptedTypes.replaceAll("[\\s]", "")).split("[,;|]")) != null) {
            for (String type : types) {
                accepted.put(type.toLowerCase(), true);
            }
        }
        return accepted;
    }

    public Object getLabelMarkup(FacesContext context, UIComponent component) throws IOException {
        CountingOutputWriter customWriter = new CountingOutputWriter();
        StringBuffer result = null;
        UIComponent label = component.getFacet("label");
        if (label != null) {
            ResponseWriter writer = context.getResponseWriter();
            String defaultRenderKitId = context.getApplication().getDefaultRenderKitId();
            if (null == defaultRenderKitId) {
                defaultRenderKitId = "HTML_BASIC";
            }
            RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = renderKitFactory.getRenderKit(context, defaultRenderKitId);
            ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)customWriter, null, "UTF-8");
            context.setResponseWriter(responseWriter);
            this.writeScriptBody(context, label, false);
            if (writer != null) {
                context.setResponseWriter(writer);
            }
            result = customWriter.getContent();
        }
        return result != null ? new JSLiteral(result.toString()) : null;
    }

    public String getFileListHeight(UIFileUpload component) {
        return HtmlUtil.qualifySize((String)component.getListHeight());
    }

    public String getFileListWidth(UIFileUpload component) {
        return HtmlUtil.qualifySize((String)component.getListWidth());
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        JSFunctionDefinition eventHandler = RendererUtils.getInstance().getAsEventHandler(context, component, attributeName, "");
        if (eventHandler != null) {
            return eventHandler.toString();
        }
        return JSReference.NULL.toScript();
    }

    public String getProgressBarId(FacesContext context, UIComponent component) throws IOException {
        return this.getProgressBar(context, component).getClientId(context);
    }

    public void renderProgress(FacesContext context, UIComponent component) throws IOException {
        UIComponent progressBar = this.getProgressBar(context, component);
        this.renderChild(context, progressBar);
    }

    private UIComponent createProgressBar(FacesContext context, UIComponent fileUpload) {
        UIComponent progressBar = fileUpload.getFacet("progress");
        if (null == progressBar) {
            progressBar = context.getApplication().createComponent("org.richfaces.ProgressBar");
            progressBar.setId(fileUpload.getId() + "_rich_progress");
        }
        fileUpload.getFacets().put("progress", progressBar);
        return progressBar;
    }

    public UIComponent getProgressBar(FacesContext context, UIComponent component) {
        UIComponent progressBar = component.getFacet("progress");
        if (null == progressBar) {
            progressBar = this.createProgressBar(context, component);
        }
        progressBar.getAttributes().put("minValue", -1);
        ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
        ValueExpression falseExpression = expressionFactory.createValueExpression(context.getELContext(), "#{" + Boolean.FALSE + "}", Boolean.class);
        progressBar.setValueExpression("enabled", falseExpression);
        progressBar.setTransient(false);
        return progressBar;
    }

    public Object getChildrenParams(FacesContext context, UIComponent component) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter p = (UIParameter)child;
            parameters.put(p.getName(), p.getValue());
        }
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        Map commonAjaxParameters = ajaxContext.getCommonAjaxParameters();
        if (commonAjaxParameters != null) {
            parameters.putAll(commonAjaxParameters);
        }
        return parameters;
    }

    public String getSessionId(FacesContext context, UIComponent component) {
        String id = null;
        Object session = context.getExternalContext().getSession(false);
        if (session != null) {
            if (session instanceof HttpSession) {
                id = ((HttpSession)session).getId();
            } else {
                Class<?> sesssionClass = session.getClass();
                try {
                    Method getIdMethod = sesssionClass.getMethod("getId", new Class[0]);
                    id = (String)getIdMethod.invoke(session, new Object[0]);
                }
                catch (SecurityException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    throw new FacesException(cause.getMessage(), cause);
                }
            }
        }
        return id;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }
}

