/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UIOrderingBaseComponent;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.renderkit.AbstractRowsRenderer;

public abstract class OrderingComponentRendererBase
extends AbstractRowsRenderer {
    private static final Converter DEFAULT_CONVERTER = new Converter(){

        public Object getAsObject(FacesContext context, UIComponent component, String value) {
            return value;
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) {
            if (value instanceof String) {
                return (String)value;
            }
            if (null == value) {
                return "";
            }
            return value.toString();
        }
    };
    private static final String ITEM_STATE_VAR_NAME = "itemState";
    protected static final String SHOW_LABELS_ATTRIBUTE_NAME = "showButtonLabels";
    protected static final String ATTRIBUTE_CE_ONHEADERCLICK = "onheaderclick";
    protected static final String CONTROL_TYPE_LINK = "link";
    protected static final String CONTROL_TYPE_BUTTON = "button";
    protected static final String CONTROL_TYPE_NONE = "none";
    protected static final String ATTRIBUTE_CONTROLS_TYPE = "controlsType";
    private final String bundleName;

    public OrderingComponentRendererBase(String bundleName) {
        this.bundleName = bundleName;
    }

    public void encodeCaption(FacesContext context, UIComponent component) throws IOException {
        this.encodeCaption(context, component, "caption", "rich-ordering-list-caption");
    }

    protected void encodeCaption(FacesContext context, UIComponent component, String facetCaption, String captionStyle, String attributeName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facetEl = component.getFacet(facetCaption);
        boolean renderFacet = facetEl != null && facetEl.isRendered();
        String captionAttr = (String)component.getAttributes().get(attributeName);
        if (renderFacet || captionAttr != null) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)captionStyle, null);
            if (renderFacet) {
                this.renderChild(context, facetEl);
            } else {
                writer.write(captionAttr);
            }
            writer.endElement("div");
        }
    }

    protected void encodeCaption(FacesContext context, UIComponent component, String facetCaption, String captionStyle) throws IOException {
        this.encodeCaption(context, component, facetCaption, captionStyle, "captionLabel");
    }

    public void encodeHeader(FacesContext context, UIOrderingBaseComponent component) throws IOException {
        this.encodeHeader(context, component, "rich-ordering-list-table-header", "rich-ordering-list-table-header-cell", "headerClass");
    }

    protected void encodeHeader(FacesContext context, UIOrderingBaseComponent component, String rowClass, String cellClass, String headerClassAttr) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator headers = component.columns();
        if (headers.hasNext()) {
            writer.startElement("thead", (UIComponent)component);
            String headerClass = (String)component.getAttributes().get(headerClassAttr);
            writer.startElement("tr", (UIComponent)component);
            this.encodeStyleClass(writer, null, rowClass, null, headerClass);
            this.encodeHeaderFacets(context, writer, headers, cellClass, headerClass, "header", "th", component);
            writer.endElement("tr");
            writer.endElement("thead");
        }
    }

    protected void renderDefaultControl(FacesContext context, UIOrderingBaseComponent orderingList, ResponseWriter writer, boolean useFacet, ControlsHelper helper, String clientId, ResourceBundle bundleExternal, ResourceBundle bundleApplication, boolean enabled, String baseStyle, String baseControlStyle) throws IOException {
        UIComponent facet = orderingList.getFacet(helper.getFacetName());
        String customEvent = null;
        Map attributes = orderingList.getAttributes();
        if (helper.customEvent != null) {
            customEvent = (String)attributes.get(helper.customEvent);
        }
        String styleFromAttribute = (String)attributes.get(helper.styleFromAttribute);
        String baseStyleLight = baseStyle.concat("-light");
        String baseStylePress = baseStyle.concat("-press");
        String currentStyle = baseControlStyle + helper.getStyleClassName();
        if (styleFromAttribute != null) {
            currentStyle = styleFromAttribute.concat(currentStyle);
        }
        writer.startElement("div", (UIComponent)orderingList);
        String controlId = clientId + helper.getIdSuffix();
        writer.writeAttribute("id", (Object)controlId, null);
        writer.writeAttribute("class", (Object)currentStyle, null);
        String style = null;
        style = enabled ? "display:block;" : "display:none;";
        writer.writeAttribute("style", (Object)style, null);
        if (!useFacet) {
            writer.startElement("div", (UIComponent)orderingList);
            writer.writeAttribute("class", (Object)(baseStyle + helper.getButtonStyleClass()), null);
            if (helper.enable) {
                writer.writeAttribute("onmouseover", (Object)("this.className='" + baseStyleLight + "'"), null);
                writer.writeAttribute("onmousedown", (Object)("this.className='" + baseStylePress + "'"), null);
                writer.writeAttribute("onmouseup", (Object)("this.className='" + baseStyle + "'"), null);
                writer.writeAttribute("onmouseout", (Object)("this.className='" + baseStyle + "'"), null);
                writer.startElement("a", (UIComponent)orderingList);
                writer.writeAttribute("id", (Object)(controlId + CONTROL_TYPE_LINK), null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
                writer.writeAttribute("class", (Object)(baseStyle + "-selection"), null);
                writer.writeAttribute("onblur", (Object)"Richfaces.Control.onblur(this);", null);
                writer.writeAttribute("onfocus", (Object)"Richfaces.Control.onfocus(this);", null);
            }
            writer.startElement("div", (UIComponent)orderingList);
            writer.writeAttribute("class", (Object)(baseStyle + "-content"), null);
        }
        if (useFacet) {
            this.renderChild(context, facet);
        } else {
            writer.startElement("img", (UIComponent)orderingList);
            writer.writeAttribute("class", (Object)"rich-ordering-control-img", null);
            writer.writeAttribute("alt", orderingList.getAttributes().get(helper.getTitle()), null);
            writer.writeAttribute("src", (Object)this.getResource(helper.getImageURI()).getUri(context, null), null);
            writer.endElement("img");
            if (this.getUtils().isBooleanAttribute((UIComponent)orderingList, SHOW_LABELS_ATTRIBUTE_NAME)) {
                String label = (String)attributes.get(helper.getLabelAttributeName());
                if (label == null) {
                    if (null != bundleApplication) {
                        try {
                            label = bundleApplication.getString(helper.getBundlePropertyName());
                        }
                        catch (MissingResourceException e) {
                            try {
                                if (null != bundleExternal) {
                                    label = bundleExternal.getString(helper.getBundlePropertyName());
                                }
                            }
                            catch (MissingResourceException missingResourceException) {}
                        }
                    } else if (null != bundleExternal) {
                        try {
                            label = bundleExternal.getString(helper.getBundlePropertyName());
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                }
                if (label == null) {
                    label = helper.getDefaultText();
                }
                writer.writeText((Object)label, null);
            }
        }
        if (!useFacet) {
            writer.endElement("div");
            if (helper.enable) {
                writer.endElement("a");
            }
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected boolean isHeaderExists(FacesContext context, UIOrderingBaseComponent component, String facetName) {
        Iterator headers = component.columns();
        while (headers.hasNext()) {
            UIComponent column = (UIComponent)headers.next();
            UIComponent facet = column.getFacet(facetName);
            if (facet == null) continue;
            return true;
        }
        return false;
    }

    protected void encodeHeaderFacets(FacesContext context, ResponseWriter writer, Iterator headers, String skinCellClass, String headerClass, String facetName, String element, UIOrderingBaseComponent orderingList) throws IOException {
        while (headers.hasNext()) {
            UIComponent facet;
            UIComponent column = (UIComponent)headers.next();
            String classAttribute = facetName + "Class";
            String columnHeaderClass = (String)column.getAttributes().get(classAttribute);
            writer.startElement(element, column);
            if (!headers.hasNext()) {
                skinCellClass = skinCellClass + "-last";
            }
            this.encodeStyleClass(writer, null, skinCellClass, headerClass, columnHeaderClass);
            this.getUtils().encodeAttribute(context, column, "colspan");
            writer.startElement("div", column);
            writer.writeAttribute("style", (Object)"overflow:hidden;white-space: nowrap;", null);
            String onHeaderClickEvent = (String)orderingList.getAttributes().get(ATTRIBUTE_CE_ONHEADERCLICK);
            if (onHeaderClickEvent != null) {
                writer.writeAttribute("onclick", (Object)onHeaderClickEvent, null);
            }
            if ((facet = column.getFacet(facetName)) != null && facet.isRendered()) {
                this.renderChild(context, facet);
            } else {
                writer.write("&#160;");
            }
            writer.endElement("div");
            writer.endElement(element);
        }
    }

    protected void encodeControlFacet(FacesContext context, UIOrderingBaseComponent orderingList, ControlsHelper helper, String clientId, ResponseWriter writer, boolean enabled, String baseStyle, String baseControlStyle) throws IOException {
        Locale locale = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            locale = viewRoot.getLocale();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ResourceBundle bundleExternal = null;
        ResourceBundle bundleApplication = null;
        String messageBundle = context.getApplication().getMessageBundle();
        if (locale != null) {
            if (null != messageBundle) {
                bundleApplication = ResourceBundle.getBundle(messageBundle, locale, contextClassLoader);
            }
            try {
                bundleExternal = ResourceBundle.getBundle(this.bundleName, locale, contextClassLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        Map attributes = orderingList.getAttributes();
        UIComponent facet = orderingList.getFacet(helper.getFacetName());
        boolean useFacet = facet != null && facet.isRendered();
        String controlType = (String)attributes.get(ATTRIBUTE_CONTROLS_TYPE);
        if (CONTROL_TYPE_NONE.equals(controlType)) {
            return;
        }
        this.renderDefaultControl(context, orderingList, writer, useFacet, helper, clientId, bundleExternal, bundleApplication, enabled, baseStyle, baseControlStyle);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIOrderingBaseComponent orderingComponent = (UIOrderingBaseComponent)component;
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        variables.setVariable(ITEM_STATE_VAR_NAME, (Object)orderingComponent.getItemState());
        super.encodeBegin(context, component);
    }

    protected UIOrderingBaseComponent.ItemState getItemState(FacesContext context, UIComponent component, ComponentVariables variables) throws IOException {
        return (UIOrderingBaseComponent.ItemState)variables.getVariable(ITEM_STATE_VAR_NAME);
    }

    protected Converter getConverter(FacesContext context, UIOrderingBaseComponent component, boolean warnOnDefaultConverter) {
        Converter converter = component.getConverter();
        if (converter == null) {
            converter = component.getConverterForValue(context);
        }
        if (converter == null) {
            converter = DEFAULT_CONVERTER;
            if (warnOnDefaultConverter) {
                Object componentLabel = MessageUtil.getLabel((FacesContext)context, (UIComponent)component);
                context.getExternalContext().log("Converter for component [" + componentLabel + "] cannot be discovered, so default implementation of converter will be used. Component items will be converted to String on decoding.");
            }
        }
        return converter;
    }

    public String getCaptionDisplay(FacesContext context, UIComponent component) {
        Object caption = component.getAttributes().get("captionLabel");
        UIComponent facet = component.getFacet("caption");
        if (null != caption && !"".equals(caption) || null != facet && facet.isRendered()) {
            return "";
        }
        return "display: none;";
    }

    protected static final class SelectionState {
        private boolean firstSelected = false;
        private boolean firstSelectedLatch = false;
        private boolean selectedLatch = false;
        private boolean itemsExist = false;
        private boolean lastSelected = false;

        public void addState(boolean selected) {
            this.itemsExist = true;
            if (!this.firstSelectedLatch) {
                this.firstSelected = selected;
                this.firstSelectedLatch = true;
            }
            if (selected) {
                this.selectedLatch = true;
            }
            this.lastSelected = selected;
        }

        public boolean isFirstSelected() {
            return this.firstSelected;
        }

        public boolean isSelected() {
            return this.selectedLatch;
        }

        public boolean isItemExist() {
            return this.itemsExist;
        }

        public boolean isLastSelected() {
            return this.lastSelected;
        }
    }

    protected static abstract class ControlsHelper {
        private String name;
        private String bundlePropertyName;
        private String imageURI;
        private String facetName;
        private String styleClassName;
        private String idSuffix;
        String customEvent;
        String styleFromAttribute;
        private String buttonStyleClass;
        boolean enable;
        private String defaultText;
        private String labelAttributeName;
        private String title;

        public abstract boolean isRendered(FacesContext var1, UIComponent var2);

        public ControlsHelper(String name, String bundlePropertyName, String defaultText, String imageURI, String facetName, String styleClassName, String styleFromAttribute, String buttonStyleClass, String idSuffix, String customEvent, boolean isEnable, String labelAttributeName, String title) {
            this.name = name;
            this.bundlePropertyName = bundlePropertyName;
            this.defaultText = defaultText;
            this.imageURI = imageURI;
            this.facetName = facetName;
            this.styleClassName = styleClassName;
            this.styleFromAttribute = styleFromAttribute;
            this.idSuffix = idSuffix;
            this.customEvent = customEvent;
            this.buttonStyleClass = buttonStyleClass;
            this.enable = isEnable;
            this.labelAttributeName = labelAttributeName;
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public String getBundlePropertyName() {
            return this.bundlePropertyName;
        }

        public String getImageURI() {
            return this.imageURI;
        }

        public String getFacetName() {
            return this.facetName;
        }

        public String getStyleClassName() {
            return this.styleClassName;
        }

        public String getIdSuffix() {
            return this.idSuffix;
        }

        public String getCustomEvent() {
            return this.customEvent;
        }

        public String getStyleFromAttribute() {
            return this.styleFromAttribute;
        }

        public String getButtonStyleClass() {
            return this.buttonStyleClass;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public String getDefaultText() {
            return this.defaultText;
        }

        public String getLabelAttributeName() {
            return this.labelAttributeName;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

