/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.org.w3c.tidy.EntityTable;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIDataTable;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.renderkit.DragIndicatorRendererBase;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.html.ExtDraggableRendererContributor;
import org.richfaces.renderkit.html.ExtDropzoneRendererContributor;

public class TableDragDropRenderer
implements Serializable {
    private static final long serialVersionUID = -8059307641808179967L;
    public static final String DRAG_SOURCE_SCRIPT_ID = "dnd_drag_script";
    public static final String DROP_TARGET_SCRIPT_ID = "dnd_drop_script";
    public static final String DROP_TARGET_BEFORE = "_left";
    public static final String DROP_TARGET_AFTER = "_right";
    private FacesContext context;
    private JSFunctionDefinition onAjaxCompleteFunctionDef;
    private JSFunction preSendAjaxRequestFunction;

    private TableDragDropRenderer(FacesContext context) {
        this.context = context;
    }

    public static TableDragDropRenderer getInstance(FacesContext context) {
        return new TableDragDropRenderer(context);
    }

    public void encodeChildScripts(FacesContext context, UIDataTable component) throws IOException {
        new DragIndicatorRendererBase(){

            public void encodeChildScripts(FacesContext context, UIDataTable component) throws IOException {
                ResponseWriter responseWriter = context.getResponseWriter();
                responseWriter.write("\nvar elt = $(\"" + component.getBaseClientId(context) + ":dataTable_indicator\");\n");
                responseWriter.write("elt.markers = {};\n");
                responseWriter.write("elt.indicatorTemplates = {};\n");
                super.encodeChildScripts(context, (UIComponent)component);
                responseWriter.write("elt.markers['default'] = \"");
                responseWriter.write(this.getPredefinedMarker(context, "reject"));
                responseWriter.write("\";\n");
                responseWriter.write("createExtDragIndicator(elt, '', '');\n");
            }
        }.encodeChildScripts(context, component);
    }

    public void renderDragSupport(UIColumn column, String dragSourceId, String indicatorId, String dragLabel) throws IOException {
        String varName = "DnD_ExtSimpleDraggable_" + column.getId().replaceAll("[^A-Za-z0-9_]", "_");
        StringBuffer buffer = new StringBuffer("delete " + varName + ";\nvar " + varName + " = ");
        JSFunction function = new JSFunction("new DnD.ExtSimpleDraggable", new Object[0]);
        function.addParameter((Object)dragSourceId);
        String dragSourceScriptId = column.getClientId(this.context) + ":" + DRAG_SOURCE_SCRIPT_ID;
        ExtDraggableRendererContributor contributor = ExtDraggableRendererContributor.getInstance();
        ScriptOptions dragOptions = contributor.buildOptions(this.context, (UIComponent)column, dragSourceScriptId, indicatorId);
        JSONObject dndParams = new JSONObject();
        try {
            dndParams.put("label", (Object)(dragLabel == null ? "" : dragLabel));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        dragOptions.addOption("dndParams", (Object)dndParams.toString());
        function.addParameter((Object)dragOptions);
        function.appendScript(buffer);
        String scriptContribution = contributor.getScriptContribution(this.context, (UIComponent)column);
        if (scriptContribution != null && scriptContribution.length() != 0) {
            buffer.append(scriptContribution);
        }
        ResponseWriter writer = this.context.getResponseWriter();
        writer.startElement("script", (UIComponent)column);
        writer.writeAttribute("id", (Object)dragSourceScriptId, "id");
        writer.write(this.escapeHtmlEntities(buffer));
        writer.endElement("script");
    }

    public void renderDropSupport(UIColumn column, String dropTargetId, boolean before) throws IOException {
        ExtDropzoneRendererContributor contributor = ExtDropzoneRendererContributor.getInstance();
        String varName = "DnD_ExtSimpleDropZone_" + column.getId().replaceAll("[^A-Za-z0-9_]", "_") + (before ? "L" : "R");
        StringBuffer buffer = new StringBuffer("delete " + varName + ";\nvar " + varName + " = ");
        JSFunction function = new JSFunction("new DnD.ExtSimpleDropZone", new Object[0]);
        function.addParameter((Object)dropTargetId);
        ScriptOptions dropOptions = contributor.buildOptions(this.context, (UIComponent)column);
        JSONObject dndParams = new JSONObject();
        dropOptions.addOption("dndParams", (Object)dndParams.toString());
        function.addParameter((Object)dropOptions);
        function.appendScript(buffer);
        String dropTargetScriptId = column.getClientId(this.context) + ":" + DROP_TARGET_SCRIPT_ID + (before ? DROP_TARGET_BEFORE : DROP_TARGET_AFTER);
        String scriptContribution = contributor.getScriptContribution(this.context, (UIComponent)column, dropTargetScriptId, this.preSendAjaxRequestFunction, this.onAjaxCompleteFunctionDef);
        if (scriptContribution != null && scriptContribution.length() != 0) {
            buffer.append(scriptContribution);
        }
        ResponseWriter writer = this.context.getResponseWriter();
        writer.startElement("script", (UIComponent)column);
        writer.writeAttribute("id", (Object)dropTargetScriptId, "id");
        writer.write(this.escapeHtmlEntities(buffer));
        writer.endElement("script");
    }

    protected String escapeHtmlEntities(CharSequence orig) {
        StringBuffer buff = new StringBuffer(orig);
        EntityTable defaultEntityTable = EntityTable.getDefaultEntityTable();
        Matcher matcher = Pattern.compile("\\&\\w+\\;").matcher(orig);
        int delta = 0;
        while (matcher.find()) {
            String name = matcher.group().substring(0, matcher.group().length() - 1);
            int code = defaultEntityTable.entityCode(name);
            if (0 == code) continue;
            String replacement = "&#" + code + ";";
            buff.replace(matcher.start() - delta, matcher.end() - delta, replacement);
            delta = delta + matcher.group().length() - replacement.length();
        }
        return buff.toString();
    }

    public JSFunctionDefinition getOnAjaxCompleteFunctionDef() {
        return this.onAjaxCompleteFunctionDef;
    }

    public void setOnAjaxCompleteFunctionDef(JSFunctionDefinition onAjaxCompleteFunctionDef) {
        this.onAjaxCompleteFunctionDef = onAjaxCompleteFunctionDef;
    }

    public void setPreSendAjaxRequestFunction(JSFunction preSendAjaxRequestFunction) {
        this.preSendAjaxRequestFunction = preSendAjaxRequestFunction;
    }
}

