/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.rule.impl;

import java.util.List;
import org.herasaf.xacml.core.combiningAlgorithm.rule.RuleUnorderedCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.impl.RuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RuleFirstApplicableAlgorithm
extends RuleUnorderedCombiningAlgorithm {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RuleFirstApplicableAlgorithm.class);

    @Override
    public String getCombiningAlgorithmId() {
        return ID;
    }

    @Override
    public DecisionType evaluateRuleList(RequestType request, List<RuleType> rules, EvaluationContext evaluationContext) {
        if (rules == null) {
            logger.error("the rules list was null. This is an illegal state.");
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
        for (int i = 0; i < rules.size(); ++i) {
            RuleType rule = rules.get(i);
            evaluationContext.resetStatus();
            if (logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:ruleid", (String)rule.getRuleId());
                logger.debug("Starting evaluation of: {}", (Object)rule.getRuleId());
            }
            DecisionType decision = this.evaluateRule(request, rule, evaluationContext);
            if (logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:ruleid", (String)rule.getRuleId());
                logger.debug("Evaluation of {} was: {}", (Object)rule.getRuleId(), (Object)decision.toString());
                MDC.remove((String)"org:herasaf:xacml:evaluation:ruleid");
            }
            switch (decision) {
                case DENY: 
                case INDETERMINATE: 
                case PERMIT: {
                    return decision;
                }
            }
        }
        return DecisionType.NOT_APPLICABLE;
    }
}

