/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.WritingException;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.ObjectFactory;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResponseType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.herasaf.xacml.core.context.impl.StatusCodeType;
import org.herasaf.xacml.core.context.impl.StatusDetailType;
import org.herasaf.xacml.core.context.impl.StatusType;
import org.herasaf.xacml.core.utils.DefaultValidationEventHandler;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class ResponseMarshaller {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ResponseMarshaller.class);
    private static JAXBContext CONTEXT;
    private static JAXBMarshallerConfiguration CONFIGURATION;
    private static final ObjectFactory OBJECT_FACTORY;

    public static void setJAXBContext(JAXBContext context) {
        CONTEXT = context;
    }

    public static void setJAXBMarshallerConfiguration(JAXBMarshallerConfiguration configuration) {
        CONFIGURATION = configuration;
    }

    private static Marshaller createMarshaller() throws JAXBException, PropertyException {
        if (CONTEXT == null || CONFIGURATION == null) {
            LOGGER.error("JAXB context and/or configuration not initialized.");
            throw new NotInitializedException("JAXB context and/or configuration not initialized.");
        }
        Marshaller marshaller = CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)CONFIGURATION.isFormattedOutput());
        marshaller.setProperty("jaxb.fragment", (Object)CONFIGURATION.isFragment());
        if (CONFIGURATION.isWriteSchemaLocation()) {
            if ("".equals(CONFIGURATION)) {
                LOGGER.error("SchemaLocation not initialized.");
                throw new NotInitializedException("SchemaLocation not initialized.");
            }
            marshaller.setProperty("jaxb.schemaLocation", (Object)CONFIGURATION.getSchemaLocationAsString());
        }
        if (CONFIGURATION.isValidateWriting()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            marshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            marshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return marshaller;
    }

    public static ResponseType create(RequestType req, DecisionType decision, EvaluationContext evaluationContext) {
        ResponseType response = ResponseMarshaller.create(req, decision, evaluationContext.getStatusCode());
        if (evaluationContext.getMissingAttributes().size() > 0) {
            StatusDetailType statusDetail = OBJECT_FACTORY.createStatusDetailType();
            ArrayList<JAXBElement<MissingAttributeDetailType>> missingAttributesJaxb = new ArrayList<JAXBElement<MissingAttributeDetailType>>();
            for (MissingAttributeDetailType madt : evaluationContext.getMissingAttributes()) {
                missingAttributesJaxb.add(OBJECT_FACTORY.createMissingAttributeDetail(madt));
            }
            statusDetail.getContent().addAll(missingAttributesJaxb);
            response.getResults().get(0).getStatus().setStatusDetail(statusDetail);
        }
        if (evaluationContext.getObligations().getObligations().size() > 0) {
            response.getResults().get(0).setObligations(evaluationContext.getObligations());
        }
        return response;
    }

    public static ResponseType create(RequestType req, DecisionType decision, StatusCode code) {
        ResponseType res = OBJECT_FACTORY.createResponseType();
        ResultType result = OBJECT_FACTORY.createResultType();
        if (req.getResources().size() == 1) {
            result.setDecision(decision);
        } else {
            result.setDecision(DecisionType.INDETERMINATE);
        }
        StatusCodeType statusCode = OBJECT_FACTORY.createStatusCodeType();
        statusCode.setValue(code.getValue());
        StatusType status = OBJECT_FACTORY.createStatusType();
        status.setStatusCode(statusCode);
        result.setStatus(status);
        res.getResults().add(result);
        return res;
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException, PropertyException {
        if (CONTEXT == null || CONFIGURATION == null) {
            LOGGER.error("JAXB context and/or configuration not initialized.");
            throw new NotInitializedException("JAXB context and/or configuration not initialized.");
        }
        Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
        if (CONFIGURATION.isValidateParsing()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            unmarshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            unmarshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return unmarshaller;
    }

    public static void marshal(ResponseType response, File file) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), file);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the file.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(ResponseType response, ContentHandler ch) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), ch);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the content handler.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(ResponseType response, Result result) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), result);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the result.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(ResponseType response, OutputStream out) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), out);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the output stream.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(ResponseType response, Writer writer) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), writer);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the writer.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(ResponseType response, Node node) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), node);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the node.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(ResponseType response, XMLStreamWriter xmlStreamWriter) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), xmlStreamWriter);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the xml stream writer.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static void marshal(ResponseType response, XMLEventWriter xmlEventWriter) throws WritingException {
        try {
            ResponseMarshaller.createMarshaller().marshal(OBJECT_FACTORY.createResponse(response), xmlEventWriter);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the xml event writer.", e);
            LOGGER.error(we.getMessage());
            throw we;
        }
    }

    public static ResponseType unmarshal(File file) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(file)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(InputStream inputStream) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(Reader reader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(reader)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(URL url) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(url)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(InputSource inputSource) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(inputSource)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(Node node) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(node)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(Source source) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(source)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(XMLStreamReader xmlStreamReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(xmlStreamReader)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseType unmarshal(XMLEventReader xmlEventReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseMarshaller.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(xmlEventReader)).getValue();
            return rt;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.", e);
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    static {
        OBJECT_FACTORY = new ObjectFactory();
    }
}

