/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context.impl;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.herasaf.xacml.core.context.impl.ActionType;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.EnvironmentType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.herasaf.xacml.core.dataTypeAttribute.impl.DateDataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.DateTimeDataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.TimeDataTypeAttribute;

@XmlRootElement
@XmlType(name="RequestType", propOrder={"subjects", "resources", "action", "environment"})
public class RequestType
implements Serializable {
    private static final String CURRENT_DATETIME_DATATYPEID = "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime";
    private static final String CURRENT_DATE_DATATYPEID = "urn:oasis:names:tc:xacml:1.0:environment:current-date";
    private static final String CURRENT_TIME_DATATYPEID = "urn:oasis:names:tc:xacml:1.0:environment:current-time";
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Subject", required=true)
    private List<SubjectType> subjects;
    @XmlElement(name="Resource", required=true)
    private List<ResourceType> resources;
    @XmlElement(name="Action", required=true)
    private ActionType action;
    @XmlElement(name="Environment", required=true)
    private EnvironmentType environment;

    public void setCreationTime(OffsetDateTime creationTime) {
        boolean foundCurrentTime = false;
        boolean foundCurrentDate = false;
        boolean foundCurrentDateTime = false;
        for (AttributeType attribute : this.environment.getAttributes()) {
            if (CURRENT_TIME_DATATYPEID.equals(attribute.getAttributeId()) && attribute.getAttributeValues() != null && !attribute.getAttributeValues().isEmpty()) {
                foundCurrentTime = true;
                continue;
            }
            if (CURRENT_DATE_DATATYPEID.equals(attribute.getAttributeId()) && attribute.getAttributeValues() != null && !attribute.getAttributeValues().isEmpty()) {
                foundCurrentDate = true;
                continue;
            }
            if (!CURRENT_DATETIME_DATATYPEID.equals(attribute.getAttributeId()) || attribute.getAttributeValues() == null || attribute.getAttributeValues().isEmpty()) continue;
            foundCurrentDateTime = true;
        }
        if (!foundCurrentTime) {
            this.environment.getAttributes().add(this.createCurrentTime(creationTime));
        }
        if (!foundCurrentDate) {
            this.environment.getAttributes().add(this.createCurrentDate(creationTime));
        }
        if (!foundCurrentDateTime) {
            this.environment.getAttributes().add(this.createCurrentDateTime(creationTime));
        }
    }

    public void ensureThatCreationTimeIsSet() {
        OffsetDateTime dateTime = OffsetDateTime.now();
        this.setCreationTime(dateTime);
    }

    private AttributeType createCurrentTime(OffsetDateTime dateTime) {
        AttributeType currentTimeAttr = new AttributeType();
        currentTimeAttr.setAttributeId(CURRENT_TIME_DATATYPEID);
        currentTimeAttr.setDataType(new TimeDataTypeAttribute());
        currentTimeAttr.getAttributeValues().add(this.createDateTime(dateTime, DateTimeFormatter.ISO_TIME));
        return currentTimeAttr;
    }

    private AttributeType createCurrentDate(OffsetDateTime dateTime) {
        AttributeType currentDateAttr = new AttributeType();
        currentDateAttr.setAttributeId(CURRENT_DATE_DATATYPEID);
        currentDateAttr.setDataType(new DateDataTypeAttribute());
        currentDateAttr.getAttributeValues().add(this.createDateTime(dateTime, DateTimeFormatter.ISO_DATE));
        return currentDateAttr;
    }

    private AttributeType createCurrentDateTime(OffsetDateTime dateTime) {
        AttributeType currentDateTimeAttr = new AttributeType();
        currentDateTimeAttr.setAttributeId(CURRENT_DATETIME_DATATYPEID);
        currentDateTimeAttr.setDataType(new DateTimeDataTypeAttribute());
        currentDateTimeAttr.getAttributeValues().add(this.createDateTime(dateTime, DateTimeFormatter.ISO_DATE_TIME));
        return currentDateTimeAttr;
    }

    private AttributeValueType createDateTime(OffsetDateTime dateTime, DateTimeFormatter format) {
        String value = dateTime.atZoneSameInstant(ZoneOffset.UTC).format(format);
        AttributeValueType attrValue = new AttributeValueType();
        attrValue.getContent().add(value);
        return attrValue;
    }

    public List<SubjectType> getSubjects() {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectType>();
        }
        return this.subjects;
    }

    public List<ResourceType> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceType>();
        }
        return this.resources;
    }

    public ActionType getAction() {
        return this.action;
    }

    public void setAction(ActionType value) {
        this.action = value;
    }

    public EnvironmentType getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentType value) {
        this.environment = value;
    }
}

