/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeJAXBTypeAdapter
extends XmlAdapter<String, DataTypeAttribute<?>> {
    private static final Logger logger = LoggerFactory.getLogger(DataTypeJAXBTypeAdapter.class);
    private static Map<String, DataTypeAttribute<?>> dataTypeAttributes = new HashMap();

    public static void addDataTypeAttributes(Map<String, ? extends DataTypeAttribute<?>> dataTypes) {
        dataTypeAttributes.putAll(dataTypes);
    }

    public String marshal(DataTypeAttribute<?> dataTypeAttr) {
        String dataTypeAttrString;
        try {
            dataTypeAttrString = dataTypeAttr.toString();
        }
        catch (NullPointerException e) {
            logger.error("Argument dataTypeAttr must not be null: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return dataTypeAttrString;
    }

    public DataTypeAttribute<?> unmarshal(String dataTypeId) {
        DataTypeAttribute<?> dta;
        try {
            dta = dataTypeAttributes.get(dataTypeId);
        }
        catch (NullPointerException e) {
            logger.error("DataTypeJAXBTypeAdapter not properly initialized.");
            throw new NotInitializedException(e);
        }
        if (dta != null) {
            return dta;
        }
        throw new IllegalArgumentException("DataTypeAttribute " + dataTypeId + " unknown.");
    }
}

