/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyCombiningAlgorithmJAXBTypeAdapter
extends XmlAdapter<String, PolicyCombiningAlgorithm> {
    private static final Logger logger = LoggerFactory.getLogger(PolicyCombiningAlgorithmJAXBTypeAdapter.class);
    private static Map<String, PolicyCombiningAlgorithm> combiningAlgorithms = new HashMap<String, PolicyCombiningAlgorithm>();

    public static void addCombiningAlgorithms(Map<String, PolicyCombiningAlgorithm> algorithms) {
        combiningAlgorithms.putAll(algorithms);
    }

    public String marshal(PolicyCombiningAlgorithm combAlg) {
        String combAlgString;
        try {
            combAlgString = combAlg.toString();
        }
        catch (NullPointerException e) {
            logger.error("Argument combAlg must not be null: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return combAlgString;
    }

    public PolicyCombiningAlgorithm unmarshal(String combAlgId) {
        PolicyCombiningAlgorithm combAlg;
        try {
            combAlg = combiningAlgorithms.get(combAlgId);
        }
        catch (NullPointerException e) {
            logger.error("PolicyCombiningAlgorithmJAXBTypeAdapter not properly initialized.");
            throw new NotInitializedException(e);
        }
        if (combAlg != null) {
            return combAlg;
        }
        throw new IllegalArgumentException("Combining Algorithm " + combAlgId + " unknown.");
    }
}

