/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.herasaf.xacml.core.api.PIP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.impl.PolicyOnlyOneApplicableAlgorithm;
import org.herasaf.xacml.core.context.StatusCodeComparator;
import org.herasaf.xacml.core.simplePDP.MapBasedSimplePolicyRepository;
import org.herasaf.xacml.core.targetMatcher.TargetMatcher;
import org.herasaf.xacml.core.targetMatcher.impl.TargetMatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePDPConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SimplePDPConfiguration.class);
    private PolicyCombiningAlgorithm rootCombiningAlgorithm;
    private PolicyRetrievalPoint policyRetrievalPoint;
    private PIP pip = null;
    private boolean respectAbandonedEvaluatables = false;
    private TargetMatcher targetMatcher;
    private StatusCodeComparator statusCodeComparator;
    private ZoneId timeZone;
    private boolean zuluUtcRepresentation = false;
    private final List<Class<?>> m_contexts = new ArrayList();

    public PolicyCombiningAlgorithm getRootCombiningAlgorithm() {
        if (this.rootCombiningAlgorithm != null) {
            logger.info("Using custom root combining algorithm: {}", (Object)this.rootCombiningAlgorithm.getClass().getCanonicalName());
            return this.rootCombiningAlgorithm;
        }
        logger.info("Using default root combining algorithm: {}", (Object)PolicyOnlyOneApplicableAlgorithm.class.getCanonicalName());
        return new PolicyOnlyOneApplicableAlgorithm();
    }

    public void setRootCombiningAlgorithm(PolicyCombiningAlgorithm rootCombiningAlgorithm) {
        this.rootCombiningAlgorithm = rootCombiningAlgorithm;
    }

    public PolicyRetrievalPoint getPolicyRetrievalPoint() {
        if (this.policyRetrievalPoint != null) {
            logger.info("Using custom policy retrieval point: {}", (Object)this.policyRetrievalPoint.getClass().getCanonicalName());
            return this.policyRetrievalPoint;
        }
        logger.info("Using default policy retrieval point: {}", (Object)MapBasedSimplePolicyRepository.class.getCanonicalName());
        return new MapBasedSimplePolicyRepository();
    }

    public void setPolicyRetrievalPoint(PolicyRetrievalPoint policyRetrievalPoint) {
        this.policyRetrievalPoint = policyRetrievalPoint;
    }

    public PIP getPip() {
        return this.pip;
    }

    public void setPip(PIP pip) {
        this.pip = pip;
    }

    public boolean isRespectAbandonedEvaluatables() {
        return this.respectAbandonedEvaluatables;
    }

    public void setRespectAbandonedEvaluatables(boolean respectAbandonedEvaluatables) {
        this.respectAbandonedEvaluatables = respectAbandonedEvaluatables;
    }

    public TargetMatcher getTargetMatcher() {
        if (this.targetMatcher != null) {
            logger.info("Using custom target matcher: {}", (Object)this.targetMatcher.getClass().getCanonicalName());
            return this.targetMatcher;
        }
        logger.info("Using default target matcher: {}", (Object)TargetMatcherImpl.class.getCanonicalName());
        return new TargetMatcherImpl();
    }

    public void setTargetMatcher(TargetMatcher targetMatcher) {
        this.targetMatcher = targetMatcher;
    }

    public StatusCodeComparator getStatusCodeComparator() {
        if (this.statusCodeComparator != null) {
            logger.info("Using custom status code comparator: {}", (Object)this.statusCodeComparator.getClass().getCanonicalName());
            return this.statusCodeComparator;
        }
        logger.info("Using default status code comparator: {}", (Object)StatusCodeComparator.class.getCanonicalName());
        return new StatusCodeComparator();
    }

    public void setStatusCodeComparator(StatusCodeComparator statusCodeComparator) {
        this.statusCodeComparator = statusCodeComparator;
    }

    public void setTimeZone(ZoneOffset timeZone) {
        this.timeZone = timeZone;
    }

    public ZoneId getTimeZone() {
        if (this.timeZone != null) {
            logger.info("Using custom timezone: {}", (Object)this.timeZone);
            return this.timeZone;
        }
        logger.info("Using default timezone: {}", (Object)this.timeZone);
        return ZoneOffset.UTC;
    }

    public boolean isZuluUtcRepresentation() {
        return this.zuluUtcRepresentation;
    }

    public void setUseZuluUtcRepresentation(boolean useZuluUtcRepresentation) {
        this.zuluUtcRepresentation = useZuluUtcRepresentation;
    }

    public void addJaxbContext(Class<?> ... contextClasses) {
        for (Class<?> clazz : contextClasses) {
            this.m_contexts.add(clazz);
        }
    }

    public List<Class<?>> getJaxbContexts() {
        return this.m_contexts;
    }
}

