/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP.initializers.jaxb;

import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.herasaf.xacml.core.InitializationException;
import org.herasaf.xacml.core.context.RequestMarshaller;
import org.herasaf.xacml.core.context.ResponseMarshaller;
import org.herasaf.xacml.core.policy.PolicyMarshaller;
import org.herasaf.xacml.core.policy.impl.ObjectFactory;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.initializers.api.Initializer;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JaxbContextInitializer
implements Initializer {
    private static final Logger logger = LoggerFactory.getLogger(JaxbContextInitializer.class);
    private static final String CONTEXT_SCHEMA_PATH = "classpath:/access_control-xacml-2.0-context-schema-os.xsd";
    private static final String POLICY_SCHEMA_PATH = "classpath:/access_control-xacml-2.0-policy-schema-os.xsd";
    private static final boolean JAXB_FRAGMENT = true;
    private static final boolean JAXB_VALIDATE = false;
    private static final boolean JAXB_VALIDATE_WRITING = false;
    private static final boolean JAXB_FORMATTED_OUTPUT = false;

    @Override
    public void run(SimplePDPConfiguration configuration) {
        this.initializePolicyContext(configuration);
        this.initializeRequestContext(configuration);
        this.initializeResponseContext(configuration);
    }

    private void initializePolicyContext(SimplePDPConfiguration configuration) {
        JAXBContext policyContext;
        try {
            ArrayList contextClasses = new ArrayList();
            contextClasses.add(ObjectFactory.class);
            if (configuration != null) {
                contextClasses.addAll(configuration.getJaxbContexts());
            }
            policyContext = JAXBContext.newInstance((Class[])contextClasses.toArray(new Class[0]));
        }
        catch (JAXBException e) {
            InitializationException ie = new InitializationException("Unable to load JAXBContext for org.herasaf.xacml.core.policy.impl.", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        PolicyMarshaller.setJAXBContext(policyContext);
        JAXBMarshallerConfiguration jmc = this.getCommonMarshallerConfiguration();
        try {
            jmc.setSchemaByPath(POLICY_SCHEMA_PATH);
        }
        catch (SAXException e) {
            InitializationException ie = new InitializationException("Unable to load Schema classpath:/access_control-xacml-2.0-policy-schema-os.xsd", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        catch (MalformedURLException e) {
            InitializationException ie = new InitializationException("Unable to load Schema classpath:/access_control-xacml-2.0-policy-schema-os.xsd", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        PolicyMarshaller.setJAXBMarshallerConfiguration(jmc);
        logger.info("PolicyMarshaller is configured with JAXB Marshaller Configuration {}", (Object)jmc.toString());
    }

    private void initializeRequestContext(SimplePDPConfiguration configuration) {
        JAXBContext requestContext;
        try {
            ArrayList contextClasses = new ArrayList();
            contextClasses.add(org.herasaf.xacml.core.context.impl.ObjectFactory.class);
            if (configuration != null) {
                contextClasses.addAll(configuration.getJaxbContexts());
            }
            requestContext = JAXBContext.newInstance((Class[])contextClasses.toArray(new Class[0]));
        }
        catch (JAXBException e) {
            InitializationException ie = new InitializationException("Unable to load JAXBContext for org.herasaf.xacml.core.context.impl.", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        RequestMarshaller.setJAXBContext(requestContext);
        JAXBMarshallerConfiguration jmc = this.getCommonMarshallerConfiguration();
        try {
            jmc.setSchemaByPath(POLICY_SCHEMA_PATH, CONTEXT_SCHEMA_PATH);
        }
        catch (SAXException e) {
            InitializationException ie = new InitializationException("Unable to load Schema classpath:/access_control-xacml-2.0-context-schema-os.xsd", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        catch (MalformedURLException e) {
            InitializationException ie = new InitializationException("Unable to load Schema classpath:/access_control-xacml-2.0-context-schema-os.xsd", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        RequestMarshaller.setJAXBMarshallerConfiguration(jmc);
        logger.info("RequestMarshaller is configured with JAXB Marshaller Configuration {}", (Object)jmc.toString());
    }

    private void initializeResponseContext(SimplePDPConfiguration configuration) {
        JAXBContext responseContext;
        try {
            ArrayList contextClasses = new ArrayList();
            contextClasses.add(org.herasaf.xacml.core.context.impl.ObjectFactory.class);
            if (configuration != null) {
                contextClasses.addAll(configuration.getJaxbContexts());
            }
            responseContext = JAXBContext.newInstance((Class[])contextClasses.toArray(new Class[0]));
        }
        catch (JAXBException e) {
            InitializationException ie = new InitializationException("Unable to load JAXBContext for org.herasaf.xacml.core.context.impl.", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        ResponseMarshaller.setJAXBContext(responseContext);
        JAXBMarshallerConfiguration jmc = this.getCommonMarshallerConfiguration();
        try {
            jmc.setSchemaByPath(POLICY_SCHEMA_PATH, CONTEXT_SCHEMA_PATH);
        }
        catch (SAXException e) {
            InitializationException ie = new InitializationException("Unable to load Schema classpath:/access_control-xacml-2.0-context-schema-os.xsd", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        catch (MalformedURLException e) {
            InitializationException ie = new InitializationException("Unable to load Schema classpath:/access_control-xacml-2.0-context-schema-os.xsd", e);
            logger.error(ie.getMessage());
            throw ie;
        }
        ResponseMarshaller.setJAXBMarshallerConfiguration(jmc);
        logger.info("ResponseMarshaller is configured with JAXB Marshaller Configuration {}", (Object)jmc.toString());
    }

    private JAXBMarshallerConfiguration getCommonMarshallerConfiguration() {
        JAXBMarshallerConfiguration jmc = new JAXBMarshallerConfiguration();
        jmc.setFormattedOutput(false);
        jmc.setFragment(true);
        jmc.setValidateParsing(false);
        jmc.setValidateWriting(false);
        return jmc;
    }
}

