/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.types.YearMonthDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Date
implements Comparable<Date> {
    private static final Logger logger = LoggerFactory.getLogger(Date.class);
    private LocalDate date;
    private ZoneOffset offset;
    private static boolean useZuluRepresentation = false;
    private static ZoneId defaultZoneId = ZoneOffset.UTC;

    public static void useZuluUtcRepresentation(boolean useZuluUtcRepresentation) {
        useZuluRepresentation = useZuluUtcRepresentation;
    }

    public static void configureWith(boolean useZuluUtcRepresentation, ZoneId defaultZoneId) {
        Date.useZuluUtcRepresentation(useZuluUtcRepresentation);
        Date.defaultZoneId = defaultZoneId;
    }

    public Date(String dateString) throws SyntaxException {
        String trimmedDate = dateString.trim();
        try {
            if (trimmedDate.length() >= 11) {
                this.date = LocalDate.parse(trimmedDate.substring(0, 10));
                this.offset = ZoneOffset.of(trimmedDate.subSequence(10, trimmedDate.length()).toString());
            } else {
                this.date = LocalDate.parse(trimmedDate);
                this.offset = this.date.atStartOfDay().atZone(defaultZoneId).getOffset();
            }
        }
        catch (DateTimeException e) {
            String message = String.format("The date '%s' is not a valid date according to http://www.w3.org/2001/XMLSchema#date", dateString);
            logger.error(message);
            throw new SyntaxException(message, e);
        }
    }

    public String toString() {
        String formatOffset = useZuluRepresentation ? this.offset.toString() : this.offset.toString().replace("Z", "+00:00");
        return this.date.toString() + formatOffset;
    }

    @Override
    public int compareTo(Date o) {
        LocalDate thisDate = this.getDate();
        LocalDate thatDate = o.getDate();
        return thisDate.compareTo(thatDate);
    }

    public boolean equals(Object obj) {
        if (obj == null || !Date.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        LocalDate jodaThisDate = this.getDate();
        LocalDate jodaThatDate = ((Date)obj).getDate();
        boolean isEqual = jodaThisDate.isEqual(jodaThatDate);
        return isEqual;
    }

    public int hashCode() {
        return Objects.hash(this.date, this.offset);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void add(YearMonthDuration yearMonthDuration) {
        this.date = yearMonthDuration.isNegative() ? this.date.minus(yearMonthDuration.getDuration()) : this.date.plus(yearMonthDuration.getDuration());
    }

    public void subtract(YearMonthDuration yearMonthDuration) {
        this.date = yearMonthDuration.isNegative() ? this.date.plus(yearMonthDuration.getDuration()) : this.date.minus(yearMonthDuration.getDuration());
    }
}

