/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.types.DayTimeDuration;
import org.herasaf.xacml.core.types.YearMonthDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTime
implements Comparable<DateTime> {
    private static final Logger logger = LoggerFactory.getLogger(DateTime.class);
    private static DateTimeFormatter dateTimeFormatter;
    private static ZoneId defaultZoneId;
    private OffsetDateTime dateTime;

    public static void useZuluUtcRepresentation(boolean useZuluUtcRepresentation) {
        dateTimeFormatter = useZuluUtcRepresentation ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendOffset("+HH:MM", "+00:00").toFormatter();
    }

    public static void configureWith(boolean useZuluUtcRepresentation, ZoneId defaultZoneId) {
        DateTime.defaultZoneId = defaultZoneId;
        DateTime.useZuluUtcRepresentation(useZuluUtcRepresentation);
    }

    public DateTime(String dateTimeString) throws SyntaxException {
        try {
            TemporalAccessor parsed;
            boolean handle24hours = dateTimeString.contains("T24:00");
            if (handle24hours) {
                dateTimeString = dateTimeString.replace("T24:00", "T00:00");
            }
            this.dateTime = (parsed = DateTimeFormatter.ISO_DATE_TIME.parseBest(dateTimeString.trim(), OffsetDateTime::from, LocalDateTime::from)) instanceof LocalDateTime ? ((LocalDateTime)parsed).atZone(defaultZoneId).toOffsetDateTime() : (OffsetDateTime)parsed;
            if (handle24hours) {
                this.dateTime = this.dateTime.plus(1L, ChronoUnit.DAYS);
            }
        }
        catch (DateTimeParseException e) {
            String message = String.format("Parsing dateTime %s is not supported.", dateTimeString);
            logger.error(message);
            throw new SyntaxException(message, e);
        }
    }

    public String toString() {
        return this.dateTime.format(dateTimeFormatter);
    }

    @Override
    public int compareTo(DateTime o) {
        OffsetDateTime thisDateTime = this.getDateTime();
        OffsetDateTime thatDateTime = o.getDateTime();
        return OffsetDateTime.timeLineOrder().compare(thisDateTime, thatDateTime);
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(DateTime.class)) {
            return false;
        }
        OffsetDateTime thisDateTime = this.getDateTime();
        OffsetDateTime thatDateTime = ((DateTime)obj).getDateTime();
        return thisDateTime.isEqual(thatDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.dateTime);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public void add(DayTimeDuration dayTimeDuration) {
        this.dateTime = this.dateTime.plus(dayTimeDuration.getDuration());
    }

    public void add(YearMonthDuration yearMonthDuration) {
        this.dateTime = yearMonthDuration.isNegative() ? this.dateTime.minus(yearMonthDuration.getDuration()) : this.dateTime.plus(yearMonthDuration.getDuration());
    }

    public void subtract(DayTimeDuration dayTimeDuration) {
        this.dateTime = this.dateTime.minus(dayTimeDuration.getDuration());
    }

    public void subtract(YearMonthDuration yearMonthDuration) {
        this.dateTime = yearMonthDuration.isNegative() ? this.dateTime.plus(yearMonthDuration.getDuration()) : this.dateTime.minus(yearMonthDuration.getDuration());
    }

    static {
        DateTime.configureWith(false, ZoneOffset.UTC);
    }
}

