/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.web.lib.mvc.CheckboxStatusType;
import org.openspcoop2.web.lib.mvc.DataElementConfirm;
import org.openspcoop2.web.lib.mvc.DataElementImage;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementParameter;
import org.openspcoop2.web.lib.mvc.DataElementPassword;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.Dialog;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TargetType;

public class DataElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Map<String, String> escapeMap = null;
    private static int DATA_ELEMENT_SIZE = 50;
    private static int DATA_ELEMENT_COLS = 15;
    private static int DATA_ELEMENT_ROWS = 5;
    String label = "";
    String labelRight = null;
    String labelLink = null;
    String value = "";
    String type = "text";
    String name = "";
    String onChange = "";
    String selected = "";
    String[] values = null;
    String[] names = null;
    String[] labels = null;
    int size;
    int cols;
    int rows;
    int id;
    boolean affiancato = false;
    boolean labelAffiancata = true;
    String idToRemove;
    boolean required = false;
    boolean bold = false;
    boolean postBack = false;
    boolean abilitaFiltroOpzioniSelect = true;
    String note = "";
    String styleClass = "inputLinkLong";
    String labelStyleClass = null;
    DataElementInfo info = null;
    String[] selezionati = null;
    private String style = null;
    private String width = null;
    private Integer minValue = null;
    private Integer maxValue = null;
    private List<DataElementImage> image = null;
    private String icon = "";
    private String url = "";
    private String toolTip = "";
    private String target = "";
    private String onClick = "";
    private boolean showAjaxStatus = true;
    private Map<String, String> dataAttributes = null;
    private String customJsFunction = null;
    private List<String> statusValues = null;
    private List<String> statusToolTips = null;
    private List<String> statusTypes = null;
    private DataElementPassword password = null;
    private boolean visualizzaLinkApriNuovaFinestra = false;
    private STATO_APERTURA_SEZIONI statoSottosezione = STATO_APERTURA_SEZIONI.CHIUSO;
    private boolean modalitaAccordion = false;
    private String valoreDefault = null;
    private Dialog dialog = null;
    private DataElementConfirm confirm = null;
    private boolean contextMenu = false;
    private String copyToClipboard = null;
    private boolean refresh = false;

    public static void initialize(DataElementParameter p) {
        if (p.getSize() != null && p.getSize() > 0) {
            DATA_ELEMENT_SIZE = p.getSize();
        }
        if (p.getCols() != null && p.getCols() > 0) {
            DATA_ELEMENT_COLS = p.getCols();
        }
        if (p.getRows() != null && p.getRows() > 0) {
            DATA_ELEMENT_ROWS = p.getRows();
        }
    }

    public String getIdToRemove() {
        return this.idToRemove;
    }

    public void setIdToRemove(String idToRemove) {
        this.idToRemove = idToRemove;
    }

    public DataElement() {
        this.image = new ArrayList<DataElementImage>();
        this.size = DATA_ELEMENT_SIZE;
        this.cols = DATA_ELEMENT_COLS;
        this.rows = DATA_ELEMENT_ROWS;
        this.dataAttributes = new HashMap<String, String>();
    }

    public void setId(int i) {
        this.id = i;
    }

    public int getId() {
        return this.id;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public String getOriginalLabel() {
        return DataElement.getEscapedValue(DataElement.checkNull(this.label));
    }

    public String getLabel() {
        return this.getLabel(true);
    }

    public String getLabel(boolean elementsRequiredEnabled) {
        StringBuilder bf = new StringBuilder();
        if (this.bold) {
            bf.append("<B>");
        }
        bf.append(DataElement.getEscapedValue(DataElement.checkNull(this.label)));
        if (elementsRequiredEnabled && this.required) {
            bf.append(" <em>*</em>");
        }
        if (this.bold) {
            bf.append("</B>");
        }
        return bf.toString();
    }

    public void setValue(String s) {
        this.value = s;
    }

    public String getValue() {
        return DataElement.checkNull(this.value);
    }

    public String getValuesNoEdit(String mode) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            String val = this.values[i];
            String cLabel = this.labels[i];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String notDefValue = mode.equals("view-noeditbutton") ? "&nbsp;" : "not defined";
            String valore = val != null && !val.equals("") ? val : notDefValue;
            sb.append(cLabel).append(": ").append(valore);
        }
        return sb.toString();
    }

    public void setType(DataElementType s) {
        this.setType(s.toString());
    }

    private void setType(String s) {
        this.type = s;
        if (DataElementType.TEXT_AREA.toString().equals(s) || DataElementType.TEXT_AREA_NO_EDIT.toString().equals(s)) {
            this.setLabelAffiancata(false);
        }
        if (DataElementType.CRYPT.toString().equals(s)) {
            this.password = new DataElementPassword();
        }
        if (DataElementType.TEXT.toString().equals(s)) {
            this.styleClass = "spanNoEdit";
        }
        if (DataElementType.CHECKBOX.toString().equals(s)) {
            this.styleClass = null;
        }
        if (DataElementType.TITLE.toString().equals(s)) {
            this.statoSottosezione = STATO_APERTURA_SEZIONI.DISABILITATO;
        }
        if (DataElementType.SUBTITLE.toString().equals(s)) {
            this.statoSottosezione = STATO_APERTURA_SEZIONI.DISABILITATO;
        }
        if (DataElementType.LINK.toString().equals(s)) {
            this.styleClass = null;
        }
        if (DataElementType.BUTTON.toString().equals(s)) {
            this.styleClass = "deButton";
        }
        if (DataElementType.LOCK.toString().equals(s)) {
            throw new UtilsRuntimeException("Use method setLock(String value) instead of setType(DataElementType.LOCK)");
        }
    }

    public String getType() {
        return DataElement.checkNull(this.type);
    }

    public void setLock(String value, boolean readOnly, boolean visualizzaInformazioniCifrate, boolean visualizzaIconaLucchetto, String warningMessage, String decoderServletName, Parameter ... parameter) {
        this.setValue(value);
        this.type = DataElementType.LOCK.toString();
        this.password = new DataElementPassword();
        this.password.setLockReadOnly(readOnly);
        this.password.setLockVisualizzaInformazioniCifrate(visualizzaInformazioniCifrate);
        this.password.setLockWarningMessage(warningMessage);
        this.password.setLockVisualizzaIconaLucchetto(visualizzaIconaLucchetto);
        this.setUrl(decoderServletName, parameter);
    }

    public void forceLockVisualizzazioneInputUtente(boolean isWrapped, boolean visualizzaInformazioniCifrate) {
        if (this.password != null) {
            if (isWrapped) {
                this.password.setLockForzaVisualizzazioneInputUtente(false);
                this.password.setLockVisualizzaInformazioniCifrate(visualizzaInformazioniCifrate);
                this.password.setLockUtilizzaInputPassword(false);
            } else {
                this.password.setLockForzaVisualizzazioneInputUtente(true);
                this.password.setLockVisualizzaInformazioniCifrate(false);
                this.password.setLockUtilizzaInputPassword(false);
            }
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setUrl(String s) {
        this.url = s;
    }

    public void setUrl(String servletName, Parameter ... parameter) {
        this.url = DataElement._getUrlValue(servletName, parameter);
    }

    public static String _getUrlValue(String servletName, Parameter ... parameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(servletName);
        if (parameter != null && parameter.length > 0) {
            if (sb.indexOf("?") > 0) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            for (int i = 0; i < parameter.length; ++i) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(parameter[i].toString());
            }
        }
        String urValue = sb.toString();
        return urValue;
    }

    public void addParameter(Parameter ... parameter) {
        this.url = DataElement._getUrlValue(this.url, parameter);
    }

    public String getUrl() {
        return DataElement.checkNull(this.url);
    }

    public void setTarget(TargetType s) {
        this.target = s != null ? s.toString() : null;
    }

    public String getTarget() {
        return DataElement.checkNull(this.target);
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return DataElement.checkNull(this.name);
    }

    public void setOnClick(String s) {
        this.onClick = s;
    }

    public String getOnClick() {
        return DataElement.checkNull(this.onClick);
    }

    @Deprecated
    public void setOnChange(String s) {
        this.onChange = s;
    }

    public void setOnChangeAlternativePostBack(String s) {
        this.onChange = s;
    }

    public String getOnChange() {
        return DataElement.checkNull(this.onChange);
    }

    public void setSelected(String s) {
        this.selected = s;
    }

    public void setSelectedAsNull() {
        this.selected = null;
    }

    public void setSelected(boolean isFlag) {
        this.selected = isFlag ? "yes" : "no";
    }

    public void setSelected(CheckboxStatusType status) {
        this.selected = status.toString();
    }

    public String getSelected() {
        return DataElement.checkNull(this.selected);
    }

    public void setSize(int i) {
        this.size = i;
    }

    public int getSize() {
        return this.size;
    }

    public void setCols(int i) {
        this.cols = i;
    }

    public int getCols() {
        return this.cols;
    }

    public void setRows(int i) {
        this.rows = i;
    }

    public int getRows() {
        return this.rows;
    }

    public void setAffiancato(boolean b) {
        this.affiancato = b;
    }

    public boolean getAffiancato() {
        return this.affiancato;
    }

    public void setValues(String[] s) {
        this.values = s;
    }

    public void setValues(List<String> s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        this.setValues(s.toArray(new String[1]));
    }

    public String[] getValues() {
        return this.values;
    }

    public void setLabels(String[] s) {
        if (s != null && s.length > 0) {
            this.labels = new String[s.length];
            for (int i = 0; i < s.length; ++i) {
                this.labels[i] = DataElement.getEscapedValue(s[i]);
            }
        } else {
            this.labels = s;
        }
    }

    public void setLabels(List<String> s) {
        if (s == null || s.size() <= 0) {
            return;
        }
        this.setLabels(s.toArray(new String[1]));
    }

    public String[] getLabels() {
        return this.labels;
    }

    public static String checkNull(String toCheck) {
        return toCheck == null ? "" : toCheck;
    }

    public String getToolTip() {
        return DataElement.checkNull(this.toolTip);
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isLabelAffiancata() {
        return this.labelAffiancata;
    }

    public void setLabelAffiancata(boolean labelAffiancata) {
        this.labelAffiancata = labelAffiancata;
    }

    public boolean isPostBack() {
        return this.postBack;
    }

    public void setPostBack(boolean postBack) {
        this.setPostBack(postBack, true);
    }

    public void setPostBack(boolean postBack, boolean setElementName) {
        this.setPostBack(postBack, setElementName, false);
    }

    public void setPostBack_viaPOST(boolean postBack) {
        this.setPostBack(postBack, true, true);
    }

    private void setPostBack(boolean postBack, boolean setElementName, boolean viaPOST) {
        this.postBack = postBack;
        if (this.postBack) {
            if (setElementName) {
                if (this.name == null || "".equals(this.name)) {
                    throw new RuntimeException("Per poter impostare il nome dell'element che scaturira' il postBack deve prima essere indicato tramite il metodo setName");
                }
                Object prefix = "";
                if (viaPOST) {
                    prefix = "postVersion_";
                }
                prefix = (String)prefix + "postBack('";
                this.setOnClick((String)prefix + this.name + "')");
                this.setOnChange((String)prefix + this.name + "')");
            } else {
                this.setOnClick("postBack()");
                this.setOnChange("postBack()");
            }
        } else {
            this.setOnClick(null);
            this.setOnChange(null);
        }
    }

    public static String getEscapedValue(String value) {
        String escaped = StringEscapeUtils.escapeHtml((String)StringEscapeUtils.unescapeHtml((String)DataElement.checkNull(value)));
        for (String key : escapeMap.keySet()) {
            if (!escaped.contains(key)) continue;
            escaped = escaped.replaceAll(key, escapeMap.get(key));
        }
        return escaped;
    }

    public String getNote() {
        return DataElement.checkNull(this.note);
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getStyleClass() {
        return DataElement.checkNull(this.styleClass);
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setSelezionati(String[] s) {
        this.selezionati = s;
    }

    public void setSelezionati(List<String> s) {
        if (s == null || s.size() <= 0) {
            return;
        }
        this.setSelezionati(s.toArray(new String[1]));
    }

    public String[] getSelezionati() {
        return this.selezionati;
    }

    public String getSelezionatiAsString() {
        if (this.selezionati == null || this.selezionati.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.selezionati.length; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(DataElement.checkNull(this.selezionati[i]));
        }
        return sb.toString();
    }

    public boolean isSelected(String value) {
        if (this.selezionati == null || this.selezionati.length <= 0) {
            return false;
        }
        for (int i = 0; i < this.selezionati.length; ++i) {
            if (!value.equals(DataElement.checkNull(this.selezionati[i]))) continue;
            return true;
        }
        return false;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public String getStyle() {
        String width = this.getWidth();
        if (StringUtils.isNotEmpty((String)this.style)) {
            if (width != null) {
                return DataElement.checkNull(this.style) + " " + width;
            }
        } else if (width != null) {
            return width;
        }
        return DataElement.checkNull(this.style);
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getWidth() {
        if (StringUtils.isNotEmpty((String)this.width)) {
            return " width: " + this.width + ";";
        }
        return null;
    }

    public void allineaTdAlCentro() {
        String styleAllinaCentro = "text-align : center;";
        this.setStyle(styleAllinaCentro);
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setWidthPx(int width) {
        this.setWidth(width + "px");
    }

    public void setWidthCm(int width) {
        this.setWidth(width + "cm");
    }

    public void setWidthAuto() {
        this.setWidth("auto");
    }

    public void setWidthPercentuale(int width) {
        this.setWidth(width + "%");
    }

    public String getLabelStyleClass() {
        return DataElement.checkNull(this.labelStyleClass);
    }

    public void setLabelStyleClass(String labelStyleClass) {
        this.labelStyleClass = labelStyleClass;
    }

    public String getLabelRight() {
        return DataElement.checkNull(this.labelRight);
    }

    public void setLabelRight(String labelRight) {
        this.labelRight = labelRight;
    }

    public String getLabelLink() {
        return DataElement.checkNull(this.labelLink);
    }

    public void setLabelLink(String labelLink) {
        this.labelLink = labelLink;
    }

    public String getIcon() {
        return DataElement.checkNull(this.icon);
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setIcon(String icon, String tooltip, String url, TargetType target) {
        this.image.clear();
        DataElementImage newImage = new DataElementImage();
        newImage.setImage(icon);
        newImage.setTarget(target);
        newImage.setUrl(url);
        newImage.setToolTip(tooltip);
        this.image.add(newImage);
    }

    @Deprecated
    public void setImage(List<DataElementImage> image) {
        this.image = image;
    }

    public List<DataElementImage> getImage() {
        return this.image;
    }

    public void setImage(DataElementImage icon) {
        this.image.clear();
        this.image.add(icon);
    }

    public void addImage(String icon) {
        DataElementImage newImage = new DataElementImage();
        newImage.setImage(icon);
        this.image.add(newImage);
    }

    public void addImage(DataElementImage icon) {
        this.image.add(icon);
    }

    public Map<String, String> getDataAttributes() {
        return this.dataAttributes;
    }

    @Deprecated
    public void setDataAttributes(Map<String, String> dataAttributes) {
        this.dataAttributes = dataAttributes;
    }

    public String getDataAttributesAsString() {
        StringBuilder sb = new StringBuilder();
        if (!this.dataAttributes.isEmpty()) {
            for (String key : this.dataAttributes.keySet()) {
                if (key.equals("colors")) continue;
                sb.append("data-").append(key).append("=\"").append(this.dataAttributes.get(key)).append("\"");
            }
        }
        return sb.toString();
    }

    public void enableTags() {
        this.getDataAttributes().put("role", "tagsinput");
    }

    public void enableTags(boolean multicolor) {
        this.getDataAttributes().put("role", "tagsinput");
        this.getDataAttributes().put("colors", "true");
    }

    public void reloadMinValue(boolean reload) {
        if (reload) {
            this.setCustomJsFunction(null);
        } else {
            this.setCustomJsFunction("customInputNumberChangeEventHandler");
        }
    }

    public String getCustomJsFunction() {
        return DataElement.checkNull(this.customJsFunction);
    }

    public void setCustomJsFunction(String customJsFunction) {
        this.customJsFunction = customJsFunction;
    }

    public void setNames(String[] s) {
        this.names = s;
    }

    public void setNames(List<String> s) {
        if (s == null || s.size() <= 0) {
            return;
        }
        this.setNames(s.toArray(new String[1]));
    }

    public String[] getNames() {
        return this.names;
    }

    public void setInfo(DataElementInfo info) {
        this.info = info;
    }

    public void setInfo(String titolo, String info) {
        this.info = new DataElementInfo(titolo);
        this.info.setHeaderBody(info);
    }

    public DataElementInfo getInfo() {
        return this.info;
    }

    @Deprecated
    public void setStatusValues(List<String> v) {
        this.statusValues = v;
    }

    @Deprecated
    public void setStatusValues(String[] v) {
        this.statusValues = v == null || v.length <= 0 ? null : Arrays.asList(v);
    }

    private void addStatusValue(String v) {
        if (this.statusValues == null) {
            this.statusValues = new ArrayList<String>();
        }
        this.statusValues.add(v);
    }

    public void setStatusValue(String v) {
        this.statusValues = new ArrayList<String>();
        this.statusValues.add(v);
    }

    public String[] getStatusValues() {
        if (this.statusValues == null || this.statusValues.size() <= 0) {
            return null;
        }
        return this.statusValues.toArray(new String[1]);
    }

    public List<String> getStatusValuesAsList() {
        return this.statusValues;
    }

    private void addStatusToolTip(String v) {
        if (this.statusToolTips == null) {
            this.statusToolTips = new ArrayList<String>();
        }
        this.statusToolTips.add(v);
    }

    public void setStatusToolTip(String v) {
        this.statusToolTips = new ArrayList<String>();
        this.statusToolTips.add(v);
    }

    public String[] getStatusToolTips() {
        if (this.statusToolTips == null || this.statusToolTips.size() <= 0) {
            return null;
        }
        return this.statusToolTips.toArray(new String[1]);
    }

    public List<String> getStatusToolTipsAsList() {
        return this.statusToolTips;
    }

    @Deprecated
    public void setStatusToolTips(List<String> v) {
        this.statusToolTips = v;
    }

    @Deprecated
    public void setStatusToolTips(String[] v) {
        this.statusToolTips = v == null || v.length <= 0 ? null : Arrays.asList(v);
    }

    private void addStatusType(String v) {
        if (this.statusTypes == null) {
            this.statusTypes = new ArrayList<String>();
        }
        this.statusTypes.add(v);
    }

    private void addStatusType(CheckboxStatusType v) {
        if (v != null) {
            this.addStatusType(v.toString());
        }
    }

    public void setStatusType(String v) {
        this.statusTypes = new ArrayList<String>();
        this.statusTypes.add(v);
    }

    public void setStatusType(CheckboxStatusType v) {
        if (v != null) {
            this.setStatusType(v.toString());
        }
    }

    public String[] getStatusTypes() {
        if (this.statusTypes == null || this.statusTypes.size() <= 0) {
            return null;
        }
        return this.statusTypes.toArray(new String[1]);
    }

    public List<String> getStatusTypesAsList() {
        return this.statusTypes;
    }

    @Deprecated
    public void setStatusTypes(List<String> v) {
        this.statusTypes = v;
    }

    @Deprecated
    public void setStatusTypes(String[] v) {
        this.statusTypes = v == null || v.length <= 0 ? null : Arrays.asList(v);
    }

    public void addStatus(String value, CheckboxStatusType type) {
        this.addStatus(null, value, type);
    }

    public void addStatus(String tooltip, String value, CheckboxStatusType type) {
        this.addStatusToolTip(tooltip);
        this.addStatusValue(value);
        this.addStatusType(type);
    }

    public void addStatus(String value, String type) {
        this.addStatus(null, value, type);
    }

    public void addStatus(String tooltip, String value, String type) {
        this.addStatusToolTip(tooltip);
        this.addStatusValue(value);
        this.addStatusType(type);
    }

    public void setDisabilitaAjaxStatus() {
        this.showAjaxStatus = false;
    }

    public boolean isShowAjaxStatus() {
        return this.showAjaxStatus;
    }

    public void setShowAjaxStatus(boolean showAjaxStatus) {
        this.showAjaxStatus = showAjaxStatus;
    }

    public void spostaLinkADestra() {
        this.setStyle("margin-left: auto;");
    }

    public DataElementPassword getPassword() {
        return this.password;
    }

    public void setPassword(DataElementPassword password) {
        this.password = password;
    }

    public boolean isAbilitaFiltroOpzioniSelect() {
        return this.abilitaFiltroOpzioniSelect;
    }

    public void disabilitaFiltroOpzioniSelect() {
        this.setAbilitaFiltroOpzioniSelect(false);
    }

    public void setAbilitaFiltroOpzioniSelect(boolean abilitaFiltroOpzioniSelect) {
        this.abilitaFiltroOpzioniSelect = abilitaFiltroOpzioniSelect;
    }

    public boolean isVisualizzaLinkApriNuovaFinestra() {
        return this.visualizzaLinkApriNuovaFinestra;
    }

    public void setVisualizzaLinkApriNuovaFinestra(boolean visualizzaLinkApriNuovaFinestra) {
        this.visualizzaLinkApriNuovaFinestra = visualizzaLinkApriNuovaFinestra;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public void setValoreBold() {
        this.setStyleClass("spanNoEdit-bold");
    }

    public void setValoreBoldRed() {
        this.setStyleClass("spanNoEdit-bold-red");
    }

    public boolean isVisualizzaSezioneAperta() {
        return STATO_APERTURA_SEZIONI.APERTO.equals((Object)this.statoSottosezione);
    }

    public void setStatoAperturaSezioni(STATO_APERTURA_SEZIONI stato) {
        this.statoSottosezione = stato;
    }

    public STATO_APERTURA_SEZIONI getStatoSottosezione() {
        return this.statoSottosezione;
    }

    public String getValoreDefault() {
        return this.valoreDefault;
    }

    public void setValoreDefault(String valoreDefault) {
        this.valoreDefault = valoreDefault;
    }

    public void setValoreDefaultCheckbox(boolean valoreDefault) {
        this.valoreDefault = ServletUtils.boolToCheckBoxStatus(valoreDefault);
    }

    public boolean getValoreDefaultCheckbox() {
        return this.valoreDefault != null ? ServletUtils.isCheckBoxEnabled(this.valoreDefault) : false;
    }

    public void setValoreDefaultSelect(String valoreDefault) {
        this.valoreDefault = valoreDefault;
    }

    public void setValoreDefaultMultiSelect(String[] valoriDefault) {
        if (valoriDefault != null && valoriDefault.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < valoriDefault.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(DataElement.checkNull(valoriDefault[i]));
            }
            this.valoreDefault = sb.toString();
        }
    }

    public boolean isElementoDaControllarePerCheckDefaultNelleForm() {
        return !DataElementType.HIDDEN.toString().equals(this.getType()) && !DataElementType.SUBTITLE.toString().equals(this.getType()) && !DataElementType.TITLE.toString().equals(this.getType()) && !DataElementType.LINK.toString().equals(this.getType()) && !DataElementType.FILE.toString().equals(this.getType()) && !DataElementType.MULTI_FILE.toString().equals(this.getType()) && !DataElementType.CRYPT.toString().equals(this.getType()) && !DataElementType.NOTE.toString().equals(this.getType()) && !DataElementType.IMAGE.toString().equals(this.getType()) && !DataElementType.BUTTON.toString().equals(this.getType());
    }

    public void addInfoAuditDataCreazione(String tooltip, String value) {
        this.addStatus(tooltip, value, "&#xE8B5;");
    }

    public void addInfoAuditDataAggiornamento(String tooltip, String value) {
        this.addStatus(tooltip, value, "&#xE923;");
    }

    public void addInfoAuditUtente(String tooltip, String value) {
        this.addStatus(tooltip, value, "&#xE7FD;");
    }

    public DataElementConfirm getConfirm() {
        return this.confirm;
    }

    public void setConfirm(DataElementConfirm confirm) {
        this.confirm = confirm;
    }

    public void setConfirm(String titolo, String messaggio, String testoBottoneAzione) {
        this.confirm = new DataElementConfirm();
        this.confirm.setTitolo(titolo);
        this.confirm.setBody(messaggio);
        this.confirm.setAzione(testoBottoneAzione);
    }

    public boolean isContextMenu() {
        return this.contextMenu;
    }

    public void setContextMenu(boolean contextMenu) {
        this.contextMenu = contextMenu;
    }

    public void setCopyToClipboard(String copyToClipboard) {
        this.copyToClipboard = copyToClipboard;
    }

    public String getCopyToClipboard() {
        return this.copyToClipboard;
    }

    public void abilitaRefresh() {
        this.setRefresh(true);
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void abilitaModalitaAccordion() {
        this.setModalitaAccordion(true);
    }

    public void setModalitaAccordion(boolean modalitaAccordion) {
        this.modalitaAccordion = modalitaAccordion;
    }

    public boolean isModalitaAccordion() {
        return this.modalitaAccordion;
    }

    static {
        escapeMap = new HashMap<String, String>();
        escapeMap.put("&lt;BR&gt;", "<BR>");
        escapeMap.put("&lt;BR/&gt;", "<BR/>");
        escapeMap.put("&lt;/BR&gt;", "</BR>");
        escapeMap.put("&lt;br&gt;", "<br>");
        escapeMap.put("&lt;br/&gt;", "<br/>");
        escapeMap.put("&lt;/br&gt;", "</br>");
    }

    public static enum STATO_APERTURA_SEZIONI {
        APERTO,
        CHIUSO,
        DISABILITATO;

    }
}

