/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.byok;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.pdd.core.byok.DriverBYOKUtilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.Parameter;

public class LockUtilities {
    private DriverBYOKUtilities driverBYOKUtilities;
    private boolean visualizzaInformazioniCifrate;
    private boolean visualizzaCampiPasswordComeLock;
    private String warningMessage;
    private String servletNameSecretDecoder;
    private String messaggioInformativoInformazioneNonCifrata;
    private String messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy;

    public LockUtilities(DriverBYOKUtilities driverBYOKUtilities, boolean visualizzaInformazioniCifrate, String warningMessage, String servletNameSecretDecoder, String messaggioInformativoInformazioneNonCifrata, String messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy, boolean visualizzaCampiPasswordComeLock) {
        this.driverBYOKUtilities = driverBYOKUtilities;
        this.visualizzaInformazioniCifrate = visualizzaInformazioniCifrate;
        this.warningMessage = warningMessage;
        this.servletNameSecretDecoder = servletNameSecretDecoder;
        this.messaggioInformativoInformazioneNonCifrata = messaggioInformativoInformazioneNonCifrata;
        this.messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy = messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy;
        this.visualizzaCampiPasswordComeLock = visualizzaCampiPasswordComeLock;
    }

    public void lockProperty(DataElement de, String value) {
        this.lockProperty(de, value, true);
    }

    public void lockProperty(DataElement de, String value, boolean escapeHtml) {
        this.lockPropertyEngine(de, value, escapeHtml, false, false);
    }

    public void lockPropertyReadOnly(DataElement de, String value) {
        this.lockPropertyReadOnly(de, value, true);
    }

    public void lockPropertyReadOnly(DataElement de, String value, boolean escapeHtml) {
        this.lockPropertyEngine(de, value, escapeHtml, false, true);
    }

    public void lockPropertyHidden(DataElement de, String value) {
        this.lockPropertyHidden(de, value, true);
    }

    public void lockPropertyHidden(DataElement de, String value, boolean escapeHtml) {
        this.lockPropertyEngine(de, value, escapeHtml, true, false);
    }

    private void lockPropertyEngine(DataElement de, String value, boolean escapeHtml, boolean hidden, boolean readOnly) {
        if (BYOKManager.isEnabledBYOK()) {
            this.lockEngineWithBIOK(de, value, escapeHtml, hidden, readOnly, value);
            de.forceLockVisualizzazioneInputUtente(this.driverBYOKUtilities.isWrappedWithAnyPolicy(value), this.visualizzaInformazioniCifrate);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(value);
        }
    }

    public void lock(DataElement de, String value) throws UtilsException {
        this.lock(de, value, true);
    }

    public void lock(DataElement de, String value, boolean escapeHtml) throws UtilsException {
        this.lockEngine(de, value, escapeHtml, false, false);
    }

    public void lockReadOnly(DataElement de, String value) throws UtilsException {
        this.lockReadOnly(de, value, true);
    }

    public void lockReadOnly(DataElement de, String value, boolean escapeHtml) throws UtilsException {
        this.lockEngine(de, value, escapeHtml, false, true);
    }

    public void lockHidden(DataElement de, String value) throws UtilsException {
        this.lockHidden(de, value, true);
    }

    public void lockHidden(DataElement de, String value, boolean escapeHtml) throws UtilsException {
        this.lockEngine(de, value, escapeHtml, true, false);
    }

    private void lockEngine(DataElement de, String value, boolean escapeHtml, boolean hidden, boolean readOnly) throws UtilsException {
        if (BYOKManager.isEnabledBYOK()) {
            this.lockEngineWithBIOK(de, value, escapeHtml, hidden, readOnly);
        } else {
            this.processByByokDisabled(de, value, escapeHtml, hidden, readOnly);
        }
    }

    private void processByByokDisabled(DataElement de, String value, boolean escapeHtml, boolean hidden, boolean readOnly) {
        if (this.isForceHidden(de, hidden)) {
            de.setType(DataElementType.HIDDEN);
        } else if (this.isForceReadOnly(de, readOnly)) {
            if (this.visualizzaCampiPasswordComeLock) {
                this.lockEngineWithoutBIOK(de, value, escapeHtml, hidden, readOnly);
            } else {
                de.setType(DataElementType.TEXT);
            }
        } else if (de.getType() == null || StringUtils.isEmpty((String)de.getType()) || !DataElementType.TEXT_EDIT.toString().equals(de.getType()) && !DataElementType.TEXT_AREA.toString().equals(de.getType())) {
            this.processByByokDisabledDataElement(de, value, escapeHtml, hidden, readOnly);
        } else {
            this.processByByokDisabledDataElement(de, value, escapeHtml, hidden, readOnly);
        }
        de.setValue(escapeHtml ? StringEscapeUtils.escapeHtml((String)value) : value);
    }

    private void processByByokDisabledDataElement(DataElement de, String value, boolean escapeHtml, boolean hidden, boolean readOnly) {
        if (this.visualizzaCampiPasswordComeLock) {
            this.lockEngineWithoutBIOK(de, value, escapeHtml, hidden, readOnly);
        } else if (hidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
        }
    }

    private boolean isForceHidden(DataElement de, boolean hidden) {
        return hidden && (de.getType() == null || StringUtils.isEmpty((String)de.getType()) || !DataElementType.HIDDEN.toString().equals(de.getType()));
    }

    private boolean isForceReadOnly(DataElement de, boolean readOnly) {
        return readOnly && (de.getType() == null || StringUtils.isEmpty((String)de.getType()) || !DataElementType.TEXT.toString().equals(de.getType()));
    }

    private void lockEngineWithBIOK(DataElement de, String value, boolean escapeHtml, boolean hidden, boolean readOnly) throws UtilsException {
        String wrapValue = this.driverBYOKUtilities.wrap(value);
        this.lockEngineWithBIOK(de, value, escapeHtml, hidden, readOnly, wrapValue);
    }

    private void lockEngineWithBIOK(DataElement de, String value, boolean escapeHtml, boolean hidden, boolean readOnly, String wrapValue) {
        if (hidden) {
            if (de.getType() == null || StringUtils.isEmpty((String)de.getType()) || !DataElementType.HIDDEN.toString().equals(de.getType())) {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue(escapeHtml ? StringEscapeUtils.escapeHtml((String)wrapValue) : wrapValue);
        } else {
            this.lockEngineWithBIOK(de, wrapValue, value, escapeHtml, readOnly);
        }
    }

    private void lockEngineWithBIOK(DataElement de, String wrapValue, String originalValue, boolean escapeHtml, boolean readOnly) {
        this.lockEngineWithBIOK(de, wrapValue, originalValue, escapeHtml, readOnly, false);
    }

    private void lockEngineWithBIOK(DataElement de, String wrapValue, String originalValue, boolean escapeHtml, boolean readOnly, boolean checkOriginalValue) {
        String checkValue;
        StringBuilder sb = new StringBuilder();
        if (originalValue != null) {
            // empty if block
        }
        if ((checkValue = wrapValue) != null && StringUtils.isNotEmpty((String)checkValue)) {
            if (BYOKUtilities.isWrappedValue((String)checkValue)) {
                if (!this.driverBYOKUtilities.isWrappedWithActivePolicy(checkValue)) {
                    this.appendErrorMessageSecurityPolicyDifferente(sb, checkValue);
                }
            } else if (checkOriginalValue && this.messaggioInformativoInformazioneNonCifrata != null && StringUtils.isNotEmpty((String)this.messaggioInformativoInformazioneNonCifrata)) {
                sb.append(this.messaggioInformativoInformazioneNonCifrata);
            }
        }
        if (sb.length() > 0) {
            de.setNote(sb.toString());
        }
        de.setLock(escapeHtml ? StringEscapeUtils.escapeHtml((String)wrapValue) : wrapValue, readOnly, this.visualizzaInformazioniCifrate, true, this.warningMessage, this.servletNameSecretDecoder, new Parameter[0]);
    }

    private void lockEngineWithoutBIOK(DataElement de, String wrapValue, boolean escapeHtml, boolean hidden, boolean readOnly) {
        if (hidden) {
            if (de.getType() == null || StringUtils.isEmpty((String)de.getType()) || !DataElementType.HIDDEN.toString().equals(de.getType())) {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue(escapeHtml ? StringEscapeUtils.escapeHtml((String)wrapValue) : wrapValue);
        } else {
            de.setLock(escapeHtml ? StringEscapeUtils.escapeHtml((String)wrapValue) : wrapValue, readOnly, false, false, null, null, new Parameter[0]);
        }
    }

    private void appendErrorMessageSecurityPolicyDifferente(StringBuilder sb, String wrapValue) {
        LockUtilities.appendErrorMessageSecurityPolicyDifferente(this.messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy, sb, wrapValue);
    }

    public static void appendErrorMessageSecurityPolicyDifferente(String messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy, StringBuilder sb, String wrapValue) {
        if (messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy != null && StringUtils.isNotEmpty((String)messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy)) {
            String suffix = "";
            try {
                String old = BYOKUtilities.getPolicy((String)wrapValue);
                if (old != null && StringUtils.isNotEmpty((String)old)) {
                    suffix = old;
                }
            }
            catch (Exception old) {
                // empty catch block
            }
            String s = messaggioInformativoInformazioneCifrataDifferenteSecurityPolicy.replace("@SECURITY_POLICY_ID@", suffix);
            sb.append(s);
        }
    }

    public DriverBYOKUtilities getDriverBYOKUtilities() {
        return this.driverBYOKUtilities;
    }
}

