/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort.actions;

import java.util.UUID;
import net.sf.jasperreports.components.sort.actions.FilterCommand;
import net.sf.jasperreports.components.sort.actions.FilterData;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandStack;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class FilterAction
extends AbstractAction {
    private static final long serialVersionUID = 10200L;
    private FilterData filterData;
    protected static FormatFactory formatFactory = new DefaultFormatFactory();

    public FilterData getFilterData() {
        return this.filterData;
    }

    public void setFilterData(FilterData filterData) {
        this.filterData = filterData;
    }

    @Override
    public void performAction() throws ActionException {
        CommandTarget target;
        if (this.filterData != null && (target = this.getCommandTarget(UUID.fromString(this.filterData.getTableUuid()))) != null) {
            JasperDesignCache cache = JasperDesignCache.getInstance(this.getJasperReportsContext(), this.getReportContext());
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            CommandStack commandStack = this.getCommandStack();
            try {
                commandStack.execute(new ResetInCacheCommand(new FilterCommand(this.getJasperReportsContext(), dataset, this.getFilterData()), this.getJasperReportsContext(), this.getReportContext(), target.getUri()));
            }
            catch (CommandException e) {
                throw new ActionException(e);
            }
        }
    }
}

