/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.text.AttributedCharacterIterator;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.StyledTextListWriter;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.PdfTextAlignment;

public abstract class AbstractPdfTextRenderer
extends AbstractTextRenderer {
    protected JRPdfExporter pdfExporter;
    protected PdfProducer pdfProducer;
    protected JRPdfExporterTagHelper tagHelper;
    protected PdfTextAlignment horizontalAlignment;
    protected float leftOffsetFactor;
    protected float rightOffsetFactor;

    public AbstractPdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        this(jasperReportsContext, ignoreMissingFont, true, false);
    }

    public AbstractPdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        super(jasperReportsContext, false, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
    }

    public void initialize(JRPdfExporter pdfExporter, PdfProducer pdfProducer, JRPdfExporterTagHelper tagHelper, JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        this.pdfExporter = pdfExporter;
        this.pdfProducer = pdfProducer;
        this.tagHelper = tagHelper;
        this.horizontalAlignment = PdfTextAlignment.LEFT;
        this.leftOffsetFactor = 0.0f;
        this.rightOffsetFactor = 0.0f;
        switch (text.getHorizontalTextAlign()) {
            case JUSTIFIED: {
                this.horizontalAlignment = PdfTextAlignment.JUSTIFIED;
                this.leftOffsetFactor = 0.0f;
                this.rightOffsetFactor = 0.0f;
                break;
            }
            case RIGHT: {
                this.horizontalAlignment = text.getRunDirectionValue() == RunDirectionEnum.LTR ? PdfTextAlignment.RIGHT : PdfTextAlignment.LEFT;
                this.leftOffsetFactor = -0.2f;
                this.rightOffsetFactor = 0.0f;
                break;
            }
            case CENTER: {
                this.horizontalAlignment = PdfTextAlignment.CENTER;
                this.leftOffsetFactor = -0.1f;
                this.rightOffsetFactor = 0.1f;
                break;
            }
            default: {
                this.horizontalAlignment = text.getRunDirectionValue() == RunDirectionEnum.LTR ? PdfTextAlignment.LEFT : PdfTextAlignment.RIGHT;
                this.leftOffsetFactor = 0.0f;
                this.rightOffsetFactor = 0.2f;
            }
        }
        super.initialize(text, styledText, offsetX, offsetY);
    }

    @Override
    protected StyledTextListWriter getListWriter() {
        return this.tagHelper.getListWriter();
    }

    public abstract boolean addActualText();

    @Override
    protected void renderParagraph(AttributedCharacterIterator allParagraphs, int paragraphStart, String paragraphText) {
        if (this.addActualText()) {
            this.tagHelper.startText(paragraphText, this.text.getLinkType() != null);
        } else {
            this.tagHelper.startText(this.text.getLinkType() != null);
        }
        super.renderParagraph(allParagraphs, paragraphStart, paragraphText);
        this.tagHelper.endText();
    }
}

