/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.OoxmlFont;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontSetInfo;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.repo.RepositoryUtil;

public abstract class BaseFontHelper
extends BaseHelper {
    private static final String FONTS_DIR = "fonts/";
    public static final String WORD_FONTS_DIR = "word/fonts/";
    public static final String PPT_FONTS_DIR = "ppt/fonts/";
    protected Map<String, String> ooxmlFontsFirstLocales = new HashMap<String, String>();
    protected Map<String, OoxmlFont> ooxmlFonts = new HashMap<String, OoxmlFont>();
    protected Map<String, String> fontPaths = new HashMap<String, String>();
    protected final Writer relsWriter;
    protected final FileBufferedZip zip;
    protected final boolean isEmbedFonts;

    public BaseFontHelper(JasperReportsContext jasperReportsContext, Writer writer, Writer relsWriter, FileBufferedZip zip, boolean isEmbedFonts) {
        super(jasperReportsContext, writer);
        this.relsWriter = relsWriter;
        this.zip = zip;
        this.isEmbedFonts = isEmbedFonts;
    }

    public void exportFonts() throws IOException {
        for (OoxmlFont ooxmlFont : this.ooxmlFonts.values()) {
            this.writer.write(this.getStartFontTag(ooxmlFont.getId()));
            if (ooxmlFont.getRegular() != null) {
                this.writer.write(this.getRegularEmbedding(ooxmlFont.getRegular()));
            }
            if (ooxmlFont.getBold() != null) {
                this.writer.write(this.getBoldEmbedding(ooxmlFont.getBold()));
            }
            if (ooxmlFont.getItalic() != null) {
                this.writer.write(this.getItalicEmbedding(ooxmlFont.getItalic()));
            }
            if (ooxmlFont.getBoldItalic() != null) {
                this.writer.write(this.getBoldItalicEmbedding(ooxmlFont.getBoldItalic()));
            }
            this.writer.write(this.getEndFontTag());
        }
        for (Map.Entry entry : this.fontPaths.entrySet()) {
            String rIdf = (String)entry.getValue();
            this.embedFont(rIdf, (String)entry.getKey());
        }
    }

    private String getFontPathId(String fontPath) {
        String rIdf = this.fontPaths.get(fontPath);
        if (rIdf == null) {
            rIdf = "rIdf" + new Integer(this.fontPaths.size() + 1);
            this.fontPaths.put(fontPath, rIdf);
        }
        return rIdf;
    }

    private void embedFont(String id, String path) {
        String entryPath = path.replace(' ', '_');
        try {
            this.relsWriter.write(" <Relationship Id=\"" + id + "\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/font\" Target=\"" + FONTS_DIR + entryPath + "\"/>\n");
            this.relsWriter.flush();
            entryPath = this.getFontsDir() + entryPath;
            byte[] bytes = RepositoryUtil.getInstance(this.jasperReportsContext).getBytesFromLocation(path);
            this.zip.addEntry(entryPath, bytes);
        }
        catch (IOException | JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String resolveFontFamily(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        String defaultFontFamily;
        String fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        FontInfo fontInfo = (FontInfo)attributes.get(JRTextAttribute.FONT_INFO);
        if (fontInfo == null) {
            defaultFontFamily = fontFamilyAttr;
            fontInfo = this.fontUtil.getFontInfo(fontFamilyAttr, locale);
        } else {
            defaultFontFamily = fontInfo.getFontFamily().getName();
        }
        String exportFont = null;
        if (fontInfo == null) {
            FontSetInfo fontSetInfo = this.fontUtil.getFontSetInfo(fontFamilyAttr, locale, true);
            if (fontSetInfo != null) {
                exportFont = fontSetInfo.getFontSet().getExportFont(this.getExporterKey());
            }
        } else {
            exportFont = fontInfo.getFontFamily().getExportFont(this.getExporterKey());
        }
        String fontFamily = defaultFontFamily;
        if (exportFont != null) {
            fontFamily = exportFont;
        } else if (this.isEmbedFonts && fontInfo != null) {
            fontFamily = this.handleOoxmlFont(fontFamily, locale, fontInfo, TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT)), TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE)));
        }
        return fontFamily;
    }

    private String handleOoxmlFont(String name, Locale locale, FontInfo fontInfo, boolean isBold, boolean isItalic) {
        FontFace fontFace = fontInfo.getFontFace();
        if (isBold) {
            if (isItalic) {
                String fontPath;
                FontFace boldItalicFontFace = null;
                if (fontFace == null) {
                    boldItalicFontFace = fontInfo.getFontFamily().getBoldItalicFace();
                    if (boldItalicFontFace == null) {
                        boldItalicFontFace = fontInfo.getFontFamily().getBoldFace();
                    }
                    if (boldItalicFontFace == null) {
                        boldItalicFontFace = fontInfo.getFontFamily().getItalicFace();
                    }
                    if (boldItalicFontFace == null) {
                        boldItalicFontFace = fontInfo.getFontFamily().getNormalFace();
                    }
                } else {
                    boldItalicFontFace = fontFace;
                }
                if ((fontPath = this.getFontPath(boldItalicFontFace)) != null && !fontPath.trim().isEmpty()) {
                    OoxmlFont ooxmlFont = this.getOoxmlFont(name, locale);
                    String rIdf = this.getFontPathId(fontPath);
                    ooxmlFont.setBoldItalic(rIdf);
                    return ooxmlFont.getId();
                }
            } else {
                String fontPath;
                FontFace boldFontFace = null;
                if (fontFace == null) {
                    boldFontFace = fontInfo.getFontFamily().getBoldFace();
                    if (boldFontFace == null) {
                        boldFontFace = fontInfo.getFontFamily().getNormalFace();
                    }
                } else {
                    boldFontFace = fontFace;
                }
                if ((fontPath = this.getFontPath(boldFontFace)) != null && !fontPath.trim().isEmpty()) {
                    OoxmlFont ooxmlFont = this.getOoxmlFont(name, locale);
                    String rIdf = this.getFontPathId(fontPath);
                    ooxmlFont.setBold(rIdf);
                    return ooxmlFont.getId();
                }
            }
        } else if (isItalic) {
            String fontPath;
            FontFace italicFontFace = null;
            if (fontFace == null) {
                italicFontFace = fontInfo.getFontFamily().getItalicFace();
                if (italicFontFace == null) {
                    italicFontFace = fontInfo.getFontFamily().getNormalFace();
                }
            } else {
                italicFontFace = fontFace;
            }
            if ((fontPath = this.getFontPath(italicFontFace)) != null && !fontPath.trim().isEmpty()) {
                OoxmlFont ooxmlFont = this.getOoxmlFont(name, locale);
                String rIdf = this.getFontPathId(fontPath);
                ooxmlFont.setItalic(rIdf);
                return ooxmlFont.getId();
            }
        } else {
            FontFace regularFontFace = null;
            regularFontFace = fontFace == null ? fontInfo.getFontFamily().getNormalFace() : fontFace;
            String fontPath = this.getFontPath(regularFontFace);
            if (fontPath != null && !fontPath.trim().isEmpty()) {
                OoxmlFont ooxmlFont = this.getOoxmlFont(name, locale);
                String rIdf = this.getFontPathId(fontPath);
                ooxmlFont.setRegular(rIdf);
                return ooxmlFont.getId();
            }
        }
        return name;
    }

    private OoxmlFont getOoxmlFont(String name, Locale locale) {
        boolean isFirstLocale = true;
        String localeCode = JRDataUtils.getLocaleCode(locale);
        String firstLocale = this.ooxmlFontsFirstLocales.get(name);
        if (firstLocale == null) {
            this.ooxmlFontsFirstLocales.put(name, localeCode);
        } else {
            isFirstLocale = firstLocale.equals(localeCode);
        }
        String ooxmlFontId = name + (isFirstLocale ? "" : " " + localeCode);
        OoxmlFont ooxmlFont = this.ooxmlFonts.get(ooxmlFontId);
        if (ooxmlFont == null) {
            ooxmlFont = OoxmlFont.getInstance(ooxmlFontId);
            this.ooxmlFonts.put(ooxmlFontId, ooxmlFont);
        }
        return ooxmlFont;
    }

    protected abstract String getExporterKey();

    protected abstract String getStartFontTag(String var1);

    protected abstract String getEndFontTag();

    protected abstract String getFontsDir();

    protected abstract String getRegularEmbedding(String var1);

    protected abstract String getBoldEmbedding(String var1);

    protected abstract String getItalicEmbedding(String var1);

    protected abstract String getBoldItalicEmbedding(String var1);

    protected abstract String getFontPath(FontFace var1);
}

