/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.audit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.web.lib.audit.AuditException;
import org.openspcoop2.web.lib.audit.log.Binary;
import org.openspcoop2.web.lib.audit.log.Operation;
import org.openspcoop2.web.lib.audit.log.constants.Stato;
import org.openspcoop2.web.lib.audit.log.constants.Tipologia;

public class DriverAuditDBAppender {
    private Connection connectionDB;
    private String tipoDB = null;

    public DriverAuditDBAppender(Connection con, String tipoDB) throws AuditException {
        this.connectionDB = con;
        if (con == null) {
            throw new AuditException("Connessione al Database non definita");
        }
        this.tipoDB = tipoDB;
        if (tipoDB == null) {
            throw new AuditException("Il tipoDatabase non puo essere null.");
        }
    }

    public Operation getOperation(long id) throws AuditException {
        Operation operation = null;
        Statement stm = null;
        ResultSet rs = null;
        if (id <= 0L) {
            throw new AuditException("[DriverAudit::getOperation]  Id non valido");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("audit_operations");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id=?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            rs = stm.executeQuery();
            if (rs.next()) {
                operation = new Operation();
                operation.setTipologia(Tipologia.toEnumConstant(rs.getString("tipo_operazione")));
                operation.setTipoOggetto(rs.getString("tipo"));
                operation.setObjectId(rs.getString("object_id"));
                operation.setObjectOldId(rs.getString("object_old_id"));
                operation.setUtente(rs.getString("utente"));
                operation.setStato(Stato.toEnumConstant(rs.getString("stato")));
                operation.setObjectDetails(rs.getString("object_details"));
                operation.setObjectClass(rs.getString("object_class"));
                operation.setError(rs.getString("error"));
                operation.setTimeRequest(rs.getTimestamp("time_request"));
                operation.setTimeExecute(rs.getTimestamp("time_execute"));
                operation.setId(id);
                ArrayList<Binary> list = this.getBinaries(id);
                if (list != null && !list.isEmpty()) {
                    operation.setBinaryList(list);
                }
            } else {
                throw new AuditException("[DriverAudit::getOperation] non presente");
            }
            Operation operation2 = operation;
            return operation2;
        }
        catch (SQLException se) {
            throw new AuditException("[DriverAudit::getOperation] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new AuditException("[DriverAudit::getOperation] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ArrayList<Binary> getBinaries(long idOperation) throws AuditException {
        ArrayList<Binary> binaries = new ArrayList<Binary>();
        Statement stm = null;
        ResultSet rs = null;
        if (idOperation <= 0L) {
            throw new AuditException("[DriverAudit::getBinaries]  Id non valido");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("audit_binaries");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_audit_operation=?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idOperation);
            rs = stm.executeQuery();
            while (rs.next()) {
                binaries.add(this.getBinary(rs.getLong("id")));
            }
            ArrayList<Binary> arrayList = binaries;
            return arrayList;
        }
        catch (SQLException se) {
            throw new AuditException("[DriverAudit::getBinaries] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new AuditException("[DriverAudit::getBinaries] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Binary getBinary(long id) throws AuditException {
        Binary binary = null;
        Statement stm = null;
        ResultSet rs = null;
        if (id <= 0L) {
            throw new AuditException("[DriverAudit::getBinary]  Id non valido");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("audit_binaries");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id=?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new AuditException("[DriverAudit::getBinary] non presente");
            }
            binary = new Binary();
            binary.setBinaryId(rs.getString("binary_id"));
            binary.setChecksum(rs.getLong("checksum"));
            binary.setIdOperation(rs.getLong("id_audit_operation"));
            binary.setId(id);
            Binary binary2 = binary;
            return binary2;
        }
        catch (SQLException se) {
            throw new AuditException("[DriverAudit::getBinary] SqlException: " + se.getMessage(), se);
        }
        catch (Exception ex) {
            throw new AuditException("[DriverAudit::getBinary] Exception: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void createOperation(Operation operation) throws AuditException {
        if (operation == null) {
            throw new AuditException("[DriverAudit::createOperation] Parametro non valido.");
        }
        try {
            if (!TipiDatabase.isAMember((String)this.tipoDB)) {
                throw new Exception("Tipo database [" + this.tipoDB + "] non supportato");
            }
            TipiDatabase tipo = TipiDatabase.toEnumConstant((String)this.tipoDB);
            Timestamp timeRequestT = null;
            if (operation.getTimeRequest() != null) {
                timeRequestT = new Timestamp(operation.getTimeRequest().getTime());
            }
            Timestamp timeExecuteT = null;
            if (operation.getTimeExecute() != null) {
                timeExecuteT = new Timestamp(operation.getTimeExecute().getTime());
            }
            CustomKeyGeneratorObject customKeyGeneratorObject = new CustomKeyGeneratorObject("audit_operations", "id", "seq_audit_operations", "audit_operations_init_seq");
            long idoperazione = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)this.connectionDB, (TipiDatabase)tipo, (IKeyGeneratorObject)customKeyGeneratorObject, (InsertAndGeneratedKeyObject[])new InsertAndGeneratedKeyObject[]{new InsertAndGeneratedKeyObject("tipo_operazione", (Object)(operation.getTipologia() != null ? operation.getTipologia().getValue() : null), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("tipo", (Object)operation.getTipoOggetto(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("object_id", (Object)operation.getObjectId(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("object_old_id", (Object)operation.getObjectOldId(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("utente", (Object)operation.getUtente(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("stato", (Object)(operation.getStato() != null ? operation.getStato().getValue() : null), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("object_details", (Object)operation.getObjectDetails(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("object_class", (Object)operation.getObjectClass(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("error", (Object)operation.getError(), InsertAndGeneratedKeyJDBCType.STRING), new InsertAndGeneratedKeyObject("time_request", (Object)timeRequestT, InsertAndGeneratedKeyJDBCType.TIMESTAMP), new InsertAndGeneratedKeyObject("time_execute", (Object)timeExecuteT, InsertAndGeneratedKeyJDBCType.TIMESTAMP)});
            if (idoperazione <= 0L) {
                throw new Exception("ID autoincrementale non ottenuto");
            }
            for (int i = 0; i < operation.sizeBinaryList(); ++i) {
                Binary binary = operation.getBinary(i);
                binary.setIdOperation(idoperazione);
                this.createBinary(binary);
            }
            operation.setId(idoperazione);
        }
        catch (Exception qe) {
            throw new AuditException(qe.getMessage(), qe);
        }
    }

    public void createBinary(Binary binary) throws AuditException {
        block19: {
            ResultSet rs = null;
            Statement stm = null;
            String sqlQuery = "";
            if (binary == null) {
                throw new AuditException("[DriverAudit::createBinary] Parametro non valido.");
            }
            if (binary.getIdOperation() == null) {
                throw new AuditException("[DriverAudit::createBinary] IDOperation non valido.");
            }
            if (binary.getIdOperation() <= 0L) {
                throw new AuditException("[DriverAudit::createBinary] IDOperation(" + binary.getIdOperation() + ") non valido.");
            }
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addInsertTable("audit_binaries");
                sqlQueryObject.addInsertField("binary_id", "?");
                sqlQueryObject.addInsertField("checksum", "?");
                sqlQueryObject.addInsertField("id_audit_operation", "?");
                sqlQuery = sqlQueryObject.createSQLInsert();
                stm = this.connectionDB.prepareStatement(sqlQuery);
                stm.setString(1, binary.getBinaryId());
                stm.setLong(2, binary.getChecksum());
                stm.setLong(3, binary.getIdOperation());
                stm.executeUpdate();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("audit_binaries");
                sqlQueryObject.addSelectField("audit_binaries", "id");
                sqlQueryObject.addWhereCondition("binary_id=?");
                sqlQueryObject.addWhereCondition("id_audit_operation=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = this.connectionDB.prepareStatement(sqlQuery);
                stm.setString(1, binary.getBinaryId());
                stm.setLong(2, binary.getIdOperation());
                rs = stm.executeQuery();
                if (rs.next()) {
                    binary.setId(rs.getLong("id"));
                    break block19;
                }
                throw new Exception("Identificativo dopo l'insert non recuperato");
            }
            catch (Exception qe) {
                throw new AuditException(qe.getMessage(), qe);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void updateOperation(Operation operation, boolean updateBinaries) throws AuditException {
        ResultSet rs = null;
        Statement stm = null;
        String sqlQuery = "";
        if (operation == null) {
            throw new AuditException("[DriverAudit::updateOperation] Parametro non valido.");
        }
        if (operation.getId() <= 0L) {
            throw new AuditException("[DriverAudit::updateOperation] ID (" + operation.getId() + ") non valido.");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable("audit_operations");
            sqlQueryObject.addUpdateField("tipo_operazione", "?");
            sqlQueryObject.addUpdateField("tipo", "?");
            sqlQueryObject.addUpdateField("object_id", "?");
            sqlQueryObject.addUpdateField("object_old_id", "?");
            sqlQueryObject.addUpdateField("utente", "?");
            sqlQueryObject.addUpdateField("stato", "?");
            sqlQueryObject.addUpdateField("object_details", "?");
            sqlQueryObject.addUpdateField("object_class", "?");
            sqlQueryObject.addUpdateField("error", "?");
            sqlQueryObject.addUpdateField("time_request", "?");
            sqlQueryObject.addUpdateField("time_execute", "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, operation.getTipologia() != null ? operation.getTipologia().getValue() : null);
            stm.setString(2, operation.getTipoOggetto());
            stm.setString(3, operation.getObjectId());
            stm.setString(4, operation.getObjectOldId());
            stm.setString(5, operation.getUtente());
            stm.setString(6, operation.getStato() != null ? operation.getStato().getValue() : null);
            stm.setString(7, operation.getObjectDetails());
            stm.setString(8, operation.getObjectClass());
            stm.setString(9, operation.getError());
            stm.setTimestamp(10, new Timestamp(operation.getTimeRequest().getTime()));
            stm.setTimestamp(11, new Timestamp(operation.getTimeExecute().getTime()));
            stm.setLong(12, operation.getId());
            stm.executeUpdate();
            if (updateBinaries) {
                this.deleteBinaries(operation.getId());
                for (int i = 0; i < operation.sizeBinaryList(); ++i) {
                    Binary binary = operation.getBinary(i);
                    binary.setIdOperation(operation.getId());
                    this.createBinary(binary);
                }
            }
        }
        catch (Exception qe) {
            throw new AuditException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateBinary(Binary binary) throws AuditException {
        Statement stm = null;
        String sqlQuery = "";
        if (binary == null) {
            throw new AuditException("[DriverAudit::updateBinary] Parametro non valido.");
        }
        if (binary.getIdOperation() == null) {
            throw new AuditException("[DriverAudit::updateBinary] IDOperation non valido.");
        }
        if (binary.getIdOperation() <= 0L) {
            throw new AuditException("[DriverAudit::updateBinary] IDOperation(" + binary.getIdOperation() + ") non valido.");
        }
        if (binary.getId() == null) {
            throw new AuditException("[DriverAudit::updateBinary] ID non valido.");
        }
        if (binary.getId() <= 0L) {
            throw new AuditException("[DriverAudit::updateBinary] ID(" + binary.getId() + ") non valido.");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable("audit_binaries");
            sqlQueryObject.addUpdateField("binary_id", "?");
            sqlQueryObject.addUpdateField("checksum", "?");
            sqlQueryObject.addUpdateField("id_audit_operation", "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setString(1, binary.getBinaryId());
            stm.setLong(2, binary.getChecksum());
            stm.setLong(3, binary.getIdOperation());
            stm.setLong(4, binary.getId());
            stm.executeUpdate();
            stm.close();
        }
        catch (Exception qe) {
            throw new AuditException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteOperation(Operation operation) throws AuditException {
        if (operation == null) {
            throw new AuditException("[DriverAudit::deleteOperation] Parametro non valido.");
        }
        if (operation.getId() <= 0L) {
            throw new AuditException("[DriverAudit::deleteOperation] ID(" + operation.getId() + ") non valido.");
        }
        this.deleteOperation(operation.getId());
    }

    public void deleteOperation(long id) throws AuditException {
        Statement stm = null;
        String sqlQuery = "";
        if (id <= 0L) {
            throw new AuditException("[DriverAudit::deleteBinary] ID(" + id + ") non valido.");
        }
        try {
            this.deleteBinaries(id);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("audit_operations");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            stm.executeUpdate();
            stm.close();
        }
        catch (Exception qe) {
            throw new AuditException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteBinaries(long idOperation) throws AuditException {
        Statement stm = null;
        String sqlQuery = "";
        if (idOperation <= 0L) {
            throw new AuditException("[DriverAudit::deleteBinary] IDOperation(" + idOperation + ") non valido.");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("audit_binaries");
            sqlQueryObject.addWhereCondition("id_audit_operation=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, idOperation);
            stm.executeUpdate();
            stm.close();
        }
        catch (Exception qe) {
            throw new AuditException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteBinary(Binary binary) throws AuditException {
        if (binary == null) {
            throw new AuditException("[DriverAudit::deleteBinary] Parametro non valido.");
        }
        if (binary.getId() == null) {
            throw new AuditException("[DriverAudit::deleteBinary] ID non valido.");
        }
        if (binary.getId() <= 0L) {
            throw new AuditException("[DriverAudit::deleteBinary] ID(" + binary.getId() + ") non valido.");
        }
        this.deleteBinary(binary.getId());
    }

    public void deleteBinary(long id) throws AuditException {
        Statement stm = null;
        String sqlQuery = "";
        if (id <= 0L) {
            throw new AuditException("[DriverAudit::deleteBinary] ID(" + id + ") non valido.");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("audit_binaries");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = this.connectionDB.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            stm.executeUpdate();
            stm.close();
        }
        catch (Exception qe) {
            throw new AuditException(qe.getMessage(), qe);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Operation> auditOperationList(ISearch ricerca, int idLista, String datainizio, String datafine, String tipooperazione, String tipooggetto, String id, String oldid, String utente, String statooperazione, String contoggetto) throws AuditException {
        String nomeMetodo = "auditOperationList";
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        try {
            Date dataFineData;
            DateTimeFormatterWrapper simpleDateFormat = DateUtils.getDefaultDateFormatter((String)"yyyy-MM-dd");
            Date dataInizioData = datainizio != null && !"".equals(datainizio) ? simpleDateFormat.parse(datainizio) : null;
            Date date = dataFineData = datafine != null && !"".equals(datafine) ? simpleDateFormat.parse(datafine) : null;
            if (dataFineData != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(dataFineData);
                cal.add(7, 1);
                dataFineData = cal.getTime();
            }
            Calendar cal_start = null;
            if (dataInizioData != null) {
                cal_start = Calendar.getInstance();
                cal_start.setTime(dataInizioData);
            }
            Calendar cal_end = null;
            if (dataFineData != null) {
                cal_end = Calendar.getInstance();
                cal_end.setTime(dataFineData);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("audit_operations");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (datainizio != null && !datainizio.equals("")) {
                sqlQueryObject.addWhereCondition("time_request >= ?");
            }
            if (datafine != null && !datafine.equals("")) {
                sqlQueryObject.addWhereCondition("time_request <= ?");
            }
            if (tipooperazione != null && !tipooperazione.equals("-")) {
                sqlQueryObject.addWhereCondition("tipo_operazione = ?");
            }
            if (tipooggetto != null && !tipooggetto.equals("-")) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            if (utente != null && !utente.equals("")) {
                sqlQueryObject.addWhereCondition("utente = ?");
            }
            if (statooperazione != null && !statooperazione.equals("-")) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (id != null && !id.equals("")) {
                sqlQueryObject.addWhereLikeCondition("object_id", id, true, true);
            }
            if (oldid != null && !oldid.equals("")) {
                sqlQueryObject.addWhereLikeCondition("object_old_id", id, true, true);
            }
            if (contoggetto != null && !contoggetto.equals("")) {
                sqlQueryObject.addWhereLikeCondition("object_details", contoggetto, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = this.connectionDB.prepareStatement(queryString);
            int param_index = 0;
            if (datainizio != null && !datainizio.equals("")) {
                stmt.setTimestamp(++param_index, new Timestamp(cal_start.getTimeInMillis()));
            }
            if (datafine != null && !datafine.equals("")) {
                stmt.setTimestamp(++param_index, new Timestamp(cal_end.getTimeInMillis()));
            }
            if (tipooperazione != null && !tipooperazione.equals("-")) {
                stmt.setString(++param_index, tipooperazione);
            }
            if (tipooggetto != null && !tipooggetto.equals("-")) {
                stmt.setString(++param_index, tipooggetto);
            }
            if (utente != null && !utente.equals("")) {
                stmt.setString(++param_index, utente);
            }
            if (statooperazione != null && !statooperazione.equals("-")) {
                stmt.setString(++param_index, statooperazione);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("audit_operations");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("time_execute");
            if (datainizio != null && !datainizio.equals("")) {
                sqlQueryObject.addWhereCondition("time_request >= ?");
            }
            if (datafine != null && !datafine.equals("")) {
                sqlQueryObject.addWhereCondition("time_request <= ?");
            }
            if (tipooperazione != null && !tipooperazione.equals("-")) {
                sqlQueryObject.addWhereCondition("tipo_operazione = ?");
            }
            if (tipooggetto != null && !tipooggetto.equals("-")) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            if (utente != null && !utente.equals("")) {
                sqlQueryObject.addWhereCondition("utente = ?");
            }
            if (statooperazione != null && !statooperazione.equals("-")) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (id != null && !id.equals("")) {
                sqlQueryObject.addWhereLikeCondition("object_id", id, true, true);
            }
            if (oldid != null && !oldid.equals("")) {
                sqlQueryObject.addWhereLikeCondition("object_old_id", id, true, true);
            }
            if (contoggetto != null && !contoggetto.equals("")) {
                sqlQueryObject.addWhereLikeCondition("object_details", contoggetto, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("time_execute");
            sqlQueryObject.setSortType(false);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = this.connectionDB.prepareStatement(queryString);
            param_index = 0;
            if (datainizio != null && !datainizio.equals("")) {
                stmt.setTimestamp(++param_index, new Timestamp(cal_start.getTimeInMillis()));
            }
            if (datafine != null && !datafine.equals("")) {
                stmt.setTimestamp(++param_index, new Timestamp(cal_end.getTimeInMillis()));
            }
            if (tipooperazione != null && !tipooperazione.equals("-")) {
                stmt.setString(++param_index, tipooperazione);
            }
            if (tipooggetto != null && !tipooggetto.equals("-")) {
                stmt.setString(++param_index, tipooggetto);
            }
            if (utente != null && !utente.equals("")) {
                stmt.setString(++param_index, utente);
            }
            if (statooperazione != null && !statooperazione.equals("-")) {
                stmt.setString(++param_index, statooperazione);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                lista.add(this.getOperation(risultato.getLong("id")));
            }
            ArrayList<Operation> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new AuditException("[DriverAuditDBAppender::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

