/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api.impl.utils;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.core.eventi.utils.SeveritaConverter;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.Enums;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.monitor.rs.server.config.SoggettiConfig;
import org.openspcoop2.core.monitor.rs.server.model.BaseTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.DetailTransazione;
import org.openspcoop2.core.monitor.rs.server.model.DetailsTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.Evento;
import org.openspcoop2.core.monitor.rs.server.model.InfoImplementazioneApi;
import org.openspcoop2.core.monitor.rs.server.model.ItemTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.ItemTransazione;
import org.openspcoop2.core.monitor.rs.server.model.ListaTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.MethodTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.PDNDClientInfo;
import org.openspcoop2.core.monitor.rs.server.model.PDNDOrganizationExternalId;
import org.openspcoop2.core.monitor.rs.server.model.PDNDOrganizationInfo;
import org.openspcoop2.core.monitor.rs.server.model.PDNDOrganizationInfoItemTransazione;
import org.openspcoop2.core.monitor.rs.server.model.Riepilogo;
import org.openspcoop2.core.monitor.rs.server.model.RiepilogoApiItem;
import org.openspcoop2.core.monitor.rs.server.model.StatoTracing;
import org.openspcoop2.core.monitor.rs.server.model.StatoTracingPDND;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.statistiche.constants.PdndMethods;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiPdnd;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiRichieste;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.BeanUtils;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.utils.service.beans.DiagnosticoSeveritaEnum;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.TransazioneExt;
import org.openspcoop2.utils.service.beans.TransazioneRuoloEnum;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.beans.utils.ProfiloUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.eventi.bean.EventoBean;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioneGenerale;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.dao.TransazioniService;
import org.slf4j.Logger;

public class Converter {
    public static String toProtocollo(ProfiloEnum profilo) throws UtilsException {
        if (profilo == null) {
            return ServerProperties.getInstance().getProtocolloDefault();
        }
        return ProfiloUtils.toProtocollo((ProfiloEnum)profilo);
    }

    public static Integer toOffset(Integer offset) {
        return offset != null ? offset : 0;
    }

    public static Integer toLimit(Integer limit) {
        return limit != null ? limit : 25;
    }

    public static SortOrder toSortOrder(String sort) {
        if (StringUtils.isNotEmpty((String)sort)) {
            if (sort.startsWith("+")) {
                return SortOrder.ASC;
            }
            if (sort.startsWith("-")) {
                return SortOrder.DESC;
            }
        }
        return SortOrder.DESC;
    }

    public static String toSortField(String sort) {
        if (StringUtils.isNotEmpty((String)sort)) {
            String sortParam = sort;
            if (sort.startsWith("+") || sort.startsWith("-")) {
                sortParam = sort.substring(1);
            }
            if ("latenzaTotale".equals(sortParam)) {
                return sortParam;
            }
            if ("latenzaServizio".equals(sortParam)) {
                return sortParam;
            }
            if ("dataIngressoRichiesta".equals(sortParam)) {
                return sortParam;
            }
            FaultCode.RICHIESTA_NON_VALIDA.throwException("Sort parameter '" + sort + "' non valido");
        }
        return "dataIngressoRichiesta";
    }

    public static DetailTransazione toTransazioneExt(TransazioneBean transazioneDB, TransazioniService transazioniService, Connection con, ServiceManagerProperties smp, Logger log) throws Exception {
        String dettaglioErrore;
        String richiedente;
        long dataRichiesta;
        long dataRisposta;
        DumpMessaggio dumpMessaggio;
        org.openspcoop2.pdd.logger.traccia.Converter converter = new org.openspcoop2.pdd.logger.traccia.Converter(log);
        PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
        Traccia tracciaRichiesta = null;
        try {
            tracciaRichiesta = govwayMonitorProperties.getDriverTracciamento(con, smp).getTraccia(transazioneDB.getIdTransazione(), RuoloMessaggio.RICHIESTA);
        }
        catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {
            // empty catch block
        }
        Traccia tracciaRisposta = null;
        try {
            tracciaRisposta = govwayMonitorProperties.getDriverTracciamento(con, smp).getTraccia(transazioneDB.getIdTransazione(), RuoloMessaggio.RISPOSTA);
        }
        catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {
            // empty catch block
        }
        FiltroRicercaDiagnosticiConPaginazione filter = new FiltroRicercaDiagnosticiConPaginazione();
        filter.setIdTransazione(transazioneDB.getIdTransazione());
        List messaggiDiagnostici = null;
        try {
            messaggiDiagnostici = govwayMonitorProperties.getDriverMsgDiagnostici(con, smp).getMessaggiDiagnostici(filter);
        }
        catch (DriverMsgDiagnosticiNotFoundException driverMsgDiagnosticiNotFoundException) {
            // empty catch block
        }
        CredenzialiMittente credenzialiMittente = Converter.convertToCredenzialiMittente(transazioneDB);
        if (transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO)) {
            dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO);
            if (dumpMessaggio != null) {
                transazioneDB.addDumpMessaggio(dumpMessaggio);
            }
        } else if ((transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_INGRESSO) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_INGRESSO)) && (dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_INGRESSO)) != null) {
            transazioneDB.addDumpMessaggio(dumpMessaggio);
        }
        if (transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO)) {
            dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO);
            if (dumpMessaggio != null) {
                transazioneDB.addDumpMessaggio(dumpMessaggio);
            }
        } else if ((transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_USCITA) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_USCITA)) && (dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RICHIESTA_USCITA)) != null) {
            transazioneDB.addDumpMessaggio(dumpMessaggio);
        }
        if (transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO)) {
            dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO);
            if (dumpMessaggio != null) {
                transazioneDB.addDumpMessaggio(dumpMessaggio);
            }
        } else if ((transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_INGRESSO) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_INGRESSO)) && (dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_INGRESSO)) != null) {
            transazioneDB.addDumpMessaggio(dumpMessaggio);
        }
        if (transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO)) {
            dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO);
            if (dumpMessaggio != null) {
                transazioneDB.addDumpMessaggio(dumpMessaggio);
            }
        } else if ((transazioniService.hasInfoDumpAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_USCITA) || transazioniService.hasInfoHeaderTrasportoAvailable(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_USCITA)) && (dumpMessaggio = transazioniService.getDumpMessaggio(transazioneDB.getIdTransazione(), null, null, TipoMessaggio.RISPOSTA_USCITA)) != null) {
            transazioneDB.addDumpMessaggio(dumpMessaggio);
        }
        TransazioneExt transazioneExt = converter.toTransazioneExt((Transazione)transazioneDB, credenzialiMittente, tracciaRichiesta, tracciaRisposta, messaggiDiagnostici);
        DetailTransazione detail = new DetailTransazione();
        if (transazioneExt.getRichiesta() != null) {
            detail.setData(transazioneExt.getRichiesta().getDataRicezione());
        }
        if (transazioneExt.getRichiesta() != null && transazioneExt.getRichiesta().getDataConsegna() != null && transazioneExt.getRisposta() != null && transazioneExt.getRisposta().getDataAccettazione() != null) {
            dataRisposta = transazioneExt.getRisposta().getDataAccettazione().getMillis();
            dataRichiesta = transazioneExt.getRichiesta().getDataConsegna().getMillis();
            detail.setLatenzaServizio(dataRisposta - dataRichiesta);
        }
        if (transazioneExt.getRichiesta() != null && transazioneExt.getRichiesta().getDataAccettazione() != null && transazioneExt.getRisposta() != null && transazioneExt.getRisposta().getDataConsegna() != null) {
            dataRisposta = transazioneExt.getRisposta().getDataConsegna().getMillis();
            dataRichiesta = transazioneExt.getRichiesta().getDataAccettazione().getMillis();
            detail.setLatenzaTotale(dataRisposta - dataRichiesta);
        }
        String pdndOrganizationName = transazioneDB.getPdndOrganizationName();
        String pdndOrganizationCategory = transazioneDB.getPdndOrganizationCategory();
        String pdndOrganizationSubUnit = transazioneDB.getPdndOrganizationSubUnit();
        String pdndExternalId = transazioneDB.getPdndOrganizationExternalId();
        String pdndConsumerId = transazioneDB.getPdndOrganizationConsumerId();
        if (StringUtils.isNotEmpty((String)pdndOrganizationName) || StringUtils.isNotEmpty((String)pdndOrganizationCategory) || StringUtils.isNotEmpty((String)pdndOrganizationSubUnit) || StringUtils.isNotEmpty((String)pdndExternalId)) {
            PDNDOrganizationInfo pdndOrganizationInfo = new PDNDOrganizationInfo();
            pdndOrganizationInfo.setNome(pdndOrganizationName);
            if (StringUtils.isNotEmpty((String)pdndOrganizationCategory)) {
                pdndOrganizationInfo.setCategoria(pdndOrganizationCategory);
            }
            if (StringUtils.isNotEmpty((String)pdndOrganizationSubUnit)) {
                pdndOrganizationInfo.setSubUnit(pdndOrganizationSubUnit);
            }
            if (StringUtils.isNotEmpty((String)pdndExternalId) && pdndExternalId.contains(" ")) {
                try {
                    int indexOf = pdndExternalId.indexOf(" ");
                    String origin = pdndExternalId.substring(0, indexOf);
                    String code = pdndExternalId.replaceFirst(origin + " ", "");
                    PDNDOrganizationExternalId extId = new PDNDOrganizationExternalId();
                    extId.setOrigine(origin);
                    extId.setCodice(code);
                    pdndOrganizationInfo.setExternalId(extId);
                }
                catch (Exception indexOf) {
                    // empty catch block
                }
            }
            pdndOrganizationInfo.setConsumerId(pdndConsumerId);
            detail.setPdndOrganization(pdndOrganizationInfo);
        }
        String pdndClientnName = transazioneDB.getPdndClientName();
        String pdndClientDescription = transazioneDB.getPdndClientDescription();
        if (StringUtils.isNotEmpty((String)pdndClientnName) || StringUtils.isNotEmpty((String)pdndClientDescription)) {
            PDNDClientInfo pdndClientInfo = new PDNDClientInfo();
            pdndClientInfo.setNome(pdndClientnName);
            if (StringUtils.isNotEmpty((String)pdndClientDescription)) {
                pdndClientInfo.setDescrizione(pdndClientDescription);
            }
            if (StringUtils.isNotEmpty((String)transazioneDB.getTokenClientIdLabel())) {
                pdndClientInfo.setClientId(transazioneDB.getTokenClientIdLabel());
            }
            detail.setPdndClient(pdndClientInfo);
        }
        if (StringUtils.isNotEmpty((String)(richiedente = transazioneDB.getLabelRichiedenteConFruitore()))) {
            detail.setRichiedente(richiedente);
        }
        if (StringUtils.isNotEmpty((String)(dettaglioErrore = transazioneDB.getDettaglioErrore(messaggiDiagnostici)))) {
            detail.setDettaglioErrore(dettaglioErrore);
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>();
        metodiEsclusi.add(new BlackListElement("setData", new Class[]{DateTime.class}));
        metodiEsclusi.add(new BlackListElement("setLatenzaServizio", new Class[]{Long.class}));
        metodiEsclusi.add(new BlackListElement("setLatenzaTotale", new Class[]{Long.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganization", new Class[]{PDNDOrganizationInfo.class}));
        metodiEsclusi.add(new BlackListElement("setPdndClient", new Class[]{PDNDClientInfo.class}));
        metodiEsclusi.add(new BlackListElement("setRichiedente", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setDettaglioErrore", new Class[]{String.class}));
        BeanUtils.copy((Logger)log, (Object)((Object)detail), (Object)transazioneExt, metodiEsclusi, (boolean)true);
        return detail;
    }

    public static ItemTransazione toItemTransazione(TransazioneBean transazioneDB, Logger log) throws Exception {
        String richiedente;
        String pdndOrganizationName;
        long dataRichiesta;
        long dataRisposta;
        TransazioneExt transazione;
        CredenzialiMittente credenzialiMittente = Converter.convertToCredenzialiMittente(transazioneDB);
        org.openspcoop2.pdd.logger.traccia.Converter converter = new org.openspcoop2.pdd.logger.traccia.Converter(log);
        if (transazioneDB.getGruppiLabel() != null && !"".equals(transazioneDB.getGruppiLabel())) {
            transazioneDB.setGruppi(transazioneDB.getGruppiLabel());
        }
        if (transazioneDB.getSocketClientAddress() == null && transazioneDB.getSocketClientAddressLabel() != null) {
            transazioneDB.setSocketClientAddress(transazioneDB.getSocketClientAddressLabel());
        }
        if (transazioneDB.getTransportClientAddress() == null && transazioneDB.getTransportClientAddressLabel() != null) {
            transazioneDB.setTransportClientAddress(transazioneDB.getTransportClientAddressLabel());
        }
        if ((transazione = converter.toTransazioneExt((Transazione)transazioneDB, credenzialiMittente, null, null, null)).getRichiesta() != null) {
            transazione.getRichiesta().setContenutiIngresso(null);
            transazione.getRichiesta().setContenutiUscita(null);
            transazione.getRichiesta().setDuplicatiMessaggio(null);
            transazione.getRichiesta().setTraccia(null);
            transazione.getRichiesta().setDataRicezioneAcquisita(null);
            transazione.getRichiesta().setDataConsegnaEffettuata(null);
        }
        if (transazione.getRisposta() != null) {
            transazione.getRisposta().setContenutiIngresso(null);
            transazione.getRisposta().setContenutiUscita(null);
            transazione.getRisposta().setDuplicatiMessaggio(null);
            transazione.getRisposta().setTraccia(null);
            transazione.getRisposta().setFaultConsegna(null);
            transazione.getRisposta().setFaultConsegnaFormato(null);
            transazione.getRisposta().setFaultRicezione(null);
            transazione.getRisposta().setFaultRicezioneFormato(null);
            transazione.getRisposta().setDettagliErrore(null);
            transazione.getRisposta().setDataRicezioneAcquisita(null);
            if (transazione.getRisposta().getDataConsegnaEffettuata() != null) {
                transazione.getRisposta().setDataConsegna(transazione.getRisposta().getDataConsegnaEffettuata());
            }
            transazione.getRisposta().setDataConsegnaEffettuata(null);
        }
        if (transazione.getApi() != null) {
            transazione.getApi().setProfiloCollaborazione(null);
            transazione.getApi().setIdAsincrono(null);
        }
        if (transazione.getMittente() != null) {
            transazione.getMittente().setCredenziali(null);
            transazione.getMittente().setToken(null);
            transazione.getMittente().setInformazioniToken(null);
        }
        ItemTransazione item = new ItemTransazione();
        if (transazione.getRichiesta() != null) {
            item.setData(transazione.getRichiesta().getDataRicezione());
        }
        if (transazione.getRichiesta() != null && transazione.getRichiesta().getDataConsegna() != null && transazione.getRisposta() != null && transazione.getRisposta().getDataAccettazione() != null) {
            dataRisposta = transazione.getRisposta().getDataAccettazione().getMillis();
            dataRichiesta = transazione.getRichiesta().getDataConsegna().getMillis();
            item.setLatenzaServizio(dataRisposta - dataRichiesta);
        }
        if (transazione.getRichiesta() != null && transazione.getRichiesta().getDataAccettazione() != null && transazione.getRisposta() != null && transazione.getRisposta().getDataConsegna() != null) {
            dataRisposta = transazione.getRisposta().getDataConsegna().getMillis();
            dataRichiesta = transazione.getRichiesta().getDataAccettazione().getMillis();
            item.setLatenzaTotale(dataRisposta - dataRichiesta);
        }
        if (StringUtils.isNotEmpty((String)(pdndOrganizationName = transazioneDB.getPdndOrganizationName()))) {
            PDNDOrganizationInfoItemTransazione pdndOrganizationInfo = new PDNDOrganizationInfoItemTransazione();
            pdndOrganizationInfo.setNome(pdndOrganizationName);
            item.setPdndOrganization(pdndOrganizationInfo);
        }
        if (StringUtils.isNotEmpty((String)(richiedente = transazioneDB.getLabelRichiedenteConFruitore()))) {
            item.setRichiedente(richiedente);
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>();
        metodiEsclusi.add(new BlackListElement("setData", new Class[]{DateTime.class}));
        metodiEsclusi.add(new BlackListElement("setLatenzaServizio", new Class[]{Long.class}));
        metodiEsclusi.add(new BlackListElement("setLatenzaTotale", new Class[]{Long.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganization", new Class[]{PDNDOrganizationInfoItemTransazione.class}));
        metodiEsclusi.add(new BlackListElement("setRichiedente", new Class[]{String.class}));
        BeanUtils.copy((Logger)log, (Object)((Object)item), (Object)transazione, metodiEsclusi, (boolean)true);
        return item;
    }

    private static CredenzialiMittente convertToCredenzialiMittente(TransazioneBean transazioneDB) {
        CredenzialeMittente credenziale;
        CredenzialiMittente credenzialiMittente = new CredenzialiMittente();
        if (transazioneDB.getTrasportoMittenteLabel() != null) {
            credenziale = new CredenzialeMittente();
            credenziale.setCredenziale(transazioneDB.getTrasportoMittenteLabel());
            credenzialiMittente.setTrasporto(credenziale);
        }
        if (transazioneDB.getTokenSubjectLabel() != null) {
            credenziale = new CredenzialeMittente();
            credenziale.setCredenziale(transazioneDB.getTokenSubjectLabel());
            credenzialiMittente.setTokenSubject(credenziale);
        }
        if (transazioneDB.getTokenIssuerLabel() != null) {
            credenziale = new CredenzialeMittente();
            credenziale.setCredenziale(transazioneDB.getTokenIssuerLabel());
            credenzialiMittente.setTokenIssuer(credenziale);
        }
        if (transazioneDB.getTokenClientIdLabel() != null) {
            credenziale = new CredenzialeMittente();
            String clientId = transazioneDB.getTokenClientIdLabel();
            IDServizioApplicativo idSA = transazioneDB.getTokenClient();
            if (idSA != null) {
                CredenzialeTokenClient credToken = new CredenzialeTokenClient(clientId, idSA);
                try {
                    credenziale.setCredenziale(credToken.getCredenziale());
                }
                catch (Throwable t) {
                    credenziale.setCredenziale(clientId);
                }
            } else {
                credenziale.setCredenziale(clientId);
            }
            credenzialiMittente.setTokenClientId(credenziale);
        }
        if (transazioneDB.getTokenUsernameLabel() != null) {
            credenziale = new CredenzialeMittente();
            credenziale.setCredenziale(transazioneDB.getTokenUsernameLabel());
            credenzialiMittente.setTokenUsername(credenziale);
        }
        if (transazioneDB.getTokenMailLabel() != null) {
            credenziale = new CredenzialeMittente();
            credenziale.setCredenziale(transazioneDB.getTokenMailLabel());
            credenzialiMittente.setTokenEMail(credenziale);
        }
        return credenzialiMittente;
    }

    public static Evento toEvento(EventoBean eventoDB, Logger log) throws Exception {
        Evento evento = new Evento();
        if (eventoDB.getSeverita() >= 0) {
            TipoSeverita tipo = SeveritaConverter.toSeverita((int)eventoDB.getSeverita());
            evento.setSeverita(Enums.toDiagnosticoSeverita.get(tipo));
        }
        evento.setOrigine(eventoDB.getIdConfigurazione());
        if (eventoDB.getOraRegistrazione() != null) {
            evento.setOraRegistrazione(new DateTime(eventoDB.getOraRegistrazione().getTime()));
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>();
        metodiEsclusi.add(new BlackListElement("setSeverita", new Class[]{DiagnosticoSeveritaEnum.class}));
        metodiEsclusi.add(new BlackListElement("setOrigine", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setOraRegistrazione", new Class[]{DateTime.class}));
        BeanUtils.copy((Logger)log, (Object)evento, (Object)eventoDB, metodiEsclusi, (boolean)true);
        return evento;
    }

    public static RiepilogoApiItem toRiepilogoApiItem(ConfigurazioneGenerale configurazioneDB, Logger log) throws Exception {
        RiepilogoApiItem riepilogo = new RiepilogoApiItem();
        riepilogo.setErogatore(configurazioneDB.getErogatore());
        riepilogo.setFruitore(configurazioneDB.getFruitore());
        String nomeAPI = configurazioneDB.getServizio();
        if (nomeAPI != null) {
            String[] tmp = nomeAPI.split(" v");
            String tipoNome = tmp[0];
            if (tipoNome.contains("/")) {
                riepilogo.setTipo(tipoNome.split("/")[0]);
                riepilogo.setNome(tipoNome.split("/")[1]);
            } else {
                riepilogo.setNome(tipoNome);
            }
            String versione = tmp[1];
            riepilogo.setVersione(Integer.parseInt(versione));
        }
        return riepilogo;
    }

    public static Riepilogo toRiepilogo(List<ConfigurazioneGenerale> listDB_infoGenerali_right, List<ConfigurazioneGenerale> listDB_infoServizi_left, ConfigurazioneGenerale soggettiOperativi, Logger log) throws Exception {
        Riepilogo riepilogo = new Riepilogo();
        if (listDB_infoGenerali_right != null && !listDB_infoGenerali_right.isEmpty()) {
            for (ConfigurazioneGenerale configurazioneGenerale : listDB_infoGenerali_right) {
                if ("Soggetti 'Esterni'".equals(configurazioneGenerale.getLabel())) {
                    riepilogo.setSoggettiDominioEsterno(Integer.valueOf(configurazioneGenerale.getValue()));
                    continue;
                }
                if ("Soggetti 'Operativi'".equals(configurazioneGenerale.getLabel())) {
                    riepilogo.setSoggettiDominioInterno(Integer.valueOf(configurazioneGenerale.getValue()));
                    continue;
                }
                if (!"Applicativi".equals(configurazioneGenerale.getLabel())) continue;
                riepilogo.setApplicativi(Integer.valueOf(configurazioneGenerale.getValue()));
            }
        }
        if (listDB_infoServizi_left != null && !listDB_infoServizi_left.isEmpty()) {
            for (ConfigurazioneGenerale configurazioneGenerale : listDB_infoServizi_left) {
                if ("API".equals(configurazioneGenerale.getLabel())) {
                    riepilogo.setApi(Integer.valueOf(configurazioneGenerale.getValue()));
                    continue;
                }
                if ("Erogazioni".equals(configurazioneGenerale.getLabel())) {
                    riepilogo.setErogazioni(Integer.valueOf(configurazioneGenerale.getValue()));
                    continue;
                }
                if (!"Fruizioni".equals(configurazioneGenerale.getLabel())) continue;
                riepilogo.setFruizioni(Integer.valueOf(configurazioneGenerale.getValue()));
            }
        }
        if (riepilogo.getSoggettiDominioInterno() == null && soggettiOperativi != null) {
            riepilogo.setSoggettiDominioInterno(Integer.valueOf(soggettiOperativi.getValue()));
        }
        return riepilogo;
    }

    public static InfoImplementazioneApi toInfoImplementazioneApi(List<ConfigurazioneGenerale> listDB_infoServizi_left, Logger log) throws Exception {
        InfoImplementazioneApi info = new InfoImplementazioneApi();
        if (listDB_infoServizi_left != null && !listDB_infoServizi_left.isEmpty()) {
            for (ConfigurazioneGenerale configurazioneGenerale : listDB_infoServizi_left) {
                if ("Erogazioni".equals(configurazioneGenerale.getLabel())) {
                    info.setErogazioni(Integer.valueOf(configurazioneGenerale.getValue()));
                    continue;
                }
                if ("Fruizioni".equals(configurazioneGenerale.getLabel())) {
                    info.setFruizioni(Integer.valueOf(configurazioneGenerale.getValue()));
                    continue;
                }
                if (!"Azioni".equals(configurazioneGenerale.getLabel())) continue;
                info.setAzioni(Integer.valueOf(configurazioneGenerale.getValue()));
            }
        }
        return info;
    }

    public static IDServizio toIDServizio(TransazioneRuoloEnum tipo, ProfiloEnum profilo, String soggetto, String soggettoRemoto, String nomeServizio, String tipoServizio, Integer versioneServizio) throws Exception {
        String protocollo = Converter.toProtocollo(profilo);
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String tipoSoggetto = (String)protocolFactoryManager.getDefaultOrganizationTypes().get((Object)protocollo);
        String tipoServizioEffettivo = tipoServizio != null ? tipoServizio : (String)((List)protocolFactoryManager._getServiceTypes().get(protocollo)).get(0);
        String nomeSoggettoLocale = soggetto;
        if (nomeSoggettoLocale == null) {
            ServerProperties serverProperties = ServerProperties.getInstance();
            if (serverProperties.useSoggettoDefault()) {
                nomeSoggettoLocale = serverProperties.getSoggettoDefaultIfEnabled(protocollo);
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Soggetto locale non indicato; parametro obbligatorio");
            }
        }
        if (!SoggettiConfig.existsIdentificativoPorta(tipoSoggetto, nomeSoggettoLocale)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il soggetto locale indicato non esiste");
        }
        String nomeSoggettoErogatore = null;
        switch (tipo) {
            case EROGAZIONE: {
                nomeSoggettoErogatore = nomeSoggettoLocale;
                break;
            }
            case FRUIZIONE: {
                if (StringUtils.isNotBlank((String)soggettoRemoto)) {
                    nomeSoggettoErogatore = soggettoRemoto;
                    break;
                }
                FaultCode.RICHIESTA_NON_VALIDA.throwException("Parametro 'soggettoRemoto' \u00e8 obbligatorio per il dettaglio di una fruizione");
                break;
            }
        }
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizioEffettivo, nomeServizio, tipoSoggetto, nomeSoggettoErogatore, versioneServizio == null ? 1 : versioneServizio);
        return idServizio;
    }

    private static void fillBaseTracingPDND(BaseTracingPDND out, StatistichePdndTracingBean bean) {
        out.tentativiPubblicazione(bean.getTentativiPubblicazione()).statoPdnd(Converter.toStatoTracingPDND(bean.getStatoPdnd())).stato(Converter.toStatoTracing(bean.getStato())).dataRegistrazione(new DateTime(bean.getDataRegistrazione().getTime())).dataTracciamento(new LocalDate(bean.getDataTracciamento().getTime())).id(bean.getId());
        if (bean.getTracingId() != null) {
            out.setTracingId(UUID.fromString(bean.getTracingId()));
        }
    }

    private static void fillDetailsTracingPDND(DetailsTracingPDND out, StatistichePdndTracingBean bean) {
        Converter.fillBaseTracingPDND(out, bean);
        out.dettagliErrore(bean.getErrorDetails()).metodo(Converter.toMethodTracingPDND(bean.getMethod())).dataPubblicazione(new DateTime(bean.getDataRegistrazione().getTime()));
        if (bean.isForcePublish()) {
            out.setForcePublish(true);
        }
    }

    public static ListaTracingPDND toListaTracingPDND(IContext context, List<StatistichePdndTracingBean> listDB, int offset, int limit, int totalCount) throws InstantiationException, IllegalAccessException {
        ListaTracingPDND list = (ListaTracingPDND)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)Converter.toOffset(offset), (Integer)Converter.toLimit(limit), (long)totalCount, ListaTracingPDND.class);
        ArrayList<ItemTracingPDND> items = new ArrayList<ItemTracingPDND>();
        for (StatistichePdndTracingBean bean : listDB) {
            ItemTracingPDND item = new ItemTracingPDND();
            Converter.fillBaseTracingPDND(item, bean);
            items.add(item);
        }
        list.setItems(items);
        return list;
    }

    public static DetailsTracingPDND toDetailsTracingPDND(StatistichePdndTracingBean bean) {
        DetailsTracingPDND details = new DetailsTracingPDND();
        Converter.fillDetailsTracingPDND(details, bean);
        return details;
    }

    public static StatoTracingPDND toStatoTracingPDND(PossibiliStatiPdnd state) {
        if (state == null) {
            return null;
        }
        switch (state) {
            case ERROR: {
                return StatoTracingPDND.ERRORE;
            }
            case OK: {
                return StatoTracingPDND.OK;
            }
            case PENDING: {
                return StatoTracingPDND.ATTESA;
            }
            case WAITING: {
                return StatoTracingPDND.ATTESA;
            }
        }
        return null;
    }

    public static StatoTracing toStatoTracing(PossibiliStatiRichieste state) {
        if (state == null) {
            return null;
        }
        switch (state) {
            case FAILED: {
                return StatoTracing.FALLITA;
            }
            case PUBLISHED: {
                return StatoTracing.PUBBLICATA;
            }
        }
        return null;
    }

    public static PossibiliStatiPdnd toStatoTracingPDND(StatoTracingPDND state) {
        if (state == null) {
            return null;
        }
        switch (state) {
            case ERRORE: {
                return PossibiliStatiPdnd.ERROR;
            }
            case OK: {
                return PossibiliStatiPdnd.OK;
            }
            case ATTESA: {
                return PossibiliStatiPdnd.PENDING;
            }
        }
        return null;
    }

    public static PossibiliStatiRichieste toStatoTracing(StatoTracing state) {
        if (state == null) {
            return null;
        }
        switch (state) {
            case FALLITA: {
                return PossibiliStatiRichieste.FAILED;
            }
            case PUBBLICATA: {
                return PossibiliStatiRichieste.PUBLISHED;
            }
        }
        return null;
    }

    public static MethodTracingPDND toMethodTracingPDND(PdndMethods method) {
        if (method == null) {
            return null;
        }
        switch (method) {
            case RECOVER: {
                return MethodTracingPDND.RECOVER;
            }
            case REPLACE: {
                return MethodTracingPDND.REPLACE;
            }
            case SUBMIT: {
                return MethodTracingPDND.SUBMIT;
            }
        }
        return null;
    }
}

