/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api.impl.utils;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.Search;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.Converter;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.monitor.rs.server.config.SoggettiConfig;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ProfiloUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.slf4j.Logger;

public class MonitoraggioEnv {
    public final IContext context;
    public final ProfiloEnum profilo;
    public final String tipoSoggetto;
    public final String nomeSoggettoLocale;
    public final Logger log;
    public final String tipo_protocollo;
    public final ProtocolFactoryManager protocolFactoryMgr;
    public final boolean supportatoSoggettoReferenteAPI;
    public IDSoggetto soggettoReferenteAPIDefault;
    private static HashMap<String, IDSoggetto> map = new HashMap();

    public MonitoraggioEnv(IContext context, ProfiloEnum profilo, String nome_soggetto, Logger log) throws UtilsException, ProtocolException {
        this.context = context;
        this.profilo = profilo == null ? (ProfiloEnum)ProfiloUtils.getMapProtocolloToProfilo().get(ServerProperties.getInstance().getProtocolloDefault()) : profilo;
        String protocollo = Converter.toProtocollo(profilo);
        this.tipoSoggetto = (String)ProtocolFactoryManager.getInstance().getDefaultOrganizationTypes().get((Object)protocollo);
        ServerProperties serverProperties = ServerProperties.getInstance();
        this.supportatoSoggettoReferenteAPI = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune();
        if (!this.supportatoSoggettoReferenteAPI) {
            this.soggettoReferenteAPIDefault = MonitoraggioEnv.getSoggettoOperativoDefault(protocollo);
        }
        if (nome_soggetto == null && serverProperties.useSoggettoDefault()) {
            nome_soggetto = serverProperties.getSoggettoDefaultIfEnabled(ProfiloUtils.toProtocollo((ProfiloEnum)this.profilo));
        }
        if (nome_soggetto != null) {
            this.nomeSoggettoLocale = nome_soggetto;
            if (!SoggettiConfig.existsIdentificativoPorta(this.tipoSoggetto, this.nomeSoggettoLocale)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il soggetto '" + this.nomeSoggettoLocale + "' indicato non esiste");
            }
        } else {
            this.nomeSoggettoLocale = null;
        }
        this.log = log;
        this.tipo_protocollo = (String)BaseHelper.tipoProtocolloFromProfilo.get(this.profilo);
        this.protocolFactoryMgr = ProtocolFactoryManager.getInstance();
    }

    private static IDSoggetto getSoggettoOperativoDefault(String protocollo) {
        if (map.containsKey(protocollo)) {
            return map.get(protocollo);
        }
        return MonitoraggioEnv._getSoggettoOperativoDefault(protocollo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized IDSoggetto _getSoggettoOperativoDefault(String protocollo) {
        if (map.containsKey(protocollo)) {
            return map.get(protocollo);
        }
        Search s = new Search();
        s.setPageSize(Liste.SOGGETTI, 1);
        s.addFilter(Liste.SOGGETTI, "filtroProtocollo", protocollo);
        s.addFilter(Liste.SOGGETTI, "filtroDominio", PddTipologia.OPERATIVO.toString());
        s.addFilter(Liste.SOGGETTI, "filtroSoggettoDefault", "true");
        List lista = null;
        DBManager dbManager = DBManager.getInstance();
        Connection con = null;
        try {
            con = dbManager.getConnectionConfig();
            DriverRegistroServiziDB driver = new DriverRegistroServiziDB(con, LoggerProperties.getLoggerCore(), dbManager.getServiceManagerPropertiesConfig().getDatabaseType());
            lista = driver.soggettiRegistroList(null, (ISearch)s);
        }
        catch (Exception e) {
            LoggerProperties.getLoggerCore().error("getSoggettoOperativoDefault(" + protocollo + "): " + e.getMessage(), (Throwable)e);
        }
        finally {
            dbManager.releaseConnectionConfig(con);
        }
        if (lista != null && lista.size() > 0) {
            IDSoggetto id = new IDSoggetto(((Soggetto)lista.get(0)).getTipo(), ((Soggetto)lista.get(0)).getNome());
            map.put(protocollo, id);
            return id;
        }
        return null;
    }
}

