/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import java.sql.Connection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.DatasourceProperties;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.slf4j.Logger;

public class SoggettiConfig {
    private static Semaphore semaphore = new Semaphore("ApiSoggettiConfig");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsIdentificativoPorta(String tipoSoggetto, String nomeSoggetto) {
        if (Utility.existsIdentificativoPorta((String)tipoSoggetto, (String)nomeSoggetto)) {
            return true;
        }
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        Logger logSql = LoggerProperties.getLoggerDAO();
        try {
            SemaphoreLock lock;
            Soggetto soggetto;
            block21: {
                boolean bl;
                connection = dbManager.getConnectionConfig();
                DriverRegistroServiziDB driverDB = new DriverRegistroServiziDB(connection, logSql, DatasourceProperties.getInstance().getConfigTipoDatabase());
                IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
                if (!driverDB.existsSoggetto(idSoggetto)) {
                    boolean bl2 = false;
                    return bl2;
                }
                soggetto = driverDB.getSoggetto(idSoggetto);
                if (soggetto.getPortaDominio() == null || StringUtils.isEmpty((String)soggetto.getPortaDominio())) {
                    boolean bl3 = false;
                    return bl3;
                }
                FiltroRicerca filtroRicercaPdd = new FiltroRicerca();
                filtroRicercaPdd.setTipo(PddTipologia.OPERATIVO.toString());
                List idsPdd = null;
                try {
                    idsPdd = driverDB.getAllIdPorteDominio(filtroRicercaPdd);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (idsPdd == null || idsPdd.isEmpty() || !idsPdd.contains(soggetto.getPortaDominio())) {
                    boolean bl4 = false;
                    return bl4;
                }
                lock = semaphore.acquire("existsIdentificativoPorta");
                try {
                    if (!Utility.existsIdentificativoPorta((String)tipoSoggetto, (String)nomeSoggetto)) break block21;
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        semaphore.release(lock, "existsIdentificativoPorta");
                        throw throwable;
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                        logSql.debug("Soggetto " + tipoSoggetto + "/" + nomeSoggetto + " non esistente: " + notFound.getMessage(), (Throwable)notFound);
                        boolean bl5 = false;
                        return bl5;
                    }
                    catch (Exception e) {
                        logSql.error("Errore durante il controllo di esistenza del soggetto " + tipoSoggetto + "/" + nomeSoggetto + ": " + e.getMessage(), (Throwable)e);
                        boolean bl6 = false;
                        return bl6;
                    }
                }
                semaphore.release(lock, "existsIdentificativoPorta");
                return bl;
            }
            Utility.putIdentificativoPorta((String)tipoSoggetto, (String)nomeSoggetto, (String)soggetto.getIdentificativoPorta());
            boolean bl = true;
            semaphore.release(lock, "existsIdentificativoPorta");
            return bl;
        }
        finally {
            dbManager.releaseConnectionConfig(connection);
        }
    }
}

