/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.abstraction.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.protocol.abstraction.CredenzialiInvocazioneBasic;
import org.openspcoop2.protocol.abstraction.DatiApplicativiErogazione;
import org.openspcoop2.protocol.abstraction.DatiApplicativiFruizione;
import org.openspcoop2.protocol.abstraction.DatiFruizione;
import org.openspcoop2.protocol.abstraction.DatiServizio;
import org.openspcoop2.protocol.abstraction.Erogazione;
import org.openspcoop2.protocol.abstraction.Fruitori;
import org.openspcoop2.protocol.abstraction.Fruizione;
import org.openspcoop2.protocol.abstraction.IdentificatoreAccordo;
import org.openspcoop2.protocol.abstraction.IdentificatoreServizio;
import org.openspcoop2.protocol.abstraction.RiferimentoAccordoServizioParteComune;
import org.openspcoop2.protocol.abstraction.RiferimentoAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.abstraction.RiferimentoServizioApplicativoErogatore;
import org.openspcoop2.protocol.abstraction.RiferimentoServizioApplicativoFruitore;
import org.openspcoop2.protocol.abstraction.RiferimentoSoggetto;
import org.openspcoop2.protocol.abstraction.Soggetto;
import org.openspcoop2.protocol.abstraction.SoggettoNotExistsBehaviour;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, Soggetto soggetto) throws SerializerException {
        this.objToXml(fileName, Soggetto.class, (Object)soggetto, false);
    }

    public void write(String fileName, Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Soggetto.class, (Object)soggetto, prettyPrint);
    }

    public void write(File file, Soggetto soggetto) throws SerializerException {
        this.objToXml(file, Soggetto.class, (Object)soggetto, false);
    }

    public void write(File file, Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Soggetto.class, (Object)soggetto, prettyPrint);
    }

    public void write(OutputStream out, Soggetto soggetto) throws SerializerException {
        this.objToXml(out, Soggetto.class, (Object)soggetto, false);
    }

    public void write(OutputStream out, Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Soggetto.class, (Object)soggetto, prettyPrint);
    }

    public byte[] toByteArray(Soggetto soggetto) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, false).toByteArray();
    }

    public byte[] toByteArray(Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, prettyPrint).toByteArray();
    }

    public String toString(Soggetto soggetto) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, false).toString();
    }

    public String toString(Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, prettyPrint).toString();
    }

    public void write(String fileName, RiferimentoSoggetto riferimentoSoggetto) throws SerializerException {
        this.objToXml(fileName, RiferimentoSoggetto.class, (Object)riferimentoSoggetto, false);
    }

    public void write(String fileName, RiferimentoSoggetto riferimentoSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RiferimentoSoggetto.class, (Object)riferimentoSoggetto, prettyPrint);
    }

    public void write(File file, RiferimentoSoggetto riferimentoSoggetto) throws SerializerException {
        this.objToXml(file, RiferimentoSoggetto.class, (Object)riferimentoSoggetto, false);
    }

    public void write(File file, RiferimentoSoggetto riferimentoSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RiferimentoSoggetto.class, (Object)riferimentoSoggetto, prettyPrint);
    }

    public void write(OutputStream out, RiferimentoSoggetto riferimentoSoggetto) throws SerializerException {
        this.objToXml(out, RiferimentoSoggetto.class, (Object)riferimentoSoggetto, false);
    }

    public void write(OutputStream out, RiferimentoSoggetto riferimentoSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RiferimentoSoggetto.class, (Object)riferimentoSoggetto, prettyPrint);
    }

    public byte[] toByteArray(RiferimentoSoggetto riferimentoSoggetto) throws SerializerException {
        return this.objToXml(RiferimentoSoggetto.class, riferimentoSoggetto, false).toByteArray();
    }

    public byte[] toByteArray(RiferimentoSoggetto riferimentoSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoSoggetto.class, riferimentoSoggetto, prettyPrint).toByteArray();
    }

    public String toString(RiferimentoSoggetto riferimentoSoggetto) throws SerializerException {
        return this.objToXml(RiferimentoSoggetto.class, riferimentoSoggetto, false).toString();
    }

    public String toString(RiferimentoSoggetto riferimentoSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoSoggetto.class, riferimentoSoggetto, prettyPrint).toString();
    }

    public void write(String fileName, SoggettoNotExistsBehaviour soggettoNotExistsBehaviour) throws SerializerException {
        this.objToXml(fileName, SoggettoNotExistsBehaviour.class, (Object)soggettoNotExistsBehaviour, false);
    }

    public void write(String fileName, SoggettoNotExistsBehaviour soggettoNotExistsBehaviour, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SoggettoNotExistsBehaviour.class, (Object)soggettoNotExistsBehaviour, prettyPrint);
    }

    public void write(File file, SoggettoNotExistsBehaviour soggettoNotExistsBehaviour) throws SerializerException {
        this.objToXml(file, SoggettoNotExistsBehaviour.class, (Object)soggettoNotExistsBehaviour, false);
    }

    public void write(File file, SoggettoNotExistsBehaviour soggettoNotExistsBehaviour, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SoggettoNotExistsBehaviour.class, (Object)soggettoNotExistsBehaviour, prettyPrint);
    }

    public void write(OutputStream out, SoggettoNotExistsBehaviour soggettoNotExistsBehaviour) throws SerializerException {
        this.objToXml(out, SoggettoNotExistsBehaviour.class, (Object)soggettoNotExistsBehaviour, false);
    }

    public void write(OutputStream out, SoggettoNotExistsBehaviour soggettoNotExistsBehaviour, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SoggettoNotExistsBehaviour.class, (Object)soggettoNotExistsBehaviour, prettyPrint);
    }

    public byte[] toByteArray(SoggettoNotExistsBehaviour soggettoNotExistsBehaviour) throws SerializerException {
        return this.objToXml(SoggettoNotExistsBehaviour.class, soggettoNotExistsBehaviour, false).toByteArray();
    }

    public byte[] toByteArray(SoggettoNotExistsBehaviour soggettoNotExistsBehaviour, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoggettoNotExistsBehaviour.class, soggettoNotExistsBehaviour, prettyPrint).toByteArray();
    }

    public String toString(SoggettoNotExistsBehaviour soggettoNotExistsBehaviour) throws SerializerException {
        return this.objToXml(SoggettoNotExistsBehaviour.class, soggettoNotExistsBehaviour, false).toString();
    }

    public String toString(SoggettoNotExistsBehaviour soggettoNotExistsBehaviour, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SoggettoNotExistsBehaviour.class, soggettoNotExistsBehaviour, prettyPrint).toString();
    }

    public void write(String fileName, CredenzialiInvocazioneBasic credenzialiInvocazioneBasic) throws SerializerException {
        this.objToXml(fileName, CredenzialiInvocazioneBasic.class, (Object)credenzialiInvocazioneBasic, false);
    }

    public void write(String fileName, CredenzialiInvocazioneBasic credenzialiInvocazioneBasic, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, CredenzialiInvocazioneBasic.class, (Object)credenzialiInvocazioneBasic, prettyPrint);
    }

    public void write(File file, CredenzialiInvocazioneBasic credenzialiInvocazioneBasic) throws SerializerException {
        this.objToXml(file, CredenzialiInvocazioneBasic.class, (Object)credenzialiInvocazioneBasic, false);
    }

    public void write(File file, CredenzialiInvocazioneBasic credenzialiInvocazioneBasic, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, CredenzialiInvocazioneBasic.class, (Object)credenzialiInvocazioneBasic, prettyPrint);
    }

    public void write(OutputStream out, CredenzialiInvocazioneBasic credenzialiInvocazioneBasic) throws SerializerException {
        this.objToXml(out, CredenzialiInvocazioneBasic.class, (Object)credenzialiInvocazioneBasic, false);
    }

    public void write(OutputStream out, CredenzialiInvocazioneBasic credenzialiInvocazioneBasic, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, CredenzialiInvocazioneBasic.class, (Object)credenzialiInvocazioneBasic, prettyPrint);
    }

    public byte[] toByteArray(CredenzialiInvocazioneBasic credenzialiInvocazioneBasic) throws SerializerException {
        return this.objToXml(CredenzialiInvocazioneBasic.class, credenzialiInvocazioneBasic, false).toByteArray();
    }

    public byte[] toByteArray(CredenzialiInvocazioneBasic credenzialiInvocazioneBasic, boolean prettyPrint) throws SerializerException {
        return this.objToXml(CredenzialiInvocazioneBasic.class, credenzialiInvocazioneBasic, prettyPrint).toByteArray();
    }

    public String toString(CredenzialiInvocazioneBasic credenzialiInvocazioneBasic) throws SerializerException {
        return this.objToXml(CredenzialiInvocazioneBasic.class, credenzialiInvocazioneBasic, false).toString();
    }

    public String toString(CredenzialiInvocazioneBasic credenzialiInvocazioneBasic, boolean prettyPrint) throws SerializerException {
        return this.objToXml(CredenzialiInvocazioneBasic.class, credenzialiInvocazioneBasic, prettyPrint).toString();
    }

    public void write(String fileName, RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore) throws SerializerException {
        this.objToXml(fileName, RiferimentoServizioApplicativoFruitore.class, (Object)riferimentoServizioApplicativoFruitore, false);
    }

    public void write(String fileName, RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RiferimentoServizioApplicativoFruitore.class, (Object)riferimentoServizioApplicativoFruitore, prettyPrint);
    }

    public void write(File file, RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore) throws SerializerException {
        this.objToXml(file, RiferimentoServizioApplicativoFruitore.class, (Object)riferimentoServizioApplicativoFruitore, false);
    }

    public void write(File file, RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RiferimentoServizioApplicativoFruitore.class, (Object)riferimentoServizioApplicativoFruitore, prettyPrint);
    }

    public void write(OutputStream out, RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore) throws SerializerException {
        this.objToXml(out, RiferimentoServizioApplicativoFruitore.class, (Object)riferimentoServizioApplicativoFruitore, false);
    }

    public void write(OutputStream out, RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RiferimentoServizioApplicativoFruitore.class, (Object)riferimentoServizioApplicativoFruitore, prettyPrint);
    }

    public byte[] toByteArray(RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoFruitore.class, riferimentoServizioApplicativoFruitore, false).toByteArray();
    }

    public byte[] toByteArray(RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoFruitore.class, riferimentoServizioApplicativoFruitore, prettyPrint).toByteArray();
    }

    public String toString(RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoFruitore.class, riferimentoServizioApplicativoFruitore, false).toString();
    }

    public String toString(RiferimentoServizioApplicativoFruitore riferimentoServizioApplicativoFruitore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoFruitore.class, riferimentoServizioApplicativoFruitore, prettyPrint).toString();
    }

    public void write(String fileName, DatiApplicativiFruizione datiApplicativiFruizione) throws SerializerException {
        this.objToXml(fileName, DatiApplicativiFruizione.class, (Object)datiApplicativiFruizione, false);
    }

    public void write(String fileName, DatiApplicativiFruizione datiApplicativiFruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DatiApplicativiFruizione.class, (Object)datiApplicativiFruizione, prettyPrint);
    }

    public void write(File file, DatiApplicativiFruizione datiApplicativiFruizione) throws SerializerException {
        this.objToXml(file, DatiApplicativiFruizione.class, (Object)datiApplicativiFruizione, false);
    }

    public void write(File file, DatiApplicativiFruizione datiApplicativiFruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DatiApplicativiFruizione.class, (Object)datiApplicativiFruizione, prettyPrint);
    }

    public void write(OutputStream out, DatiApplicativiFruizione datiApplicativiFruizione) throws SerializerException {
        this.objToXml(out, DatiApplicativiFruizione.class, (Object)datiApplicativiFruizione, false);
    }

    public void write(OutputStream out, DatiApplicativiFruizione datiApplicativiFruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DatiApplicativiFruizione.class, (Object)datiApplicativiFruizione, prettyPrint);
    }

    public byte[] toByteArray(DatiApplicativiFruizione datiApplicativiFruizione) throws SerializerException {
        return this.objToXml(DatiApplicativiFruizione.class, datiApplicativiFruizione, false).toByteArray();
    }

    public byte[] toByteArray(DatiApplicativiFruizione datiApplicativiFruizione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiApplicativiFruizione.class, datiApplicativiFruizione, prettyPrint).toByteArray();
    }

    public String toString(DatiApplicativiFruizione datiApplicativiFruizione) throws SerializerException {
        return this.objToXml(DatiApplicativiFruizione.class, datiApplicativiFruizione, false).toString();
    }

    public String toString(DatiApplicativiFruizione datiApplicativiFruizione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiApplicativiFruizione.class, datiApplicativiFruizione, prettyPrint).toString();
    }

    public void write(String fileName, IdentificatoreAccordo identificatoreAccordo) throws SerializerException {
        this.objToXml(fileName, IdentificatoreAccordo.class, (Object)identificatoreAccordo, false);
    }

    public void write(String fileName, IdentificatoreAccordo identificatoreAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdentificatoreAccordo.class, (Object)identificatoreAccordo, prettyPrint);
    }

    public void write(File file, IdentificatoreAccordo identificatoreAccordo) throws SerializerException {
        this.objToXml(file, IdentificatoreAccordo.class, (Object)identificatoreAccordo, false);
    }

    public void write(File file, IdentificatoreAccordo identificatoreAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdentificatoreAccordo.class, (Object)identificatoreAccordo, prettyPrint);
    }

    public void write(OutputStream out, IdentificatoreAccordo identificatoreAccordo) throws SerializerException {
        this.objToXml(out, IdentificatoreAccordo.class, (Object)identificatoreAccordo, false);
    }

    public void write(OutputStream out, IdentificatoreAccordo identificatoreAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdentificatoreAccordo.class, (Object)identificatoreAccordo, prettyPrint);
    }

    public byte[] toByteArray(IdentificatoreAccordo identificatoreAccordo) throws SerializerException {
        return this.objToXml(IdentificatoreAccordo.class, identificatoreAccordo, false).toByteArray();
    }

    public byte[] toByteArray(IdentificatoreAccordo identificatoreAccordo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdentificatoreAccordo.class, identificatoreAccordo, prettyPrint).toByteArray();
    }

    public String toString(IdentificatoreAccordo identificatoreAccordo) throws SerializerException {
        return this.objToXml(IdentificatoreAccordo.class, identificatoreAccordo, false).toString();
    }

    public String toString(IdentificatoreAccordo identificatoreAccordo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdentificatoreAccordo.class, identificatoreAccordo, prettyPrint).toString();
    }

    public void write(String fileName, IdentificatoreServizio identificatoreServizio) throws SerializerException {
        this.objToXml(fileName, IdentificatoreServizio.class, (Object)identificatoreServizio, false);
    }

    public void write(String fileName, IdentificatoreServizio identificatoreServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdentificatoreServizio.class, (Object)identificatoreServizio, prettyPrint);
    }

    public void write(File file, IdentificatoreServizio identificatoreServizio) throws SerializerException {
        this.objToXml(file, IdentificatoreServizio.class, (Object)identificatoreServizio, false);
    }

    public void write(File file, IdentificatoreServizio identificatoreServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdentificatoreServizio.class, (Object)identificatoreServizio, prettyPrint);
    }

    public void write(OutputStream out, IdentificatoreServizio identificatoreServizio) throws SerializerException {
        this.objToXml(out, IdentificatoreServizio.class, (Object)identificatoreServizio, false);
    }

    public void write(OutputStream out, IdentificatoreServizio identificatoreServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdentificatoreServizio.class, (Object)identificatoreServizio, prettyPrint);
    }

    public byte[] toByteArray(IdentificatoreServizio identificatoreServizio) throws SerializerException {
        return this.objToXml(IdentificatoreServizio.class, identificatoreServizio, false).toByteArray();
    }

    public byte[] toByteArray(IdentificatoreServizio identificatoreServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdentificatoreServizio.class, identificatoreServizio, prettyPrint).toByteArray();
    }

    public String toString(IdentificatoreServizio identificatoreServizio) throws SerializerException {
        return this.objToXml(IdentificatoreServizio.class, identificatoreServizio, false).toString();
    }

    public String toString(IdentificatoreServizio identificatoreServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdentificatoreServizio.class, identificatoreServizio, prettyPrint).toString();
    }

    public void write(String fileName, DatiServizio datiServizio) throws SerializerException {
        this.objToXml(fileName, DatiServizio.class, (Object)datiServizio, false);
    }

    public void write(String fileName, DatiServizio datiServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DatiServizio.class, (Object)datiServizio, prettyPrint);
    }

    public void write(File file, DatiServizio datiServizio) throws SerializerException {
        this.objToXml(file, DatiServizio.class, (Object)datiServizio, false);
    }

    public void write(File file, DatiServizio datiServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DatiServizio.class, (Object)datiServizio, prettyPrint);
    }

    public void write(OutputStream out, DatiServizio datiServizio) throws SerializerException {
        this.objToXml(out, DatiServizio.class, (Object)datiServizio, false);
    }

    public void write(OutputStream out, DatiServizio datiServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DatiServizio.class, (Object)datiServizio, prettyPrint);
    }

    public byte[] toByteArray(DatiServizio datiServizio) throws SerializerException {
        return this.objToXml(DatiServizio.class, datiServizio, false).toByteArray();
    }

    public byte[] toByteArray(DatiServizio datiServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiServizio.class, datiServizio, prettyPrint).toByteArray();
    }

    public String toString(DatiServizio datiServizio) throws SerializerException {
        return this.objToXml(DatiServizio.class, datiServizio, false).toString();
    }

    public String toString(DatiServizio datiServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiServizio.class, datiServizio, prettyPrint).toString();
    }

    public void write(String fileName, Fruitori fruitori) throws SerializerException {
        this.objToXml(fileName, Fruitori.class, (Object)fruitori, false);
    }

    public void write(String fileName, Fruitori fruitori, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Fruitori.class, (Object)fruitori, prettyPrint);
    }

    public void write(File file, Fruitori fruitori) throws SerializerException {
        this.objToXml(file, Fruitori.class, (Object)fruitori, false);
    }

    public void write(File file, Fruitori fruitori, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Fruitori.class, (Object)fruitori, prettyPrint);
    }

    public void write(OutputStream out, Fruitori fruitori) throws SerializerException {
        this.objToXml(out, Fruitori.class, (Object)fruitori, false);
    }

    public void write(OutputStream out, Fruitori fruitori, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Fruitori.class, (Object)fruitori, prettyPrint);
    }

    public byte[] toByteArray(Fruitori fruitori) throws SerializerException {
        return this.objToXml(Fruitori.class, fruitori, false).toByteArray();
    }

    public byte[] toByteArray(Fruitori fruitori, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Fruitori.class, fruitori, prettyPrint).toByteArray();
    }

    public String toString(Fruitori fruitori) throws SerializerException {
        return this.objToXml(Fruitori.class, fruitori, false).toString();
    }

    public String toString(Fruitori fruitori, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Fruitori.class, fruitori, prettyPrint).toString();
    }

    public void write(String fileName, RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore) throws SerializerException {
        this.objToXml(fileName, RiferimentoServizioApplicativoErogatore.class, (Object)riferimentoServizioApplicativoErogatore, false);
    }

    public void write(String fileName, RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RiferimentoServizioApplicativoErogatore.class, (Object)riferimentoServizioApplicativoErogatore, prettyPrint);
    }

    public void write(File file, RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore) throws SerializerException {
        this.objToXml(file, RiferimentoServizioApplicativoErogatore.class, (Object)riferimentoServizioApplicativoErogatore, false);
    }

    public void write(File file, RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RiferimentoServizioApplicativoErogatore.class, (Object)riferimentoServizioApplicativoErogatore, prettyPrint);
    }

    public void write(OutputStream out, RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore) throws SerializerException {
        this.objToXml(out, RiferimentoServizioApplicativoErogatore.class, (Object)riferimentoServizioApplicativoErogatore, false);
    }

    public void write(OutputStream out, RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RiferimentoServizioApplicativoErogatore.class, (Object)riferimentoServizioApplicativoErogatore, prettyPrint);
    }

    public byte[] toByteArray(RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoErogatore.class, riferimentoServizioApplicativoErogatore, false).toByteArray();
    }

    public byte[] toByteArray(RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoErogatore.class, riferimentoServizioApplicativoErogatore, prettyPrint).toByteArray();
    }

    public String toString(RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoErogatore.class, riferimentoServizioApplicativoErogatore, false).toString();
    }

    public String toString(RiferimentoServizioApplicativoErogatore riferimentoServizioApplicativoErogatore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoServizioApplicativoErogatore.class, riferimentoServizioApplicativoErogatore, prettyPrint).toString();
    }

    public void write(String fileName, DatiApplicativiErogazione datiApplicativiErogazione) throws SerializerException {
        this.objToXml(fileName, DatiApplicativiErogazione.class, (Object)datiApplicativiErogazione, false);
    }

    public void write(String fileName, DatiApplicativiErogazione datiApplicativiErogazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DatiApplicativiErogazione.class, (Object)datiApplicativiErogazione, prettyPrint);
    }

    public void write(File file, DatiApplicativiErogazione datiApplicativiErogazione) throws SerializerException {
        this.objToXml(file, DatiApplicativiErogazione.class, (Object)datiApplicativiErogazione, false);
    }

    public void write(File file, DatiApplicativiErogazione datiApplicativiErogazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DatiApplicativiErogazione.class, (Object)datiApplicativiErogazione, prettyPrint);
    }

    public void write(OutputStream out, DatiApplicativiErogazione datiApplicativiErogazione) throws SerializerException {
        this.objToXml(out, DatiApplicativiErogazione.class, (Object)datiApplicativiErogazione, false);
    }

    public void write(OutputStream out, DatiApplicativiErogazione datiApplicativiErogazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DatiApplicativiErogazione.class, (Object)datiApplicativiErogazione, prettyPrint);
    }

    public byte[] toByteArray(DatiApplicativiErogazione datiApplicativiErogazione) throws SerializerException {
        return this.objToXml(DatiApplicativiErogazione.class, datiApplicativiErogazione, false).toByteArray();
    }

    public byte[] toByteArray(DatiApplicativiErogazione datiApplicativiErogazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiApplicativiErogazione.class, datiApplicativiErogazione, prettyPrint).toByteArray();
    }

    public String toString(DatiApplicativiErogazione datiApplicativiErogazione) throws SerializerException {
        return this.objToXml(DatiApplicativiErogazione.class, datiApplicativiErogazione, false).toString();
    }

    public String toString(DatiApplicativiErogazione datiApplicativiErogazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiApplicativiErogazione.class, datiApplicativiErogazione, prettyPrint).toString();
    }

    public void write(String fileName, RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(fileName, RiferimentoAccordoServizioParteSpecifica.class, (Object)riferimentoAccordoServizioParteSpecifica, false);
    }

    public void write(String fileName, RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RiferimentoAccordoServizioParteSpecifica.class, (Object)riferimentoAccordoServizioParteSpecifica, prettyPrint);
    }

    public void write(File file, RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(file, RiferimentoAccordoServizioParteSpecifica.class, (Object)riferimentoAccordoServizioParteSpecifica, false);
    }

    public void write(File file, RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RiferimentoAccordoServizioParteSpecifica.class, (Object)riferimentoAccordoServizioParteSpecifica, prettyPrint);
    }

    public void write(OutputStream out, RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(out, RiferimentoAccordoServizioParteSpecifica.class, (Object)riferimentoAccordoServizioParteSpecifica, false);
    }

    public void write(OutputStream out, RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RiferimentoAccordoServizioParteSpecifica.class, (Object)riferimentoAccordoServizioParteSpecifica, prettyPrint);
    }

    public byte[] toByteArray(RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteSpecifica.class, riferimentoAccordoServizioParteSpecifica, false).toByteArray();
    }

    public byte[] toByteArray(RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteSpecifica.class, riferimentoAccordoServizioParteSpecifica, prettyPrint).toByteArray();
    }

    public String toString(RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteSpecifica.class, riferimentoAccordoServizioParteSpecifica, false).toString();
    }

    public String toString(RiferimentoAccordoServizioParteSpecifica riferimentoAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteSpecifica.class, riferimentoAccordoServizioParteSpecifica, prettyPrint).toString();
    }

    public void write(String fileName, DatiFruizione datiFruizione) throws SerializerException {
        this.objToXml(fileName, DatiFruizione.class, (Object)datiFruizione, false);
    }

    public void write(String fileName, DatiFruizione datiFruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DatiFruizione.class, (Object)datiFruizione, prettyPrint);
    }

    public void write(File file, DatiFruizione datiFruizione) throws SerializerException {
        this.objToXml(file, DatiFruizione.class, (Object)datiFruizione, false);
    }

    public void write(File file, DatiFruizione datiFruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DatiFruizione.class, (Object)datiFruizione, prettyPrint);
    }

    public void write(OutputStream out, DatiFruizione datiFruizione) throws SerializerException {
        this.objToXml(out, DatiFruizione.class, (Object)datiFruizione, false);
    }

    public void write(OutputStream out, DatiFruizione datiFruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DatiFruizione.class, (Object)datiFruizione, prettyPrint);
    }

    public byte[] toByteArray(DatiFruizione datiFruizione) throws SerializerException {
        return this.objToXml(DatiFruizione.class, datiFruizione, false).toByteArray();
    }

    public byte[] toByteArray(DatiFruizione datiFruizione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiFruizione.class, datiFruizione, prettyPrint).toByteArray();
    }

    public String toString(DatiFruizione datiFruizione) throws SerializerException {
        return this.objToXml(DatiFruizione.class, datiFruizione, false).toString();
    }

    public String toString(DatiFruizione datiFruizione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiFruizione.class, datiFruizione, prettyPrint).toString();
    }

    public void write(String fileName, RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune) throws SerializerException {
        this.objToXml(fileName, RiferimentoAccordoServizioParteComune.class, (Object)riferimentoAccordoServizioParteComune, false);
    }

    public void write(String fileName, RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RiferimentoAccordoServizioParteComune.class, (Object)riferimentoAccordoServizioParteComune, prettyPrint);
    }

    public void write(File file, RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune) throws SerializerException {
        this.objToXml(file, RiferimentoAccordoServizioParteComune.class, (Object)riferimentoAccordoServizioParteComune, false);
    }

    public void write(File file, RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RiferimentoAccordoServizioParteComune.class, (Object)riferimentoAccordoServizioParteComune, prettyPrint);
    }

    public void write(OutputStream out, RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune) throws SerializerException {
        this.objToXml(out, RiferimentoAccordoServizioParteComune.class, (Object)riferimentoAccordoServizioParteComune, false);
    }

    public void write(OutputStream out, RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RiferimentoAccordoServizioParteComune.class, (Object)riferimentoAccordoServizioParteComune, prettyPrint);
    }

    public byte[] toByteArray(RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteComune.class, riferimentoAccordoServizioParteComune, false).toByteArray();
    }

    public byte[] toByteArray(RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteComune.class, riferimentoAccordoServizioParteComune, prettyPrint).toByteArray();
    }

    public String toString(RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteComune.class, riferimentoAccordoServizioParteComune, false).toString();
    }

    public String toString(RiferimentoAccordoServizioParteComune riferimentoAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RiferimentoAccordoServizioParteComune.class, riferimentoAccordoServizioParteComune, prettyPrint).toString();
    }

    public void write(String fileName, Erogazione erogazione) throws SerializerException {
        this.objToXml(fileName, Erogazione.class, (Object)erogazione, false);
    }

    public void write(String fileName, Erogazione erogazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Erogazione.class, (Object)erogazione, prettyPrint);
    }

    public void write(File file, Erogazione erogazione) throws SerializerException {
        this.objToXml(file, Erogazione.class, (Object)erogazione, false);
    }

    public void write(File file, Erogazione erogazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Erogazione.class, (Object)erogazione, prettyPrint);
    }

    public void write(OutputStream out, Erogazione erogazione) throws SerializerException {
        this.objToXml(out, Erogazione.class, (Object)erogazione, false);
    }

    public void write(OutputStream out, Erogazione erogazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Erogazione.class, (Object)erogazione, prettyPrint);
    }

    public byte[] toByteArray(Erogazione erogazione) throws SerializerException {
        return this.objToXml(Erogazione.class, erogazione, false).toByteArray();
    }

    public byte[] toByteArray(Erogazione erogazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Erogazione.class, erogazione, prettyPrint).toByteArray();
    }

    public String toString(Erogazione erogazione) throws SerializerException {
        return this.objToXml(Erogazione.class, erogazione, false).toString();
    }

    public String toString(Erogazione erogazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Erogazione.class, erogazione, prettyPrint).toString();
    }

    public void write(String fileName, Fruizione fruizione) throws SerializerException {
        this.objToXml(fileName, Fruizione.class, (Object)fruizione, false);
    }

    public void write(String fileName, Fruizione fruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Fruizione.class, (Object)fruizione, prettyPrint);
    }

    public void write(File file, Fruizione fruizione) throws SerializerException {
        this.objToXml(file, Fruizione.class, (Object)fruizione, false);
    }

    public void write(File file, Fruizione fruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Fruizione.class, (Object)fruizione, prettyPrint);
    }

    public void write(OutputStream out, Fruizione fruizione) throws SerializerException {
        this.objToXml(out, Fruizione.class, (Object)fruizione, false);
    }

    public void write(OutputStream out, Fruizione fruizione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Fruizione.class, (Object)fruizione, prettyPrint);
    }

    public byte[] toByteArray(Fruizione fruizione) throws SerializerException {
        return this.objToXml(Fruizione.class, fruizione, false).toByteArray();
    }

    public byte[] toByteArray(Fruizione fruizione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Fruizione.class, fruizione, prettyPrint).toByteArray();
    }

    public String toString(Fruizione fruizione) throws SerializerException {
        return this.objToXml(Fruizione.class, fruizione, false).toString();
    }

    public String toString(Fruizione fruizione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Fruizione.class, fruizione, prettyPrint).toString();
    }
}

