/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.builder;

import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import org.openspcoop2.core.controllo_traffico.constants.Costanti;
import org.openspcoop2.core.eccezione.errore_applicativo.Eccezione;
import org.openspcoop2.core.eccezione.errore_applicativo.ErroreApplicativo;
import org.openspcoop2.core.eccezione.errore_applicativo.constants.TipoEccezione;
import org.openspcoop2.core.eccezione.errore_applicativo.utils.XMLUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.IEsitoBuilder;
import org.openspcoop2.protocol.sdk.builder.InformazioniErroriInfrastrutturali;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CostantiProtocollo;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.protocol.utils.EsitoIdentificationModeContextProperty;
import org.openspcoop2.protocol.utils.EsitoIdentificationModeSoapFault;
import org.openspcoop2.protocol.utils.EsitoTransportContextIdentification;
import org.openspcoop2.utils.LimitedInputStream;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.TimeoutInputStream;
import org.openspcoop2.utils.rest.problem.JsonDeserializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.rest.problem.XmlDeserializer;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EsitoBuilder
extends BasicComponentFactory
implements IEsitoBuilder {
    protected EsitiProperties esitiProperties;
    protected boolean erroreProtocollo = false;
    protected boolean envelopeErroreProtocollo = true;
    protected boolean faultEsterno = false;

    public EsitoBuilder(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
        this.esitiProperties = EsitiProperties.getInstance(this.log, protocolFactory);
        this.erroreProtocollo = this.esitiProperties.isErroreProtocollo();
        this.envelopeErroreProtocollo = this.esitiProperties.isEnvelopeErroreProtocollo();
        this.faultEsterno = this.esitiProperties.isFaultEsterno();
    }

    protected String getTipoContext(TransportRequestContext transportRequestContext) throws ProtocolException {
        return EsitoBuilder.getTipoContext(transportRequestContext, this.esitiProperties, this.log);
    }

    public static String getTipoContext(TransportRequestContext transportRequestContext, EsitiProperties esitiProperties, Logger log) throws ProtocolException {
        String tipoContext = "standard";
        if (esitiProperties.isSingleTransactionContextCode()) {
            return tipoContext;
        }
        if (transportRequestContext != null) {
            String propertyName;
            String msg;
            String headerName;
            String value;
            List<EsitoTransportContextIdentification> list;
            if (transportRequestContext.getHeaders() != null && transportRequestContext.getHeaders().size() > 0 && (list = esitiProperties.getEsitoTransactionContextHeaderTrasportoDynamicIdentification()) != null && !list.isEmpty()) {
                for (EsitoTransportContextIdentification esitoTransportContextIdentification : list) {
                    if (!esitoTransportContextIdentification.match(transportRequestContext.getHeaders())) continue;
                    tipoContext = esitoTransportContextIdentification.getType();
                    break;
                }
            }
            if (transportRequestContext.getParameters() != null && transportRequestContext.getParameters().size() > 0 && (list = esitiProperties.getEsitoTransactionContextHeaderFormBasedDynamicIdentification()) != null && !list.isEmpty()) {
                for (EsitoTransportContextIdentification esitoTransportContextIdentification : list) {
                    if (!esitoTransportContextIdentification.match(transportRequestContext.getParameters())) continue;
                    tipoContext = esitoTransportContextIdentification.getType();
                    break;
                }
            }
            if (transportRequestContext.getHeaders() != null && transportRequestContext.getHeaders().size() > 0 && (value = transportRequestContext.getHeaderFirstValue(headerName = esitiProperties.getEsitoTransactionContextHeaderTrasportoName())) != null) {
                if (!esitiProperties.getEsitiTransactionContextCode().contains(value)) {
                    msg = "Trovato nell'header http un header con nome [" + headerName + "] il cui valore [" + value + "] non rientra tra i tipi di contesto supportati";
                    log.error(msg);
                } else {
                    tipoContext = value;
                }
            }
            if (transportRequestContext.getParameters() != null && transportRequestContext.getParameters().size() > 0 && (value = transportRequestContext.getParameterFirstValue(propertyName = esitiProperties.getEsitoTransactionContextFormBasedPropertyName())) != null) {
                if (!esitiProperties.getEsitiTransactionContextCode().contains(value)) {
                    msg = "Trovato nella url una propriet\u00e0 con nome [" + propertyName + "] il cui valore [" + value + "] non rientra tra i tipi di contesto supportati";
                    log.error(msg);
                } else {
                    tipoContext = value;
                }
            }
        }
        return tipoContext;
    }

    private EsitoTransazione getEsitoErroreGenerale(InformazioniErroriInfrastrutturali informazioniErroriInfrastrutturali, String tipoContext) throws ProtocolException {
        if (informazioniErroriInfrastrutturali.isRicevutoSoapFaultServerPortaDelegata()) {
            if (this.faultEsterno) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_SERVER, tipoContext);
            }
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
        }
        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
    }

    @Override
    public EsitoTransazione getEsito(TransportRequestContext transportRequestContext, EsitoTransazioneName name) {
        String tipoContext = null;
        try {
            tipoContext = this.getTipoContext(transportRequestContext);
            return this.esitiProperties.convertToEsitoTransazione(name, tipoContext);
        }
        catch (Exception e) {
            this.log.error("Errore durante la trasformazione in oggetto EsitoTransazione (utilizzo lo standard): " + e.getMessage(), (Throwable)e);
            Integer code = null;
            EsitoTransazioneName tmp = null;
            try {
                if (tipoContext == null) {
                    tipoContext = "standard";
                }
                code = this.esitiProperties.convertoToCode(name);
                tmp = name;
            }
            catch (Exception eInternal) {
                if (tipoContext != null) {
                    this.log.error("Errore durante la trasformazione interna per il codice: " + eInternal.getMessage(), (Throwable)eInternal);
                }
                return EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
            }
            try {
                return new EsitoTransazione(tmp, code, tipoContext);
            }
            catch (Exception eInternal) {
                this.log.error("Errore durante la init EsitoTransazione", (Throwable)eInternal);
                return EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
            }
        }
    }

    @Override
    public EsitoTransazione getEsito(TransportRequestContext transportRequestContext, int returnCode, ServiceBinding serviceBinding, OpenSPCoop2Message message, InformazioniErroriInfrastrutturali informazioniErroriInfrastrutturali, Map<Object> context) throws ProtocolException {
        return this.getEsito(transportRequestContext, returnCode, serviceBinding, message, null, informazioniErroriInfrastrutturali, context);
    }

    @Override
    public EsitoTransazione getEsito(TransportRequestContext transportRequestContext, int returnCode, ServiceBinding serviceBinding, OpenSPCoop2Message message, ProprietaErroreApplicativo erroreApplicativo, InformazioniErroriInfrastrutturali informazioniErroriInfrastrutturali, Map<Object> context) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage soapMessage = null;
            if (message != null && ServiceBinding.SOAP.equals((Object)message.getServiceBinding()) && !message.isForcedEmptyResponse() && message.getForcedResponse() == null) {
                soapMessage = message.castAsSoap();
            }
            if (informazioniErroriInfrastrutturali == null) {
                informazioniErroriInfrastrutturali = new InformazioniErroriInfrastrutturali();
            }
            String tipoContext = this.getTipoContext(transportRequestContext);
            boolean emissioneDiagnosticiError = context != null && context.containsKey(org.openspcoop2.core.constants.Costanti.EMESSI_DIAGNOSTICI_ERRORE);
            boolean corsPreflightRequestViaGateway = context != null && context.containsKey(org.openspcoop2.core.constants.Costanti.CORS_PREFLIGHT_REQUEST_VIA_GATEWAY);
            boolean corsPreflightRequestTrasparente = context != null && context.containsKey(org.openspcoop2.core.constants.Costanti.CORS_PREFLIGHT_REQUEST_TRASPARENTE);
            EsitoTransazione returnEsitoOk = null;
            returnEsitoOk = emissioneDiagnosticiError ? this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.OK_PRESENZA_ANOMALIE, tipoContext) : (corsPreflightRequestViaGateway ? this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_VIA_GATEWAY, tipoContext) : (corsPreflightRequestTrasparente ? this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_TRASPARENTE, tipoContext) : this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.OK, tipoContext)));
            EsitoTransazione esitoErrore4xx = this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
            EsitoTransazione esitoErrore5xx = this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
            if (context != null) {
                if (context.containsKey(LimitedInputStream.ERROR_MSG_KEY)) {
                    String limitedExceededMessage = (String)context.get(LimitedInputStream.ERROR_MSG_KEY);
                    if (limitedExceededMessage != null && limitedExceededMessage.startsWith("Request ") || limitedExceededMessage != null && limitedExceededMessage.startsWith("Response ")) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CONTROLLO_TRAFFICO_POLICY_VIOLATA, tipoContext);
                    }
                } else if (context.containsKey(Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE) || context.containsKey(TimeoutInputStream.ERROR_MSG_KEY)) {
                    String timeoutExceededMessage = null;
                    if (context.containsKey(Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE)) {
                        timeoutExceededMessage = (String)context.get(Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE);
                        if ("controlloTrafficoConnectionTimeout".equals(timeoutExceededMessage)) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_CONNECTION_TIMEOUT, tipoContext);
                        }
                        if ("controlloTrafficoRequestReadTimeout".equals(timeoutExceededMessage)) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_REQUEST_TIMEOUT, tipoContext);
                        }
                        if ("controlloTrafficoResponseReadTimeout".equals(timeoutExceededMessage) || "controlloTrafficoReadTimeout".equals(timeoutExceededMessage)) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_RESPONSE_TIMEOUT, tipoContext);
                        }
                        if ("controlloTrafficoRateLimitingPolicyInErrore".equals(timeoutExceededMessage)) {
                            if (context.containsKey(Costanti.PDD_CONTEXT_VALUE_POLICY_IN_ERROR_ESITO)) {
                                EsitoTransazioneName esito = (EsitoTransazioneName)context.get(Costanti.PDD_CONTEXT_VALUE_POLICY_IN_ERROR_ESITO);
                                return this.esitiProperties.convertToEsitoTransazione(esito, tipoContext);
                            }
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                        }
                    }
                    if ((timeoutExceededMessage = (String)context.get(LimitedInputStream.ERROR_MSG_KEY)) != null && timeoutExceededMessage.startsWith("Request ")) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_REQUEST_TIMEOUT, tipoContext);
                    }
                    if (timeoutExceededMessage != null && timeoutExceededMessage.startsWith("Response ")) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_RESPONSE_TIMEOUT, tipoContext);
                    }
                }
            }
            if (informazioniErroriInfrastrutturali.isContenutoRichiestaNonRiconosciuto()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, tipoContext);
            }
            if (informazioniErroriInfrastrutturali.isContenutoRispostaNonRiconosciuto()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, tipoContext);
            }
            if (context != null) {
                String pS;
                Object p;
                List<Integer> customCodeForContextProperty = this.esitiProperties.getEsitiCodeForContextPropertyIdentificationMode();
                if (customCodeForContextProperty != null && !customCodeForContextProperty.isEmpty()) {
                    for (Integer customCode : customCodeForContextProperty) {
                        List<EsitoIdentificationModeContextProperty> l = this.esitiProperties.getEsitoIdentificationModeContextPropertyList(customCode);
                        if (l == null || l.isEmpty()) continue;
                        for (EsitoIdentificationModeContextProperty esitoIdentificationModeContextProperty : l) {
                            try {
                                Object p2 = context.get(esitoIdentificationModeContextProperty.getMapKey());
                                if (!(p2 instanceof String)) continue;
                                String pS2 = (String)p2;
                                if (esitoIdentificationModeContextProperty.getValue() != null && !esitoIdentificationModeContextProperty.getValue().equals(pS2)) continue;
                                EsitoTransazioneName esitoTransazioneName = esitoIdentificationModeContextProperty.getEsito();
                                if (esitoTransazioneName == null) {
                                    esitoTransazioneName = EsitoTransazioneName.CUSTOM;
                                }
                                EsitoTransazione esito = this.esitiProperties.convertToEsitoTransazione(esitoTransazioneName, customCode, tipoContext);
                                List<Integer> esitiOk = this.esitiProperties.getEsitiCodeOk();
                                boolean found = false;
                                for (Integer intValue : esitiOk) {
                                    if (intValue.intValue() != customCode.intValue()) continue;
                                    found = true;
                                }
                                if (!found) {
                                    return esito;
                                }
                                returnEsitoOk = esito;
                            }
                            catch (Exception t) {
                                String msgError = "Errore durante l'identificazione dell'esito: " + t.getMessage();
                                this.log.error(msgError, (Throwable)t);
                            }
                        }
                    }
                }
                if ((p = context.get(org.openspcoop2.core.constants.Costanti.ERRORE_GENERICO)) instanceof String && "true".equalsIgnoreCase(pS = (String)p)) {
                    return esitoErrore5xx;
                }
            }
            if (informazioniErroriInfrastrutturali.isErroreUtilizzoConnettore()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_INVOCAZIONE, tipoContext);
            }
            if (soapMessage != null && soapMessage.hasSOAPFault()) {
                Object erroreGovwayObject = message.getContextProperty(org.openspcoop2.message.constants.Costanti.ERRORE_GOVWAY);
                String erroreGovway = null;
                if (erroreGovwayObject instanceof String) {
                    erroreGovway = (String)erroreGovwayObject;
                }
                if (erroreGovway != null && !"".equals(erroreGovway)) {
                    Object o;
                    boolean erroreProtocolloInContext = false;
                    if (this.erroreProtocollo && (o = message.getContextProperty(org.openspcoop2.core.constants.Costanti.ERRORE_VALIDAZIONE_PROTOCOLLO)) != null) {
                        if (o instanceof String) {
                            erroreProtocolloInContext = "true".equalsIgnoreCase((String)o);
                        } else if (o instanceof Boolean) {
                            erroreProtocolloInContext = (Boolean)o;
                        }
                    }
                    if (erroreProtocolloInContext) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                    }
                }
                return this.getEsitoSoapFault(message, soapMessage.getSOAPBody(), erroreApplicativo, informazioniErroriInfrastrutturali, tipoContext);
            }
            if (message != null) {
                boolean checkElementSeContieneFaultPdD = true;
                Object erroreGovwayObject = message.getContextProperty(org.openspcoop2.message.constants.Costanti.ERRORE_GOVWAY);
                String erroreGovway = null;
                if (erroreGovwayObject instanceof String) {
                    erroreGovway = (String)erroreGovwayObject;
                }
                Object internalErrorCodeGovWayObject = message.getContextProperty(org.openspcoop2.message.constants.Costanti.ERRORE_GOVWAY_CODE);
                String internalErrorCodeGovWay = null;
                if (internalErrorCodeGovWayObject != null) {
                    internalErrorCodeGovWay = (String)internalErrorCodeGovWayObject;
                }
                if (erroreGovway != null && !"".equals(erroreGovway)) {
                    Object o;
                    boolean erroreProtocolloInContext = false;
                    if (this.erroreProtocollo && (o = message.getContextProperty(org.openspcoop2.core.constants.Costanti.ERRORE_VALIDAZIONE_PROTOCOLLO)) != null) {
                        if (o instanceof String) {
                            erroreProtocolloInContext = "true".equalsIgnoreCase((String)o);
                        } else if (o instanceof Boolean) {
                            erroreProtocolloInContext = (Boolean)o;
                        }
                    }
                    if (erroreProtocolloInContext) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                    }
                }
                boolean checkReturnCodeForFault = false;
                switch (message.getMessageType()) {
                    case SOAP_11: 
                    case SOAP_12: {
                        EsitoTransazione esitoErrore;
                        if (!MessageRole.FAULT.equals((Object)message.getMessageRole())) break;
                        if (checkElementSeContieneFaultPdD && soapMessage != null && (esitoErrore = this.getEsitoMessaggioApplicativo(message.getFactory(), erroreApplicativo, soapMessage.getSOAPBody(), tipoContext, erroreGovway, internalErrorCodeGovWay)) != null) {
                            return esitoErrore;
                        }
                        checkReturnCodeForFault = true;
                        break;
                    }
                    case XML: {
                        EsitoTransazione esitoErrore;
                        if (message.castAsRestXml().isProblemDetailsForHttpApis_RFC7807() && erroreGovway == null) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
                        }
                        if (!MessageRole.FAULT.equals((Object)message.getMessageRole())) break;
                        if (checkElementSeContieneFaultPdD && message.castAsRestXml().hasContent() && (esitoErrore = this.getEsitoMessaggioApplicativo(message.getFactory(), erroreApplicativo, (Node)message.castAsRestXml().getContent(), tipoContext, erroreGovway, internalErrorCodeGovWay)) != null) {
                            return esitoErrore;
                        }
                        checkReturnCodeForFault = true;
                        break;
                    }
                    case JSON: {
                        EsitoTransazione esitoErrore;
                        if (message.castAsRestJson().isProblemDetailsForHttpApis_RFC7807() && erroreGovway == null) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
                        }
                        if (!MessageRole.FAULT.equals((Object)message.getMessageRole())) break;
                        if (checkElementSeContieneFaultPdD && message.castAsRestJson().hasContent() && (esitoErrore = this.getEsitoMessaggioApplicativo(erroreApplicativo, (String)message.castAsRestJson().getContent(), tipoContext, erroreGovway, internalErrorCodeGovWay)) != null) {
                            return esitoErrore;
                        }
                        checkReturnCodeForFault = true;
                        break;
                    }
                    default: {
                        if (!MessageRole.FAULT.equals((Object)message.getMessageRole())) break;
                        checkReturnCodeForFault = true;
                    }
                }
                if (checkReturnCodeForFault) {
                    if (returnCode >= 400 && returnCode <= 499) {
                        return esitoErrore4xx;
                    }
                    return esitoErrore5xx;
                }
                if (returnCode >= 200 && returnCode <= 299) {
                    return returnEsitoOk;
                }
                if (returnCode >= 300 && returnCode <= 399) {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.HTTP_3xx, tipoContext);
                }
                if (returnCode >= 400 && returnCode <= 499) {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.HTTP_4xx, tipoContext);
                }
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.HTTP_5xx, tipoContext);
            }
            if (returnCode >= 200 && returnCode <= 299) {
                return returnEsitoOk;
            }
            if (returnCode >= 300 && returnCode <= 399) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.HTTP_3xx, tipoContext);
            }
            if (returnCode >= 400 && returnCode <= 499) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.HTTP_4xx, tipoContext);
            }
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.HTTP_5xx, tipoContext);
        }
        catch (Exception e) {
            throw new ProtocolException("Identificazione stato non riuscita: " + e.getMessage(), e);
        }
    }

    private EsitoTransazione getEsitoSoapFault(OpenSPCoop2Message message, SOAPBody soapBody, ProprietaErroreApplicativo erroreApplicativo, InformazioniErroriInfrastrutturali informazioniErroriInfrastrutturali, String tipoContext) throws ProtocolException {
        boolean faultActorCustom;
        boolean faultInternalError;
        SOAPFault fault = soapBody.getFault();
        String actor = fault.getFaultActor();
        String reason = fault.getFaultString();
        String codice = null;
        String namespaceCodice = null;
        if (fault.getFaultCodeAsQName() != null) {
            codice = fault.getFaultCodeAsQName().getLocalPart();
            namespaceCodice = fault.getFaultCodeAsQName().getNamespaceURI();
        } else {
            codice = fault.getFaultCode();
        }
        Object backwardCompatibilityActorObject = message.getContextProperty(CostantiProtocollo.BACKWARD_COMPATIBILITY_ACTOR);
        String backwardCompatibilityActor = null;
        if (backwardCompatibilityActorObject != null) {
            backwardCompatibilityActor = (String)backwardCompatibilityActorObject;
        }
        Object customActorObject = message.getContextProperty(CostantiProtocollo.CUSTOM_ACTOR);
        String customActor = null;
        if (customActorObject != null) {
            customActor = (String)customActorObject;
        }
        boolean bl = faultInternalError = actor != null && "http://govway.org/fault".equals(actor);
        if (faultInternalError) {
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
        }
        Object erroreGovwayObject = message.getContextProperty(org.openspcoop2.message.constants.Costanti.ERRORE_GOVWAY);
        String erroreGovway = null;
        if (erroreGovwayObject instanceof String) {
            erroreGovway = (String)erroreGovwayObject;
        }
        boolean faultActorOpenSPCoopV2 = erroreApplicativo != null && erroreApplicativo.getFaultActor() != null && erroreApplicativo.getFaultActor().equals(actor);
        boolean faultActorBackwardCompatibility = backwardCompatibilityActor != null && backwardCompatibilityActor.equals(actor);
        boolean bl2 = faultActorCustom = customActor != null && customActor.equals(actor);
        if (faultActorOpenSPCoopV2 || faultActorBackwardCompatibility || faultActorCustom) {
            String internalErrorCode;
            List list;
            if ("rfc7807".equals(erroreGovway) && MessageRole.FAULT.equals((Object)message.getMessageRole()) && fault.getDetail() != null && (list = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)message.getFactory(), (Node)fault.getDetail(), (boolean)false)) != null && !list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    XmlDeserializer xmlDeserializer = new XmlDeserializer();
                    Node node = (Node)iterator.next();
                    if (!xmlDeserializer.isProblemRFC7807(node) || !(node instanceof Element)) continue;
                    try {
                        ProblemRFC7807 problem = xmlDeserializer.fromNode(node, false);
                        Integer status = problem.getStatus();
                        if (status != null) {
                            int valueInt = status;
                            if (valueInt >= 400 && valueInt <= 499) {
                                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                            }
                            if (valueInt >= 500 && valueInt <= 599) {
                                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                            }
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                        }
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    catch (Exception e) {
                        this.log.error("Errore durante l'identificazione dell'esito: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (codice == null) {
                return this.getEsitoErroreGenerale(informazioniErroriInfrastrutturali, tipoContext);
            }
            String prefixFaultCode = erroreApplicativo.getFaultPrefixCode();
            if (prefixFaultCode == null) {
                prefixFaultCode = "GOVWAY-";
            }
            boolean prefixOpv2 = codice.startsWith(prefixFaultCode);
            Object backwardCompatibilityPrefixObject = message.getContextProperty(CostantiProtocollo.BACKWARD_COMPATIBILITY_PREFIX_FAULT_CODE);
            String backwardCompatibilityPrefix = null;
            if (backwardCompatibilityPrefixObject != null) {
                backwardCompatibilityPrefix = (String)backwardCompatibilityPrefixObject;
            }
            boolean prefixBackwardCompatibility = backwardCompatibilityPrefix != null && codice.startsWith(backwardCompatibilityPrefix);
            boolean genericErrorGovWay = false;
            Object govwayCodeInContextProperty = message.getContextProperty(org.openspcoop2.message.constants.Costanti.ERRORE_GOVWAY_CODE);
            String govwayInternalErrorCode = null;
            if (govwayCodeInContextProperty != null && (genericErrorGovWay = (internalErrorCode = (String)govwayCodeInContextProperty).startsWith(prefixFaultCode))) {
                govwayInternalErrorCode = internalErrorCode;
            }
            if (prefixOpv2 || prefixBackwardCompatibility || genericErrorGovWay) {
                String value = null;
                value = prefixOpv2 ? codice.substring(prefixFaultCode.length()) : (genericErrorGovWay ? govwayInternalErrorCode.substring(prefixFaultCode.length()) : codice.substring(backwardCompatibilityPrefix.length()));
                try {
                    int valueInt = Integer.parseInt(value);
                    if (valueInt >= 400 && valueInt <= 499) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                    }
                    if (valueInt >= 500 && valueInt <= 599) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    return this.getEsitoErroreGenerale(informazioniErroriInfrastrutturali, tipoContext);
                }
                catch (Throwable t) {
                    String error = "Errore calcolato da codice[" + codice + "] prefixOpv2[" + prefixOpv2 + "] prefixFaultCode[" + prefixFaultCode + "] prefixBackwardCompatibility[" + prefixBackwardCompatibility + "] prefixBackwardCompatibility[" + prefixBackwardCompatibility + "] value[" + value + "]";
                    if (this.log != null) {
                        this.log.error(error + ": " + t.getMessage(), t);
                    } else {
                        System.err.print(error);
                        t.printStackTrace(System.err);
                    }
                    return this.getEsitoErroreGenerale(informazioniErroriInfrastrutturali, tipoContext);
                }
            }
            if (this.erroreProtocollo) {
                if (this.envelopeErroreProtocollo) {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                }
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
            }
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
        }
        ITraduttore trasl = this.protocolFactory.createTraduttore();
        if ("Client".equals(codice) && trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE).equals(reason)) {
            if (this.erroreProtocollo && this.envelopeErroreProtocollo) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
            }
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
        }
        if ("Server".equals(codice) && trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(reason)) {
            if (this.erroreProtocollo && this.envelopeErroreProtocollo) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
            }
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
        }
        List<Integer> customCodeForSoapFault = this.esitiProperties.getEsitiCodeForSoapFaultIdentificationMode();
        if (customCodeForSoapFault != null && !customCodeForSoapFault.isEmpty()) {
            for (Integer customCodeSF : customCodeForSoapFault) {
                List<EsitoIdentificationModeSoapFault> l = this.esitiProperties.getEsitoIdentificationModeSoapFaultList(customCodeSF);
                for (int i = 0; i < l.size(); ++i) {
                    EsitoIdentificationModeSoapFault e = l.get(i);
                    if (e.getFaultCode() != null && !e.getFaultCode().equals(codice) || e.getFaultNamespaceCode() != null && !e.getFaultNamespaceCode().equals(namespaceCodice) || e.getFaultReason() != null && (e.getFaultReasonContains() == null || e.getFaultReasonContains() == false ? !e.getFaultReason().equals(reason) : reason == null || !reason.contains(e.getFaultReason()))) continue;
                    if (e.getFaultActor() != null && !e.getFaultActor().equals(actor) || e.getFaultActorNotDefined() != null && e.getFaultActorNotDefined().booleanValue() && actor != null) continue;
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CUSTOM, customCodeSF, tipoContext);
                }
            }
        }
        if (informazioniErroriInfrastrutturali.isRicevutoSoapFaultServerPortaDelegata()) {
            if (this.faultEsterno) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_SERVER, tipoContext);
            }
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
        }
        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
    }

    protected EsitoTransazione getEsitoMessaggioApplicativo(OpenSPCoop2MessageFactory messageFactory, ProprietaErroreApplicativo erroreApplicativo, SOAPBody body, String tipoContext, String erroreGovway, String internalErrorCodeGovWay) throws ProtocolException {
        Node childNode;
        if (erroreApplicativo != null && (childNode = body.getFirstChild()) != null) {
            return this.getEsitoMessaggioApplicativo(messageFactory, erroreApplicativo, childNode, tipoContext, erroreGovway, internalErrorCodeGovWay);
        }
        return null;
    }

    protected EsitoTransazione getEsitoMessaggioApplicativo(OpenSPCoop2MessageFactory messageFactory, ProprietaErroreApplicativo erroreApplicativo, Node childNode, String tipoContext, String erroreGovway, String internalErrorCodeGovWay) throws ProtocolException {
        if (childNode != null && childNode.getNextSibling() == null) {
            if ("rfc7807".equals(erroreGovway)) {
                if (childNode instanceof Element) {
                    try {
                        XmlDeserializer xmlDeserializer = new XmlDeserializer();
                        ProblemRFC7807 problem = xmlDeserializer.fromNode(childNode, false);
                        Integer status = problem.getStatus();
                        if (status != null) {
                            int valueInt = status;
                            if (valueInt >= 400 && valueInt <= 499) {
                                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                            }
                            if (valueInt >= 500 && valueInt <= 599) {
                                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                            }
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                        }
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    catch (Exception e) {
                        this.log.error("Errore durante l'identificazione dell'esito: " + e.getMessage(), (Throwable)e);
                    }
                }
            } else if (XMLUtils.isErroreApplicativo((Node)childNode)) {
                try {
                    boolean prefixOpv2;
                    byte[] xml = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)messageFactory).toByteArray(childNode, true);
                    ErroreApplicativo erroreApplicativoObject = XMLUtils.getErroreApplicativo((Logger)this.log, (byte[])xml);
                    Eccezione ecc = erroreApplicativoObject.getException();
                    if (TipoEccezione.PROTOCOL.equals((Object)ecc.getType())) {
                        if (this.erroreProtocollo && this.envelopeErroreProtocollo) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                        }
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    String value = ecc.getCode().getBase();
                    String prefixFaultCode = erroreApplicativo.getFaultPrefixCode();
                    if (prefixFaultCode == null) {
                        prefixFaultCode = "GOVWAY-";
                    }
                    if (!(prefixOpv2 = value.startsWith(prefixFaultCode)) && internalErrorCodeGovWay != null && internalErrorCodeGovWay.startsWith(prefixFaultCode)) {
                        prefixOpv2 = true;
                        value = internalErrorCodeGovWay;
                    }
                    if (prefixOpv2) {
                        int valueInt = Integer.parseInt(value = value.substring(prefixFaultCode.length()));
                        if (valueInt >= 400 && valueInt <= 499) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                        }
                        if (valueInt >= 500 && valueInt <= 599) {
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                        }
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                }
                catch (Exception e) {
                    this.log.error("Errore durante l'identificazione dell'esito: " + e.getMessage(), (Throwable)e);
                }
            } else if (OpenSPCoop2MessageFactory.isFaultXmlMessage((Node)childNode)) {
                try {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                }
                catch (Exception e) {
                    this.log.error("Errore durante l'identificazione dell'esito: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected EsitoTransazione getEsitoMessaggioApplicativo(ProprietaErroreApplicativo erroreApplicativo, String jsonBody, String tipoContext, String erroreGovway, String internalErrorCodeGovWay) throws ProtocolException {
        if ("rfc7807".equals(erroreGovway)) {
            try {
                JsonDeserializer jsonDeserializer = new JsonDeserializer();
                ProblemRFC7807 problem = jsonDeserializer.fromString(jsonBody, false);
                Integer status = problem.getStatus();
                if (status != null) {
                    int valueInt = status;
                    if (valueInt >= 400 && valueInt <= 499) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                    }
                    if (valueInt >= 500 && valueInt <= 599) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                }
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
            }
            catch (Exception e) {
                this.log.error("Errore durante l'identificazione dell'esito: " + e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                boolean prefixOpv2;
                String tipo = JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)jsonBody, (String)"$.exception.type", (Logger)this.log);
                if (TipoEccezione.PROTOCOL.getValue().equals(tipo)) {
                    if (this.erroreProtocollo && this.envelopeErroreProtocollo) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                    }
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                }
                String value = JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)jsonBody, (String)"$.exception.code.value", (Logger)this.log);
                String prefixFaultCode = erroreApplicativo.getFaultPrefixCode();
                if (prefixFaultCode == null) {
                    prefixFaultCode = "GOVWAY-";
                }
                if (!(prefixOpv2 = value.startsWith(prefixFaultCode)) && internalErrorCodeGovWay != null && internalErrorCodeGovWay.startsWith(prefixFaultCode)) {
                    prefixOpv2 = true;
                    value = internalErrorCodeGovWay;
                }
                if (prefixOpv2) {
                    int valueInt = Integer.parseInt(value = value.substring(prefixFaultCode.length()));
                    if (valueInt >= 400 && valueInt <= 499) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                    }
                    if (valueInt >= 500 && valueInt <= 599) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                }
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
            }
            catch (Exception e) {
                this.log.error("Errore durante l'identificazione dell'esito: " + e.getMessage(), (Throwable)e);
                try {
                    if (OpenSPCoop2MessageFactory.isFaultJsonMessage((String)jsonBody, (Logger)this.log)) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                }
                catch (Exception e2) {
                    this.log.error("Errore durante l'identificazione dell'esito: " + e2.getMessage(), (Throwable)e2);
                }
            }
        }
        return null;
    }
}

