/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.diagnostica;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.BasicConnectionResult;
import org.openspcoop2.protocol.basic.BasicProducer;
import org.openspcoop2.protocol.basic.BasicProducerType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.jdbc.NullByteTextColumnSanitizer;

public class DiagnosticProducer
extends BasicProducer
implements IDiagnosticProducer {
    public DiagnosticProducer(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory, BasicProducerType.DIAGNOSTIC);
    }

    @Override
    public void initializeAppender(OpenspcoopAppender appenderProperties) throws MsgDiagnosticoException {
        try {
            this.initializeAppender(appenderProperties, false);
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void log(Connection conOpenSPCoopPdD, MsgDiagnostico msgDiagnostico) throws MsgDiagnosticoException {
        if (NullByteTextColumnSanitizer.needsSanitization((String)this.tipoDatabase)) {
            msgDiagnostico.setMessaggio(NullByteTextColumnSanitizer.sanitize((String)this.tipoDatabase, (String)msgDiagnostico.getMessaggio()));
        }
        Statement stmt = null;
        Connection con = null;
        String messaggio = msgDiagnostico.getMessaggio();
        BasicConnectionResult cr = null;
        try {
            Date gdo = msgDiagnostico.getGdo();
            IDSoggetto idPorta = msgDiagnostico.getIdSoggetto();
            String idFunzione = msgDiagnostico.getIdFunzione();
            int severita = msgDiagnostico.getSeverita();
            String idBusta = msgDiagnostico.getIdBusta();
            String idBustaRisposta = msgDiagnostico.getIdBustaRisposta();
            String codiceDiagnostico = msgDiagnostico.getCodice();
            String applicativo = msgDiagnostico.getApplicativo();
            String idTransazione = msgDiagnostico.getIdTransazione();
            if (this.debug) {
                this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] ....");
            }
            TipiDatabase tipo = null;
            if (this.tipoDatabase != null) {
                if (!TipiDatabase.isAMember((String)this.tipoDatabase)) {
                    throw new MsgDiagnosticoException("Tipo database [" + this.tipoDatabase + "] non supportato");
                }
                tipo = TipiDatabase.toEnumConstant((String)this.tipoDatabase);
            }
            cr = this.getConnection(conOpenSPCoopPdD, "log");
            con = cr.getConnection();
            if (this.debug) {
                this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (getConnection finished) ....");
            }
            if (tipo == null) {
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico BackwardCompatible) ....");
                }
                String updateString = "INSERT INTO msgdiagnostici (gdo, pdd_codice, pdd_tipo_soggetto, pdd_nome_soggetto, idfunzione, severita, messaggio, idmessaggio, idmessaggio_risposta, protocollo, codice, id_transazione, applicativo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?)";
                int index = 1;
                stmt = con.prepareStatement(updateString);
                if (gdo != null) {
                    stmt.setTimestamp(index++, new Timestamp(gdo.getTime()));
                } else {
                    stmt.setTimestamp(index++, null);
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)idPorta.getCodicePorta());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)idPorta.getTipo());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)idPorta.getNome());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)idFunzione);
                stmt.setInt(index++, severita);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)messaggio);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)idBusta);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)idBustaRisposta);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)msgDiagnostico.getProtocollo());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)codiceDiagnostico);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)idTransazione);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, (int)index++, (String)applicativo);
                stmt.executeUpdate();
                stmt.close();
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico BackwardCompatible terminato) ....");
                }
            } else {
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico) ....");
                }
                ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
                Timestamp gdoT = null;
                if (gdo != null) {
                    gdoT = new Timestamp(gdo.getTime());
                }
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("gdo", (Object)gdoT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_codice", (Object)this.getSQLStringValue(idPorta.getCodicePorta()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_tipo_soggetto", (Object)this.getSQLStringValue(idPorta.getTipo()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_nome_soggetto", (Object)this.getSQLStringValue(idPorta.getNome()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idfunzione", (Object)this.getSQLStringValue(idFunzione), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("severita", (Object)severita, InsertAndGeneratedKeyJDBCType.INT));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("messaggio", (Object)this.getSQLStringValue(messaggio), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idmessaggio", (Object)this.getSQLStringValue(idBusta), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idmessaggio_risposta", (Object)this.getSQLStringValue(idBustaRisposta), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("protocollo", (Object)this.getSQLStringValue(msgDiagnostico.getProtocollo()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("codice", (Object)this.getSQLStringValue(codiceDiagnostico), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_transazione", (Object)this.getSQLStringValue(idTransazione), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicativo", (Object)this.getSQLStringValue(applicativo), InsertAndGeneratedKeyJDBCType.STRING));
                long iddiagnostico = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)tipo, (IKeyGeneratorObject)new CustomKeyGeneratorObject("msgdiagnostici", "id", "seq_msgdiagnostici", "msgdiagnostici_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                if (iddiagnostico <= 0L) {
                    throw new Exception("ID autoincrementale non ottenuto");
                }
                msgDiagnostico.setId(iddiagnostico);
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico terminato) ....");
                }
            }
            if (this.debug) {
                this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] completato");
            }
        }
        catch (Exception e) {
            try {
                throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico: " + e.getMessage() + "\nIl messaggio era: " + messaggio, e);
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.releaseConnection(cr, "log");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception gdo) {
            // empty catch block
        }
        try {
            this.releaseConnection(cr, "log");
            return;
        }
        catch (Exception gdo) {
            return;
        }
    }
}

