/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.validator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.TipiDocumentoConversazione;
import org.openspcoop2.core.registry.constants.TipiDocumentoCoordinamento;
import org.openspcoop2.core.registry.constants.TipiDocumentoInterfaccia;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.validator.IValidazioneDocumenti;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.ParseWarningException;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xacml.MarshallUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml.XSDUtils;
import org.w3c.dom.Document;

public class ValidazioneDocumenti
extends BasicComponentFactory
implements IValidazioneDocumenti {
    protected AbstractXMLUtils xmlUtils = XMLUtils.getInstance();
    protected XSDUtils xsdUtils = new XSDUtils(this.xmlUtils);
    protected WSDLUtilities wsdlUtilities = WSDLUtilities.getInstance((AbstractXMLUtils)this.xmlUtils);
    protected JSONUtils jsonUtils = JSONUtils.getInstance();
    protected YAMLUtils yamlUtils = YAMLUtils.getInstance();

    public ValidazioneDocumenti(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ValidazioneResult validaSpecificaInterfaccia(AccordoServizioParteComune accordoServizioParteComune) {
        block37: {
            objectInEsame = null;
            result = new ValidazioneResult();
            result.setEsito(false);
            if (ServiceBinding.SOAP.equals((Object)accordoServizioParteComune.getServiceBinding())) {
                try {
                    objectInEsame = "[InterfacciaWSDL Definitoria] ";
                    wsdlDefinitorio = null;
                    if (accordoServizioParteComune.getByteWsdlDefinitorio() != null) {
                        wsdlDefinitorio = accordoServizioParteComune.getByteWsdlDefinitorio();
                    } else if (accordoServizioParteComune.getWsdlDefinitorio() != null) {
                        wsdlDefinitorio = this.readDocumento(accordoServizioParteComune.getWsdlDefinitorio());
                    }
                    if (wsdlDefinitorio != null) {
                        this.xmlUtils.newDocument(wsdlDefinitorio);
                        this.xsdUtils.getTargetNamespace(wsdlDefinitorio);
                    }
                }
                catch (Exception e) {
                    result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
                    result.setException(e);
                    return result;
                }
                try {
                    objectInEsame = "[InterfacciaWSDL Concettuale] ";
                    wsdlConcettuale = null;
                    if (accordoServizioParteComune.getByteWsdlConcettuale() != null) {
                        wsdlConcettuale = accordoServizioParteComune.getByteWsdlConcettuale();
                    } else if (accordoServizioParteComune.getWsdlConcettuale() != null) {
                        wsdlConcettuale = this.readDocumento(accordoServizioParteComune.getWsdlConcettuale());
                    }
                    if (wsdlConcettuale != null) {
                        d = this.xmlUtils.newDocument(wsdlConcettuale);
                        this.wsdlUtilities.getTargetNamespace(wsdlConcettuale);
                        this.wsdlUtilities.removeSchemiIntoTypes(d);
                        wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
                        wsdl.valida(false);
                    }
                }
                catch (Exception e) {
                    result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
                    result.setException(e);
                    return result;
                }
                try {
                    objectInEsame = "[InterfacciaWSDL Erogatore] ";
                    wsdlErogatore = null;
                    if (accordoServizioParteComune.getByteWsdlLogicoErogatore() != null) {
                        wsdlErogatore = accordoServizioParteComune.getByteWsdlLogicoErogatore();
                    } else if (accordoServizioParteComune.getWsdlLogicoErogatore() != null) {
                        wsdlErogatore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoErogatore());
                    }
                    if (wsdlErogatore != null) {
                        d = this.xmlUtils.newDocument(wsdlErogatore);
                        this.wsdlUtilities.getTargetNamespace(wsdlErogatore);
                        this.wsdlUtilities.removeSchemiIntoTypes(d);
                        wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
                        wsdl.valida(false);
                    }
                }
                catch (Exception e) {
                    result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
                    result.setException(e);
                    return result;
                }
                try {
                    objectInEsame = "[InterfacciaWSDL Fruitore] ";
                    wsdlFruitore = null;
                    if (accordoServizioParteComune.getByteWsdlLogicoFruitore() != null) {
                        wsdlFruitore = accordoServizioParteComune.getByteWsdlLogicoFruitore();
                    } else if (accordoServizioParteComune.getWsdlLogicoFruitore() != null) {
                        wsdlFruitore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoFruitore());
                    }
                    if (wsdlFruitore == null) ** GOTO lbl121
                    d = this.xmlUtils.newDocument(wsdlFruitore);
                    this.wsdlUtilities.getTargetNamespace(wsdlFruitore);
                    this.wsdlUtilities.removeSchemiIntoTypes(d);
                    wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
                    wsdl.valida(false);
                }
                catch (Exception e) {
                    result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
                    result.setException(e);
                    return result;
                }
            } else {
                try {
                    wsdlConcettuale = null;
                    if (accordoServizioParteComune.getByteWsdlConcettuale() != null) {
                        wsdlConcettuale = accordoServizioParteComune.getByteWsdlConcettuale();
                    } else if (accordoServizioParteComune.getWsdlConcettuale() != null) {
                        wsdlConcettuale = this.readDocumento(accordoServizioParteComune.getWsdlConcettuale());
                    }
                    if (wsdlConcettuale == null || accordoServizioParteComune.getFormatoSpecifica() == null) break block37;
                    format = null;
                    switch (1.$SwitchMap$org$openspcoop2$core$registry$constants$FormatoSpecifica[accordoServizioParteComune.getFormatoSpecifica().ordinal()]) {
                        case 1: {
                            objectInEsame = "[Interfaccia WADL] ";
                            format = ApiFormats.WADL;
                            break;
                        }
                        case 2: {
                            objectInEsame = "[Interfaccia Swagger 2] ";
                            format = ApiFormats.SWAGGER_2;
                            break;
                        }
                        case 3: {
                            objectInEsame = "[Interfaccia OpenAPI 3] ";
                            format = ApiFormats.OPEN_API_3;
                            break;
                        }
                    }
                    config = new ApiReaderConfig();
                    config.setProcessInclude(false);
                    apiReader = ApiFactory.newApiReader((ApiFormats)format);
                    apiReader.init(this.log, wsdlConcettuale, config);
                    api = apiReader.read();
                    try {
                        api.validate();
                    }
                    catch (ParseWarningException warning) {
                        result.setEsito(true);
                        result.setMessaggioWarning(objectInEsame + " Documento contenente anomalie: " + warning.getMessage());
                        return result;
                    }
                }
                catch (Exception e) {
                    result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
                    result.setException(e);
                    return result;
                }
            }
        }
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaSpecificaConversazione(AccordoServizioParteComune accordoServizioParteComune) {
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaSpecificaInterfaccia(AccordoServizioParteSpecifica accordoServizioParteSpecifica, AccordoServizioParteComune accordoServizioParteComune) {
        DefinitionWrapper wsdlParteSpecifica;
        Document d;
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        String tipoWsdl = null;
        byte[] wsdlImplementativoFruitore = null;
        byte[] wsdlImplementativoErogatore = null;
        byte[] wsdlLogicoFruitore = null;
        byte[] wsdlLogicoErogatore = null;
        try {
            tipoWsdl = "ImplementativoFruitore";
            if (accordoServizioParteSpecifica.getByteWsdlImplementativoFruitore() != null) {
                wsdlImplementativoFruitore = accordoServizioParteSpecifica.getByteWsdlImplementativoFruitore();
            } else if (accordoServizioParteSpecifica.getWsdlImplementativoFruitore() != null) {
                wsdlImplementativoFruitore = this.readDocumento(accordoServizioParteSpecifica.getWsdlImplementativoFruitore());
            }
            tipoWsdl = "ImplementativoErogatore";
            if (accordoServizioParteSpecifica.getByteWsdlImplementativoErogatore() != null) {
                wsdlImplementativoErogatore = accordoServizioParteSpecifica.getByteWsdlImplementativoErogatore();
            } else if (accordoServizioParteSpecifica.getWsdlImplementativoErogatore() != null) {
                wsdlImplementativoErogatore = this.readDocumento(accordoServizioParteSpecifica.getWsdlImplementativoErogatore());
            }
            tipoWsdl = "LogicoFruitore";
            if (accordoServizioParteComune.getByteWsdlLogicoFruitore() != null) {
                wsdlLogicoFruitore = accordoServizioParteComune.getByteWsdlLogicoFruitore();
            } else if (accordoServizioParteComune.getWsdlLogicoFruitore() != null) {
                wsdlLogicoFruitore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoFruitore());
            }
            tipoWsdl = "LogicoErogatore";
            if (accordoServizioParteComune.getByteWsdlLogicoErogatore() != null) {
                wsdlLogicoErogatore = accordoServizioParteComune.getByteWsdlLogicoErogatore();
            } else if (accordoServizioParteComune.getWsdlLogicoErogatore() != null) {
                wsdlLogicoErogatore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoErogatore());
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Raccolta wsdl " + tipoWsdl + " non riuscita: " + e.getMessage());
            result.setException(e);
            return result;
        }
        ArrayList<String> portTypesWSDL_erogatore = new ArrayList<String>();
        tipoWsdl = "LogicoErogatore";
        try {
            if (wsdlLogicoErogatore != null) {
                Document dParteComune = this.xmlUtils.newDocument(wsdlLogicoErogatore);
                this.wsdlUtilities.removeSchemiIntoTypes(dParteComune);
                DefinitionWrapper wsdlParteCoumune = new DefinitionWrapper(dParteComune, this.xmlUtils, false, false);
                for (QName pt : wsdlParteCoumune.getAllPortTypes().keySet()) {
                    portTypesWSDL_erogatore.add(pt.getLocalPart());
                }
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Lettura wsdl " + tipoWsdl + " (identificazione port types) non riuscita: " + e.getMessage());
            result.setException(e);
            return result;
        }
        if (portTypesWSDL_erogatore.size() == 0 && wsdlImplementativoErogatore != null) {
            result.setMessaggioErrore("Per poter fornire un WSDL Implementativo Erogatore, \u00e8 necessario prima definire un wsdl logico erogatore valido nell'accordo di servizio parte comune");
            return result;
        }
        ArrayList<String> portTypesWSDL_fruitore = new ArrayList<String>();
        tipoWsdl = "LogicoFruitore";
        try {
            if (wsdlLogicoFruitore != null) {
                Document dParteComune = this.xmlUtils.newDocument(wsdlLogicoFruitore);
                this.wsdlUtilities.removeSchemiIntoTypes(dParteComune);
                DefinitionWrapper wsdlParteCoumune = new DefinitionWrapper(dParteComune, this.xmlUtils, false, false);
                for (QName pt : wsdlParteCoumune.getAllPortTypes().keySet()) {
                    portTypesWSDL_fruitore.add(pt.getLocalPart());
                }
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Lettura wsdl " + tipoWsdl + " (identificazione port types) non riuscita: " + e.getMessage());
            result.setException(e);
            return result;
        }
        if (portTypesWSDL_fruitore.size() == 0 && wsdlImplementativoFruitore != null) {
            result.setMessaggioErrore("Per poter fornire un WSDL Implementativo Fruitore, \u00e8 necessario prima definire un wsdl logico fruitore valido nell'accordo di servizio parte comune");
            return result;
        }
        if (wsdlImplementativoErogatore != null && wsdlImplementativoFruitore != null) {
            result.setMessaggioErrore("Non \u00e8 possibile definire sia il WSDL implementativo erogatore che il WSDL implementativo fruitore");
            return result;
        }
        try {
            if (wsdlImplementativoErogatore != null) {
                d = this.xmlUtils.newDocument(wsdlImplementativoErogatore);
                this.wsdlUtilities.getTargetNamespace(wsdlImplementativoErogatore);
                this.wsdlUtilities.removeSchemiIntoTypes(d);
                wsdlParteSpecifica = new DefinitionWrapper(d, this.xmlUtils, false, false);
                wsdlParteSpecifica.validaBinding(portTypesWSDL_erogatore);
                this.checkPortTypeInBinding(wsdlParteSpecifica);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("WSDL Implementativo Erogatore non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        try {
            if (wsdlImplementativoFruitore != null) {
                d = this.xmlUtils.newDocument(wsdlImplementativoFruitore);
                this.wsdlUtilities.getTargetNamespace(wsdlImplementativoFruitore);
                this.wsdlUtilities.removeSchemiIntoTypes(d);
                wsdlParteSpecifica = new DefinitionWrapper(d, this.xmlUtils, false, false);
                wsdlParteSpecifica.validaBinding(portTypesWSDL_fruitore);
                this.checkPortTypeInBinding(wsdlParteSpecifica);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("WSDL Implementativo Fruitore non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        result.setEsito(true);
        return result;
    }

    private void checkPortTypeInBinding(DefinitionWrapper wsdlParteSpecifica) throws Exception {
        Map mapBindingToPortTypeImplemented = wsdlParteSpecifica.getMapPortTypesImplementedBinding();
        ArrayList<String> portTypes = new ArrayList<String>();
        StringBuilder bf = new StringBuilder();
        for (QName binding : mapBindingToPortTypeImplemented.keySet()) {
            QName portType = (QName)mapBindingToPortTypeImplemented.get(binding);
            String portTypeName = portType.getLocalPart();
            if (portTypes.contains(portTypeName)) continue;
            portTypes.add(portTypeName);
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(portTypeName);
        }
        if (portTypes.size() > 1) {
            throw new Exception("Trovato pi\u00f9 di un port type implementato dai binding presenti: " + bf.toString());
        }
    }

    @Override
    public ValidazioneResult validaSpecificaInterfaccia(Fruitore fruitore, AccordoServizioParteSpecifica accordoServizioParteSpecifica, AccordoServizioParteComune accordoServizioParteComune) {
        AccordoServizioParteSpecifica as = new AccordoServizioParteSpecifica();
        as.setByteWsdlImplementativoErogatore(fruitore.getByteWsdlImplementativoErogatore());
        as.setByteWsdlImplementativoFruitore(fruitore.getByteWsdlImplementativoFruitore());
        as.setWsdlImplementativoErogatore(fruitore.getWsdlImplementativoErogatore());
        as.setWsdlImplementativoFruitore(fruitore.getWsdlImplementativoFruitore());
        return this.validaSpecificaInterfaccia(as, accordoServizioParteComune);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidazioneResult valida(Documento documento) {
        ValidazioneResult result;
        block33: {
            result = new ValidazioneResult();
            result.setEsito(false);
            if (documento.getTipo() != null) {
                if (TipiDocumentoInterfaccia.WSDL.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoConversazione.WSBL.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoConversazione.BPEL.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoCoordinamento.BPEL.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoCoordinamento.WSCDL.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoLivelloServizio.WSAGREEMENT.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoLivelloServizio.WSLA.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoSemiformale.XML.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoSicurezza.WSPOLICY.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) || TipiDocumentoSicurezza.XACML_POLICY.toString().toLowerCase().equals(documento.getTipo().toLowerCase())) {
                    try {
                        byte[] doc = null;
                        if (documento.getByteContenuto() != null) {
                            doc = documento.getByteContenuto();
                        } else if (documento.getFile() != null) {
                            doc = this.readDocumento(documento.getFile());
                        }
                        if (doc != null) {
                            this.xmlUtils.newDocument(doc);
                        }
                        if (TipiDocumentoSicurezza.XACML_POLICY.toString().toLowerCase().equals(documento.getTipo().toLowerCase()) && MarshallUtilities.unmarshallPolicy((byte[])doc) == null) {
                            throw new Exception("Policy non corretta");
                        }
                        break block33;
                    }
                    catch (Exception e) {
                        result.setMessaggioErrore("Documento " + documento.getFile() + " (ruolo:" + documento.getRuolo() + ") non valido: " + e.getMessage());
                        result.setException(e);
                        return result;
                    }
                }
                if (TipiDocumentoSemiformale.XSD.toString().toLowerCase().equals(documento.getTipo().toLowerCase())) {
                    try {
                        byte[] doc = null;
                        if (documento.getByteContenuto() != null) {
                            doc = documento.getByteContenuto();
                        } else if (documento.getFile() != null) {
                            doc = this.readDocumento(documento.getFile());
                        }
                        if (doc != null) {
                            this.xmlUtils.newDocument(doc);
                            if (!this.xsdUtils.isXSDSchema(doc)) {
                                throw new Exception("non riconosciuto come documento xsd");
                            }
                        }
                        break block33;
                    }
                    catch (Exception e) {
                        result.setMessaggioErrore("Documento " + documento.getFile() + " (ruolo:" + documento.getRuolo() + ") non valido: " + e.getMessage());
                        result.setException(e);
                        return result;
                    }
                }
                if (TipiDocumentoSemiformale.JSON.toString().toLowerCase().equals(documento.getTipo().toLowerCase())) {
                    try {
                        byte[] doc = null;
                        if (documento.getByteContenuto() != null) {
                            doc = documento.getByteContenuto();
                        } else if (documento.getFile() != null) {
                            doc = this.readDocumento(documento.getFile());
                        }
                        if (doc != null) {
                            this.jsonUtils.getAsNode(doc);
                            if (!this.jsonUtils.isJson(doc)) {
                                throw new Exception("non riconosciuto come documento json");
                            }
                        }
                        break block33;
                    }
                    catch (Exception e) {
                        result.setMessaggioErrore("Documento " + documento.getFile() + " (ruolo:" + documento.getRuolo() + ") non valido: " + e.getMessage());
                        result.setException(e);
                        return result;
                    }
                }
                if (TipiDocumentoSemiformale.YAML.toString().toLowerCase().equals(documento.getTipo().toLowerCase())) {
                    try {
                        byte[] doc = null;
                        if (documento.getByteContenuto() != null) {
                            doc = documento.getByteContenuto();
                        } else if (documento.getFile() != null) {
                            doc = this.readDocumento(documento.getFile());
                        }
                        if (doc != null) {
                            this.yamlUtils.getAsNode(doc);
                            if (!this.yamlUtils.isYaml(doc)) {
                                throw new Exception("non riconosciuto come documento yaml");
                            }
                        }
                    }
                    catch (Exception e) {
                        result.setMessaggioErrore("Documento " + documento.getFile() + " (ruolo:" + documento.getRuolo() + ") non valido: " + e.getMessage());
                        result.setException(e);
                        return result;
                    }
                }
            }
        }
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaDocumenti(AccordoServizioParteComune accordoServizioParteComune) {
        ValidazioneResult v;
        int i;
        for (i = 0; i < accordoServizioParteComune.sizeAllegatoList(); ++i) {
            v = this.valida(accordoServizioParteComune.getAllegato(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteComune.sizeSpecificaSemiformaleList(); ++i) {
            v = this.valida(accordoServizioParteComune.getSpecificaSemiformale(i));
            if (v.isEsito()) continue;
            return v;
        }
        if (accordoServizioParteComune.getServizioComposto() != null) {
            for (i = 0; i < accordoServizioParteComune.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                v = this.valida(accordoServizioParteComune.getServizioComposto().getSpecificaCoordinamento(i));
                if (v.isEsito()) continue;
                return v;
            }
        }
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaDocumenti(AccordoServizioParteSpecifica accordoServizioParteSpecifica) {
        ValidazioneResult v;
        int i;
        for (i = 0; i < accordoServizioParteSpecifica.sizeAllegatoList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getAllegato(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteSpecifica.sizeSpecificaSemiformaleList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getSpecificaSemiformale(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteSpecifica.sizeSpecificaLivelloServizioList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getSpecificaLivelloServizio(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteSpecifica.sizeSpecificaSicurezzaList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getSpecificaSicurezza(i));
            if (v.isEsito()) continue;
            return v;
        }
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaDocumenti(AccordoCooperazione accordoCooperazione) {
        ValidazioneResult v;
        int i;
        for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
            v = this.valida(accordoCooperazione.getAllegato(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoCooperazione.sizeSpecificaSemiformaleList(); ++i) {
            v = this.valida(accordoCooperazione.getSpecificaSemiformale(i));
            if (v.isEsito()) continue;
            return v;
        }
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readDocumento(String fileName) throws ProtocolException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            if (fileName.startsWith("http://") || fileName.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile((String)fileName);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(fileName);
                if (f.exists()) {
                    FileInputStream file = null;
                    try {
                        file = new FileInputStream(f);
                        CopyStream.copy((InputStream)file, (OutputStream)bout);
                    }
                    finally {
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                throw new Exception("File [" + fileName + "] non esistente");
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        catch (Exception e) {
            this.log.warn("File " + fileName + ", lettura documento non riuscita:", (Throwable)e);
        }
        throw new ProtocolException("Contenuto non letto?? File [" + fileName + "]");
    }
}

