/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.protocol.sdk.ModIPDNDClientConfig;
import org.openspcoop2.protocol.sdk.ModIPDNDOrganizationConfig;
import org.openspcoop2.protocol.sdk.ModIPropertiesUtils;
import org.openspcoop2.protocol.sdk.PDNDTokenInfoDetails;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class PDNDTokenInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, PDNDTokenInfoDetails> pdnd = new HashMap<String, PDNDTokenInfoDetails>();
    public static final String CLIENT_INFO = "client";
    public static final String ORGANIZATION_INFO = "organization";
    public static final String TOKEN_INFO_PREFIX_PDND = "pdnd.";

    public Map<String, PDNDTokenInfoDetails> getPdnd() {
        return this.pdnd;
    }

    public void setPdnd(Map<String, PDNDTokenInfoDetails> pdnd) {
        this.pdnd = pdnd;
    }

    public PDNDTokenInfoDetails getInfo(String infoId) {
        return this.pdnd != null ? this.pdnd.get(infoId) : null;
    }

    public void setInfo(String infoId, PDNDTokenInfoDetails info) {
        if (this.pdnd == null) {
            this.pdnd = new HashMap<String, PDNDTokenInfoDetails>();
        }
        this.pdnd.put(infoId, info);
    }

    public PDNDTokenInfoDetails getClient() {
        return this.getInfo(CLIENT_INFO);
    }

    public Serializable getClient(String claim) {
        PDNDTokenInfoDetails details = this.getInfo(CLIENT_INFO);
        return details != null && details.getClaims() != null ? details.getClaims().get(claim) : null;
    }

    public void setClient(PDNDTokenInfoDetails info) {
        this.setInfo(CLIENT_INFO, info);
    }

    public PDNDTokenInfoDetails getOrganization() {
        return this.getInfo(ORGANIZATION_INFO);
    }

    public Serializable getOrganization(String claim) {
        PDNDTokenInfoDetails details = this.getInfo(ORGANIZATION_INFO);
        return details != null && details.getClaims() != null ? details.getClaims().get(claim) : null;
    }

    public void setOrganization(PDNDTokenInfoDetails info) {
        this.setInfo(ORGANIZATION_INFO, info);
    }

    public static boolean existsOrganizationInfoPDNDTokenInfo(Map<String, ?> mapPdnd) {
        return PDNDTokenInfo.isPDNDTokenInfoMap(mapPdnd, ORGANIZATION_INFO);
    }

    public static boolean existsClientInfoPDNDTokenInfo(Map<String, ?> mapPdnd) {
        return PDNDTokenInfo.isPDNDTokenInfoMap(mapPdnd, CLIENT_INFO);
    }

    private static boolean isPDNDTokenInfoMap(Map<String, ?> mapPdnd, String key) {
        Object o = mapPdnd.get(key);
        return o instanceof PDNDTokenInfoDetails;
    }

    public String getOrganizationJson() {
        return PDNDTokenInfo.getOrganizationJsonDetailFromPDNDMapTokenInfo(this.pdnd);
    }

    public static String getOrganizationJsonDetailFromPDNDMapTokenInfo(Map<String, PDNDTokenInfoDetails> mapPdnd) {
        PDNDTokenInfoDetails details = mapPdnd.get(ORGANIZATION_INFO);
        return details != null ? details.getDetails() : null;
    }

    public String getClientJson() {
        return PDNDTokenInfo.getClientJsonDetailFromPDNDMapTokenInfo(this.pdnd);
    }

    public static String getClientJsonDetailFromPDNDMapTokenInfo(Map<String, PDNDTokenInfoDetails> mapPdnd) {
        PDNDTokenInfoDetails details = mapPdnd.get(CLIENT_INFO);
        return details != null ? details.getDetails() : null;
    }

    public static String getOrganizationInfoFromPDNDMap(Map<String, ?> mapPdnd, String name) {
        Object o = mapPdnd.get(ORGANIZATION_INFO);
        if (o instanceof Map) {
            Map m = (Map)o;
            return (String)m.get(name);
        }
        return null;
    }

    public static String getClientInfoFromPDNDMap(Map<String, ?> mapPdnd, String name) {
        Object o = mapPdnd.get(CLIENT_INFO);
        if (o instanceof Map) {
            Map m = (Map)o;
            return (String)m.get(name);
        }
        return null;
    }

    private static Map<?, ?> getMapOrganization(Map<String, ?> mapPdnd) {
        return PDNDTokenInfo.getMap(mapPdnd, ORGANIZATION_INFO);
    }

    private static Map<?, ?> getMapClient(Map<String, ?> mapPdnd) {
        return PDNDTokenInfo.getMap(mapPdnd, CLIENT_INFO);
    }

    private static Map<?, ?> getMap(Map<String, ?> mapPdnd, String tipoInfo) {
        Object oTipoInfo;
        if (mapPdnd != null && !mapPdnd.isEmpty() && (oTipoInfo = mapPdnd.get(tipoInfo)) instanceof Map) {
            return (Map)oTipoInfo;
        }
        return new HashMap();
    }

    private static String getMapOrganizationAsJson(Map<String, ?> mapPdnd) {
        return PDNDTokenInfo.getMapAsJson(mapPdnd, ORGANIZATION_INFO);
    }

    private static String getMapClientAsJson(Map<String, ?> mapPdnd) {
        return PDNDTokenInfo.getMapAsJson(mapPdnd, CLIENT_INFO);
    }

    private static String getMapAsJson(Map<String, ?> mapPdnd, String tipoInfo) {
        Map<?, ?> mInternal = PDNDTokenInfo.getMap(mapPdnd, tipoInfo);
        StringBuilder sb = new StringBuilder();
        if (mInternal != null && !mInternal.isEmpty()) {
            PDNDTokenInfo.fillMapAsJson(mInternal, sb);
        }
        return "{" + sb.toString() + "}";
    }

    private static void fillMapAsJson(Map<?, ?> mInternal, StringBuilder sb) {
        for (Map.Entry<?, ?> entry : mInternal.entrySet()) {
            Object o = entry.getValue();
            if (!(o instanceof String)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\"").append(entry.getKey()).append("\": \"").append(o).append("\"");
        }
    }

    private static String getFieldNameFromPattern(String pattern) {
        if (pattern.startsWith("$..")) {
            return pattern.replace("$..", "");
        }
        if (pattern.startsWith("$.")) {
            return pattern.replace("$.", "");
        }
        return pattern;
    }

    private static String getTokenInfoPatternOrganizationJsonPathPrefix() {
        return "$..pdnd.organization.";
    }

    private static String getTokenInfoPatternClientJsonPathPrefix() {
        return "$..pdnd.client.";
    }

    private static Logger getLogger() {
        return LoggerWrapperFactory.getLogger(PDNDTokenInfo.class);
    }

    public String getClientId(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readClientIdFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getClientId() throws ProtocolException {
        return PDNDTokenInfo.readClientIdFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readClientIdFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readClientId(log, PDNDTokenInfo.getClientJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readClientIdFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readClientId(log, tokenInfo, true);
    }

    public static String readClientIdFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readClientId(log, json, false);
    }

    private static String readClientId(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(json, log);
        if (tokenInfo) {
            ModIPDNDClientConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternClientJsonPathPrefix());
            return cloned.getId();
        }
        return config.getId();
    }

    public static String readClientIdFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(PDNDTokenInfo.getMapClientAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapClient(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternId()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getClientConsumerId(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readClientConsumerIdFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getClientConsumerId() throws ProtocolException {
        return PDNDTokenInfo.readClientConsumerIdFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readClientConsumerIdFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readClientConsumerId(log, PDNDTokenInfo.getClientJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readClientConsumerIdFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readClientConsumerId(log, tokenInfo, true);
    }

    public static String readClientConsumerIdFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readClientConsumerId(log, json, false);
    }

    private static String readClientConsumerId(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(json, log);
        if (tokenInfo) {
            ModIPDNDClientConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternClientJsonPathPrefix());
            return cloned.getOrganization();
        }
        return config.getOrganization();
    }

    public static String readClientConsumerIdFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(PDNDTokenInfo.getMapClientAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapClient(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternOrganization()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getClientName(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readClientNameFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getClientName() throws ProtocolException {
        return PDNDTokenInfo.readClientNameFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readClientNameFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readClientName(log, PDNDTokenInfo.getClientJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readClientNameFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readClientName(log, tokenInfo, true);
    }

    public static String readClientNameFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readClientName(log, json, false);
    }

    private static String readClientName(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(json, log);
        if (tokenInfo) {
            ModIPDNDClientConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternClientJsonPathPrefix());
            return cloned.getName();
        }
        return config.getName();
    }

    public static String readClientNameFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(PDNDTokenInfo.getMapClientAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapClient(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternName()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getClientDescription(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readClientDescriptionFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getClientDescription() throws ProtocolException {
        return PDNDTokenInfo.readClientDescriptionFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readClientDescriptionFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readClientDescription(log, PDNDTokenInfo.getClientJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readClientDescriptionFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readClientDescription(log, tokenInfo, true);
    }

    public static String readClientDescriptionFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readClientDescription(log, json, false);
    }

    private static String readClientDescription(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(json, log);
        if (tokenInfo) {
            ModIPDNDClientConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternClientJsonPathPrefix());
            return cloned.getDescription();
        }
        return config.getDescription();
    }

    public static String readClientDescriptionFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDClientConfig config = ModIPropertiesUtils.getAPIPDNDClientConfig(PDNDTokenInfo.getMapClientAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapClient(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternDescription()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrganizationId(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationIdFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getOrganizationId() throws ProtocolException {
        return PDNDTokenInfo.readOrganizationIdFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readOrganizationIdFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationId(log, PDNDTokenInfo.getOrganizationJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readOrganizationIdFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationId(log, tokenInfo, true);
    }

    public static String readOrganizationIdFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationId(log, json, false);
    }

    private static String readOrganizationId(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(json, log);
        if (tokenInfo) {
            ModIPDNDOrganizationConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternOrganizationJsonPathPrefix());
            return cloned.getId();
        }
        return config.getId();
    }

    public static String readOrganizationIdFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(PDNDTokenInfo.getMapOrganizationAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapOrganization(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternId()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrganizationName(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationNameFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getOrganizationName() throws ProtocolException {
        return PDNDTokenInfo.readOrganizationNameFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readOrganizationNameFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationName(log, PDNDTokenInfo.getOrganizationJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readOrganizationNameFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationName(log, tokenInfo, true);
    }

    public static String readOrganizationNameFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationName(log, json, false);
    }

    private static String readOrganizationName(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(json, log);
        if (tokenInfo) {
            ModIPDNDOrganizationConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternOrganizationJsonPathPrefix());
            return cloned.getName();
        }
        return config.getName();
    }

    public static String readOrganizationNameFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(PDNDTokenInfo.getMapOrganizationAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapOrganization(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternName()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrganizationCategory(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationCategoryFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getOrganizationCategory() throws ProtocolException {
        return PDNDTokenInfo.readOrganizationCategoryFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readOrganizationCategoryFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationCategory(log, PDNDTokenInfo.getOrganizationJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readOrganizationCategoryFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationCategory(log, tokenInfo, true);
    }

    public static String readOrganizationCategoryFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationCategory(log, json, false);
    }

    private static String readOrganizationCategory(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(json, log);
        if (tokenInfo) {
            ModIPDNDOrganizationConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternOrganizationJsonPathPrefix());
            return cloned.getCategory();
        }
        return config.getCategory();
    }

    public static String readOrganizationCategoryFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(PDNDTokenInfo.getMapOrganizationAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapOrganization(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternCategory()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrganizationSubUnit(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationSubUnitFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getOrganizationSubUnit() throws ProtocolException {
        return PDNDTokenInfo.readOrganizationSubUnitFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readOrganizationSubUnitFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationSubUnit(log, PDNDTokenInfo.getOrganizationJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readOrganizationSubUnitFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationSubUnit(log, tokenInfo, true);
    }

    public static String readOrganizationSubUnitFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationSubUnit(log, json, false);
    }

    private static String readOrganizationSubUnit(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(json, log);
        if (tokenInfo) {
            ModIPDNDOrganizationConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternOrganizationJsonPathPrefix());
            return cloned.getSubUnit();
        }
        return config.getSubUnit();
    }

    public static String readOrganizationSubUnitFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(PDNDTokenInfo.getMapOrganizationAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapOrganization(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternSubUnit()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrganizationExternalOrigin(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalOriginFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getOrganizationExternalOrigin() throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalOriginFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readOrganizationExternalOriginFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalOrigin(log, PDNDTokenInfo.getOrganizationJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readOrganizationExternalOriginFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalOrigin(log, tokenInfo, true);
    }

    public static String readOrganizationExternalOriginFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalOrigin(log, json, false);
    }

    private static String readOrganizationExternalOrigin(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(json, log);
        if (tokenInfo) {
            ModIPDNDOrganizationConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternOrganizationJsonPathPrefix());
            cloned.setOvveridePatternAsConstant(true);
            return cloned.getExternalOrigin();
        }
        return config.getExternalOrigin();
    }

    public static String readOrganizationExternalOriginFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(PDNDTokenInfo.getMapOrganizationAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapOrganization(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternExternalOrigin()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrganizationExternalId(Logger log) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalIdFromPDNDMapTokenInfo(log, this.pdnd);
    }

    public String getOrganizationExternalId() throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalIdFromPDNDMapTokenInfo(PDNDTokenInfo.getLogger(), this.pdnd);
    }

    public static String readOrganizationExternalIdFromPDNDMapTokenInfo(Logger log, Map<String, PDNDTokenInfoDetails> mapPdnd) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalId(log, PDNDTokenInfo.getOrganizationJsonDetailFromPDNDMapTokenInfo(mapPdnd), false);
    }

    public static String readOrganizationExternalIdFromTokenInfo(Logger log, String tokenInfo) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalId(log, tokenInfo, true);
    }

    public static String readOrganizationExternalIdFromJson(Logger log, String json) throws ProtocolException {
        return PDNDTokenInfo.readOrganizationExternalId(log, json, false);
    }

    private static String readOrganizationExternalId(Logger log, String json, boolean tokenInfo) throws ProtocolException {
        ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(json, log);
        if (tokenInfo) {
            ModIPDNDOrganizationConfig cloned = config.cloneNewInstance();
            cloned.setOverridePrefixJsonPath(PDNDTokenInfo.getTokenInfoPatternOrganizationJsonPathPrefix());
            cloned.setOvveridePatternAsConstant(true);
            return cloned.getExternalId();
        }
        return config.getExternalId();
    }

    public static String readOrganizationExternalIdFromPDNDMap(Map<String, ?> mapPdnd) {
        try {
            ModIPDNDOrganizationConfig config = ModIPropertiesUtils.getAPIPDNDOrganizationConfig(PDNDTokenInfo.getMapOrganizationAsJson(mapPdnd));
            return (String)PDNDTokenInfo.getMapOrganization(mapPdnd).get(PDNDTokenInfo.getFieldNameFromPattern(config.getPatternExternalId()));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

