/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk;

import java.io.Serializable;
import org.openspcoop2.protocol.sdk.ProtocolException;

public abstract class XMLRootElement
implements Serializable {
    private static final long serialVersionUID = -3157816024001587816L;
    private String localName;
    private String namespace;
    private String prefix;

    protected XMLRootElement(String localName, String namespace, String prefix) {
        this.localName = localName;
        this.namespace = namespace;
        this.prefix = prefix;
    }

    protected XMLRootElement(String localName, String namespace) {
        this(localName, namespace, null);
    }

    protected XMLRootElement() {
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getAsStringStartTag() throws ProtocolException {
        return this.getAsStringTag(true);
    }

    public String getAsStringEndTag() throws ProtocolException {
        return this.getAsStringTag(false);
    }

    private String getAsStringTag(boolean start) throws ProtocolException {
        if (this.localName == null || "".equals(this.localName)) {
            throw new ProtocolException("LocalName not defined");
        }
        if (this.namespace == null || "".equals(this.namespace)) {
            throw new ProtocolException("Namespace not defined");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("<");
        if (!start) {
            bf.append("/");
        }
        if (this.prefix != null && !"".equals(this.prefix)) {
            bf.append(this.prefix).append(":");
        }
        bf.append(this.localName);
        if (start) {
            bf.append(" xmlns");
            if (this.prefix != null && !"".equals(this.prefix)) {
                bf.append(":").append(this.prefix);
            }
            bf.append("=\"").append(this.namespace).append("\"");
        }
        bf.append(">");
        return bf.toString();
    }
}

