/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchiveScope
implements IArchiveObject {
    private IDScope idScope;
    private Scope scope;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String nomeScope) throws ProtocolException {
        if (nomeScope == null) {
            throw new ProtocolException("nomeScope non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("Scope_");
        bf.append(nomeScope);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveScope.buildKey(this.idScope.getNome());
    }

    public ArchiveScope(Scope scope, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (scope == null) {
            throw new ProtocolException("Scope non fornito");
        }
        if (scope.getNome() == null) {
            throw new ProtocolException("Scope.nome non definito");
        }
        this.idScope = new IDScope(scope.getNome());
        this.scope = scope;
        this.idCorrelazione = idCorrelazione;
    }

    public IDScope getIdScope() {
        return this.idScope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

