/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchiveSoggetto
implements IArchiveObject {
    private IDSoggetto idSoggetto;
    private Soggetto soggettoRegistro;
    private org.openspcoop2.core.config.Soggetto soggettoConfigurazione;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggetto, String nomeSoggetto) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("Soggetto_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveSoggetto.buildKey(this.idSoggetto.getTipo(), this.idSoggetto.getNome());
    }

    public ArchiveSoggetto(Soggetto soggettoRegistro, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (soggettoRegistro == null) {
            throw new ProtocolException("SoggettoRegistro non fornito");
        }
        if (soggettoRegistro.getNome() == null) {
            throw new ProtocolException("SoggettoRegistro.nome non definito");
        }
        if (soggettoRegistro.getTipo() == null) {
            throw new ProtocolException("SoggettoRegistro.tipo non definito");
        }
        this.soggettoRegistro = soggettoRegistro;
        this.idSoggetto = new IDSoggetto(soggettoRegistro.getTipo(), soggettoRegistro.getNome());
        this.idCorrelazione = idCorrelazione;
    }

    public ArchiveSoggetto(org.openspcoop2.core.config.Soggetto soggettoConfigurazione, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (soggettoConfigurazione == null) {
            throw new ProtocolException("SoggettoConfigurazione non fornito");
        }
        if (soggettoConfigurazione.getNome() == null) {
            throw new ProtocolException("SoggettoConfigurazione.nome non definito");
        }
        if (soggettoConfigurazione.getTipo() == null) {
            throw new ProtocolException("SoggettoConfigurazione.tipo non definito");
        }
        this.soggettoConfigurazione = soggettoConfigurazione;
        this.idSoggetto = new IDSoggetto(soggettoConfigurazione.getTipo(), soggettoConfigurazione.getNome());
        this.idCorrelazione = idCorrelazione;
    }

    public ArchiveSoggetto(org.openspcoop2.core.config.Soggetto soggettoConfigurazione, Soggetto soggettoRegistro, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (soggettoRegistro == null) {
            throw new ProtocolException("SoggettoRegistro non fornito");
        }
        if (soggettoRegistro.getNome() == null) {
            throw new ProtocolException("SoggettoRegistro.nome non definito");
        }
        if (soggettoRegistro.getTipo() == null) {
            throw new ProtocolException("SoggettoRegistro.tipo non definito");
        }
        this.soggettoRegistro = soggettoRegistro;
        if (soggettoConfigurazione == null) {
            throw new ProtocolException("SoggettoConfigurazione non fornito");
        }
        if (soggettoConfigurazione.getNome() == null) {
            throw new ProtocolException("SoggettoConfigurazione.nome non definito");
        }
        if (!soggettoRegistro.getNome().equals(soggettoConfigurazione.getNome())) {
            throw new ProtocolException("SoggettoRegistro.nome e SoggettoConfigurazione.nome devono coincidere");
        }
        if (soggettoConfigurazione.getTipo() == null) {
            throw new ProtocolException("SoggettoConfigurazione.tipo non definito");
        }
        if (!soggettoRegistro.getTipo().equals(soggettoConfigurazione.getTipo())) {
            throw new ProtocolException("SoggettoRegistro.tipo e SoggettoConfigurazione.tipo devono coincidere");
        }
        this.soggettoConfigurazione = soggettoConfigurazione;
        this.idSoggetto = new IDSoggetto(soggettoRegistro.getTipo(), soggettoRegistro.getNome());
        this.idCorrelazione = idCorrelazione;
    }

    public IDSoggetto getIdSoggetto() {
        return this.idSoggetto;
    }

    public Soggetto getSoggettoRegistro() {
        return this.soggettoRegistro;
    }

    public org.openspcoop2.core.config.Soggetto getSoggettoConfigurazione() {
        return this.soggettoConfigurazione;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

