/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.constants;

import java.io.Serializable;
import org.openspcoop2.message.constants.IntegrationError;

public enum IntegrationFunctionError implements Serializable
{
    CONTENT_TYPE_NOT_PROVIDED(true),
    CONTENT_TYPE_NOT_SUPPORTED(true),
    SOAP_MUST_UNDERSTAND_UNKNOWN(true),
    SOAP_VERSION_MISMATCH(true),
    UNPROCESSABLE_REQUEST_CONTENT(true),
    REQUEST_TIMED_OUT(true),
    NOT_SUPPORTED_BY_PROTOCOL(true),
    CORRELATION_INFORMATION_NOT_FOUND(true),
    APPLICATION_CORRELATION_IDENTIFICATION_REQUEST_FAILED(true),
    INVALID_REQUEST_CONTENT(true),
    INTEROPERABILITY_PROFILE_REQUEST_ALREADY_EXISTS(true),
    INVALID_INTEROPERABILITY_PROFILE_REQUEST(true),
    BAD_REQUEST(true),
    ATTACHMENTS_PROCESSING_REQUEST_FAILED(true),
    MESSAGE_SECURITY_REQUEST_FAILED(true),
    INTEROPERABILITY_PROFILE_ENVELOPING_REQUEST_FAILED(true),
    TRANSFORMATION_RULE_REQUEST_FAILED(true),
    CONNECTOR_NOT_FOUND(true),
    WRAP_400_INTERNAL_BAD_REQUEST(true),
    PROXY_AUTHENTICATION_CREDENTIALS_NOT_FOUND(true),
    PROXY_AUTHENTICATION_INVALID_CREDENTIALS(true),
    PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND(true),
    AUTHENTICATION_CREDENTIALS_NOT_FOUND(true),
    AUTHENTICATION_INVALID_CREDENTIALS(true),
    TOKEN_NOT_FOUND(true),
    TOKEN_INVALID(true),
    TOKEN_EXPIRED(true),
    TOKEN_NOT_USABLE_BEFORE(true),
    TOKEN_IN_THE_FUTURE(true),
    TOKEN_REQUIRED_CLAIMS_NOT_FOUND(true),
    AUTHENTICATION(true),
    CONTENT_AUTHORIZATION_DENY(true),
    CONTENT_AUTHORIZATION_POLICY_DENY(true),
    AUTHORIZATION_DENY(true),
    AUTHORIZATION_POLICY_DENY(true),
    AUTHORIZATION_TOKEN_DENY(true),
    AUTHORIZATION_MISSING_SCOPE(true),
    AUTHORIZATION_MISSING_ROLE(true),
    AUTHORIZATION(true),
    API_IN_UNKNOWN(true),
    API_OUT_UNKNOWN(true),
    OPERATION_UNDEFINED(true),
    IM_MESSAGES_NOT_FOUND(true),
    IM_MESSAGE_NOT_FOUND(true),
    NOT_FOUND(true),
    CONFLICT_IN_QUEUE(true),
    CONFLICT(true),
    REQUEST_SIZE_EXCEEDED(true),
    LIMIT_EXCEEDED_CONDITIONAL_CONGESTION(true),
    LIMIT_EXCEEDED_CONDITIONAL_DETERIORATION_PERFORMANCE(true),
    LIMIT_EXCEEDED(true),
    TOO_MANY_REQUESTS_CONDITIONAL_CONGESTION(true),
    TOO_MANY_REQUESTS_CONDITIONAL_DETERIORATION_PERFORMANCE(true),
    TOO_MANY_REQUESTS(true),
    UNPROCESSABLE_RESPONSE_CONTENT(false),
    ATTACHMENTS_PROCESSING_RESPONSE_FAILED(false),
    APPLICATION_CORRELATION_IDENTIFICATION_RESPONSE_FAILED(false),
    MESSAGE_SECURITY_RESPONSE_FAILED(false),
    INVALID_RESPONSE_CONTENT(false),
    INTEROPERABILITY_PROFILE_ENVELOPING_RESPONSE_FAILED(false),
    INVALID_INTEROPERABILITY_PROFILE_RESPONSE(false),
    INTEROPERABILITY_PROFILE_RESPONSE_ALREADY_EXISTS(false),
    INTEROPERABILITY_PROFILE_RESPONSE_ERROR(false),
    TRANSFORMATION_RULE_RESPONSE_FAILED(false),
    EXPECTED_RESPONSE_NOT_FOUND(false),
    CONFLICT_RESPONSE(false),
    RESPONSE_SIZE_EXCEEDED(false),
    BAD_RESPONSE(false),
    INTERNAL_RESPONSE_ERROR(false),
    WRAP_502_BAD_RESPONSE(false),
    WRAP_502_INTERNAL_RESPONSE_ERROR(false),
    SERVICE_UNAVAILABLE(false),
    API_SUSPEND(false),
    GOVWAY_NOT_INITIALIZED(false),
    GOVWAY_RESOURCES_NOT_AVAILABLE(false),
    INTERNAL_REQUEST_ERROR(false),
    WRAP_503_INTERNAL_ERROR(false),
    ENDPOINT_REQUEST_TIMED_OUT(false);

    private boolean clientError;

    private IntegrationFunctionError(boolean clientError) {
        this.clientError = clientError;
    }

    public static IntegrationFunctionError[] wrappedValues() {
        IntegrationFunctionError[] ife = new IntegrationFunctionError[]{WRAP_400_INTERNAL_BAD_REQUEST, WRAP_502_BAD_RESPONSE, WRAP_502_INTERNAL_RESPONSE_ERROR, WRAP_503_INTERNAL_ERROR};
        return ife;
    }

    public boolean isClientError() {
        return this.clientError;
    }

    public boolean isServerError() {
        return !this.clientError;
    }

    public boolean isWrapBadRequest() {
        return ATTACHMENTS_PROCESSING_REQUEST_FAILED.equals(this) || MESSAGE_SECURITY_REQUEST_FAILED.equals(this) || INTEROPERABILITY_PROFILE_ENVELOPING_REQUEST_FAILED.equals(this) || TRANSFORMATION_RULE_REQUEST_FAILED.equals(this) || CONNECTOR_NOT_FOUND.equals(this);
    }

    public boolean isWrapInternalError() {
        return GOVWAY_NOT_INITIALIZED.equals(this) || GOVWAY_RESOURCES_NOT_AVAILABLE.equals(this) || INTERNAL_REQUEST_ERROR.equals(this);
    }

    public boolean isWrapBadResponse(IntegrationError integrationError) {
        return IntegrationError.BAD_RESPONSE.equals((Object)integrationError) && !RESPONSE_SIZE_EXCEEDED.equals(this);
    }

    public boolean isWrapInternalResponseError(IntegrationError integrationError) {
        return IntegrationError.INTERNAL_RESPONSE_ERROR.equals((Object)integrationError);
    }
}

