/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.tracciamento.Proprieta;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.NumberConsoleItem;
import org.openspcoop2.protocol.sdk.properties.NumberProperty;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.utils.BooleanNullable;

public class ProtocolPropertiesUtils {
    public static void setDefaultValue(List<BaseConsoleItem> consoleItems, AbstractProperty<?> property) throws ProtocolException {
        if (property == null) {
            return;
        }
        for (BaseConsoleItem consoleItem : consoleItems) {
            if (!consoleItem.getId().equals(property.getId())) continue;
            ProtocolPropertiesUtils.setDefaultValue(consoleItem, property);
        }
    }

    public static void setDefaultValue(List<BaseConsoleItem> consoleItems, org.openspcoop2.core.registry.ProtocolProperty property) {
        if (property == null) {
            return;
        }
        for (BaseConsoleItem consoleItem : consoleItems) {
            if (!consoleItem.getId().equals(property.getName()) || !(consoleItem instanceof AbstractConsoleItem)) continue;
            if (consoleItem instanceof StringConsoleItem) {
                ((StringConsoleItem)consoleItem).setDefaultValue(property.getValue());
                continue;
            }
            if (consoleItem instanceof NumberConsoleItem) {
                Long numberValue = property.getNumberValue();
                ((NumberConsoleItem)consoleItem).setDefaultValue(numberValue);
                continue;
            }
            if (consoleItem instanceof BinaryConsoleItem) {
                byte[] byteFile = property.getByteFile();
                ((BinaryConsoleItem)consoleItem).setFileName(property.getFile());
                ((BinaryConsoleItem)consoleItem).setDefaultValue(byteFile);
                continue;
            }
            if (!(consoleItem instanceof BooleanConsoleItem)) continue;
            Boolean booleanValue = property.getBooleanValue();
            ((BooleanConsoleItem)consoleItem).setDefaultValue(booleanValue);
        }
    }

    public static List<String> getListFromMultiSelectValue(String value) {
        ArrayList<String> l = new ArrayList<String>();
        if (value.contains(",")) {
            l = Arrays.asList(value.split(","));
        } else {
            l.add(value);
        }
        return l;
    }

    public static String getValueMultiSelect(String[] list) {
        return ProtocolPropertiesUtils.getValueMultiSelect(Arrays.asList(list));
    }

    public static String getValueMultiSelect(List<String> list) {
        StringBuilder bf = new StringBuilder();
        for (String s : list) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(s);
        }
        return bf.toString();
    }

    public static void setDefaultValueMultiSelect(List<String> list, StringConsoleItem item) {
        item.setDefaultValue(ProtocolPropertiesUtils.getValueMultiSelect(list));
    }

    public static BaseConsoleItem getBaseConsoleItem(List<BaseConsoleItem> consoleItems, AbstractProperty<?> property) {
        if (property == null) {
            return null;
        }
        String propertyId = property.getId();
        return ProtocolPropertiesUtils.getBaseConsoleItem(consoleItems, propertyId);
    }

    public static BaseConsoleItem getBaseConsoleItem(List<BaseConsoleItem> consoleItems, String propertyId) {
        if (propertyId == null) {
            return null;
        }
        for (BaseConsoleItem consoleItem : consoleItems) {
            if (!consoleItem.getId().equals(propertyId)) continue;
            return consoleItem;
        }
        return null;
    }

    public static AbstractConsoleItem<?> getAbstractConsoleItem(List<BaseConsoleItem> consoleItems, AbstractProperty<?> property) {
        if (property == null) {
            return null;
        }
        String propertyId = property.getId();
        return ProtocolPropertiesUtils.getAbstractConsoleItem(consoleItems, propertyId);
    }

    public static AbstractConsoleItem<?> getAbstractConsoleItem(List<BaseConsoleItem> consoleItems, org.openspcoop2.core.registry.ProtocolProperty property) {
        if (property == null) {
            return null;
        }
        String propertyId = property.getName();
        return ProtocolPropertiesUtils.getAbstractConsoleItem(consoleItems, propertyId);
    }

    public static AbstractConsoleItem<?> getAbstractConsoleItem(List<BaseConsoleItem> consoleItems, String propertyId) {
        if (propertyId == null) {
            return null;
        }
        for (BaseConsoleItem consoleItem : consoleItems) {
            if (!consoleItem.getId().equals(propertyId) || !(consoleItem instanceof AbstractConsoleItem)) continue;
            return (AbstractConsoleItem)consoleItem;
        }
        return null;
    }

    public static AbstractProperty<?> getAbstractPropertyById(ProtocolProperties protocolProperties, String propertyId) {
        if (propertyId == null) {
            return null;
        }
        for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
            AbstractProperty<?> property = protocolProperties.getProperty(i);
            if (!property.getId().equals(propertyId)) continue;
            return property;
        }
        return null;
    }

    public static void setDefaultValue(BaseConsoleItem item, AbstractProperty<?> property) throws ProtocolException {
        Object defaultValue = null;
        try {
            if (item instanceof AbstractConsoleItem && property != null) {
                defaultValue = property.getValue();
                if (item instanceof StringConsoleItem) {
                    StringProperty sp = (StringProperty)property;
                    ((StringConsoleItem)item).setDefaultValue((String)sp.getValue());
                } else if (item instanceof NumberConsoleItem) {
                    NumberProperty np = (NumberProperty)property;
                    ((NumberConsoleItem)item).setDefaultValue((Long)np.getValue());
                } else if (item instanceof BinaryConsoleItem) {
                    BinaryProperty bp = (BinaryProperty)property;
                    ((BinaryConsoleItem)item).setFileId(bp.getFileId());
                    ((BinaryConsoleItem)item).setFileName(bp.getFileName());
                    ((BinaryConsoleItem)item).setDefaultValue((byte[])bp.getValue());
                } else if (item instanceof BooleanConsoleItem) {
                    BooleanProperty bolP = (BooleanProperty)property;
                    ((BooleanConsoleItem)item).setDefaultValue((Boolean)bolP.getValue());
                }
            }
        }
        catch (Exception e) {
            String defaultValueClassName = defaultValue != null ? defaultValue.getClass().getName() : "Default Value Null";
            throw new ProtocolException("Impossibile assegnare un valore di tipo [" + defaultValueClassName + "] all'item [" + item.getId() + "]");
        }
    }

    public static ConsoleItemValueType getConsoleItemValueType(BaseConsoleItem item) {
        if (item instanceof AbstractConsoleItem) {
            if (item instanceof StringConsoleItem) {
                return ConsoleItemValueType.STRING;
            }
            if (item instanceof NumberConsoleItem) {
                return ConsoleItemValueType.NUMBER;
            }
            if (item instanceof BooleanConsoleItem) {
                return ConsoleItemValueType.BOOLEAN;
            }
            if (item instanceof BinaryConsoleItem) {
                return ConsoleItemValueType.BINARY;
            }
        }
        return null;
    }

    public static List<org.openspcoop2.core.registry.ProtocolProperty> toProtocolPropertiesRegistry(ProtocolProperties protocolProperties, ConsoleOperationType consoleOperationType, List<org.openspcoop2.core.registry.ProtocolProperty> oldProtocolPropertyList) {
        ArrayList<org.openspcoop2.core.registry.ProtocolProperty> lstProtocolProperty = new ArrayList<org.openspcoop2.core.registry.ProtocolProperty>();
        for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
            AbstractProperty bp;
            AbstractProperty<?> property = protocolProperties.getProperty(i);
            org.openspcoop2.core.registry.ProtocolProperty prop = new org.openspcoop2.core.registry.ProtocolProperty();
            prop.setName(property.getId());
            boolean add = false;
            if (property instanceof StringProperty) {
                StringProperty sp = (StringProperty)property;
                if (StringUtils.isNotEmpty((String)((String)sp.getValue()))) {
                    prop.setValue((String)sp.getValue());
                }
                add = true;
            } else if (property instanceof NumberProperty) {
                NumberProperty np = (NumberProperty)property;
                if (np.getValue() != null) {
                    prop.setNumberValue((Long)np.getValue());
                }
                add = true;
            } else if (property instanceof BinaryProperty) {
                bp = (BinaryProperty)property;
                if (consoleOperationType.equals((Object)ConsoleOperationType.ADD) || bp.getValue() != null) {
                    prop.setByteFile((byte[])bp.getValue());
                    prop.setFile(((BinaryProperty)bp).getFileName());
                    if (bp.getValue() != null && ((byte[])bp.getValue()).length > 0) {
                        add = true;
                    }
                } else {
                    for (org.openspcoop2.core.registry.ProtocolProperty protocolProperty : oldProtocolPropertyList) {
                        if (!property.getId().equals(protocolProperty.getName())) continue;
                        if (((BinaryProperty)bp).isClearContent()) {
                            prop.setByteFile(null);
                            prop.setFile(null);
                            add = true;
                        } else {
                            prop.setByteFile(protocolProperty.getByteFile());
                            prop.setFile(protocolProperty.getFile());
                            if (protocolProperty.getByteFile() != null && protocolProperty.getByteFile().length > 0) {
                                add = true;
                            }
                        }
                        break;
                    }
                }
            } else if (property instanceof BooleanProperty) {
                bp = (BooleanProperty)property;
                prop.setBooleanValue(Boolean.valueOf(bp.getValue() != null ? (Boolean)bp.getValue() : false));
                add = true;
            }
            if (!add) continue;
            lstProtocolProperty.add(prop);
        }
        return lstProtocolProperty;
    }

    public static List<ProtocolProperty> toProtocolPropertiesConfig(ProtocolProperties protocolProperties, ConsoleOperationType consoleOperationType, List<ProtocolProperty> oldProtocolPropertyList) {
        ArrayList<ProtocolProperty> lstProtocolProperty = new ArrayList<ProtocolProperty>();
        for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
            AbstractProperty bp;
            AbstractProperty<?> property = protocolProperties.getProperty(i);
            ProtocolProperty prop = new ProtocolProperty();
            prop.setName(property.getId());
            boolean add = false;
            if (property instanceof StringProperty) {
                StringProperty sp = (StringProperty)property;
                if (StringUtils.isNotEmpty((String)((String)sp.getValue()))) {
                    prop.setValue((String)sp.getValue());
                }
                add = true;
            } else if (property instanceof NumberProperty) {
                NumberProperty np = (NumberProperty)property;
                if (np.getValue() != null) {
                    prop.setNumberValue((Long)np.getValue());
                }
                add = true;
            } else if (property instanceof BinaryProperty) {
                bp = (BinaryProperty)property;
                if (consoleOperationType.equals((Object)ConsoleOperationType.ADD) || bp.getValue() != null) {
                    prop.setByteFile((byte[])bp.getValue());
                    prop.setFile(((BinaryProperty)bp).getFileName());
                    if (bp.getValue() != null && ((byte[])bp.getValue()).length > 0) {
                        add = true;
                    }
                } else {
                    for (ProtocolProperty protocolProperty : oldProtocolPropertyList) {
                        if (!property.getId().equals(protocolProperty.getName())) continue;
                        if (((BinaryProperty)bp).isClearContent()) {
                            prop.setByteFile(null);
                            prop.setFile(null);
                            add = true;
                        } else {
                            prop.setByteFile(protocolProperty.getByteFile());
                            prop.setFile(protocolProperty.getFile());
                            if (protocolProperty.getByteFile() != null && protocolProperty.getByteFile().length > 0) {
                                add = true;
                            }
                        }
                        break;
                    }
                }
            } else if (property instanceof BooleanProperty) {
                bp = (BooleanProperty)property;
                prop.setBooleanValue(Boolean.valueOf(bp.getValue() != null && (Boolean)bp.getValue() != false));
                add = true;
            }
            if (!add) continue;
            lstProtocolProperty.add(prop);
        }
        return lstProtocolProperty;
    }

    public static void mergeProtocolPropertiesRegistry(ProtocolProperties protocolProperties, List<org.openspcoop2.core.registry.ProtocolProperty> listaProtocolPropertiesDaDB, ConsoleOperationType consoleOperationType) {
        if (consoleOperationType != null) {
            // empty if block
        }
        block0: for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
            AbstractProperty<?> property = protocolProperties.getProperty(i);
            for (org.openspcoop2.core.registry.ProtocolProperty protocolProperty : listaProtocolPropertiesDaDB) {
                AbstractProperty bp;
                if (!property.getId().equals(protocolProperty.getName())) continue;
                if (property instanceof StringProperty) {
                    StringProperty sp = (StringProperty)property;
                    sp.setValue(protocolProperty.getValue());
                    continue block0;
                }
                if (property instanceof NumberProperty) {
                    NumberProperty np = (NumberProperty)property;
                    np.setValue(protocolProperty.getNumberValue());
                    continue block0;
                }
                if (property instanceof BinaryProperty) {
                    bp = (BinaryProperty)property;
                    bp.setValue(protocolProperty.getByteFile());
                    ((BinaryProperty)bp).setFileName(protocolProperty.getFile());
                    continue block0;
                }
                if (!(property instanceof BooleanProperty)) continue block0;
                bp = (BooleanProperty)property;
                bp.setValue(protocolProperty.getBooleanValue());
                continue block0;
            }
        }
    }

    public static void mergeProtocolPropertiesConfig(ProtocolProperties protocolProperties, List<ProtocolProperty> listaProtocolPropertiesDaDB, ConsoleOperationType consoleOperationType) {
        if (consoleOperationType != null) {
            // empty if block
        }
        block0: for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
            AbstractProperty<?> property = protocolProperties.getProperty(i);
            for (ProtocolProperty protocolProperty : listaProtocolPropertiesDaDB) {
                AbstractProperty bp;
                if (!property.getId().equals(protocolProperty.getName())) continue;
                if (property instanceof StringProperty) {
                    StringProperty sp = (StringProperty)property;
                    sp.setValue(protocolProperty.getValue());
                    continue block0;
                }
                if (property instanceof NumberProperty) {
                    NumberProperty np = (NumberProperty)property;
                    np.setValue(protocolProperty.getNumberValue());
                    continue block0;
                }
                if (property instanceof BinaryProperty) {
                    bp = (BinaryProperty)property;
                    bp.setValue(protocolProperty.getByteFile());
                    ((BinaryProperty)bp).setFileName(protocolProperty.getFile());
                    continue block0;
                }
                if (!(property instanceof BooleanProperty)) continue block0;
                bp = (BooleanProperty)property;
                bp.setValue(protocolProperty.getBooleanValue());
                continue block0;
            }
        }
    }

    public static org.openspcoop2.core.registry.ProtocolProperty getProtocolPropertyRegistry(String propertyId, List<org.openspcoop2.core.registry.ProtocolProperty> listaProtocolPropertiesDaDB) {
        if (listaProtocolPropertiesDaDB == null || propertyId == null) {
            return null;
        }
        for (org.openspcoop2.core.registry.ProtocolProperty protocolProperty : listaProtocolPropertiesDaDB) {
            if (!propertyId.equals(protocolProperty.getName())) continue;
            return protocolProperty;
        }
        return null;
    }

    public static ProtocolProperty getProtocolPropertyConfig(String propertyId, List<ProtocolProperty> listaProtocolPropertiesDaDB) {
        if (listaProtocolPropertiesDaDB == null || propertyId == null) {
            return null;
        }
        for (ProtocolProperty protocolProperty : listaProtocolPropertiesDaDB) {
            if (!propertyId.equals(protocolProperty.getName())) continue;
            return protocolProperty;
        }
        return null;
    }

    public static String getRequiredStringValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName) throws ProtocolException {
        String value = ProtocolPropertiesUtils.getStringValuePropertyRegistry(list, propertyName, true);
        if (value == null) {
            throw new ProtocolException("Property [" + propertyName + "] with null value?");
        }
        return value;
    }

    public static String getOptionalStringValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName) throws ProtocolException {
        String value = ProtocolPropertiesUtils.getStringValuePropertyRegistry(list, propertyName, false);
        return value;
    }

    private static String getStringValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        org.openspcoop2.core.registry.ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyRegistry(list, propertyName, throwNotFoundException);
        if (pp != null) {
            return pp.getValue();
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static String getRequiredStringValuePropertyConfig(List<ProtocolProperty> list, String propertyName) throws ProtocolException {
        String value = ProtocolPropertiesUtils.getStringValuePropertyConfig(list, propertyName, true);
        if (value == null) {
            throw new ProtocolException("Property [" + propertyName + "] with null value?");
        }
        return value;
    }

    public static String getOptionalStringValuePropertyConfig(List<ProtocolProperty> list, String propertyName) throws ProtocolException {
        String value = ProtocolPropertiesUtils.getStringValuePropertyConfig(list, propertyName, false);
        return value;
    }

    private static String getStringValuePropertyConfig(List<ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyConfig(list, propertyName, throwNotFoundException);
        if (pp != null) {
            return pp.getValue();
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static byte[] getRequiredBinaryValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName) throws ProtocolException {
        byte[] value = ProtocolPropertiesUtils.getBinaryValuePropertyRegistry(list, propertyName, true);
        if (value == null) {
            throw new ProtocolException("Property [" + propertyName + "] with null value?");
        }
        return value;
    }

    public static byte[] getOptionalBinaryValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName) throws ProtocolException {
        byte[] value = ProtocolPropertiesUtils.getBinaryValuePropertyRegistry(list, propertyName, false);
        return value;
    }

    private static byte[] getBinaryValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        org.openspcoop2.core.registry.ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyRegistry(list, propertyName, throwNotFoundException);
        if (pp != null) {
            return pp.getByteFile();
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static byte[] getRequiredBinaryValuePropertyConfig(List<ProtocolProperty> list, String propertyName) throws ProtocolException {
        byte[] value = ProtocolPropertiesUtils.getBinaryValuePropertyConfig(list, propertyName, true);
        if (value == null) {
            throw new ProtocolException("Property [" + propertyName + "] with null value?");
        }
        return value;
    }

    public static byte[] getOptionalBinaryValuePropertyConfig(List<ProtocolProperty> list, String propertyName) throws ProtocolException {
        byte[] value = ProtocolPropertiesUtils.getBinaryValuePropertyConfig(list, propertyName, false);
        return value;
    }

    private static byte[] getBinaryValuePropertyConfig(List<ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyConfig(list, propertyName, throwNotFoundException);
        if (pp != null) {
            return pp.getByteFile();
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static BooleanNullable getOptionalBooleanValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName) throws ProtocolException {
        org.openspcoop2.core.registry.ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyRegistry(list, propertyName, false);
        if (pp != null && pp.getBooleanValue() != null) {
            return pp.getBooleanValue() != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
        }
        return BooleanNullable.NULL();
    }

    public static BooleanNullable getOptionalBooleanValuePropertyConfig(List<ProtocolProperty> list, String propertyName) throws ProtocolException {
        ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyConfig(list, propertyName, false);
        if (pp != null && pp.getBooleanValue() != null) {
            return pp.getBooleanValue() != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
        }
        return BooleanNullable.NULL();
    }

    public static boolean getBooleanValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        org.openspcoop2.core.registry.ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyRegistry(list, propertyName, throwNotFoundException);
        if (pp != null) {
            return pp.getBooleanValue() != null ? pp.getBooleanValue() : false;
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return false;
    }

    public static boolean getBooleanValuePropertyConfig(List<ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyConfig(list, propertyName, throwNotFoundException);
        if (pp != null) {
            return pp.getBooleanValue() != null ? pp.getBooleanValue() : false;
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return false;
    }

    public static Long getRequiredNumberValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName, boolean greatherThanZero) throws ProtocolException {
        Long value = ProtocolPropertiesUtils.getNumberValuePropertyRegistry(list, propertyName, true, greatherThanZero);
        if (value == null) {
            throw new ProtocolException("Property [" + propertyName + "] with null value?");
        }
        return value;
    }

    public static Long getOptionalNumberValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName, boolean greatherThanZero) throws ProtocolException {
        Long value = ProtocolPropertiesUtils.getNumberValuePropertyRegistry(list, propertyName, false, greatherThanZero);
        return value;
    }

    private static Long getNumberValuePropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName, boolean throwNotFoundException, boolean greatherThanZero) throws ProtocolException {
        org.openspcoop2.core.registry.ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyRegistry(list, propertyName, throwNotFoundException);
        if (pp != null) {
            Long value = pp.getNumberValue();
            if (value != null && greatherThanZero && value <= 0L) {
                throw new ProtocolException("Property [" + propertyName + "] must be greatherThanZero");
            }
            return value;
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static Long getRequiredNumberValuePropertyConfig(List<ProtocolProperty> list, String propertyName) throws ProtocolException {
        Long value = ProtocolPropertiesUtils.getNumberValuePropertyConfig(list, propertyName, true);
        if (value == null) {
            throw new ProtocolException("Property [" + propertyName + "] with null value?");
        }
        return value;
    }

    public static Long getOptionalNumberValuePropertyConfig(List<ProtocolProperty> list, String propertyName) throws ProtocolException {
        Long value = ProtocolPropertiesUtils.getNumberValuePropertyConfig(list, propertyName, false);
        return value;
    }

    private static Long getNumberValuePropertyConfig(List<ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        ProtocolProperty pp = ProtocolPropertiesUtils.getProtocolPropertyConfig(list, propertyName, throwNotFoundException);
        if (pp != null) {
            return pp.getNumberValue();
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static org.openspcoop2.core.registry.ProtocolProperty getProtocolPropertyRegistry(List<org.openspcoop2.core.registry.ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        if (list == null || list.size() <= 0) {
            return null;
        }
        for (org.openspcoop2.core.registry.ProtocolProperty protocolProperty : list) {
            if (!propertyName.equals(protocolProperty.getName())) continue;
            return protocolProperty;
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static ProtocolProperty getProtocolPropertyConfig(List<ProtocolProperty> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        if (list == null || list.size() <= 0) {
            return null;
        }
        for (ProtocolProperty protocolProperty : list) {
            if (!propertyName.equals(protocolProperty.getName())) continue;
            return protocolProperty;
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static Proprieta getProtocolPropertySDK(List<Proprieta> list, String propertyName, boolean throwNotFoundException) throws ProtocolException {
        if (list == null || list.size() <= 0) {
            return null;
        }
        for (Proprieta protocolProperty : list) {
            if (!propertyName.equals(protocolProperty.getNome())) continue;
            return protocolProperty;
        }
        if (throwNotFoundException) {
            throw new ProtocolException("Property [" + propertyName + "] not found");
        }
        return null;
    }

    public static List<org.openspcoop2.core.registry.ProtocolProperty> getProtocolProperties(boolean fruizione, IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps) throws ProtocolException {
        List listProtocolProperties = null;
        Fruitore fruitore = null;
        if (fruizione) {
            fruitore = ProtocolPropertiesUtils.getFruitore(soggettoFruitore, asps);
            listProtocolProperties = fruitore.getProtocolPropertyList();
        } else {
            listProtocolProperties = asps.getProtocolPropertyList();
        }
        return listProtocolProperties;
    }

    public static Fruitore getFruitore(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps) throws ProtocolException {
        if (soggettoFruitore == null) {
            throw new ProtocolException("Fruitore non fornito");
        }
        Fruitore fruitore = null;
        boolean find = false;
        for (Fruitore fruitoreCheck : asps.getFruitoreList()) {
            if (!fruitoreCheck.getTipo().equals(soggettoFruitore.getTipo()) || !fruitoreCheck.getNome().equals(soggettoFruitore.getNome())) continue;
            fruitore = fruitoreCheck;
            find = true;
            break;
        }
        if (!find) {
            throw new ProtocolException("Fruitore '" + soggettoFruitore + "' non registrato come fruitore dell'accordo parte specifica");
        }
        return fruitore;
    }
}

