/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.message.constants.IntegrationError;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.utils.ErroriInstanceProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class ErroriProperties {
    private static volatile boolean FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST = false;
    private static volatile boolean FORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE = false;
    private static volatile boolean FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR = false;
    private static volatile boolean FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR = false;
    private Logger log = null;
    private static ErroriProperties erroriProperties = null;
    private ErroriInstanceProperties reader;
    private Boolean typeEnabled = null;
    private String webSite = null;
    private String webSiteErrorPage = null;
    private ConcurrentHashMap<IntegrationFunctionError, Boolean> mapWrapped = null;
    private ConcurrentHashMap<IntegrationFunctionError, IntegrationError> mapIntegrationError = null;
    private ConcurrentHashMap<IntegrationFunctionError, IntegrationError> mapIntegrationError_noWrap = null;
    private ConcurrentHashMap<IntegrationFunctionError, String> mapErrorType = null;
    private ConcurrentHashMap<IntegrationFunctionError, String> mapErrorType_noWrap = null;
    private ConcurrentHashMap<IntegrationFunctionError, String> mapWebSite = null;
    private ConcurrentHashMap<IntegrationFunctionError, String> mapWebSite_noWrap = null;
    private ConcurrentHashMap<IntegrationFunctionError, String> mapGenericDetails = null;
    private ConcurrentHashMap<IntegrationFunctionError, String> mapGenericDetails_noWrap = null;
    private ConcurrentHashMap<IntegrationFunctionError, Boolean> mapIsGenericDetails = null;
    private ConcurrentHashMap<IntegrationFunctionError, Boolean> mapIsGenericDetails_noWrap = null;

    public static boolean isFORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST() {
        return FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST;
    }

    public static void setFORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST(boolean fORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST, String confDir, Logger log, Loader loader) throws ProtocolException {
        FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST = fORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST;
        ErroriProperties.reInit(confDir, log, loader);
    }

    public static boolean isFORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE() {
        return FORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE;
    }

    public static void setFORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE(boolean fORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE, String confDir, Logger log, Loader loader) throws ProtocolException {
        FORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE = fORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE;
        ErroriProperties.reInit(confDir, log, loader);
    }

    public static boolean isFORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR() {
        return FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR;
    }

    public static void setFORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR(boolean fORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR, String confDir, Logger log, Loader loader) throws ProtocolException {
        FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR = fORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR;
        ErroriProperties.reInit(confDir, log, loader);
    }

    public static boolean isFORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR() {
        return FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR;
    }

    public static void setFORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR(boolean fORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR, String confDir, Logger log, Loader loader) throws ProtocolException {
        FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR = fORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR;
        ErroriProperties.reInit(confDir, log, loader);
    }

    private static synchronized void reInit(String confDir, Logger log, Loader loader) throws ProtocolException {
        ErroriProperties erroriPropertiesNew = new ErroriProperties(confDir, log);
        erroriPropertiesNew.validaConfigurazione(loader);
        erroriProperties = erroriPropertiesNew;
    }

    private ErroriProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(ErroriProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = ErroriProperties.class.getResourceAsStream("/org/openspcoop2/protocol/utils/errori.properties");
            if (properties == null) {
                throw new Exception("File '/org/openspcoop2/protocol/utils/errori.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'org/openspcoop2/protocol/utils/errori.properties': " + e.getMessage());
            throw new ProtocolException("ErroriProperties initialize error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            this.reader = new ErroriInstanceProperties(confDir, propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log, Loader loader) throws ProtocolException {
        if (erroriProperties == null) {
            erroriProperties = new ErroriProperties(confDir, log);
            erroriProperties.validaConfigurazione(loader);
        }
    }

    public static ErroriProperties getInstance(Logger log) throws ProtocolException {
        if (erroriProperties == null) {
            Class<ErroriProperties> clazz = ErroriProperties.class;
            synchronized (ErroriProperties.class) {
                throw new ProtocolException("ErroriProperties not initialized (use init method in factory)");
            }
        }
        return erroriProperties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            IntegrationFunctionError[] lista;
            this.getPrefixWebSite();
            this.getPrefixWebSiteErrorPage();
            this.initMapWrapped();
            for (IntegrationFunctionError integrationFunctionError : lista = IntegrationFunctionError.values()) {
                this.getIntegrationError(integrationFunctionError);
                this.getErrorType(integrationFunctionError);
                this.getGenericDetails(integrationFunctionError);
                this.isForceGenericDetails(integrationFunctionError);
                this.getWebSite(integrationFunctionError);
            }
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' degli errori, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public boolean isTypeEnabled() throws ProtocolException {
        if (this.typeEnabled == null) {
            this.initTypeEnabled();
        }
        return this.typeEnabled;
    }

    private synchronized void initTypeEnabled() throws ProtocolException {
        if (this.typeEnabled == null) {
            this.typeEnabled = this.getBooleanProperty("type.enabled");
        }
    }

    public String getPrefixWebSite() throws ProtocolException {
        if (this.webSite == null) {
            this.initPrefixWebSite();
        }
        return this.webSite;
    }

    private synchronized void initPrefixWebSite() throws ProtocolException {
        if (this.webSite == null) {
            this.webSite = this.getProperty("webSite");
            if (this.webSite.endsWith("/")) {
                this.webSite = this.webSite.substring(0, this.webSite.length() - 1);
            }
        }
    }

    public String getPrefixWebSiteErrorPage() throws ProtocolException {
        if (this.webSiteErrorPage == null) {
            this.initPrefixWebSiteErrorPage();
        }
        return this.webSiteErrorPage;
    }

    private synchronized void initPrefixWebSiteErrorPage() throws ProtocolException {
        if (this.webSiteErrorPage == null) {
            this.webSiteErrorPage = this.getProperty("webSite.errorPage");
        }
    }

    public Boolean isWrapped(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapWrapped == null) {
            this.initMapWrapped();
        }
        return this.mapWrapped.get(functionError);
    }

    private synchronized void initMapWrapped() throws ProtocolException {
        if (this.mapWrapped == null) {
            IntegrationFunctionError[] lista;
            this.mapWrapped = new ConcurrentHashMap();
            for (IntegrationFunctionError integrationFunctionError : lista = IntegrationFunctionError.wrappedValues()) {
                String pName = integrationFunctionError.name() + ".enabled";
                try {
                    Boolean p = null;
                    p = IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST.equals(integrationFunctionError) ? (FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_BAD_REQUEST ? Boolean.valueOf(false) : this.getBooleanProperty(pName)) : (IntegrationFunctionError.WRAP_502_BAD_RESPONSE.equals(integrationFunctionError) ? (FORCE_SPECIFIC_ERROR_TYPE_FOR_BAD_RESPONSE ? Boolean.valueOf(false) : this.getBooleanProperty(pName)) : (IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR.equals(integrationFunctionError) ? (FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_RESPONSE_ERROR ? Boolean.valueOf(false) : this.getBooleanProperty(pName)) : (IntegrationFunctionError.WRAP_503_INTERNAL_ERROR.equals(integrationFunctionError) ? (FORCE_SPECIFIC_ERROR_TYPE_FOR_INTERNAL_ERROR ? Boolean.valueOf(false) : this.getBooleanProperty(pName)) : this.getBooleanProperty(pName))));
                    this.mapWrapped.put(integrationFunctionError, p);
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + integrationFunctionError.name() + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    public IntegrationError getIntegrationError(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapIntegrationError == null) {
            this.initMapIntegrationError();
        }
        return this.mapIntegrationError.get(functionError);
    }

    public IntegrationError getIntegrationError_noWrap(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapIntegrationError_noWrap == null) {
            this.initMapIntegrationError();
        }
        return this.mapIntegrationError_noWrap.get(functionError);
    }

    private synchronized void initMapIntegrationError() throws ProtocolException {
        if (this.mapIntegrationError == null) {
            IntegrationFunctionError[] lista;
            this.mapIntegrationError = new ConcurrentHashMap();
            this.mapIntegrationError_noWrap = new ConcurrentHashMap();
            for (IntegrationFunctionError integrationFunctionError : lista = IntegrationFunctionError.values()) {
                String pName = integrationFunctionError.name() + ".errorCode";
                try {
                    String pWrappedName;
                    String p = this.getProperty(pName);
                    IntegrationError integrationError = IntegrationError.valueOf((String)p);
                    IntegrationError integrationError_noWrap = IntegrationError.valueOf((String)p);
                    if (integrationFunctionError.isWrapBadRequest()) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST.name() + ".errorCode";
                            p = this.getProperty(pWrappedName);
                            integrationError = IntegrationError.valueOf((String)p);
                        }
                    } else if (integrationFunctionError.isWrapBadResponse(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_BAD_RESPONSE).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_BAD_RESPONSE.name() + ".errorCode";
                            p = this.getProperty(pWrappedName);
                            integrationError = IntegrationError.valueOf((String)p);
                        }
                    } else if (integrationFunctionError.isWrapInternalResponseError(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR.name() + ".errorCode";
                            p = this.getProperty(pWrappedName);
                            integrationError = IntegrationError.valueOf((String)p);
                        }
                    } else if (integrationFunctionError.isWrapInternalError() && this.isWrapped(IntegrationFunctionError.WRAP_503_INTERNAL_ERROR).booleanValue()) {
                        pWrappedName = IntegrationFunctionError.WRAP_503_INTERNAL_ERROR.name() + ".errorCode";
                        p = this.getProperty(pWrappedName);
                        integrationError = IntegrationError.valueOf((String)p);
                    }
                    this.mapIntegrationError.put(integrationFunctionError, integrationError);
                    this.mapIntegrationError_noWrap.put(integrationFunctionError, integrationError_noWrap);
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + integrationFunctionError.name() + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    public String getErrorType(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapErrorType == null) {
            this.initMapErrorType();
        }
        return this.mapErrorType.get(functionError);
    }

    public String getErrorType_noWrap(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapErrorType_noWrap == null) {
            this.initMapErrorType();
        }
        return this.mapErrorType_noWrap.get(functionError);
    }

    public IntegrationFunctionError convertToIntegrationFunctionError(String errorType) throws ProtocolException {
        return this._convertToIntegrationFunctionError(errorType);
    }

    private IntegrationFunctionError _convertToIntegrationFunctionError(String errorType) throws ProtocolException {
        if (this.mapErrorType == null) {
            this.initMapErrorType();
        }
        Enumeration<IntegrationFunctionError> en = this.mapErrorType.keys();
        while (en.hasMoreElements()) {
            IntegrationFunctionError integrationFunctionError = en.nextElement();
            String type = this.mapErrorType.get(integrationFunctionError);
            if (!type.equals(errorType)) continue;
            return integrationFunctionError;
        }
        throw new ProtocolException("GovWayErrorType '" + errorType + "' unknown");
    }

    public IntegrationFunctionError convertToIntegrationFunctionError_noWrap(String errorType) throws ProtocolException {
        return this._convertToIntegrationFunctionError_noWrap(errorType);
    }

    private IntegrationFunctionError _convertToIntegrationFunctionError_noWrap(String errorType) throws ProtocolException {
        if (this.mapErrorType_noWrap == null) {
            this.initMapErrorType();
        }
        Enumeration<IntegrationFunctionError> en = this.mapErrorType_noWrap.keys();
        while (en.hasMoreElements()) {
            IntegrationFunctionError integrationFunctionError = en.nextElement();
            String type = this.mapErrorType_noWrap.get(integrationFunctionError);
            if (!type.equals(errorType)) continue;
            return integrationFunctionError;
        }
        throw new ProtocolException("GovWayErrorType '" + errorType + "' unknown");
    }

    private synchronized void initMapErrorType() throws ProtocolException {
        if (this.mapErrorType == null) {
            IntegrationFunctionError[] lista;
            this.mapErrorType = new ConcurrentHashMap();
            this.mapErrorType_noWrap = new ConcurrentHashMap();
            for (IntegrationFunctionError integrationFunctionError : lista = IntegrationFunctionError.values()) {
                String pName = integrationFunctionError.name() + ".errorType";
                try {
                    String pWrappedName;
                    String p;
                    String p_noWrap = p = this.getProperty(pName);
                    IntegrationError integrationError = this.mapIntegrationError_noWrap.get(integrationFunctionError);
                    if (integrationFunctionError.isWrapBadRequest()) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST.name() + ".errorType";
                            p = this.getProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapBadResponse(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_BAD_RESPONSE).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_BAD_RESPONSE.name() + ".errorType";
                            p = this.getProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapInternalResponseError(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR.name() + ".errorType";
                            p = this.getProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapInternalError() && this.isWrapped(IntegrationFunctionError.WRAP_503_INTERNAL_ERROR).booleanValue()) {
                        pWrappedName = IntegrationFunctionError.WRAP_503_INTERNAL_ERROR.name() + ".errorType";
                        p = this.getProperty(pWrappedName);
                    }
                    this.mapErrorType.put(integrationFunctionError, p);
                    this.mapErrorType_noWrap.put(integrationFunctionError, p_noWrap);
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + integrationFunctionError.name() + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    public String getWebSite(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapWebSite == null) {
            this.initMapWebSite();
        }
        return this.mapWebSite.get(functionError);
    }

    public String getWebSite_noWrap(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapWebSite_noWrap == null) {
            this.initMapWebSite();
        }
        return this.mapWebSite_noWrap.get(functionError);
    }

    private synchronized void initMapWebSite() throws ProtocolException {
        if (this.mapWebSite == null) {
            IntegrationFunctionError[] lista;
            this.mapWebSite = new ConcurrentHashMap();
            this.mapWebSite_noWrap = new ConcurrentHashMap();
            for (IntegrationFunctionError integrationFunctionError : lista = IntegrationFunctionError.values()) {
                String pName = integrationFunctionError.name() + ".webSite";
                try {
                    String pWrappedName;
                    String integrationType;
                    IntegrationError integrationError;
                    String p;
                    String p_noWrap = p = this.getOptionalProperty(pName);
                    IntegrationError integrationError_noWrap = integrationError = this.mapIntegrationError_noWrap.get(integrationFunctionError);
                    String integrationType_noWrap = integrationType = this.getErrorType(integrationFunctionError);
                    if (integrationFunctionError.isWrapBadRequest()) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST.name() + ".webSite";
                            p = this.getOptionalProperty(pWrappedName);
                            integrationError = this.getIntegrationError(IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST);
                            integrationType = this.getErrorType(IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST);
                        }
                    } else if (integrationFunctionError.isWrapBadResponse(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_BAD_RESPONSE).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_BAD_RESPONSE.name() + ".webSite";
                            p = this.getOptionalProperty(pWrappedName);
                            integrationError = this.getIntegrationError(IntegrationFunctionError.WRAP_502_BAD_RESPONSE);
                            integrationType = this.getErrorType(IntegrationFunctionError.WRAP_502_BAD_RESPONSE);
                        }
                    } else if (integrationFunctionError.isWrapInternalResponseError(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR.name() + ".webSite";
                            p = this.getOptionalProperty(pWrappedName);
                            integrationError = this.getIntegrationError(IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR);
                            integrationType = this.getErrorType(IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR);
                        }
                    } else if (integrationFunctionError.isWrapInternalError() && this.isWrapped(IntegrationFunctionError.WRAP_503_INTERNAL_ERROR).booleanValue()) {
                        pWrappedName = IntegrationFunctionError.WRAP_503_INTERNAL_ERROR.name() + ".webSite";
                        p = this.getOptionalProperty(pWrappedName);
                        integrationError = this.getIntegrationError(IntegrationFunctionError.WRAP_503_INTERNAL_ERROR);
                        integrationType = this.getErrorType(IntegrationFunctionError.WRAP_503_INTERNAL_ERROR);
                    }
                    String site = this.getSite(p, integrationError, integrationType);
                    this.mapWebSite.put(integrationFunctionError, site);
                    String site_noWrap = this.getSite(p_noWrap, integrationError_noWrap, integrationType_noWrap);
                    this.mapWebSite_noWrap.put(integrationFunctionError, site_noWrap);
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + integrationFunctionError.name() + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    private String getSite(String p, IntegrationError integrationError, String integrationType) {
        Object site = null;
        if (p != null) {
            if (p.startsWith("http://") || p.startsWith("https://")) {
                return p;
            }
            site = p.startsWith("/") ? this.webSite + p : this.webSite + "/" + p;
        } else {
            site = this.webSiteErrorPage.startsWith("/") ? this.webSite + this.webSiteErrorPage : this.webSite + "/" + this.webSiteErrorPage;
        }
        while (((String)site).contains("HTTP_CODE")) {
            switch (integrationError) {
                case BAD_REQUEST: {
                    site = ((String)site).replace("HTTP_CODE", "400");
                    break;
                }
                case AUTHENTICATION: {
                    site = ((String)site).replace("HTTP_CODE", "401");
                    break;
                }
                case AUTHORIZATION: {
                    site = ((String)site).replace("HTTP_CODE", "403");
                    break;
                }
                case NOT_FOUND: {
                    site = ((String)site).replace("HTTP_CODE", "404");
                    break;
                }
                case CONFLICT: {
                    site = ((String)site).replace("HTTP_CODE", "409");
                    break;
                }
                case REQUEST_TOO_LARGE: {
                    site = ((String)site).replace("HTTP_CODE", "413");
                    break;
                }
                case LIMIT_EXCEEDED: 
                case TOO_MANY_REQUESTS: {
                    site = ((String)site).replace("HTTP_CODE", "429");
                    break;
                }
                case BAD_RESPONSE: 
                case INTERNAL_RESPONSE_ERROR: {
                    site = ((String)site).replace("HTTP_CODE", "502");
                    break;
                }
                case SERVICE_UNAVAILABLE: 
                case INTERNAL_REQUEST_ERROR: {
                    site = ((String)site).replace("HTTP_CODE", "503");
                    break;
                }
                case ENDPOINT_REQUEST_TIMED_OUT: {
                    site = ((String)site).replace("HTTP_CODE", "504");
                    break;
                }
                case DEFAULT: {
                    site = ((String)site).replace("HTTP_CODE", "503");
                }
            }
        }
        while (((String)site).contains("ERROR_CODE")) {
            site = ((String)site).replace("ERROR_CODE", integrationError.name());
        }
        while (((String)site).contains("ERROR_TYPE")) {
            site = ((String)site).replace("ERROR_TYPE", integrationType);
        }
        return site;
    }

    public String getGenericDetails(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapGenericDetails == null) {
            this.initMapGenericDetails();
        }
        return this.mapGenericDetails.get(functionError);
    }

    public String getGenericDetails_noWrap(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapGenericDetails_noWrap == null) {
            this.initMapGenericDetails();
        }
        return this.mapGenericDetails_noWrap.get(functionError);
    }

    private synchronized void initMapGenericDetails() throws ProtocolException {
        if (this.mapGenericDetails == null) {
            IntegrationFunctionError[] lista;
            this.mapGenericDetails = new ConcurrentHashMap();
            this.mapGenericDetails_noWrap = new ConcurrentHashMap();
            for (IntegrationFunctionError integrationFunctionError : lista = IntegrationFunctionError.values()) {
                String pName = integrationFunctionError.name() + ".genericDetails";
                try {
                    String pWrappedName;
                    String p;
                    String p_noWrap = p = this.getProperty(pName);
                    IntegrationError integrationError = this.mapIntegrationError_noWrap.get(integrationFunctionError);
                    if (integrationFunctionError.isWrapBadRequest()) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST.name() + ".genericDetails";
                            p = this.getProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapBadResponse(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_BAD_RESPONSE).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_BAD_RESPONSE.name() + ".genericDetails";
                            p = this.getProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapInternalResponseError(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR.name() + ".genericDetails";
                            p = this.getProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapInternalError() && this.isWrapped(IntegrationFunctionError.WRAP_503_INTERNAL_ERROR).booleanValue()) {
                        pWrappedName = IntegrationFunctionError.WRAP_503_INTERNAL_ERROR.name() + ".genericDetails";
                        p = this.getProperty(pWrappedName);
                    }
                    this.mapGenericDetails.put(integrationFunctionError, p);
                    this.mapGenericDetails_noWrap.put(integrationFunctionError, p_noWrap);
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + integrationFunctionError.name() + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    public Boolean isForceGenericDetails(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapIsGenericDetails == null) {
            this.initMapIsGenericDetails();
        }
        return this.mapIsGenericDetails.get(functionError);
    }

    public Boolean isForceGenericDetails_noWrap(IntegrationFunctionError functionError) throws ProtocolException {
        if (this.mapIsGenericDetails_noWrap == null) {
            this.initMapIsGenericDetails();
        }
        return this.mapIsGenericDetails_noWrap.get(functionError);
    }

    private synchronized void initMapIsGenericDetails() throws ProtocolException {
        if (this.mapIsGenericDetails == null) {
            IntegrationFunctionError[] lista;
            this.mapIsGenericDetails = new ConcurrentHashMap();
            this.mapIsGenericDetails_noWrap = new ConcurrentHashMap();
            for (IntegrationFunctionError integrationFunctionError : lista = IntegrationFunctionError.values()) {
                String pName = integrationFunctionError.name() + ".forceGenericDetails";
                try {
                    String pWrappedName;
                    Boolean p;
                    Boolean p_noWrap = p = this.getBooleanProperty(pName);
                    IntegrationError integrationError = this.mapIntegrationError_noWrap.get(integrationFunctionError);
                    if (integrationFunctionError.isWrapBadRequest()) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_400_INTERNAL_BAD_REQUEST.name() + ".forceGenericDetails";
                            p = this.getBooleanProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapBadResponse(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_BAD_RESPONSE).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_BAD_RESPONSE.name() + ".forceGenericDetails";
                            p = this.getBooleanProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapInternalResponseError(integrationError)) {
                        if (this.isWrapped(IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR).booleanValue()) {
                            pWrappedName = IntegrationFunctionError.WRAP_502_INTERNAL_RESPONSE_ERROR.name() + ".forceGenericDetails";
                            p = this.getBooleanProperty(pWrappedName);
                        }
                    } else if (integrationFunctionError.isWrapInternalError() && this.isWrapped(IntegrationFunctionError.WRAP_503_INTERNAL_ERROR).booleanValue()) {
                        pWrappedName = IntegrationFunctionError.WRAP_503_INTERNAL_ERROR.name() + ".forceGenericDetails";
                        p = this.getBooleanProperty(pWrappedName);
                    }
                    this.mapIsGenericDetails.put(integrationFunctionError, p);
                    this.mapIsGenericDetails_noWrap.put(integrationFunctionError, p_noWrap);
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + integrationFunctionError.name() + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    public String getProperty(String property) throws ProtocolException {
        try {
            String name = null;
            name = this.reader.getValueConvertEnvProperties(property);
            if (name == null) {
                throw new Exception("proprieta non definita");
            }
            return name.trim();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public String getOptionalProperty(String property) throws ProtocolException {
        try {
            String name = null;
            name = this.reader.getValueConvertEnvProperties(property);
            if (name == null) {
                return null;
            }
            return name.trim();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public Boolean getBooleanProperty(String property) throws ProtocolException {
        try {
            String name = null;
            name = this.reader.getValueConvertEnvProperties(property);
            if (name == null) {
                throw new Exception("proprieta non definita");
            }
            return Boolean.parseBoolean(name.trim());
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }
}

