/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorType;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class IDSerialGenerator {
    private static DataSource datasourcePdD = null;
    static Logger checkLogger = null;
    static volatile boolean checkIsClosed = true;
    static volatile boolean checkAutocommit = true;
    private IState state;
    private Logger log;
    private TipiDatabase tipoDatabase;

    public static synchronized void init(DataSource ds) {
        if (datasourcePdD == null) {
            datasourcePdD = ds;
        }
    }

    private static Connection getConnectionPdD() throws SQLException, ProtocolException {
        if (datasourcePdD == null) {
            throw new ProtocolException("IDSerialGenerator non inizializzato");
        }
        return datasourcePdD.getConnection();
    }

    private static void releaseConnectionPdD(Connection con) throws SQLException {
        JDBCUtilities.closeConnection((Logger)IDSerialGenerator.getCheckLogger(), (Connection)con, (boolean)IDSerialGenerator.isCheckAutocommit(), (boolean)IDSerialGenerator.isCheckIsClosed());
    }

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        IDSerialGenerator.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        IDSerialGenerator.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        IDSerialGenerator.checkLogger = checkLogger;
    }

    public IDSerialGenerator(Logger log, IState state, TipiDatabase tipoDatabase) {
        this.log = log;
        this.state = state;
        this.tipoDatabase = tipoDatabase;
    }

    public long buildIDAsNumber(IDSerialGeneratorParameter param) throws ProtocolException {
        try {
            if (param != null && IDSerialGeneratorType.ALFANUMERICO.equals((Object)param.getTipo())) {
                throw new ProtocolException("IDSerialGeneratorType[" + param.getTipo() + "] prevede anche caratteri alfanumerici");
            }
            return Long.parseLong(this.buildID(param));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public String buildID(IDSerialGeneratorParameter param) throws ProtocolException {
        Connection conDB = null;
        boolean conDBFromDatasource = false;
        try {
            StateMessage stateMsg;
            if (this.state instanceof StateMessage && (stateMsg = (StateMessage)this.state).getConnectionDB() != null && !stateMsg.getConnectionDB().isClosed()) {
                conDB = stateMsg.getConnectionDB();
            }
            if (conDB == null) {
                conDB = IDSerialGenerator.getConnectionPdD();
                conDBFromDatasource = true;
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Connessione non disponibile: " + e.getMessage(), e);
        }
        this.checkConnection(conDB);
        String identificativoUnivoco = null;
        try {
            org.openspcoop2.utils.id.serial.IDSerialGenerator generator = new org.openspcoop2.utils.id.serial.IDSerialGenerator();
            String string = identificativoUnivoco = generator.buildID(param, conDB, this.tipoDatabase, this.log);
            return string;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            block14: {
                try {
                    if (conDBFromDatasource) {
                        IDSerialGenerator.releaseConnectionPdD(conDB);
                    }
                }
                catch (Exception e) {
                    if (this.log == null) break block14;
                    this.log.error("Rilascio connessione non riuscito: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void checkConnection(Connection conDB) throws ProtocolException {
        if (conDB == null) {
            throw new ProtocolException("Connessione non disponibile");
        }
    }
}

