/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.util.List;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;

public class PorteNamingUtils {
    private IProtocolFactory<?> protocolFactory;
    private IProtocolConfiguration protocolConfiguration;
    private ServiceBinding serviceBindingDefault = null;

    public PorteNamingUtils(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.protocolConfiguration = protocolFactory.createProtocolConfiguration();
        if (this.protocolFactory.getManifest().getBinding().getRest() != null && this.protocolFactory.getManifest().getBinding().getSoap() != null) {
            switch (this.protocolFactory.getManifest().getBinding().getDefault()) {
                case REST: {
                    this.serviceBindingDefault = ServiceBinding.REST;
                    break;
                }
                case SOAP: {
                    this.serviceBindingDefault = ServiceBinding.SOAP;
                }
            }
        } else {
            this.serviceBindingDefault = this.protocolFactory.getManifest().getBinding().getRest() != null ? ServiceBinding.REST : ServiceBinding.SOAP;
        }
    }

    public String normalizePD(String nome) throws ProtocolException {
        int[] posizioneSoggetto = new int[]{0, 1};
        int[] posizioneServizio = new int[]{2};
        return this._normalize(nome, posizioneSoggetto, posizioneServizio);
    }

    public String normalizePA(String nome) throws ProtocolException {
        int[] posizioneSoggetto = new int[]{0};
        int[] posizioneServizio = new int[]{1};
        return this._normalize(nome, posizioneSoggetto, posizioneServizio);
    }

    private String _normalize(String nome, int[] posizioneSoggetto, int[] posizioneServizio) throws ProtocolException {
        if (nome.contains("/")) {
            String tipoSoggettoDefault = this.protocolConfiguration.getTipoSoggettoDefault();
            String _tipoSoggettoDefault = tipoSoggettoDefault + "_";
            int _lengthTipoSoggettoDefault = _tipoSoggettoDefault.length();
            String tipoServizioDefault = this.protocolConfiguration.getTipoServizioDefault(this.serviceBindingDefault);
            String _tipoServizioDefault = tipoServizioDefault + "_";
            int _lengthTipoServizioDefault = _tipoServizioDefault.length();
            String[] tmp = nome.split("/");
            if (tmp.length >= 3) {
                StringBuilder bf = new StringBuilder();
                for (int i = 0; i < tmp.length; ++i) {
                    if (i > 0) {
                        bf.append("/");
                    }
                    boolean soggetto = false;
                    for (int j = 0; j < posizioneSoggetto.length; ++j) {
                        if (i != posizioneSoggetto[j]) continue;
                        soggetto = true;
                        break;
                    }
                    boolean servizio = false;
                    for (int j = 0; j < posizioneServizio.length; ++j) {
                        if (i != posizioneServizio[j]) continue;
                        servizio = true;
                        break;
                    }
                    String s = tmp[i].trim();
                    if (soggetto || servizio) {
                        if (soggetto) {
                            if (s.startsWith(_tipoSoggettoDefault) && s.length() > _lengthTipoSoggettoDefault) {
                                bf.append(s.substring(_lengthTipoSoggettoDefault));
                                continue;
                            }
                            bf.append(s);
                            continue;
                        }
                        if (s.startsWith(_tipoServizioDefault) && s.length() > _lengthTipoServizioDefault) {
                            bf.append(s.substring(_lengthTipoServizioDefault));
                            continue;
                        }
                        bf.append(s);
                        continue;
                    }
                    bf.append(s);
                }
                return bf.toString();
            }
        }
        return nome;
    }

    public String enrichPD(String nome) throws ProtocolException {
        int[] posizioneSoggetto = new int[]{0, 1};
        int[] posizioneServizio = new int[]{2};
        return this._enrich(nome, posizioneSoggetto, posizioneServizio);
    }

    public String enrichPA(String nome) throws ProtocolException {
        int[] posizioneSoggetto = new int[]{0};
        int[] posizioneServizio = new int[]{1};
        return this._enrich(nome, posizioneSoggetto, posizioneServizio);
    }

    private String _enrich(String nome, int[] posizioneSoggetto, int[] posizioneServizio) throws ProtocolException {
        if (nome.contains("/")) {
            String tipoSoggettoDefault = this.protocolConfiguration.getTipoSoggettoDefault();
            String _tipoSoggettoDefault = tipoSoggettoDefault + "_";
            List<String> tipiSoggetto = this.protocolConfiguration.getTipiSoggetti();
            String tipoServizioDefault = this.protocolConfiguration.getTipoServizioDefault(this.serviceBindingDefault);
            String _tipoServizioDefault = tipoServizioDefault + "_";
            List<String> tipiServizi = this.protocolConfiguration.getTipiServizi(this.serviceBindingDefault);
            String[] tmp = nome.split("/");
            if (tmp.length >= 3) {
                StringBuilder bf = new StringBuilder();
                for (int i = 0; i < tmp.length; ++i) {
                    if (i > 0) {
                        bf.append("/");
                    }
                    boolean soggetto = false;
                    for (int j = 0; j < posizioneSoggetto.length; ++j) {
                        if (i != posizioneSoggetto[j]) continue;
                        soggetto = true;
                        break;
                    }
                    boolean servizio = false;
                    for (int j = 0; j < posizioneServizio.length; ++j) {
                        if (i != posizioneServizio[j]) continue;
                        servizio = true;
                        break;
                    }
                    String s = tmp[i].trim();
                    if (soggetto || servizio) {
                        boolean found;
                        if (soggetto) {
                            if (!s.contains("_")) {
                                bf.append(_tipoSoggettoDefault);
                            } else {
                                found = false;
                                for (String tipoSoggetto : tipiSoggetto) {
                                    if (!s.startsWith(tipoSoggetto + "_")) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    bf.append(_tipoSoggettoDefault);
                                }
                            }
                            bf.append(s);
                            continue;
                        }
                        if (!s.contains("_")) {
                            bf.append(_tipoServizioDefault);
                        } else {
                            found = false;
                            for (String tipoServizio : tipiServizi) {
                                if (!s.startsWith(tipoServizio + "_")) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                bf.append(_tipoServizioDefault);
                            }
                        }
                        bf.append(s);
                        continue;
                    }
                    bf.append(s);
                }
                return bf.toString();
            }
        }
        return nome;
    }
}

